<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-6">

            <div class="card">
                <div class="card-header card-header-primary">
                    <h4 class="card-title"><?= $title ?></h4>
                </div>

                <div class="card-body">
                    <form method="post"
                          action="<?= isset($row)
                              ? base_url('admin/roolseting/role-route/update/' . $row['id'])
                              : base_url('admin/roolseting/role-route/store') ?>">

                        <?= csrf_field() ?>

                        <div class="form-group">
                            <label>Route</label>
                            <input type="text"
                                   name="route"
                                   class="form-control"
                                   required
                                   value="<?= $row['route'] ?? '' ?>">
                        </div>

                        <div class="form-group">
                            <label>Allowed Roles</label>
                            <input type="text"
                                   name="allowed_roles"
                                   class="form-control"
                                   placeholder="contoh: 1,2,3"
                                   required
                                   value="<?= $row['allowed_roles'] ?? '' ?>">
                        </div>

                        <div class="mt-3">
                            <button class="btn btn-primary" type="submit">
                                Simpan
                            </button>
                            <a href="<?= base_url('admin/roolseting/role-route') ?>"
                               class="btn btn-secondary">
                                Kembali
                            </a>
                        </div>

                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

<?= $this->endSection() ?>
