<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">

            <?php if (session()->getFlashdata('success')) : ?>
                <div class="alert alert-success">
                    <?= session()->getFlashdata('success') ?>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header card-header-primary">
                    <h4 class="card-title">Role Route Setting</h4>
                    <a href="<?= base_url('admin/roolseting/role-route/create') ?>"
                       class="btn btn-sm btn-success">
                        + Tambah Route
                    </a>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Route</th>
                                    <th>Allowed Roles</th>
                                    <th width="20%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($routes as $i => $r) : ?>
                                    <tr>
                                        <td><?= $i + 1 ?></td>
                                        <td><?= esc($r['route']) ?></td>
                                        <td><?= esc($r['allowed_roles']) ?></td>
                                        <td>
                                            <a href="<?= base_url('admin/roolseting/role-route/edit/' . $r['id']) ?>"
                                               class="btn btn-sm btn-warning">
                                                Edit
                                            </a>
                                            <a href="<?= base_url('admin/roolseting/role-route/delete/' . $r['id']) ?>"
                                               class="btn btn-sm btn-danger"
                                               onclick="return confirm('Hapus data ini?')">
                                                Hapus
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
