<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12">

    <!-- CARD -->
    <div class="card">
        <div class="card-header card-header-danger d-flex justify-content-between align-items-center">
            <div>
                <h4 class="card-title mb-0">
                    <b><i class="material-icons">route</i> <?= $title ?></b>
                </h4>
                <p class="card-category">
                    Pengaturan akses route berdasarkan role
                </p>
            </div>

            <!-- BUTTON PULL RIGHT -->
            <a href="<?= base_url('admin/roolseting/role-route') ?>"
               class="btn btn-success btn-sm">
                <i class="material-icons">arrow_back</i> Kembali
            </a>
        </div>

        <div class="card-body">

            <form method="post"
                  action="<?= isset($row)
                      ? base_url('admin/roolseting/role-route/update/' . $row['id'])
                      : base_url('admin/roolseting/role-route/store') ?>">

                <?= csrf_field() ?>

                <div class="row">

                    <!-- ROUTE -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="bmd-label-floating">
                                <i class="material-icons text-primary">link</i> Route
                            </label>
                            <input type="text"
                                   name="route"
                                   class="form-control"
                                   required
                                   value="<?= $row['route'] ?? '' ?>">
                            <small class="text-muted">
                                Contoh: <code>admin/siswa</code>
                            </small>
                        </div>
                    </div>

                    <!-- ROLES -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="bmd-label-floating">
                                <i class="material-icons text-warning">security</i> Allowed Roles
                            </label>
                            <input type="text"
                                   name="allowed_roles"
                                   class="form-control"
                                   placeholder=""
                                   required
                                   value="<?= $row['allowed_roles'] ?? '' ?>">
                            <small class="text-muted">
                                Pisahkan role dengan koma (,)
                            </small>
                        </div>
                    </div>

                </div>

                <hr>

                <!-- ACTION -->
                <div class="text-right">
                    <button class="btn btn-success">
                        <i class="material-icons">save</i> Simpan
                    </button>
                </div>

            </form>

        </div>
    </div>
    <!-- END CARD -->

</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
