<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12">

    <!-- FLASH MESSAGE -->
    <?php if (session()->getFlashdata('success')) : ?>
        <div class="pb-2 px-3">
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert">
                    <i class="material-icons">close</i>
                </button>
                <?= session()->getFlashdata('success') ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- CARD -->
    <div class="card">
        <div class="card-header card-header-danger">
            <h4 class="card-title">
                <b><i class="material-icons">route</i> Role Route Setting</b>
            </h4>
            <p class="card-category">Pengaturan akses route berdasarkan role</p>
        </div>

        <div class="card-body">

            <!-- BUTTON TAMBAH -->
            <div class="mb-3">
                <a href="<?= base_url('admin/roolseting/role-route/create') ?>"
                   class="btn btn-success">
                    <i class="material-icons">add</i> Tambah Route
                </a>
            </div>

            <!-- TABLE -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="text-primary">
                        <tr>
                            <th width="5%">No</th>
                            <th>Route</th>
                            <th>Allowed Roles</th>
                            <th width="20%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(empty($routes)): ?>
                            <tr>
                                <td colspan="4" class="text-center text-muted">
                                    <i class="material-icons">info</i> Data belum tersedia
                                </td>
                            </tr>
                        <?php endif; ?>

                        <?php foreach ($routes as $i => $r) : ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td>
                                    <code><?= esc($r['route']) ?></code>
                                </td>
                                <td>
                                    <span class="badge badge-info">
                                        <?= esc($r['allowed_roles']) ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="<?= base_url('admin/roolseting/role-route/edit/' . $r['id']) ?>"
                                       class="btn btn-warning btn-sm">
                                        <i class="material-icons">edit</i>
                                    </a>

                                    <a href="<?= base_url('admin/roolseting/role-route/delete/' . $r['id']) ?>"
                                       class="btn btn-danger btn-sm"
                                       onclick="return confirm('Hapus data ini?')">
                                        <i class="material-icons">delete</i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <!-- END CARD -->

</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
