<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

<!-- ================= CARD ================= -->
<div class="card">

    <!-- ================= HEADER ================= -->
    <div class="card-header card-header-primary">
        <h4 class="card-title">
            <i class="material-icons">vpn_key</i>
            <b>Edit Unique Code</b>
        </h4>
        <p class="card-category">
            Ubah kode unik siswa
        </p>
    </div>

    <!-- ================= BODY ================= -->
    <div class="card-body">

        <!-- FLASH MESSAGE -->
        <?php if (session()->getFlashdata('success')) : ?>
            <div class="alert alert-success">
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')) : ?>
            <div class="alert alert-danger">
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <!-- ================= DESKTOP FORM ================= -->
        <div class="d-none d-md-block">
            <form method="post" action="<?= base_url('admin/siswa/update-code/'.$siswa['id_siswa']) ?>">
                <?= csrf_field() ?>

                <div class="form-group">
                    <label>Nama Siswa</label>
                    <input type="text"
                           class="form-control"
                           value="<?= esc($siswa['nama_siswa']) ?>"
                           readonly>
                </div>

                <div class="form-group">
                    <label>Unique Code</label>
                    <input type="text"
                           name="unique_code"
                           class="form-control"
                           value="<?= old('unique_code', $siswa['unique_code']) ?>"
                           required>
                </div>

                <div class="mt-3">
                    <button type="submit" class="btn btn-primary">
                        <i class="material-icons">save</i>
                        Simpan
                    </button>

                    <a href="javascript:history.back()" class="btn btn-secondary">
                        <i class="material-icons">arrow_back</i>
                        Kembali
                    </a>
                </div>
            </form>
        </div>

        <!-- ================= MOBILE CARD ================= -->
        <div class="d-md-none">
            <div class="card mb-3">
                <div class="card-body">

                    <form method="post" action="<?= base_url('admin/siswa/update-code/'.$siswa['id_siswa']) ?>">
                        <?= csrf_field() ?>

                        <p class="mb-1 text-muted">Nama Siswa</p>
                        <h6><?= esc($siswa['nama_siswa']) ?></h6>

                        <div class="form-group mt-3">
                            <label>Unique Code</label>
                            <input type="text"
                                   name="unique_code"
                                   class="form-control"
                                   value="<?= old('unique_code', $siswa['unique_code']) ?>"
                                   required>
                        </div>

                        <button type="submit" class="btn btn-primary w-100 mt-3">
                            <i class="material-icons">save</i>
                            Simpan
                        </button>

                        <a href="javascript:history.back()" class="btn btn-secondary w-100 mt-2">
                            <i class="material-icons">arrow_back</i>
                            Kembali
                        </a>
                    </form>

                </div>
            </div>
        </div>

    </div>
</div>

</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
