<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

<!-- ================= CARD ================= -->
<div class="card">

    <!-- ================= HEADER ================= -->
    <div class="card-header card-header-primary">
        <h4 class="card-title">
            <i class="material-icons">school</i>
            <b>Daftar Siswa</b>
        </h4>
        <p class="card-category">
            Kelola dan edit Unique Code siswa
        </p>
    </div>

    <!-- ================= BODY ================= -->
    <div class="card-body">

        <!-- ================= NAV BUTTON ================= -->
        <div class="row mb-3">
            <div class="col-md-6 col-12 mb-2">
                <a href="<?= base_url('admin/menuseting') ?>" class="btn btn-primary w-100">
                    <i class="material-icons">settings</i> Menu Setting
                </a>
            </div>
            <div class="col-md-6 col-12 mb-2">
                <a href="<?= base_url('admin/siswa/kelas') ?>" class="btn btn-info w-100">
                    <i class="material-icons">groups</i> Pilih Kelas
                </a>
            </div>
        </div>

        <!-- ================= SEARCH ================= -->
        <div class="row mb-3">
            <div class="col-md-6 col-12">
                <div class="form-group">
                    <label>Cari Siswa</label>
                    <input type="text"
                           id="searchSiswa"
                           class="form-control"
                           placeholder="Cari nama / kelas / unique code">
                </div>
            </div>
        </div>

        <!-- ================= DESKTOP TABLE ================= -->
        <div class="table-responsive d-none d-md-block">
            <table class="table table-hover table-bordered">
                <thead class="text-center">
                    <tr>
                        <th width="50">No</th>
                        <th>Nama</th>
                        <th width="120">Kelas</th>
                        <th width="150">Unique Code</th>
                        <th width="150">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (!empty($siswa)) : ?>
                    <?php $no=1; foreach($siswa as $row): ?>
                        <tr class="siswa-item"
                            data-search="<?= strtolower(
                                $row['nama_siswa'].' '.($row['kelas'] ?? '').' '.$row['unique_code']
                            ) ?>">
                            <td class="text-center"><?= $no++ ?></td>
                            <td><?= esc($row['nama_siswa']) ?></td>
                            <td class="text-center"><?= esc($row['kelas'] ?? '-') ?></td>
                            <td class="text-center">
                                <code><?= esc($row['unique_code']) ?></code>
                            </td>
                            <td class="text-center">
                                <a href="<?= base_url('admin/siswa/edit-code/'.$row['id_siswa']) ?>"
                                   class="btn btn-warning btn-sm">
                                    <i class="material-icons">vpn_key</i> Edit
                                </a>
                            </td>
                        </tr>
                    <?php endforeach ?>
                <?php else : ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted">
                            Tidak ada data siswa
                        </td>
                    </tr>
                <?php endif ?>
                </tbody>
            </table>
        </div>

        <!-- ================= MOBILE CARD ================= -->
        <div class="d-md-none">
            <?php if (!empty($siswa)) : ?>
                <?php foreach($siswa as $row): ?>
                    <div class="card mb-3 siswa-item"
                         data-search="<?= strtolower(
                             $row['nama_siswa'].' '.($row['kelas'] ?? '').' '.$row['unique_code']
                         ) ?>">
                        <div class="card-body">

                            <p class="mb-1 text-muted">Nama Siswa</p>
                            <h6><?= esc($row['nama_siswa']) ?></h6>

                            <p class="mb-1 text-muted">Kelas</p>
                            <p><?= esc($row['kelas'] ?? '-') ?></p>

                            <p class="mb-1 text-muted">Unique Code</p>
                            <code><?= esc($row['unique_code']) ?></code>

                            <a href="<?= base_url('admin/siswa/edit-code/'.$row['id_siswa']) ?>"
                               class="btn btn-warning w-100 mt-2">
                                <i class="material-icons">vpn_key</i>
                                Edit Unique Code
                            </a>

                        </div>
                    </div>
                <?php endforeach ?>
            <?php else : ?>
                <div class="alert alert-warning text-center">
                    Tidak ada data siswa
                </div>
            <?php endif ?>
        </div>

    </div>
</div>

</div>
</div>
</div>
</div>

<!-- ================= SEARCH SCRIPT ================= -->
<script>
document.getElementById('searchSiswa').addEventListener('keyup', function(){
    const key = this.value.toLowerCase();
    document.querySelectorAll('.siswa-item').forEach(item=>{
        item.style.display = item.dataset.search.includes(key) ? '' : 'none';
    });
});
</script>

<?= $this->endSection() ?>
