<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

    <!-- ================= CARD UTAMA ================= -->
    <div class="card">

        <!-- ================= HEADER ================= -->
        <div class="card-header card-header-primary">
            <h4 class="card-title">
                <i class="material-icons">groups</i>
                <b>Data Kelas</b>
            </h4>
            <p class="card-category">
                Pilih kelas untuk melihat dan mengedit Unique Code siswa
            </p>
        </div>

        <!-- ================= BODY ================= -->
        <div class="card-body">

            <!-- ===== PETUNJUK ===== -->
            <div class="alert alert-info">
                <i class="material-icons">info</i>
                <strong>Petunjuk:</strong>
                Klik salah satu kelas di bawah untuk melihat daftar siswa dan mengedit Unique Code mereka.
            </div>


                        <div class="mt-3 text-end">
                <a href="<?= base_url('admin/menuseting') ?>" 
                   class="btn btn-primary w-100" 
                   style="background-color: #f41848; border-color: #b144ff; color: #fff;">
                    <i class="material-icons">arrow_back</i> Kembali
                </a>
            </div>

            <!-- ===== LIST KELAS ===== -->
            <div class="row">

                <?php if (!empty($kelas)) : ?>
                    <?php foreach ($kelas as $row) : ?>

                        <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                            <a href="<?= base_url('admin/siswa/kelas/' . $row['id_kelas']) ?>" class="text-decoration-none">
                                <div class="card text-center mb-3" style="cursor:pointer">
                                    <div class="card-body">

                                        <i class="material-icons text-primary" style="font-size:3rem">
                                            groups
                                        </i>

                                        <h5 class="mt-2 mb-0">
                                            <b><?= esc($row['kelas']) ?></b>
                                        </h5>

                                        <?php if (isset($row['jurusan'])) : ?>
                                            <p class="text-muted mb-0">
                                                Jurusan <?= esc($row['jurusan']) ?>
                                            </p>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </a>
                        </div>

                    <?php endforeach ?>
                <?php else : ?>

                    <div class="col-12">
                        <div class="alert alert-warning text-center">
                            <i class="material-icons">warning</i>
                            Data kelas belum tersedia
                        </div>
                    </div>

                <?php endif ?>

            </div>

        </div>
    </div>

</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
