<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

<div class="card">

    <!-- ================= HEADER ================= -->
    <div class="card-header card-header-tabs card-header-primary">
        <div class="nav-tabs-navigation">
            <div class="row align-items-center">
                <div class="col-md-9">
                    <ul class="nav nav-tabs" id="wizardTabs">
                        <li class="nav-item">
                            <a class="nav-link disabled" href="#" data-step="1">
                                <i class="material-icons">school</i> DATA PESERTA DIDIK
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- ================= BODY ================= -->
     <div class="card-body">
                <div class="mt-3 text-end">
                <a href="<?= base_url('admin/menudata') ?>" 
                   class="btn btn-primary w-100" 
                   style="background-color: #f9641f; border-color: #fb7c2d; color: #fff;">
                    <i class="material-icons">arrow_back</i> Kembali
                </a>
            </div>  </div>
    
    <div class="card-body">

        <!-- SEARCH & DATA SISWA -->
        <h5 class="mb-3"><b>📊 Ketikan Nama / NIS / Kelas untuk Mencari Siswa ....</b></h5>
        <input type="text" class="form-control mb-3" id="searchSiswa" placeholder="🔍 Cari NIS / Nama / Kelas...">

        <div class="card shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover table-bordered table-striped mb-0 align-middle">
                        <thead class="table-primary text-center">
                            <tr>
                                <th style="width:60px;">No</th>
                                <th>NIS</th>
                                <th>Nama Siswa</th>
                                <th>Kelas</th>
                                <th>Jenis Kelamin</th>
                                <th>No HP</th>
                                <th>Kode</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if(!empty($siswa)): ?>
                            <?php $no = 1; ?>
                            <?php foreach($siswa as $row): ?>
                                <tr>
                                    <td data-label="No"><?= $no++ ?></td>
                                    <td data-label="NIS"><?= esc($row['nis']) ?></td>
                                    <td data-label="Nama"><?= esc($row['nama_siswa']) ?></td>
                                    <td data-label="Kelas"><?= esc($row['kelas']) ?></td>
                                    <td data-label="Jenis Kelamin"><?= esc($row['jenis_kelamin']) ?></td>
                                    <td data-label="No HP"><?= esc($row['no_hp']) ?></td>
                                    <td data-label="Kode" class="text-center">
                                        <span class="badge bg-info text-dark"><?= esc($row['unique_code']) ?></span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted py-3">
                                    Belum ada data siswa
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
</div>
</div>
</div>
</div>

<style>
/* ================= TABLE DESKTOP ================= */
.table-hover tbody tr:hover {
    background-color: #f1f0ff;
}
.table-primary th {
    background-color: #9844ff;
    color: #fff;
}

/* ================= RESPONSIVE MOBILE ================= */
@media (max-width: 768px) {
    table thead { display: none; }
    table, table tbody, table tr, table td { display: block; width: 100%; }
    table tr { 
        margin-bottom: 1rem; 
        border-bottom: 2px solid #dee2e6; 
        padding: 0.5rem 1rem;
        background-color: #f8f9fa;
        border-radius: 8px;
    }
    table td { 
        text-align: left; 
        padding: 0.25rem 0;
        border: none;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    table td::before { 
        content: attr(data-label) ":"; 
        font-weight: bold;
        margin-right: 0.5rem;
        flex-shrink: 0;
        width: 30%;
    }
    table td[data-label="Kode"]::before {
        width: auto;
    }

    /* ================= WARNA & BACKGROUND NOMOR MOBILE ================= */
    table td[data-label="No"] {
        background-color: #9844ff;
        color: #fff;
        font-weight: bold;
        border-radius: 5px;
        padding: 0.25rem 0.5rem;
    }
    table td[data-label="No"]::before {
        color: #fff; /* teks label tetap putih */
    }
}
</style>

<script>
// ================= SEARCH REALTIME =================
document.getElementById('searchSiswa').addEventListener('input', function(){
    const filter = this.value.toLowerCase();
    document.querySelectorAll('table tbody tr').forEach(row => {
        row.style.display = row.textContent.toLowerCase().includes(filter) ? '' : 'none';
    });
});
</script>

<?= $this->endSection() ?>
