<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

    <!-- ================= FLASH MESSAGE ================= -->
    <?php if (session()->getFlashdata('success')) : ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')) : ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- ================= CARD INPUT ================= -->
    <div class="card">
        <div class="card-header card-header-primary">
            <h4 class="card-title">
                <i class="material-icons">menu_book</i>
                <b>Input Jurusan</b>
            </h4>
            <p class="card-category">Manajemen data jurusan sekolah</p>
        </div>

        <div class="card-body">
            <form action="<?= base_url('admin/upload/input-jurusan/store') ?>" method="post">
                <?= csrf_field() ?>

                <div class="form-group">
                    <label>Nama Jurusan</label>
                    <input type="text"
                           name="jurusan"
                           class="form-control"
                           value="<?= old('jurusan') ?>"
                           required
                           placeholder="Contoh: IPA, IPS, Bahasa, atau Umum">
                </div>

                <div class="mt-3 d-flex gap-2">
                    <!-- Tombol Simpan -->
                    <div class="flex-grow-1">
                        <button type="submit"
                                class="btn btn-lg w-100 btn-animate text-white"
                                style="background-color: #5744ff; border-color: #5744ff;">
                            <i class="material-icons me-1">save</i> Simpan
                        </button>
                    </div>

                    <!-- Tombol Kembali -->
                    <div class="flex-grow-1">
                        <a href="<?= base_url('admin/menudata') ?>" 
                           class="btn btn-lg w-100 btn-animate text-white"
                           style="background-color: #ff44b7; border-color: #ff44b7;">
                            <i class="material-icons me-1">arrow_back</i> Kembali
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- ================= CARD TABLE ================= -->
    <div class="card mt-4">
        <div class="card-header card-header-info">
            <h4 class="card-title">
                <i class="material-icons">list</i>
                <b>Daftar Jurusan</b>
            </h4>
        </div>

        <div class="card-body">

            <!-- Tabel untuk desktop -->
            <div class="table-responsive d-none d-md-block">
                <table class="table table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th width="5%">#</th>
                            <th>Nama Jurusan</th>
                            <th width="20%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($jurusan)) : ?>
                            <?php foreach ($jurusan as $i => $j) : ?>
                                <tr>
                                    <td><?= $i + 1 ?></td>
                                    <td><?= esc($j['jurusan']) ?></td>
                                    <td>
                                        <button class="btn btn-warning btn-sm"
                                                data-bs-toggle="modal"
                                                data-bs-target="#editModal<?= $j['id'] ?>">
                                            <i class="material-icons">edit</i>
                                        </button>

                                        <a href="<?= base_url('admin/upload/input-jurusan/delete/'.$j['id']) ?>"
                                           class="btn btn-danger btn-sm"
                                           onclick="return confirm('Yakin hapus jurusan ini?')">
                                            <i class="material-icons">delete</i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="3" class="text-center text-muted">
                                    Belum ada data jurusan
                                </td>
                            </tr>
                        <?php endif ?>
                    </tbody>
                </table>
            </div>

            <!-- Card view untuk mobile -->
            <div class="d-block d-md-none">
                <?php if (!empty($jurusan)) : ?>
                    <?php foreach ($jurusan as $i => $j) : ?>
                        <div class="card mb-2 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title"><b><?= esc($j['jurusan']) ?></b></h5>
                                <div class="d-flex justify-content-start gap-2 mt-2">
                                    <button class="btn btn-warning btn-sm"
                                            data-bs-toggle="modal"
                                            data-bs-target="#editModal<?= $j['id'] ?>">
                                        <i class="material-icons">edit</i>
                                    </button>

                                    <a href="<?= base_url('admin/upload/input-jurusan/delete/'.$j['id']) ?>"
                                       class="btn btn-danger btn-sm"
                                       onclick="return confirm('Yakin hapus jurusan ini?')">
                                        <i class="material-icons">delete</i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach ?>
                <?php else : ?>
                    <div class="text-center text-muted">
                        Belum ada data jurusan
                    </div>
                <?php endif ?>
            </div>

        </div>
    </div>

</div>
</div>
</div>
</div>

<!-- ================= MODAL EDIT ================= -->
<?php if (!empty($jurusan)) : ?>
    <?php foreach ($jurusan as $j) : ?>
        <div class="modal fade" id="editModal<?= $j['id'] ?>" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">

                    <form method="post"
                          action="<?= base_url('admin/upload/input-jurusan/update/'.$j['id']) ?>">

                        <?= csrf_field() ?>

                        <div class="modal-header">
                            <h5 class="modal-title">Edit Jurusan</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>

                        <div class="modal-body">
                            <div class="form-group">
                                <label>Nama Jurusan</label>
                                <input type="text"
                                       name="jurusan"
                                       class="form-control"
                                       value="<?= esc($j['jurusan']) ?>"
                                       required>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button"
                                    class="btn btn-secondary"
                                    data-bs-dismiss="modal">
                                Batal
                            </button>

                            <button type="submit"
                                    class="btn btn-success">
                                <i class="material-icons">save</i> Update
                            </button>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    <?php endforeach ?>
<?php endif ?>

<?= $this->endSection() ?>
