<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12">

<!-- ================= FLASH MESSAGE ================= -->
<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>


<!-- ================= CARD INPUT ================= -->
<div class="card">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">
            <i class="material-icons">school</i>
            <?= esc($title) ?>
        </h5>
        <small>Input data kelas berdasarkan jurusan</small>
    </div>

    <div class="card-body">
        <form action="<?= base_url('admin/upload/kelas/store') ?>" method="post">
            <?= csrf_field() ?>

            <div class="mb-3">
                <label class="form-label fw-bold">ID Kelas</label>
                <input type="number"
                       name="id_kelas"
                       class="form-control"
                       value="<?= esc($next_id_kelas) ?>"
                       min="1"
                       required>
                <small class="text-muted">
                    ID otomatis mengikuti data terakhir, tetapi masih bisa diedit
                </small>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Nama Kelas</label>
                <input type="text"
                       name="kelas"
                       class="form-control"
                       placeholder="Contoh: X-1, X-2, 7A"
                       required>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Jurusan</label>
                <select name="id_jurusan" class="form-select" required>
                    <option value="">-- Pilih Jurusan --</option>
                    <?php foreach ($jurusan as $j): ?>
                        <option value="<?= esc($j['id']) ?>">
                            <?= esc($j['jurusan']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">
                    <i class="material-icons">save</i> Simpan
                </button>
            </div>

            <div class="mt-3 text-end">
                <a href="<?= base_url('admin/menudata') ?>" 
                   class="btn btn-primary w-100" 
                   style="background-color: #9844ff; border-color: #b144ff; color: #fff;">
                    <i class="material-icons">arrow_back</i> Kembali
                </a>
            </div>

        </form>
    </div>
</div>


<!-- ================= DATA TABLE RESPONSIVE ================= -->
<div class="card mt-4">
    <div class="card-header bg-info text-white">
        <h5 class="mb-0">
            <i class="material-icons">list</i>
            Data Kelas Tersimpan
        </h5>
    </div>

    <div class="card-body">

        <!-- Desktop Table -->
        <div class="table-responsive d-none d-md-block">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th width="50">No</th>
                        <th>ID</th>
                        <th>Nama Kelas</th>
                        <th>Jurusan</th>
                        <th width="170">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (!empty($kelasList)): ?>
                    <?php $no=1; foreach ($kelasList as $k): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= esc($k['id_kelas']) ?></td>
                            <td>
                                <?= esc($k['kelas']) ?>
                                <?php if (!empty($k['is_used'])): ?>
                                    <span class="badge bg-warning text-dark ms-2">Digunakan</span>
                                <?php endif; ?>
                            </td>
                            <td><?= esc($k['jurusan'] ?? '-') ?></td>
                            <td>
                                <button class="btn btn-warning btn-sm"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editModal<?= $k['id_kelas'] ?>">
                                    <i class="material-icons">edit</i>
                                </button>

                                <form action="<?= base_url('admin/upload/kelas/delete/'.$k['id_kelas']) ?>"
                                      method="post"
                                      class="d-inline">
                                    <?= csrf_field() ?>
                                    <?php if (!empty($k['is_used'])): ?>
                                        <button type="button"
                                                class="btn btn-secondary btn-sm"
                                                disabled
                                                title="Kelas sedang digunakan">
                                            <i class="material-icons">delete</i>
                                        </button>
                                    <?php else: ?>
                                        <button type="submit"
                                                class="btn btn-danger btn-sm"
                                                onclick="return confirm('Yakin hapus kelas ini?')">
                                            <i class="material-icons">delete</i>
                                        </button>
                                    <?php endif; ?>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted">Belum ada data kelas</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Mobile Card -->
        <div class="d-block d-md-none">
            <?php if (!empty($kelasList)): ?>
                <?php foreach ($kelasList as $k): ?>
                    <div class="card mb-2 shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title"><b><?= esc($k['kelas']) ?></b></h5>
                            <p class="mb-1">ID: <?= esc($k['id_kelas']) ?></p>
                            <p class="mb-1">Jurusan: <?= esc($k['jurusan'] ?? '-') ?></p>
                            <?php if (!empty($k['is_used'])): ?>
                                <span class="badge bg-warning text-dark mb-2">Digunakan</span>
                            <?php endif; ?>
                            <div class="d-flex gap-2 mt-2">
                                <button class="btn btn-warning btn-sm"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editModal<?= $k['id_kelas'] ?>">
                                    <i class="material-icons">edit</i>
                                </button>

                                <form action="<?= base_url('admin/upload/kelas/delete/'.$k['id_kelas']) ?>"
                                      method="post"
                                      class="d-inline">
                                    <?= csrf_field() ?>
                                    <?php if (!empty($k['is_used'])): ?>
                                        <button type="button"
                                                class="btn btn-secondary btn-sm"
                                                disabled>
                                            <i class="material-icons">delete</i>
                                        </button>
                                    <?php else: ?>
                                        <button type="submit"
                                                class="btn btn-danger btn-sm"
                                                onclick="return confirm('Yakin hapus kelas ini?')">
                                            <i class="material-icons">delete</i>
                                        </button>
                                    <?php endif; ?>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="text-center text-muted">Belum ada data kelas</div>
            <?php endif; ?>
        </div>

    </div>
</div>

</div>
</div>
</div>
</div>

<!-- ================= MODAL EDIT ================= -->
<?php if (!empty($kelasList)): ?>
<?php foreach ($kelasList as $k): ?>
<div class="modal fade" id="editModal<?= $k['id_kelas'] ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="<?= base_url('admin/upload/kelas/update/'.$k['id_kelas']) ?>">
                <?= csrf_field() ?>

                <div class="modal-header">
                    <h5 class="modal-title">Edit Kelas</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">ID Kelas</label>
                        <input type="number" name="id_kelas"
                               class="form-control" value="<?= esc($k['id_kelas']) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nama Kelas</label>
                        <input type="text" name="kelas"
                               class="form-control" value="<?= esc($k['kelas']) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Jurusan</label>
                        <select name="id_jurusan" class="form-select" required>
                            <?php foreach ($jurusan as $j): ?>
                                <option value="<?= esc($j['id']) ?>" <?= ($j['id']==$k['id_jurusan'])?'selected':'' ?>>
                                    <?= esc($j['jurusan']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="material-icons">save</i> Update
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>
<?php endforeach; ?>
<?php endif; ?>

<?= $this->endSection() ?>
