<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

    <!-- FLASH MESSAGE (jika ada) -->
    <?php if(session()->getFlashdata('error')): ?>
        <div class="px-3 pb-2">
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">
                    <i class="material-icons">close</i>
                </button>
                <?= session()->getFlashdata('error') ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- CARD -->
    <div class="card">

        <!-- HEADER -->
        <div class="card-header card-header-primary">
            <h4 class="card-title">
                <i class="material-icons">groups</i>
                <b><?= esc($title) ?></b>
            </h4>
            <p class="card-category">
                Preview data siswa sebelum disimpan ke database
            </p>
        </div>

        <!-- BODY -->
        <div class="card-body">

            <!-- TABLE -->
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover">
                    <thead class="text-primary">
                        <tr>
                            <th width="50">No</th>
                            <th>NIS</th>
                            <th>Nama</th>
                            <th>Kelas</th>
                            <th>JK</th>
                            <th>No HP</th>
                            <th>Unique Code</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($data)): ?>
                            <?php foreach ($data as $i => $row): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td><?= esc($row['nis']) ?></td>
                                <td><?= esc($row['nama_siswa']) ?></td>
                                <td><?= esc($row['id_kelas']) ?></td>
                                <td><?= esc($row['jenis_kelamin']) ?></td>
                                <td><?= esc($row['no_hp']) ?></td>
                                <td>
                                    <span class="badge badge-info">
                                        <?= esc($row['unique_code']) ?>
                                    </span>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted">
                                    Tidak ada data
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- ACTION BUTTON -->
            <form action="<?= base_url('admin/upload/siswa/save') ?>" method="post" class="mt-3">
                <?= csrf_field() ?>

                <button type="submit" class="btn btn-success">
                    <i class="material-icons">save</i>
                    Simpan ke Database
                </button>

                <a href="<?= base_url('admin/upload/siswa') ?>" class="btn btn-secondary"
                    style="background-color: #9844ff; border-color: #b144ff; color: #fff;">
                    <i class="material-icons">arrow_back</i>
                    Batal
                </a>



                    <!-- <a href="<?= base_url('admin/menudata') ?>" 
                    class="btn btn-primary w-100" 
                    style="background-color: #9844ff; border-color: #b144ff; color: #fff;">
                        <i class="material-icons">arrow_back</i> Kembali
                    </a> -->




            </form>

        </div>
    </div>

</div>
</div>
</div>
</div>

<?= $this->endSection() ?>
