<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ================= UPLOAD CARD ================= */
.upload-card {
    border-radius: 1rem;
    box-shadow: 0 8px 25px rgba(0,0,0,.1);
    border: none;
    overflow: hidden;
    transition: transform .3s, box-shadow .3s;
}
.upload-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.upload-header {
    background: linear-gradient(135deg, #0d6efd, #4a9ef8);
    color: #fff;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    font-size: 1.1rem;
    display: flex;
    align-items: center;
    gap: .5rem;
}
.upload-body {
    padding: 1.5rem;
}
.format-box {
    background: #f8f9fa;
    border-left: 5px solid #0d6efd;
    padding: 1rem 1rem 1rem 1.25rem;
    border-radius: .75rem;
    font-size: .9rem;
}
.format-box pre {
    margin: 0;
    white-space: pre-wrap;
    font-family: monospace;
    background: #e9ecef;
    padding: .75rem;
    border-radius: .5rem;
    overflow-x: auto;
}
.btn-upload {
    padding: .6rem 1.5rem;
    font-weight: 600;
    border-radius: .75rem;
}
.note {
    font-size: .85rem;
    color: #6c757d;
}
</style>

<div class="container-fluid py-4">

    <!-- ================= TITLE ================= -->
    <div class="mb-4">
        <h4 class="fw-bold text-dark">
            <i class="material-icons align-middle text-primary">upload_file</i>
            <?= esc($title ?? 'Upload Data Siswa') ?>
        </h4>
        <p class="text-muted mb-0">
            Upload data siswa menggunakan file CSV. Preview terlebih dahulu sebelum disimpan ke database.
        </p>
    </div>

    <!-- ================= ALERT FLASHDATA ================= -->
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- ================= CARD UPLOAD ================= -->
    <div class="card upload-card">
        <div class="upload-header">
            <i class="material-icons fs-4">description</i>
            Upload File CSV
        </div>

        <div class="upload-body">

            <!-- ================= FORM UPLOAD (FIXED) ================= -->
            <form action="<?= base_url('admin/upload/siswa/preview') ?>"
                  method="post"
                  enctype="multipart/form-data">

                <?= csrf_field() ?>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Pilih File CSV</label>
                    <input type="file"
                           name="file_csv"
                           class="form-control"
                           accept=".csv"
                           required>
                    <div class="note mt-1">
                        * Hanya file <strong>.csv</strong> dengan delimiter <strong>;</strong>
                    </div>
                </div>

                <div class="d-flex gap-2 mt-3">
                    <button type="submit" class="btn btn-primary btn-upload">
                        <i class="material-icons align-middle me-1">preview</i>
                        Preview Data
                    </button>
                </div>
                    <!-- Pembatas -->
                <div class="d-flex gap-2 mt-3">
                    <a href="<?= base_url('admin/upload/siswa/format') ?>"
                       class="btn btn-outline-success btn-upload">
                        <i class="material-icons align-middle me-1">download</i>
                        Download Format CSV
                    </a>
                </div>

                <!-- Pembatas -->
                <div class="mt-3 text-end">
                    <a href="<?= base_url('admin/menudata') ?>" 
                    class="btn btn-primary w-100" 
                    style="background-color: #9844ff; border-color: #b144ff; color: #fff;">
                        <i class="material-icons">arrow_back</i> Kembali
                    </a>
                </div>


            </form>
            <!-- ================= END FORM ================= -->

            <hr class="my-4">

            <!-- ================= FORMAT CSV ================= -->
            <div class="format-box">
                <strong>📄 Format CSV (WAJIB)</strong>
                <ul class="mb-2 mt-1">
                    <li>Delimiter: <strong>titik koma ( ; )</strong></li>
                    <li><strong>TANPA header</strong></li>
                    <li>Urutan kolom wajib sesuai contoh</li>
                </ul>

                <pre>
1;94165336;AHMAD SARIF HIDAYAT;1;Laki-Laki;085223XXXXXX;94165336
2;105920808;ALBINA DWI PERMANA;1;Perempuan;085223XXXXXX;105920808
3;95647743;ANETHA AGUSTYA RAMADHAN;2;Perempuan;085223XXXXXX;95647743
                </pre>

                <div class="note mt-2">
                    Urutan kolom:
                    <strong>ID ; NIS ; NAMA ; ID_KELAS ; JENIS_KELAMIN ; NO_HP ; UNIQUE_CODE</strong>
                </div>
            </div>

        </div>
    </div>

</div>

<?= $this->endSection() ?>
