<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content py-4">
  <div class="container">

    <!-- ===== HEADER ===== -->
    <div class="row mb-4">
      <div class="col-12">
        <div class="card shadow-sm border-0">
          <div class="card-header bg-warning text-white">
            <h4 class="mb-0 fw-bold">🔒 Ganti Password</h4>
            <p class="mb-0">Password hanya bisa diganti oleh akun yang sedang login</p>
          </div>

          <div class="card-body">

            <!-- ===== FLASH MESSAGES ===== -->
            <?php if (session('error')) : ?>
              <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= session('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
            <?php endif ?>

            <?php if (session('success')) : ?>
              <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= session('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
            <?php endif ?>

            <?php $validation = session('validation'); ?>

            <!-- ===== FORM ===== -->
            <form action="<?= base_url('admin/userloginaktif/update') ?>" method="post" class="row g-3">
              <?= csrf_field() ?>

              <div class="col-12 col-md-6">
                <label for="password_lama" class="form-label fw-bold">Password Lama</label>
                <input type="password"
                       name="password_lama"
                       id="password_lama"
                       class="form-control <?= $validation && $validation->hasError('password_lama') ? 'is-invalid' : '' ?>">
                <div class="invalid-feedback">
                  <?= $validation?->getError('password_lama') ?>
                </div>
              </div>

              <div class="col-12 col-md-6">
                <label for="password_baru" class="form-label fw-bold">Password Baru</label>
                <input type="password"
                       name="password_baru"
                       id="password_baru"
                       class="form-control <?= $validation && $validation->hasError('password_baru') ? 'is-invalid' : '' ?>">
                <div class="invalid-feedback">
                  <?= $validation?->getError('password_baru') ?>
                </div>
              </div>

              <div class="col-12 col-md-6">
                <label for="konfirmasi" class="form-label fw-bold">Konfirmasi Password Baru</label>
                <input type="password"
                       name="konfirmasi"
                       id="konfirmasi"
                       class="form-control <?= $validation && $validation->hasError('konfirmasi') ? 'is-invalid' : '' ?>">
                <div class="invalid-feedback">
                  <?= $validation?->getError('konfirmasi') ?>
                </div>
              </div>

              <div class="col-12 col-md-6 d-grid">
                <button type="submit" class="btn btn-warning btn-lg fw-bold">
                  💾 Simpan Password
                </button>
              </div>

            </form>

          </div>
        </div>
      </div>
    </div>

    <!-- ===== BACK BUTTON ===== -->
    <div class="row">
      <div class="col-12 col-md-4">
        <a href="<?= base_url('admin/menuseting') ?>" class="btn btn-primary btn-lg fw-bold w-100">
          <i class="material-icons me-1">arrow_back</i> Kembali
        </a>
      </div>
    </div>

  </div>
</div>

<?= $this->endSection() ?>
