<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <?= view('admin/_messages'); ?>

                <div class="row">
                    <!-- LEFT -->
                    <div class="col-12 col-xl-8">
                        <div class="card">
                            <div class="card-header card-header-primary">
                                <h4 class="card-title"><b>Bulk Post Upload Siswa</b></h4>
                                <p class="card-category">Angkatan <?= $generalSettings->school_year; ?></p>
                            </div>

                            <div class="card-body">
                                <div class="dm-uploader-container">
                                    <div id="drag-and-drop-zone" class="dm-uploader p-3 text-center">
                                        <p class="dm-upload-icon">
                                            <i class="material-icons">cloud_upload</i>
                                        </p>
                                        <h4 class="text-muted">Drag & Drop CSV di sini</h4>

                                        <div class="btn btn-primary mt-3">
                                            <label style="cursor:pointer;margin:0;">
                                                <span>Open File Browser</span>
                                                <input type="file" id="csv_file_input" name="file" hidden>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <!-- SPINNER -->
                                <div class="mt-4 text-center">
                                    <div id="csv_upload_spinner" style="display:none;">
                                        <strong class="text-csv-importing">Importing Siswa...</strong>
                                        <strong class="text-csv-import-completed" style="display:none;">Completed!</strong>
                                        <div class="spinner-bounce mt-2">
                                            <div class="bounce1"></div>
                                            <div class="bounce2"></div>
                                            <div class="bounce3"></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- LIST STATUS -->
                                <ul id="csv_uploaded_files" class="list-group mt-4"></ul>

                                <!-- PREVIEW TABLE -->
                                <div class="table-responsive mt-4">
                                    <table class="table table-bordered table-sm" id="csv_preview_table" style="display:none;">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>NIS</th>
                                                <th>Nama Siswa</th>
                                                <th>ID Kelas</th>
                                                <th>Jenis Kelamin</th>
                                                <th>No HP</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                    </div>

                    <!-- RIGHT -->
                    <div class="col-12 col-xl-4">
                        <div class="card">
                            <div class="card-header card-header-primary">
                                <h4 class="card-title"><b>Help Documents</b></h4>
                            </div>
                            <div class="card-body">
                                <form action="<?= base_url('admin/siswa/downloadCSVFilePost'); ?>" method="post">
                                    <?= csrf_field(); ?>
                                    <button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#modalKelas">
                                        List Kelas
                                    </button>
                                    <button class="btn btn-success btn-block mt-2" name="submit" value="csv_siswa_template">
                                        Download CSV Template
                                    </button>



                                                   <a href="<?= base_url('admin/siswa') ?>" 
                   class="btn btn-primary w-100" 
                   style="background-color: #9844ff; border-color: #b144ff; color: #fff;">
                    <i class="material-icons">arrow_back</i> Kembali
                </a>


                                </form>
                            </div>
                        </div>
                    </div>

                </div><!-- row -->
            </div>
        </div>
    </div>
</div>

<!-- MODAL KELAS -->
<div class="modal fade" id="modalKelas">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">List Kelas</h5>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <table class="table table-hover">
                    <thead class="text-primary">
                        <tr>
                            <th>ID</th>
                            <th>Kelas</th>
                            <th>Jurusan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($kelas as $v): ?>
                        <tr>
                            <td><?= $v['id_kelas']; ?></td>
                            <td><?= $v['kelas']; ?></td>
                            <td><?= $v['jurusan']; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
$(function () {

    $('#drag-and-drop-zone').dmUploader({
        url: '<?= base_url("admin/siswa/generateCSVObjectPost"); ?>',
        multiple: false,
        extFilter: ['csv'],
        extraData: function () {
            return { '<?= csrf_token() ?>': '<?= csrf_hash() ?>' };
        },

        onNewFile: function () {
            $("#csv_uploaded_files").empty();
            $("#csv_preview_table tbody").empty();
            $("#csv_preview_table").hide();

            $("#csv_upload_spinner").show();
            $(".text-csv-importing").show();
            $(".text-csv-import-completed").hide();
        },

        onUploadSuccess: function (id, response) {
            let obj = JSON.parse(response);
            if (obj.result == 1 && obj.numberOfItems > 0) {
                addCSVItem(obj.numberOfItems, obj.txtFileName, 1);
            } else {
                $("#csv_upload_spinner").hide();
            }
        }
    });

    $('#csv_file_input').on('change', function (e) {
        $('#drag-and-drop-zone').dmUploader('addFiles', e.target.files);
    });
});

function addCSVItem(total, txtFileName, index) {
    if (index > total) return;

    $.post(
        '<?= base_url("admin/siswa/importCSVItemPost"); ?>',
        setAjaxData({ txtFileName, index }),
        function (res) {
            let obj = JSON.parse(res);
            $("#csv_preview_table").show();

            if (obj.result == 1) {
                $("#csv_uploaded_files").prepend(
                    `<li class="list-group-item list-group-item-success">${index}. ${obj.siswa.nis} - ${obj.siswa.nama_siswa}</li>`
                );

                $("#csv_preview_table tbody").append(`
                    <tr class="table-success">
                        <td>${obj.siswa.nis}</td>
                        <td>${obj.siswa.nama_siswa}</td>
                        <td>${obj.siswa.id_kelas}</td>
                        <td>${obj.siswa.jenis_kelamin}</td>
                        <td>${obj.siswa.no_hp}</td>
                        <td><span class="badge badge-success">OK</span></td>
                    </tr>
                `);
            } else {
                $("#csv_uploaded_files").prepend(
                    `<li class="list-group-item list-group-item-danger">${index}. GAGAL</li>`
                );

                $("#csv_preview_table tbody").append(`
                    <tr class="table-danger">
                        <td colspan="6">Baris ${index} gagal diimport</td>
                    </tr>
                `);
            }

            if (index == total) {
                $(".text-csv-importing").hide();
                $(".text-csv-import-completed").show();
            }

            addCSVItem(total, txtFileName, index + 1);
        }
    );
}
</script>

<?= $this->endSection() ?>
