<div class="card-body">

<?php if (!$empty) : ?>

<style>
/* ================= DESKTOP ================= */
.table thead th{
    text-align:center;
    font-weight:700;
    background:#0d6efd;
    color:#fff;
    vertical-align:middle;
}

.table tbody td{
    text-align:center;
    vertical-align:middle;
}

.table tbody td.nama-col{
    text-align:left;
    font-weight:600;
}


/* ================= MOBILE CARD ================= */
.mobile-card{
    border-radius:12px;
    overflow:hidden;
}

.mobile-header{
    background:#0d6efd;
    color:#fff;
    padding:10px 14px;
    font-weight:700;
}

/* BARIS 2 – GRID RAPi */
.mobile-body{
    padding:12px 14px;
}

.mobile-row{
    display:grid;
    grid-template-columns: 110px 12px 1fr; /* KUNCI 3 KOLOM */
    align-items:flex-start;
    font-size:.85rem;
    margin-bottom:6px;
}

.mobile-label{
    text-align:left;
    font-weight:600;
    color:#555;
}

.mobile-separator{
    text-align:center;
    font-weight:600;
}

.mobile-value{
    text-align:left;
    color:#000;
    word-break:break-word;
}

/* BARIS 3 */
.mobile-actions{
    display:flex;
    gap:8px;
    padding:10px 14px;
    background:#f8f9fa;
}

.mobile-actions .btn{
    flex:1;
    font-size:.8rem;
}
</style>


<!-- ===================== -->
<!-- DESKTOP TABLE -->
<!-- ===================== -->
<div class="table-responsive d-none d-md-block">
    <table id="siswaTable" class="table table-hover display nowrap w-100">
        <thead>
            <tr>
                <th width="20">
                    <input type="checkbox" id="checkAll">
                </th>
                <th>No</th>
                <th>NIS</th>
                <th class="text-start">Nama Siswa</th>
                <th>Jenis Kelamin</th>
                <th>Kelas</th>
                <th>Jurusan</th>
                <th>No HP</th>
                <th>Unique Code</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $i=1; foreach($data as $value): ?>
            <tr>
                <td>
                    <input type="checkbox" class="check-item" value="<?= $value['id_siswa']; ?>">
                </td>
                <td><?= $i++; ?></td>
                <td><?= $value['nis']; ?></td>
                <td class="nama-col"><?= $value['nama_siswa']; ?></td>
                <td><?= $value['jenis_kelamin']; ?></td>
                <td><?= $value['kelas']; ?></td>
                <td><?= $value['jurusan']; ?></td>
                <td><?= $value['no_hp']; ?></td>
                <td><?= $value['unique_code']; ?></td>
                <td>
                    <div class="d-flex justify-content-center gap-1">
                        <a href="<?= base_url('admin/siswa/edit/'.$value['id_siswa']); ?>" class="btn btn-primary btn-sm">
                            <i class="material-icons">edit</i>
                        </a>
                        <form action="<?= base_url('admin/siswa/delete/'.$value['id_siswa']); ?>" method="post" class="m-0">
                            <?= csrf_field(); ?>
                            <input type="hidden" name="_method" value="DELETE">
                            <button class="btn btn-danger btn-sm" onclick="return confirm('Hapus data?')">
                                <i class="material-icons">delete_forever</i>
                            </button>
                        </form>
                        <a href="<?= base_url('admin/qr/siswa/'.$value['id_siswa'].'/download'); ?>" class="btn btn-success btn-sm">
                            <i class="material-icons">qr_code</i>
                        </a>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- ===================== -->
<!-- MOBILE CARD -->
<!-- ===================== -->
<div class="d-block d-md-none mt-3">
<?php foreach($data as $value): ?>
    <div class="card mobile-card mb-3 shadow-sm">

        <!-- BARIS 1 -->
        <div class="mobile-header">
            <?= $value['nama_siswa']; ?>
        </div>

        <!-- BARIS 2 -->
        <div class="mobile-body">
            <div class="mobile-row">
                <div class="mobile-label">NIS</div>
                <div class="mobile-separator">:</div>
                <div class="mobile-value"><?= $value['nis']; ?></div>
            </div>

            <div class="mobile-row">
                <div class="mobile-label">Jenis Kelamin</div>
                <div class="mobile-separator">:</div>
                <div class="mobile-value"><?= $value['jenis_kelamin']; ?></div>
            </div>

            <div class="mobile-row">
                <div class="mobile-label">Kelas</div>
                <div class="mobile-separator">:</div>
                <div class="mobile-value"><?= $value['kelas']; ?></div>
            </div>

            <div class="mobile-row">
                <div class="mobile-label">Jurusan</div>
                <div class="mobile-separator">:</div>
                <div class="mobile-value"><?= $value['jurusan']; ?></div>
            </div>

            <div class="mobile-row">
                <div class="mobile-label">No HP</div>
                <div class="mobile-separator">:</div>
                <div class="mobile-value"><?= $value['no_hp']; ?></div>
            </div>

            <div class="mobile-row">
                <div class="mobile-label">Unique Code</div>
                <div class="mobile-separator">:</div>
                <div class="mobile-value"><?= $value['unique_code']; ?></div>
            </div>
        </div>

        <!-- BARIS 3 -->
        <div class="mobile-actions">
            <a href="<?= base_url('admin/siswa/edit/'.$value['id_siswa']); ?>" class="btn btn-outline-primary">
                <i class="material-icons">edit</i>
            </a>

            <form action="<?= base_url('admin/siswa/delete/'.$value['id_siswa']); ?>" method="post" class="flex-fill">
                <?= csrf_field(); ?>
                <input type="hidden" name="_method" value="DELETE">
                <button class="btn btn-outline-danger w-100" onclick="return confirm('Hapus data?')">
                    <i class="material-icons">delete</i>
                </button>
            </form>

            <a href="<?= base_url('admin/qr/siswa/'.$value['id_siswa'].'/download'); ?>" class="btn btn-outline-success">
                <i class="material-icons">qr_code</i>
            </a>
        </div>

    </div>
<?php endforeach; ?>
</div>


<?php else: ?>
<div class="text-center text-danger fw-bold">Data tidak ditemukan</div>
<?php endif; ?>

</div>

<!-- DATATABLE -->
<script>
$(document).ready(function () {
    if (window.innerWidth >= 768) {
        $('#siswaTable').DataTable({
            responsive:true,
            language:{
                search:"Cari:",
                emptyTable:"Data tidak ditemukan"
            }
        });
    }

    $('#checkAll').on('click', function(){
        $('.check-item').prop('checked', this.checked);
    });
});
</script>
