<?= $this->extend('templates/starting_page_layout'); ?>

<?= $this->section('navaction') ?>
<a href="<?= base_url('/admin'); ?>" class="btn" style="background-color: #4a9ef8; color: #fff; border-radius: 5px; padding: 8px 16px;">
   <i class="material-icons mr-2">dashboard</i>
   Dashboard
</a>
<?= $this->endSection() ?>

<?= $this->section('content'); ?>

<?php
$waktuLower = strtolower($waktu);
if ($waktuLower === 'masuk') $oppBtn = 'pulang';
elseif ($waktuLower === 'pulang') $oppBtn = 'masuk';
else $oppBtn = 'masuk';
?>

<div class="main-panel">
   <div class="content">
      <div class="container-fluid">
         <div class="row mx-auto">

            <!-- Tips -->
            <div class="col-lg-3 col-xl-4">
               <!-- <div class="card">
                  <div class="card-body">
                     <h3 class="mt-2"><b>Tips</b></h3>
                     <ul class="pl-3">
                        <li>Tunjukkan QR Code sampai terlihat jelas di kamera</li>
                        <li>Posisikan QR Code tidak terlalu jauh maupun terlalu dekat</li>
                     </ul>
                  </div>
               </div> -->
            </div>

            <!-- Scanner -->
            <div class="col-lg-6 col-xl-4">
               <div class="card">
                  <div class="col-10 mx-auto card-header card-header-primary" style="background-color: #71a4fd; color: #fff;">
                     <div class="row">
                        <div class="col">
                          <h4 class="card-title" style="color: #ffffff;"><b>Absen <?= ucfirst($waktuLower); ?></b></h4>
                           <!-- <p class="card-category">Silahkan tunjukkan QR Code anda</p> -->
                        </div>
                        <div class="col-md-auto">
                           <a href="<?= base_url("scan/$oppBtn"); ?>" class="btn" style="background-color: #42c192; color: #fff; border-radius: 5px; padding: 6px 12px;">
                              Absen <?= ucfirst($oppBtn); ?>
                           </a>
                           <a href="<?= base_url("scan/duhur"); ?>" class="btn" style="background-color: #f3a742; color: #fff; border-radius: 5px; padding: 6px 12px;">
                              Absen Duhur
                           </a>
                        </div>
                     </div>
                  </div>
                  <div class="card-body my-auto px-5">
                     <h4 class="d-inline">Pilih kamera</h4>
                     <select id="pilihKamera" class="custom-select w-50 ml-2" style="height: 35px;">
                        <option selected>Select camera devices</option>
                     </select>

                     <br><br>

                     <div class="row">
                        <div class="col-sm-12 mx-auto">
                           <div class="previewParent text-center" id="previewParent">
                              <video id="previewKamera" width="100%" height="auto"></video>
                           </div>
                        </div>
                     </div>

                     <div id="hasilScan" class="mt-3"></div>
                  </div>
               </div>
            </div>

            <!-- Penggunaan -->
            <div class="col-lg-3 col-xl-4">
               <!-- <div class="card">
                  <div class="card-body">
                     <h3 class="mt-2"><b>Penggunaan</b></h3>
                     <ul class="pl-3">
                        <li>Jika berhasil scan maka akan muncul data siswa/guru dibawah preview kamera</li>
                        <li>Klik tombol <b><span style="color:#6f42c1;">Absen Masuk</span> / <span style="color:#6f42c1;">Absen Pulang</span> / <span style="color:#6f42c1;">Absen Duhur</span></b> untuk mengubah waktu absensi</li>
                        <li>Untuk melihat data absensi, klik tombol <span style="color:#6f42c1;"><i class="material-icons" style="font-size: 16px;">dashboard</i> Dashboard Petugas</span></li>
                        <li>Untuk mengakses halaman petugas anda harus login terlebih dahulu</li>
                     </ul>
                  </div>
               </div> -->
            </div>

         </div>
      </div>
   </div>
</div>

<script src="<?= base_url('assets/js/plugins/zxing/zxing.min.js') ?>"></script>
<script src="<?= base_url('assets/js/core/jquery-3.5.1.min.js') ?>"></script>
<script>
let selectedDeviceId = null;
let audio = new Audio("<?= base_url('assets/audio/beep.mp3'); ?>");
const codeReader = new ZXing.BrowserMultiFormatReader();
const sourceSelect = $('#pilihKamera');
let scanning = false; // Flag untuk scan sekali per QR

function initScanner() {
    codeReader.listVideoInputDevices().then(videoInputDevices => {
        if (!videoInputDevices.length) return alert("Camera not found!");
        if (!selectedDeviceId) selectedDeviceId = videoInputDevices[0].deviceId;

        sourceSelect.html('');
        videoInputDevices.forEach(device => {
            const option = document.createElement('option');
            option.text = device.label;
            option.value = device.deviceId;
            if(device.deviceId===selectedDeviceId) option.selected=true;
            sourceSelect.append(option);
        });

        $('#previewParent').removeClass('unpreview');

        // Scan terus menerus, tapi pakai flag scanning
        codeReader.decodeFromVideoDevice(selectedDeviceId, 'previewKamera', (result, err) => {
            if(result && !scanning){
                scanning = true; // blok scan berikutnya
                audio.play();
                cekData(result.text);
            }
            if(err && !(err instanceof ZXing.NotFoundException)){
                console.error(err);
            }
        });

    }).catch(err=>console.error(err));
}

// Ganti kamera
$(document).on('change','#pilihKamera',function(){
    selectedDeviceId=$(this).val();
    if(codeReader){
        codeReader.reset();
        scanning = false;
        initScanner();
    }
});

if(navigator.mediaDevices) initScanner();
else alert('Cannot access camera.');

// AJAX scan
async function cekData(code){
    try{
        const response = await $.ajax({
            url:"<?= base_url('scan/cek'); ?>",
            type:'post',
            data:{ unique_code: code, waktu: '<?= $waktuLower; ?>' }
        });
        $('#hasilScan').html(response);
        $('html, body').animate({scrollTop: $("#hasilScan").offset().top},500);

        // reset scanning agar bisa scan QR berikutnya setelah 2 detik
        setTimeout(()=> scanning=false, 2000);
    } catch(err){
        console.error(err);
        $('#hasilScan').html('<div class="alert alert-danger">Gagal scan. Silahkan coba lagi.</div>');
        setTimeout(()=> scanning=false, 1000);
    }
}
</script>

<?= $this->endSection(); ?>
