<?= $this->extend('templates/starting_page_layout'); ?>

<?= $this->section('navaction') ?>
<a href="<?= base_url('/admin'); ?>" class="btn" style="background-color:#4a9ef8;color:#fff;border-radius:5px;padding:8px 16px;">
    <i class="material-icons mr-2">dashboard</i> Dashboard
</a>
<?= $this->endSection() ?>

<?= $this->section('content'); ?>

<?php
$mode = strtolower($waktu); // masuk | pulang | izin
?>

<div class="main-panel">
    <div class="content">
        <div class="container-fluid">
            <div class="row mx-auto">

                <!-- SCANNER -->
                <div class="col-lg-6 col-xl-4 mx-auto">
                    <div class="card">

                        <div class="card-header text-white" style="background:#71a4fd">
                            <h4 class="mb-0"><b>Scan <?= ucfirst($mode); ?></b></h4>
                        </div>

                        <div class="card-body px-4">

                            <h5>Pilih Kamera</h5>
                            <select id="pilihKamera" class="custom-select mb-3">
                                <option>Pilih Kamera</option>
                            </select>

                            <div class="text-center">
                                <video id="previewKamera" width="100%"></video>
                            </div>

                            <div id="hasilScan" class="mt-3"></div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- LIBRARY -->
<script src="<?= base_url('assets/js/plugins/zxing/zxing.min.js') ?>"></script>
<script src="<?= base_url('assets/js/core/jquery-3.5.1.min.js') ?>"></script>

<!-- SCRIPT UTAMA -->
<script>
let selectedDeviceId = null;
let scanning = false;
const mode = "<?= $mode ?>";

const audio = new Audio("<?= base_url('assets/audio/beep.mp3'); ?>");
const codeReader = new ZXing.BrowserMultiFormatReader();
const sourceSelect = $('#pilihKamera');

/* ================= INIT CAMERA ================= */
function initScanner(){
    codeReader.listVideoInputDevices().then(devices=>{
        if(!devices.length){
            alert('Kamera tidak ditemukan');
            return;
        }

        sourceSelect.html('');
        devices.forEach((device,index)=>{
            const option = $('<option>')
                .val(device.deviceId)
                .text(device.label || `Camera ${index+1}`);
            sourceSelect.append(option);
        });

        selectedDeviceId = devices[0].deviceId;
        startScan();
    });
}

/* ================= START SCAN ================= */
function startScan(){
    codeReader.decodeFromVideoDevice(
        selectedDeviceId,
        'previewKamera',
        (result, err)=>{
            if(result && !scanning){
                scanning = true;
                audio.play();
                cekData(result.text);
            }
        }
    );
}

/* ================= GANTI KAMERA ================= */
$('#pilihKamera').on('change', function(){
    selectedDeviceId = this.value;
    codeReader.reset();
    scanning = false;
    startScan();
});

/* ================= AJAX CEK ================= */
async function cekData(code){
    try{
        const urlScan = mode === 'izin'
            ? "<?= base_url('scan/cek-izin'); ?>"
            : "<?= base_url('scan/cek'); ?>";

        const response = await $.ajax({
            url: urlScan,
            type: 'POST',
            data: {
                unique_code: code,
                waktu: mode
            }
        });

        $('#hasilScan').html(response);
        setTimeout(()=> scanning = false, 2000);

    }catch(e){
        scanning = false;
        $('#hasilScan').html('<div class="alert alert-danger">Gagal scan</div>');
    }
}

/* ================= RUN ================= */
if(navigator.mediaDevices){
    initScanner();
}else{
    alert('Browser tidak mendukung kamera');
}
</script>

<?= $this->endSection(); ?>
