<?php
$context = $ctx ?? '';
$sidebarColor = 'rose';

foreach ($sidebarMenus as $m) {
    if ($m['ctx'] === $context && !empty($m['sidebar_color'])) {
        $sidebarColor = $m['sidebar_color'];
        break;
    }
}
?>

<div class="sidebar" data-color="<?= $sidebarColor ?>" data-background-color="black">
    <div class="logo">
        <a class="simple-text logo-normal">
            <b>SMAN 1 Cikatomas<br>2026</b>
        </a>
    </div>

    <div class="sidebar-wrapper">
        <ul class="nav">
            <?php foreach ($sidebarMenus as $menu): ?>
                <?php
                    // Check if current menu is active
                    $active = ($context === $menu['ctx']) ? 'active' : '';
                    // For collapse support: if menu has children, you can extend here
                ?>
                <li class="nav-item <?= $active ?>">
                    <a class="nav-link" href="<?= base_url($menu['url']) ?>">
                        <i class="material-icons"><?= esc($menu['icon']) ?></i>
                        <p><?= esc($menu['label']) ?></p>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
</div>

<!-- Optional JS for collapse (if needed for nested menus) -->
<script>
document.addEventListener("DOMContentLoaded", function(){
    const sidebarLinks = document.querySelectorAll('.sidebar .nav-link');
    sidebarLinks.forEach(link => {
        link.addEventListener('click', function(){
            // Hapus semua active
            sidebarLinks.forEach(l => l.parentElement.classList.remove('active'));
            // Set current active
            this.parentElement.classList.add('active');
        });
    });
});
</script>
