CREATE TABLE `auth_activation_attempts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(255) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;



CREATE TABLE `auth_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;



CREATE TABLE `auth_groups_permissions` (
  `group_id` int(11) unsigned NOT NULL DEFAULT 0,
  `permission_id` int(11) unsigned NOT NULL DEFAULT 0,
  KEY `auth_groups_permissions_permission_id_foreign` (`permission_id`),
  KEY `group_id_permission_id` (`group_id`,`permission_id`),
  CONSTRAINT `auth_groups_permissions_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `auth_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `auth_groups_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `auth_permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;



CREATE TABLE `auth_groups_users` (
  `group_id` int(11) unsigned NOT NULL DEFAULT 0,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  KEY `auth_groups_users_user_id_foreign` (`user_id`),
  KEY `group_id_user_id` (`group_id`,`user_id`),
  CONSTRAINT `auth_groups_users_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `auth_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `auth_groups_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;



CREATE TABLE `auth_logins` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `date` datetime NOT NULL,
  `success` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `email` (`email`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2567 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1','::1','adminsuper@gmail.com','1','2025-12-23 08:10:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2','::1','adminsuper@gmail.com','1','2025-12-31 14:36:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('3','::1','gurusmancika1@gmail.com','2','2026-01-12 17:40:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('4','::1','gurusmancika1@gmail.com','2','2026-01-12 17:47:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('5','::1','adminsuper@gmail.com','1','2026-01-12 17:48:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('6','::1','adminsuper@gmail.com','1','2026-01-12 17:57:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('7','::1','gurusmancika2@gmail.com','3','2026-01-12 18:23:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('8','::1','adminsuper@gmail.com','1','2026-01-12 20:04:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('9','::1','adminsuper@gmail.com','1','2026-01-12 20:44:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('10','103.188.169.69','adminsuper@gmail.com','1','2026-01-13 01:03:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('11','103.188.169.69','adminsuper@gmail.com','1','2026-01-13 01:06:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('12','103.188.169.69','adminsuper@gmail.com','1','2026-01-13 06:38:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('13','2001:448a:3063:2838:90b4:799a:e9ad:8955','asepcandra@gmail.com','31','2026-01-13 07:53:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('14','2001:448a:3063:2838:3daf:bbaa:1bfb:f415','adminsuper@gmail.com','1','2026-01-13 08:36:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('15','2001:448a:3063:2838:3daf:bbaa:1bfb:f415','dadansudrajat@gmail.com','2','2026-01-13 08:44:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('16','2001:448a:3063:2838:3daf:bbaa:1bfb:f415','adminsuper@gmail.com','1','2026-01-13 09:12:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('17','114.122.79.214','mohammadsuhardiwan@gmail.com','4','2026-01-13 09:13:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('18','2001:448a:3063:2838:3daf:bbaa:1bfb:f415','asepcandra@gmail.com','31','2026-01-13 09:25:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('19','2001:448a:3063:2838:3daf:bbaa:1bfb:f415','asepcandra@gmail.com','31','2026-01-13 09:32:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('20','2001:448a:3063:2838:b563:c016:1fe8:7b57','adminsuper@gmail.com','1','2026-01-13 10:00:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('21','2001:448a:3063:2838:3daf:bbaa:1bfb:f415','adminsuper@gmail.com','1','2026-01-13 10:07:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('22','114.122.117.99','adeirpannugraha',NULL,'2026-01-13 10:10:21','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('23','114.122.117.99','adeirpannugraha',NULL,'2026-01-13 10:10:38','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('24','2001:448a:3063:2838:3daf:bbaa:1bfb:f415','adminsuper@gmail.com','1','2026-01-13 10:10:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('25','114.122.117.99','adeirfannugraha@gmail.com','29','2026-01-13 10:11:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('26','2001:448a:3063:2838:58d7:4789:70d8:2f06','asepcandra@gmail.com','31','2026-01-13 14:08:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('27','36.77.25.97','adeirfannugraha',NULL,'2026-01-13 14:20:12','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('28','36.77.25.97','adeirfannugraha@gmail.com','29','2026-01-13 14:20:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('29','2001:448a:3063:2838:3daf:bbaa:1bfb:f415','adminsuper@gmail.com','1','2026-01-13 14:34:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('30','2001:448a:3063:2838:58d7:4789:70d8:2f06','adminsuper@gmail.com','1','2026-01-13 16:50:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('31','202.46.68.90','adeirfannugraha@gmail.com','29','2026-01-13 23:40:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('32','114.122.116.221','adeirfannugraha@gmail.com','29','2026-01-14 08:30:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('33','114.122.115.91','adeirfannugraha@gmail.com','29','2026-01-14 12:35:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('34','2404:c0:2e10::d5d:3570','emmysitimariyam',NULL,'2026-01-14 12:36:11','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('35','114.122.73.55','acepantonfajar',NULL,'2026-01-14 12:36:24','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('36','2404:c0:2d10::d5d:8368','emmysitimaryam',NULL,'2026-01-14 12:36:56','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('37','114.122.73.55','acepantonfajar',NULL,'2026-01-14 12:37:16','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('38','2404:c0:2e10::d5d:3570','emmysitimariyam',NULL,'2026-01-14 12:37:21','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('39','114.122.115.91','ripkiardian@gmail.com','35','2026-01-14 12:37:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('40','114.122.73.55','acepantonfajar@gmail.com','57','2026-01-14 12:38:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('41','114.122.115.191','neneng',NULL,'2026-01-14 12:39:16','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('42','2404:c0:2d10::d5d:8368','emmysitimariyam@gmail.com','19','2026-01-14 12:39:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('43','2404:c0:2810::4d5:a363','syipaulhusna',NULL,'2026-01-14 12:39:24','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('44','2404:c0:2b10::ef5:25f6','tiaiqbalhembara@gmail.com','55','2026-01-14 12:40:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('45','2404:c0:2b10::f10:2b46','weniwidaningrum30@gmail.com',NULL,'2026-01-14 12:40:06','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('46','2404:c0:2b10::f10:2b46','weniwidaningrum30@gmail.com',NULL,'2026-01-14 12:40:53','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('47','2404:c0:2a10::efa:2a0c','ikasartika@gmail.com','7','2026-01-14 12:40:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('48','2404:c0:2810::4d5:a363','syifaulhusna',NULL,'2026-01-14 12:40:56','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('49','2404:c0:2b10::f11:e5d2','muhtarsidik@gmail.com','49','2026-01-14 12:41:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('50','114.122.71.117','Enengsriastutisyam',NULL,'2026-01-14 12:41:29','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('51','2404:c0:2810::4d5:a363','syipaulhusna',NULL,'2026-01-14 12:41:41','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('52','114.122.70.97','Dewu',NULL,'2026-01-14 12:41:43','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('53','114.122.70.97','evi tini sukartini',NULL,'2026-01-14 12:41:47','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('54','114.122.115.191','neneng@gmail.com','13','2026-01-14 12:41:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('55','114.122.71.117','enengsriastutisyam',NULL,'2026-01-14 12:42:04','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('56','114.122.70.97','evitinisukartini@gmail.com','12','2026-01-14 12:42:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('57','36.77.25.97','enokmira@gmail.com','60','2026-01-14 12:42:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('58','114.122.70.97','dewi@gmail.com','10','2026-01-14 12:42:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('59','2404:c0:2b10::f10:2b46','Weniwidaningrum',NULL,'2026-01-14 12:42:37','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('60','36.77.25.97','enokmira@gmail.com','60','2026-01-14 12:42:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('61','114.122.115.91','haniherlina@gmail.com','34','2026-01-14 12:43:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('62','114.122.78.102','syfaulhusna@gmail.com','52','2026-01-14 12:43:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('63','2404:c0:2b10::f10:2b46','weniwidaningrum@gmail.com','8','2026-01-14 12:43:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('64','114.122.71.117','sriastutisyam',NULL,'2026-01-14 12:43:52','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('65','114.122.71.117','sriastutisyam@gmail.com','22','2026-01-14 12:44:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('66','114.122.101.226','Sistisitimunawaroh',NULL,'2026-01-14 12:44:25','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('67','114.122.82.222','susilawati@gmail.com','54','2026-01-14 12:45:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('68','2404:c0:2f10::d61:e401','dinanursolihat@gmail.com','56','2026-01-14 12:45:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('69','114.122.101.226','sitimunawaroh@gmail.com','41','2026-01-14 12:45:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('70','114.122.74.184','galihwangi@gmail.com','43','2026-01-14 12:45:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('71','2404:c0:2b10::f12:4dd8','elsaandriani@gmsil.com',NULL,'2026-01-14 12:46:49','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('72','2404:c0:2b10::f12:4dd8','elsaandriani@gmail.com','40','2026-01-14 12:47:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('73','36.77.25.97','linlinpermatapraja',NULL,'2026-01-14 12:49:10','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('74','2404:c0:2e10::d5e:c191','nisa@gmail.com','51','2026-01-14 12:51:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('75','2404:c0:2910::f0e:f512','sitipatimah@gmail.com','6','2026-01-14 12:52:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('76','2404:c0:2f10::d37:6462','firmanmuharam17@gmail.com',NULL,'2026-01-14 12:54:20','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('77','2404:c0:2f10::d37:6462','firmanmuharam17@gmail.com',NULL,'2026-01-14 12:54:53','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('78','114.122.85.92','yusmansetiawan@gmail.com','14','2026-01-14 12:55:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('79','2404:c0:2810::4bc:7c5b','henririsnandar',NULL,'2026-01-14 12:55:12','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('80','2404:c0:2f10::d37:6462','firmanmuharam17@gmail.com',NULL,'2026-01-14 12:55:20','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('81','2404:c0:2f10::d37:6462','firmanmuharam17@gmail.com',NULL,'2026-01-14 12:55:48','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('82','2404:c0:2810::4bc:7c5b','henririsnandar@gmail.com','28','2026-01-14 12:55:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('83','2404:c0:2e10::d5a:86','detirosmawati@gmail.com','36','2026-01-14 12:56:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('84','114.122.115.177','Firman Muharam',NULL,'2026-01-14 12:57:46','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('85','114.122.115.177','Firman Muharam',NULL,'2026-01-14 12:57:46','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('86','2404:c0:2f10::d37:6462','firmanmuharam',NULL,'2026-01-14 13:01:06','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('87','114.122.102.48','ikanurhasanah@gmail.com','26','2026-01-14 13:01:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('88','2404:c0:2f10::d37:6462','firman',NULL,'2026-01-14 13:02:06','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('89','2404:c0:2910::f07:5670','ekasantikalestari@gmail.com','44','2026-01-14 13:03:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('90','114.122.101.226','pupuypuadah@gmail.com','53','2026-01-14 13:07:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('91','114.122.70.97','yuliagustiani',NULL,'2026-01-14 14:15:42','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('92','114.122.70.97','yuliagustiani@gmail.com','17','2026-01-14 14:16:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('93','114.122.74.184','galihwangi@gmail.com','43','2026-01-14 15:13:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('94','114.122.116.45','agustomi@gmail.com','27','2026-01-14 15:14:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('95','2404:c0:2810::4da:4443','muchtarsidiq@gmail.com','16','2026-01-14 15:15:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('96','202.46.68.90','adeirfannugraha',NULL,'2026-01-14 16:18:08','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('97','202.46.68.90','adeirfannugraha',NULL,'2026-01-14 16:18:26','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('98','202.46.68.90','adeirfannugraha',NULL,'2026-01-14 16:18:55','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('99','202.46.68.90','adeirfannugraha@gmail.com','29','2026-01-14 16:19:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('100','202.46.68.90','adeirfannugraha@gmail.com','29','2026-01-14 16:22:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('101','36.77.25.97','Nanang Najamudin ',NULL,'2026-01-14 16:23:53','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('102','36.77.25.97','Nanang Najamudin ',NULL,'2026-01-14 16:25:26','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('103','36.77.25.97','Nanang Najamudin ',NULL,'2026-01-14 16:26:13','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('104','36.77.25.97','nanangnajamudin ',NULL,'2026-01-14 16:37:57','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('105','36.77.25.97','nanangnajamudin',NULL,'2026-01-14 16:38:37','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('106','36.77.25.97','nanangnajamudin',NULL,'2026-01-14 16:39:04','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('107','36.77.25.97','nanangnajmudin@gmail.com','30','2026-01-14 16:50:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('108','2001:448a:306f:31a7:d2a3:7bc4:db05:e195','andrinugraha56@guru.sma.belajar.id',NULL,'2026-01-14 17:28:28','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('109','2001:448a:306f:31a7:d2a3:7bc4:db05:e195','ANDRI NUGRAHA',NULL,'2026-01-14 17:28:48','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('110','36.77.25.114','asepcandra@gmail.com','31','2026-01-14 17:29:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('111','2001:448a:306f:31a7:d2a3:7bc4:db05:e195','andrinugraha@gmail.com','46','2026-01-14 17:29:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('112','103.188.169.69','ranianggraeni@gmail.com','59','2026-01-14 18:56:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('113','202.46.68.90','adeirfannugraha@gmail.com','29','2026-01-14 19:56:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('114','103.166.159.217','pupuypuadah@gmail.com','53','2026-01-14 21:00:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('115','36.83.133.7','detirosmawati@gmail.com','36','2026-01-15 03:27:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('116','2404:c0:2d10::d78:46ee','wulanpurnamasari',NULL,'2026-01-15 06:08:38','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('117','2404:c0:2d10::d78:46ee','wulanpurnamasari@gmail.com','37','2026-01-15 06:09:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('118','2404:c0:2e10::d91:190c','sitipatimah@gmail.com','6','2026-01-15 06:11:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('119','114.122.79.118','anihgindalistiani@gmail.com','15','2026-01-15 06:16:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('120','2404:c0:2c10::d87:728e','nanangnajamudin@gmail.com','30','2026-01-15 06:16:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('121','2404:c0:2e10::d93:de16','syfaulhusna@gmail.com','52','2026-01-15 06:20:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('122','2404:c0:2d10::d94:be18','ekasantikalestari@gmail.com','44','2026-01-15 06:20:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('123','2404:c0:2c10::d95:97f','jonihprasetia@gmail.com','47','2026-01-15 06:21:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('124','114.122.74.173','asepsuryadi',NULL,'2026-01-15 06:24:58','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('125','2404:c0:2c10::d93:e6a1','susilawati@gmail.com','54','2026-01-15 06:25:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('126','114.122.68.253','asepsuryadi@gmail.com','5','2026-01-15 06:26:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('127','2404:c0:2f10::d98:688b','siskatutiana@gmail.com','62','2026-01-15 06:26:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('128','114.122.78.149','dewi@gmail.com','10','2026-01-15 06:30:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('129','114.122.70.38','adeirfannugraha@gmail.com','29','2026-01-15 06:33:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('130','2404:c0:2910::f4f:70d0','emmysitimariyam ',NULL,'2026-01-15 06:35:21','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('131','2404:c0:2a10::f4f:6d8','emmysitimariyam@gmail.com','19','2026-01-15 06:35:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('132','114.122.82.165','gilangsepteranurhendra@gmail.com','38','2026-01-15 06:36:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('133','114.122.104.7','haniherlina@gmail.com','34','2026-01-15 06:39:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('134','36.77.25.97','ikanurhasanah',NULL,'2026-01-15 06:45:49','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('135','36.77.25.97','ikanurhasanah',NULL,'2026-01-15 06:46:01','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('136','36.77.25.97','ikanurhasanah@gmail.com','26','2026-01-15 06:46:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('137','2404:c0:2b10::f51:9ca2','dinanursolihat',NULL,'2026-01-15 06:47:28','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('138','2404:c0:2b10::f51:9ca2','dinanursolihat@gmail.com','56','2026-01-15 06:47:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('139','2404:c0:2f10::d8d:f4c5','weniwidaningrum@gmail.com','8','2026-01-15 06:49:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('140','114.122.111.62','andrinugraha@gmail.com','46','2026-01-15 06:49:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('141','2404:c0:2f10::d97:8a5a','henririsnandar@gmail.com','28','2026-01-15 06:52:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('142','114.122.101.239','mohammadsuhardiwan@gmail.com','4','2026-01-15 06:52:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('143','2404:c0:2d10::d8e:dbf9','pupuypuadah@gmail.com','53','2026-01-15 06:55:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('144','2404:c0:2810::51d:9d7e','firmanmuharam@gmail.com','58','2026-01-15 06:59:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('145','114.122.107.158','Elsa Andriani ',NULL,'2026-01-15 07:00:45','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('146','114.122.107.158','elsaandriani@gmsil.com',NULL,'2026-01-15 07:01:14','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('147','2404:c0:2c10::d86:974b','elsaandriani@gmsil.com',NULL,'2026-01-15 07:02:31','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('148','2404:c0:2c10::d86:974b','elsaandriani@gmsil.com',NULL,'2026-01-15 07:03:11','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('149','114.122.70.109','sriastutisyam@gmail.com','22','2026-01-15 07:03:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('150','2404:c0:2c10::d8f:2aa0','ikasartika@gmail.com','7','2026-01-15 07:06:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('151','114.122.114.156','neneng@gmail.com','13','2026-01-15 07:06:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('152','114.122.106.219','yosisitirosita@gmail.com','32','2026-01-15 07:12:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('153','2404:c0:2c10::d8f:2aa0','ikasartika@gmail.com','7','2026-01-15 07:20:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('154','2404:c0:2910::f4a:6015','ritanurfatimah@gmail.com','25','2026-01-15 07:28:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('155','114.122.74.184','galihwangi@gmail.com','43','2026-01-15 07:31:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('156','36.77.25.97','ripkiardian@gmail.com','35','2026-01-15 07:34:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('157','2404:c0:2910::f41:227e','tiaiqbalhembara@gmail.com','55','2026-01-15 07:35:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('158','2404:c0:2910::f50:3764','nisa@gmail.com','51','2026-01-15 07:37:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('159','36.77.25.97','muchtarsidiq@gmail.com','16','2026-01-15 07:39:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('160','2404:c0:2f10::d91:8dd','irman nu hendra',NULL,'2026-01-15 07:40:12','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('161','2404:c0:2f10::d91:8dd','irmannurhendra@gmail.com','20','2026-01-15 07:41:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('162','2404:c0:2910::f2d:864d','acepantonfajar@gmail.com','57','2026-01-15 08:14:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('163','114.122.106.219','yosisitirosita',NULL,'2026-01-15 09:04:14','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('164','114.122.106.219','yosisitirosita@gmail.com','32','2026-01-15 09:04:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('165','2404:c0:2e10::d93:ed17','ekasantikalestari@gmail.com','44','2026-01-15 09:58:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('166','2404:c0:2e10::da0:e930','elsaandriani@gmsil.com',NULL,'2026-01-15 10:03:57','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('167','2404:c0:2e10::da0:e930','elsaandriani@gmail.com','40','2026-01-15 10:04:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('168','114.122.114.156','neneng@gmail.com','13','2026-01-15 10:14:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('169','36.77.25.97','ripkiardian@gmail.com','35','2026-01-15 10:30:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('170','114.122.70.38','adeirfannugraha',NULL,'2026-01-15 11:03:50','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('171','114.122.70.38','adeirfannugraha@gmail.com','29','2026-01-15 11:04:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('172','114.122.108.65','evitinisukartini@gmail.com','12','2026-01-15 11:07:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('173','2404:c0:2e10::da2:3429','detirosmawati@gmail.com','36','2026-01-15 11:07:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('174','114.122.70.109','sriastutisyam@gmail.com','22','2026-01-15 11:29:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('175','36.77.25.97','galihwangi@gmail.com','43','2026-01-15 12:18:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('176','36.77.25.97','asepcandra@gmail.com','31','2026-01-15 12:20:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('177','36.77.25.97','asepcandra@gmail.com','31','2026-01-15 12:20:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('178','2001:448a:3063:2838:894c:b0cb:e389:52ae','adminsuper@gmail.com','1','2026-01-15 12:20:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('179','2404:c0:2f10::d94:7da6','susilawati@gmail.com','54','2026-01-15 12:35:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('180','2404:c0:2f10::d94:7da6','susilawati@gmail.com','54','2026-01-15 12:35:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('181','114.122.108.65','yuliagustiani@gmail.com','17','2026-01-15 12:36:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('182','36.77.25.97','muhtarsidik@gmail.com','49','2026-01-15 12:43:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('183','103.188.169.69','rentydwiyanti@gmail.com','50','2026-01-15 12:46:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('184','2404:c0:2a10::f6d:289c','ikasartika@gmail.com','7','2026-01-15 12:57:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('185','2404:c0:2d10::dad:de5a','nanangnajamudin@gmail.com','30','2026-01-15 12:59:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('186','114.122.82.132','neneng@gmail.com','13','2026-01-15 13:05:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('187','2404:c0:2c10::d90:8259','henririsnandar@gmail.com','28','2026-01-15 13:57:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('188','2404:c0:2d10::dae:4ef7','emmysitimariyam@gmail.com','19','2026-01-15 14:00:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('189','2404:c0:2d10::d8f:4a16','sitipatimah@gmail.com','6','2026-01-15 14:00:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('190','2404:c0:2d10::d8f:4a16','sitipatimah@gmail.com','6','2026-01-15 14:00:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('191','114.122.100.73','dewu',NULL,'2026-01-15 14:01:44','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('192','114.122.100.73','dewi',NULL,'2026-01-15 14:02:29','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('193','114.122.100.73','dewi',NULL,'2026-01-15 14:03:19','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('194','114.122.100.73','dewi@gmail.com','10','2026-01-15 14:03:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('195','2404:c0:2b10::f76:b70c','dinanursolihat@gmail.com','56','2026-01-15 14:04:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('196','114.122.102.211','sitimunawaroh@gmail.com','41','2026-01-15 14:05:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('197','114.122.117.149','agustomi@gmail.com','27','2026-01-15 14:05:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('198','2404:c0:2e10::db8:d6a9','syfaulhusna@gmail.com','52','2026-01-15 14:05:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('199','114.122.105.204','anggagunawan@gmail.com','39','2026-01-15 14:05:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('200','114.122.101.241','anihgindalistiani@gmail.com','15','2026-01-15 14:05:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('201','2404:c0:2c10::db3:e92c','ikanurhasanah@gmail.com','26','2026-01-15 14:07:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('202','2404:c0:2c10::daa:c806','linlinpermatapraja',NULL,'2026-01-15 14:07:51','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('203','2404:c0:2a10::f4b:2e83','ripkiardian@gmail.com','35','2026-01-15 14:07:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('204','2404:c0:2c10::daa:c806','linlinpermatapraja',NULL,'2026-01-15 14:08:15','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('205','114.122.82.181','haniherlina@gmail.com','34','2026-01-15 14:08:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('206','2404:c0:2c10::daa:c806','linlinpermatapraja',NULL,'2026-01-15 14:08:55','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('207','2404:c0:2810::51d:9d7e','firmanmuharam',NULL,'2026-01-15 14:09:46','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('208','2404:c0:2c10::daa:c806','linlinpermata',NULL,'2026-01-15 14:09:49','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('209','114.10.149.172','evitinisukartini@gmail.com','12','2026-01-15 14:10:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('210','2404:c0:2f10::dac:86e4','linlinpermatapraja',NULL,'2026-01-15 14:10:18','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('211','2404:c0:2810::51d:9d7e','firmanmuharam@gmail.com','58','2026-01-15 14:10:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('212','2404:c0:2e10::db4:b134','siskatutiana@gmail.com','62','2026-01-15 14:10:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('213','114.122.71.39','yosisitirosita@gmail.com','32','2026-01-15 14:12:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('214','2404:c0:2910::f41:227e','tiaiqbalhembara@gmail.com','55','2026-01-15 14:12:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('215','114.122.105.35','enokmira@gmail.com','60','2026-01-15 14:13:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('216','114.122.105.35','enokmira@gmail.com','60','2026-01-15 14:13:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('217','2404:c0:2c10::dab:7fc3','pupuypuadah@gmail.com','53','2026-01-15 14:14:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('218','2404:c0:2e10::db8:d6a9','syfaulhusna@gmail.com','52','2026-01-15 14:16:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('219','114.122.73.230','officialosissmancika@gmail.com',NULL,'2026-01-15 14:21:44','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('220','2404:c0:2a10::f74:7d','nisa@gmail.com','51','2026-01-15 14:38:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('221','114.122.117.61','ujenahmadzaeniridwan',NULL,'2026-01-15 15:00:52','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('222','114.122.117.61','ujenahmadzaeniridwan',NULL,'2026-01-15 15:02:13','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('223','114.122.117.61','ujenahmadzaeniridwan',NULL,'2026-01-15 15:03:02','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('224','114.122.117.61','ujenahmadzaeniridwan',NULL,'2026-01-15 15:03:53','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('225','114.122.117.61','ujenahmadzaeniridwan',NULL,'2026-01-15 15:05:54','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('226','114.122.117.61','ujen ',NULL,'2026-01-15 15:06:48','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('227','114.122.117.61','ujenahmadzaeniridwan',NULL,'2026-01-15 15:07:39','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('228','2404:c0:2c10::daa:c806','linlinpermatapraja@gmail.com','61','2026-01-15 15:15:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('229','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-15 15:47:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('230','114.122.73.17','asepsuryadi',NULL,'2026-01-15 15:49:09','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('231','2404:c0:2c10::db6:ff2a','weniwidaningrum@gmail.com','8','2026-01-15 17:26:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('232','114.122.117.61','ujenahmadzaeniridwan',NULL,'2026-01-15 17:27:50','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('233','114.122.117.61','ujenahmad@gmail.com','11','2026-01-15 17:29:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('234','103.188.169.153','ritanurfatimah@gmail.com','25','2026-01-15 17:44:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('235','103.188.169.153','ritanurfatimah@gmail.com','25','2026-01-15 17:44:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('236','2404:c0:2910::f7c:8056','tiaiqbalhembara@gmail.com','55','2026-01-15 17:50:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('237','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-15 18:57:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('238','2404:c0:2a10::f80:518','acepantonfajar@gmail.com','57','2026-01-15 19:07:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('239','2404:c0:2f10::db5:6e5e','rdsusimurti@gmail.com','48','2026-01-15 19:33:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('240','202.46.68.90','adeirfannugraha@gmail.com','29','2026-01-15 21:06:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('241','103.188.169.153','asepsuryadi',NULL,'2026-01-16 06:10:52','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('242','103.188.169.153','asepsuryadi',NULL,'2026-01-16 06:10:58','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('243','103.188.169.153','asepsuryadi',NULL,'2026-01-16 06:11:12','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('244','103.188.169.153','asepsuryadi',NULL,'2026-01-16 06:11:18','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('245','103.188.169.153','asepsuryadi@gmail.com','5','2026-01-16 06:12:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('246','103.188.169.153','asepsuryadi@gmail.com','5','2026-01-16 06:12:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('247','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-16 06:14:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('248','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-16 08:54:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('249','103.188.169.153','asepsuryadi',NULL,'2026-01-16 11:43:10','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('250','103.188.169.153','asepsuryadi',NULL,'2026-01-16 11:45:08','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('251','103.188.169.153','asepsuryadi',NULL,'2026-01-16 11:45:49','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('252','103.188.169.153','asepsuryadi',NULL,'2026-01-16 11:46:00','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('253','103.188.169.153','asepsuryadi',NULL,'2026-01-16 11:46:54','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('254','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-16 11:47:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('255','103.188.169.153','asepsuryadi',NULL,'2026-01-16 11:48:01','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('256','103.188.169.153','asepsuryadi',NULL,'2026-01-16 11:49:33','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('257','103.188.169.69','superadmin',NULL,'2026-01-16 14:24:55','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('258','103.188.169.69','adminsuper@gmail.com','1','2026-01-16 14:25:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('259','114.122.102.25','adminsuper@gmail.com','1','2026-01-16 15:30:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('260','114.122.68.51','adeirfannugraha@gmail.com','29','2026-01-16 15:42:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('261','103.208.101.2','nisa@gmail.com','51','2026-01-16 17:08:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('262','114.122.75.164','galihwangi@gmail.com','43','2026-01-16 17:31:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('263','114.122.101.197','ujenahmad@gmail.com','11','2026-01-16 17:39:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('264','103.188.169.69','adminsuper@gmail.com','1','2026-01-16 17:50:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('265','2404:c0:2810::5ee:9256','weniwidaningrum@gmail.com','8','2026-01-17 13:58:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('266','202.46.68.71','adeirfannugraha',NULL,'2026-01-18 08:14:16','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('267','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-18 08:14:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('268','2404:c0:2910::10c7:1406','pupuypuadah@gmail.com','53','2026-01-19 06:12:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('269','2404:c0:2810::68a:f2ea','emmysitimariyam@gmail.com','19','2026-01-19 06:13:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('270','114.122.107.231','adeirfannugraha@gmail.com','29','2026-01-19 06:16:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('271','2404:c0:2e10::ed8:5168','syfaulhusna@gmail.com','52','2026-01-19 06:17:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('272','2404:c0:2a10::10c2:f845','yuyunyunaningsih@gmail.com','23','2026-01-19 06:23:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('273','2404:c0:2d10::ee3:b406','evitinisukartini@gmail.com','12','2026-01-19 06:23:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('274','103.188.169.69','susilawati@gmail.com','54','2026-01-19 06:24:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('275','2404:c0:2910::10b6:395c','nisa@gmail.com','51','2026-01-19 06:25:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('276','2404:c0:2810::68b:1343','tiaiqbalhembara@gmail.com','55','2026-01-19 06:25:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('277','2404:c0:2810::690:930a','61629',NULL,'2026-01-19 06:27:06','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('278','2404:c0:2910::10ae:aaf4','ikasartika@gmail.com','7','2026-01-19 06:38:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('279','103.188.169.69','yuliagustiani@gmail.com','17','2026-01-19 06:40:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('280','2404:c0:2c10::ed9:62da','weniwidaningrum@gmail.com','8','2026-01-19 06:42:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('281','2404:c0:2c10::ee4:db6b','irmannurhendra@gmail.com','20','2026-01-19 06:42:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('282','2404:c0:2f10::ee2:415d','henririsnandar',NULL,'2026-01-19 06:42:53','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('283','2404:c0:2f10::ee2:415d','henririsnandar@gmail.com','28','2026-01-19 06:43:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('284','114.122.79.109','sriastutisyam@gmail.com','22','2026-01-19 06:44:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('285','2404:c0:2d10::ede:50e','ripkiardian@gmail.com','35','2026-01-19 06:47:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('286','114.122.115.213','haniherlina@gmail.com','34','2026-01-19 06:50:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('287','2404:c0:2b10::10c3:3444','elsaandriani@gmail.com','40','2026-01-19 06:50:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('288','114.122.104.0','asepcandra@gmail.com','31','2026-01-19 07:02:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('289','114.122.75.51','yosisitirosita@gmail.com','32','2026-01-19 07:02:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('290','114.122.104.0','asepcandra@gmail.com','31','2026-01-19 07:02:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('291','114.122.107.54','galihwangi@gmail.com','43','2026-01-19 07:03:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('292','2404:c0:2b10::10c8:29ce','dinanursolihat@gmail.com','56','2026-01-19 07:10:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('293','2404:c0:2b10::10bf:60dd','sitipatimah@gmail.com','6','2026-01-19 07:12:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('294','114.122.106.246','anihgindalistiani@gmail.com','15','2026-01-19 07:19:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('295','2404:c0:2910::10c3:fb43','ranianggraeni@gmail.com','59','2026-01-19 07:21:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('296','2404:c0:2a10::10c7:cc96','rentydwiyanti@gmail.com','50','2026-01-19 07:21:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('297','2404:c0:2a10::10c7:cc96','rentydwiyanti@gmail.com','50','2026-01-19 07:21:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('298','114.122.105.203','gilangsepteranurhendra@gmail.com','38','2026-01-19 07:24:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('299','2404:c0:2f10::ee6:46e4','muhtarsidik@gmail.com','49','2026-01-19 07:30:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('300','114.122.84.85','agustomi@gmail.com','27','2026-01-19 07:30:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('301','114.122.84.141','wulanpurnamasari@gmail.com','37','2026-01-19 07:49:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('302','114.122.85.62','dewi@gmail.com','10','2026-01-19 08:02:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('303','114.122.77.122','neneng@gmail.com','13','2026-01-19 08:43:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('304','114.122.102.167','yusmansetiawan@gmail.com','14','2026-01-19 09:12:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('305','36.81.226.139','evitinisukartini@gmail.com','12','2026-01-19 09:34:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('306','114.122.70.109','sriastutisyam@gmail.com','22','2026-01-19 09:40:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('307','36.81.226.139','197908072015082002',NULL,'2026-01-19 09:47:49','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('308','36.81.226.139','197908072014082002',NULL,'2026-01-19 09:48:12','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('309','36.81.226.139','evitinisukartini',NULL,'2026-01-19 09:50:52','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('310','36.81.226.139','evitinisukartini',NULL,'2026-01-19 09:51:28','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('311','36.81.226.139','evitinisukartini@gmail.com','12','2026-01-19 09:51:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('312','36.81.226.139','anihgindalistiani@gmail.com','15','2026-01-19 10:09:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('313','2404:c0:2b10::10de:6616','noviestephen@gmail.com','18','2026-01-19 10:11:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('314','2404:c0:2a10::10b4:e285','pupuypuadah@gmail.com','53','2026-01-19 10:28:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('315','114.122.100.110','enokmira@gmail.com','60','2026-01-19 10:34:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('316','114.122.115.139','galihwangi@gmail.com','43','2026-01-19 11:00:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('317','114.122.110.133','adminsuper@gmail.com','1','2026-01-19 12:15:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('318','2404:c0:2d10::ef5:3583','weniwidaningrum@gmail.com','8','2026-01-19 13:16:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('319','36.81.226.139','evitinisukartini@gmail.com','12','2026-01-19 13:48:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('320','2404:c0:2a10::10c2:f845','yuyunyunaningsih@gmail.com','23','2026-01-19 14:05:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('321','2404:c0:2f10::ee2:415d','henririsnandar@gmail.com','28','2026-01-19 14:06:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('322','2404:c0:2c10::efd:f53e','emmysitimariyam@gmail.com','19','2026-01-19 14:08:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('323','114.122.85.62','dewi@gmail.com','10','2026-01-19 14:16:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('324','2404:c0:2c10::ef0:edf5','detirosmawati@gmail.com','36','2026-01-19 14:20:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('325','2404:c0:2810::6ab:d86d','tiaiqbalhembara@gmail.com','55','2026-01-19 14:21:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('326','114.122.79.106','gilangsepteranurhendra@gmail.com','38','2026-01-19 14:22:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('327','114.122.72.201','asepcandra@gmail.com','31','2026-01-19 14:22:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('328','2404:c0:2d10::ede:50e','ripkiardian@gmail.com','35','2026-01-19 14:23:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('329','114.122.105.118','neneng@gmail.com','13','2026-01-19 14:23:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('330','2404:c0:2c10::ef2:d0e8','muhtarsidik@gmail.com','49','2026-01-19 14:23:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('331','114.122.105.3','adeirfannugraha@gmail.com','29','2026-01-19 14:23:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('332','114.122.108.199','yusmansetiawan@gmail.com','14','2026-01-19 14:24:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('333','36.81.226.139','jonihprasetia@gmail.com','47','2026-01-19 14:24:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('334','114.122.109.185','agustomi@gmail.com','27','2026-01-19 14:25:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('335','114.122.106.13','sitimunawaroh@gmail.com','41','2026-01-19 14:25:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('336','114.122.110.197','asepsuryadi',NULL,'2026-01-19 14:25:40','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('337','114.122.110.197','asepsuryadi',NULL,'2026-01-19 14:25:48','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('338','114.122.110.197','asepsuryadi',NULL,'2026-01-19 14:25:51','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('339','2404:c0:2b10::10de:6616','noviestephen@gmail.com','18','2026-01-19 14:26:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('340','114.122.110.197','asepsuryadi',NULL,'2026-01-19 14:27:10','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('341','114.122.110.197','asepsuryadi',NULL,'2026-01-19 14:27:13','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('342','114.122.110.197','asepsuryadi@gmail.com','5','2026-01-19 14:28:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('343','114.122.110.197','asepsuryadi@gmail.com','5','2026-01-19 14:28:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('344','114.122.116.230','anihgindalistiani@gmail.com','15','2026-01-19 14:28:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('345','114.122.70.113','sriastutisyam@gmail.com','22','2026-01-19 14:29:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('346','114.122.104.59','enokmira@gmail.com','60','2026-01-19 14:29:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('347','114.122.107.219','mohammadsuhardiwan@gmail.com','4','2026-01-19 14:29:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('348','114.122.115.139','galihwangi@gmail.com','43','2026-01-19 14:29:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('349','103.188.169.69','anggagunawan@gmail.com','39','2026-01-19 14:30:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('350','114.122.110.133','adminsuper@gmail.com','1','2026-01-19 14:31:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('351','114.122.101.249','Muhtar Gojali',NULL,'2026-01-19 14:32:26','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('352','2404:c0:2a10::10cc:a675','ikasartika@gmail.com','7','2026-01-19 14:33:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('353','114.122.101.249','Muhtar Gojali',NULL,'2026-01-19 14:33:07','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('354','114.122.101.249','muhtargojali@gmail.com','21','2026-01-19 14:33:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('355','2404:c0:2f10::efe:dc9b','agismujiprayitno@gmail.com','24','2026-01-19 14:35:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('356','2404:c0:2a10::10b4:e285','pupuypuadah@gmail.com','53','2026-01-19 14:36:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('357','114.122.101.249','muhtargojali@gmail.com','21','2026-01-19 14:38:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('358','36.81.226.139','yosisitirosita@gmail.com','32','2026-01-19 14:43:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('359','202.46.68.41','sitipatimah@gmail.com','6','2026-01-19 14:46:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('360','2404:c0:2810::674:8894','acepantonfajar@gmail.com','57','2026-01-19 15:03:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('361','36.81.226.139','elsaandriani@gmail.com','40','2026-01-19 15:04:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('362','103.188.169.69','susilawati@gmail.com','54','2026-01-19 15:17:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('363','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-19 16:19:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('364','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-19 16:55:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('365','114.122.72.79','haniherlina@gmail.com','34','2026-01-19 17:50:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('366','2404:c0:2910::10ee:7726','elsaandriani@gmail.com','40','2026-01-19 18:19:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('367','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-19 19:36:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('368','103.188.169.69','rentydwiyanti@gmail.com','50','2026-01-19 20:02:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('369','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-19 22:34:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('370','2404:c0:2c10::f3f:617d','emmysitimariyam@gmail.com','19','2026-01-20 06:05:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('371','2404:c0:2f10::f29:94ae','elsaandriani@gmail.com','40','2026-01-20 06:09:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('372','114.122.101.56','agustomi@gmail.com','27','2026-01-20 06:10:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('373','114.122.70.134','haniherlina@gmail.com','34','2026-01-20 06:14:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('374','2404:c0:2910::1111:7d25','yuyunyunaningsih@gmail.com','23','2026-01-20 06:17:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('375','114.122.74.219','galihwangi@gmail.com','43','2026-01-20 06:18:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('376','2404:c0:2f10::f2b:672e','detirosmawati@gmail.com','36','2026-01-20 06:20:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('377','114.122.115.54','asepcandra@gmail.com','31','2026-01-20 06:21:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('378','2404:c0:2a10::112a:8dc8','rentydwiyanti@gmail.com','50','2026-01-20 06:23:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('379','2404:c0:2c10::f2f:f24','ikasartika@gmail.com','7','2026-01-20 06:27:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('380','2404:c0:2910::112e:2cc1','evitinisukartini@gmail.com','12','2026-01-20 06:27:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('381','2404:c0:2e10::f2e:568c','weniwidaningrum@gmail.com','8','2026-01-20 06:30:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('382','114.122.106.49','adeirfannugraha@gmail.com','29','2026-01-20 06:31:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('383','2404:c0:2b10::111f:3354','irmannurhendra@gmail.com','20','2026-01-20 06:43:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('384','202.46.68.41','agismujiprayitno@gmail.com','24','2026-01-20 06:46:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('385','114.122.111.24','anggagunawan@gmail.com','39','2026-01-20 06:48:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('386','114.122.70.113','sriastutisyam@gmail.com','22','2026-01-20 06:49:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('387','2404:c0:2f10::f43:e6bb','dinanursolihat@gmail.com','56','2026-01-20 06:49:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('388','2404:c0:2f10::f3a:9674','susilawati@gmail.com','54','2026-01-20 06:49:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('389','2404:c0:2910::1118:295c','tiaiqbalhembara@gmail.com','55','2026-01-20 06:50:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('390','2404:c0:2910::1118:295c','tiaiqbalhembara@gmail.com','55','2026-01-20 06:50:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('391','2404:c0:2d10::f28:18ca','sitipatimah@gmail.com','6','2026-01-20 07:06:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('392','114.122.77.26','anihgindalistiani@gmail.com','15','2026-01-20 07:26:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('393','114.122.111.153','henririsnandar@gmail.com','28','2026-01-20 07:28:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('394','2404:c0:2a10::1122:c643','noviestephen@gmail.com','18','2026-01-20 07:36:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('395','2404:c0:2d10::f2e:af8e','pupuypuadah@gmail.com','53','2026-01-20 07:39:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('396','2404:c0:2f10::f35:6a61','ripkiardian@gmail.com','35','2026-01-20 07:42:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('397','2404:c0:2f10::f35:6a61','ripkiardian@gmail.com','35','2026-01-20 07:42:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('398','36.81.226.139','muhtarsidik@gmail.com','49','2026-01-20 07:52:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('399','2404:c0:2c10::f39:4e41','ritanurfatimah@gmail.com','25','2026-01-20 08:08:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('400','36.81.226.139','yosisitirosita@gmail.com','32','2026-01-20 08:13:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('401','2404:c0:2e10::f38:7754','jonihprasetia@gmail.com','47','2026-01-20 08:17:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('402','114.122.79.127','yuliagustiani@gmail.com','17','2026-01-20 08:32:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('403','114.122.110.164','gilangsepteranurhendra@gmail.com','38','2026-01-20 08:34:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('404','2404:c0:2a10::1126:be71','evitinisukartini@gmail.com','12','2026-01-20 08:42:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('405','114.122.85.233','galihwangi@gmail.com','43','2026-01-20 09:44:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('406','114.122.85.233','galihwangi@gmail.com','43','2026-01-20 09:44:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('407','114.122.100.152','elsaandriani@gmail.com','40','2026-01-20 10:31:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('408','114.122.107.46','adeirfannugraha@gmail.com','29','2026-01-20 10:47:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('409','2404:c0:2b10::1138:6635','nisa@gmail.com','51','2026-01-20 11:24:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('410','114.122.70.174','noviestephen@gmail.com','18','2026-01-20 11:28:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('411','114.122.102.163','haniherlina@gmail.com','34','2026-01-20 11:53:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('412','2404:c0:2e10::f47:2d66','pupuypuadah@gmail.com','53','2026-01-20 12:08:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('413','2404:c0:2910::1139:642a','irmannurhendra@gmail.com','20','2026-01-20 13:23:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('414','2404:c0:2e10::f4b:4fad','elsaandriani@gmail.com','40','2026-01-20 14:33:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('415','114.122.79.246','noviestephen@gmail.com','18','2026-01-20 14:33:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('416','2404:c0:2c10::f4d:fb4a','ikasartika@gmail.com','7','2026-01-20 14:33:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('417','2404:c0:2c10::f33:802d','syfaulhusna@gmail.com','52','2026-01-20 14:34:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('418','2404:c0:2910::1144:af8e','weniwidaningrum@gmail.com','8','2026-01-20 14:34:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('419','2404:c0:2810::713:2465','jonihprasetia@gmail.com','47','2026-01-20 14:35:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('420','114.122.85.10','anihgindalistiani@gmail.com','15','2026-01-20 14:35:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('421','2404:c0:2810::713:a31e','rentydwiyanti@gmail.com','50','2026-01-20 14:36:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('422','2404:c0:2c10::f31:f683','susilawati@gmail.com','54','2026-01-20 14:36:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('423','114.122.71.117','sriastutisyam@gmail.com','22','2026-01-20 14:36:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('424','114.122.77.185','sitimunawaroh@gmail.com','41','2026-01-20 14:37:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('425','202.46.68.41','sitipatimah@gmail.com','6','2026-01-20 14:37:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('426','114.122.71.115','yuliagustiani@gmail.com','17','2026-01-20 14:38:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('427','114.122.110.240','enokmira@gmail.com','60','2026-01-20 14:38:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('428','2404:c0:2f10::f53:bbbc','ranianggraeni@gmail.com','59','2026-01-20 14:38:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('429','2404:c0:2e10::f47:2d66','pupuypuadah@gmail.com','53','2026-01-20 14:38:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('430','2404:c0:2e10::f3d:87f6','henririsnandar@gmail.com','28','2026-01-20 14:39:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('431','114.122.106.67','haniherlina@gmail.com','34','2026-01-20 14:39:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('432','114.122.68.38','neneng@gmail.com','13','2026-01-20 14:42:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('433','2404:c0:2a10::114f:dee4','rdsusimurti@gmail.com','48','2026-01-20 14:43:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('434','2404:c0:2810::6b4:bc6e','wulanpurnamasari@gmail.com','37','2026-01-20 14:44:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('435','2404:c0:2d10::f31:c6d7','acepantonfajar@gmail.com','57','2026-01-20 14:44:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('436','36.81.226.139','asepcandra@gmail.com','31','2026-01-20 14:44:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('437','36.81.226.139','asepcandra@gmail.com','31','2026-01-20 14:44:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('438','36.81.226.139','asepcandra@gmail.com','31','2026-01-20 14:45:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('439','2404:c0:2910::1143:3780','dinanursolihat@gmail.com','56','2026-01-20 14:50:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('440','2404:c0:2d10::f40:f0a4','novitaandriani@gmail.com','45','2026-01-20 14:51:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('441','2404:c0:2a10::113f:2e00','evitinisukartini',NULL,'2026-01-20 14:52:32','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('442','2404:c0:2a10::113f:2e00','evitinisukartini',NULL,'2026-01-20 14:52:45','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('443','2404:c0:2a10::113f:2e00','evitinisukartini@gmail.com','12','2026-01-20 14:53:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('444','2404:c0:2910::1111:7d25','yuyunyunaningsih@gmail.com','23','2026-01-20 14:53:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('445','2404:c0:2e10::f37:f8bc','emmysitimariyam@gmail.com','19','2026-01-20 14:54:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('446','2404:c0:2e10::f37:f8bc','emmysitimariyam@gmail.com','19','2026-01-20 14:54:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('447','114.122.111.0','anggagunawan@gmail.com','39','2026-01-20 15:03:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('448','2404:c0:2a10::114c:b276','niss',NULL,'2026-01-20 15:09:05','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('449','2404:c0:2a10::114c:b276','nisa@gmail.com','51','2026-01-20 15:09:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('450','2404:c0:2b10::111c:e906','ekasantikalestari@gmail.com','44','2026-01-20 15:18:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('451','36.81.226.139','yosisitirosita@gmail.com','32','2026-01-20 15:23:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('452','2404:c0:2f10::f35:6a61','ripkiardian@gmail.com','35','2026-01-20 15:43:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('453','2404:c0:2d10::f55:7cb4','muhtarsidik@gmail.com','49','2026-01-20 15:48:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('454','103.188.169.153','ritanurfatimah@gmail.com','25','2026-01-20 15:56:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('455','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-20 17:21:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('456','103.188.169.69','rentydwiyanti@gmail.com','50','2026-01-20 18:54:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('457','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-20 22:30:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('458','180.245.117.193','agustomi@gmail.com','27','2026-01-20 22:49:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('459','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-21 04:58:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('460','2404:c0:2c10::f7b:b89e','emmysitimariyam@gmail.com','19','2026-01-21 05:45:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('461','2404:c0:2c10::f7a:2710','syfaulhusna@gmail.com','52','2026-01-21 06:09:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('462','2404:c0:2810::747:8fc5','yuyunyunaningsih@gmail.com','23','2026-01-21 06:10:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('463','2404:c0:2a10::117e:966d','sitipatimah@gmail.com','6','2026-01-21 06:20:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('464','2404:c0:2d10::f85:f901','muhtarsidik@gmail.com','49','2026-01-21 06:28:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('465','114.122.83.81','muhtargojali@gmail.com','21','2026-01-21 06:31:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('466','114.122.110.113','sitimunawaroh@gmail.com','41','2026-01-21 06:31:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('467','114.122.115.115','galihwangi@gmail.com','43','2026-01-21 06:37:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('468','103.188.169.69','susilawati@gmail.com','54','2026-01-21 06:39:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('469','2404:c0:2810::74e:cdcd','dinanursolihat@gmail.com','56','2026-01-21 06:41:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('470','2404:c0:2b10::117c:7714','novitaandriani@gmail.com','45','2026-01-21 06:42:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('471','114.122.76.109','sriastutisyam@gmail.com','22','2026-01-21 06:44:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('472','2404:c0:2e10::f82:25e4','elsaandriani@gmail.com','40','2026-01-21 06:47:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('473','114.122.110.204','anggagunawan@gmail.com','39','2026-01-21 06:54:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('474','2404:c0:2e10::f80:162b','irmannurhendra@gmail.com','20','2026-01-21 06:56:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('475','2404:c0:2810::74f:11d3','evitinisukartini@gmail.com','12','2026-01-21 06:56:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('476','2404:c0:2810::74f:11d3','evitinisukartini@gmail.com','12','2026-01-21 06:56:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('477','114.122.76.64','henririsnandar@gmail.com','28','2026-01-21 06:59:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('478','2404:c0:2e10::f8b:877c','weniwidaningrum@gmail.com','8','2026-01-21 07:02:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('479','114.122.105.76','enokmira@gmail.com','60','2026-01-21 07:06:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('480','114.122.68.38','neneng@gmail.com','13','2026-01-21 07:10:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('481','180.245.117.193','agustomi@gmail.com','27','2026-01-21 07:19:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('482','2404:c0:2b10::1196:20cc','noviestephen@gmail.com','18','2026-01-21 07:22:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('483','114.122.85.3','yosisitirosita@gmail.com','32','2026-01-21 07:22:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('484','2404:c0:2a10::1168:8eb','yuliagustiani@gmail.com','17','2026-01-21 07:23:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('485','114.122.85.114','haniherlina@gmail.com','34','2026-01-21 07:24:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('486','114.122.77.220','asepcandra@gmail.com','31','2026-01-21 07:27:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('487','114.122.70.56','pupuypuadah@gmail.com','53','2026-01-21 07:29:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('488','2404:c0:2d10::f80:c375','agismujiprayitno@gmail.com','24','2026-01-21 07:30:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('489','2404:c0:2e10::f8f:7c71','rentydwiyanti@gmail.com','50','2026-01-21 07:31:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('490','36.81.226.139','anihgindalistiani@gmail.com','15','2026-01-21 08:20:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('491','2404:c0:2a10::1151:fb5c','acepantonfajar@gmail.com','57','2026-01-21 08:56:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('492','2404:c0:2e10::f85:334b','susilawati@gmail.com','54','2026-01-21 09:14:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('493','114.122.103.158','adeirfannugraha@gmail.com','29','2026-01-21 09:43:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('494','2404:c0:2f10::f95:110a','emmysitimariyam@gmail.com','19','2026-01-21 09:46:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('495','2404:c0:2f10::f95:110a','emmysitimariyam@gmail.com','19','2026-01-21 09:46:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('496','114.122.115.25','gilangsepteranurhendra@gmail.com','38','2026-01-21 10:14:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('497','114.122.72.113','anihgindalistiani@gmail.com','15','2026-01-21 10:54:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('498','2404:c0:2c10::f87:b9b3','sitipatimah@gmail.com','6','2026-01-21 10:57:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('499','2404:c0:2910::1170:a663','henririsnandar@gmail.com','28','2026-01-21 10:58:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('500','2001:448a:3070:1d39:189f:19b:de75:7248','yusmansetiawan@gmail.com','14','2026-01-21 12:22:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('501','2404:c0:2e10::f9d:f007','elsaandriani@gmail.com','40','2026-01-21 12:30:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('502','2404:c0:2a10::1190:ace4','yuyunyunaningsih@gmail.com','23','2026-01-21 12:38:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('503','36.81.226.139','dinanursolihat@gmail.com','56','2026-01-21 12:46:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('504','36.81.226.139','haniherlina@gmail.com','34','2026-01-21 12:47:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('505','114.122.84.134','neneng@gmail.com','13','2026-01-21 12:54:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('506','114.122.111.20','anggagunawan@gmail.com','39','2026-01-21 13:02:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('507','180.245.117.193','agustomi@gmail.com','27','2026-01-21 13:44:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('508','2404:c0:2c10::f7e:bd9e','tiaiqbalhembara@gmail.com','55','2026-01-21 13:56:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('509','2404:c0:2c10::f7e:bd9e','tiaiqbalhembara@gmail.com','55','2026-01-21 13:56:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('510','2404:c0:2c10::f9b:b58f','ritanurfatimah',NULL,'2026-01-21 14:11:45','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('511','2404:c0:2c10::f9b:b58f','ritanurfatimah',NULL,'2026-01-21 14:12:12','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('512','2404:c0:2f10::f9c:1cec','ritanurfatimah@gmail.com','25','2026-01-21 14:37:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('513','2404:c0:2a10::1190:ace4','yuyunyunaningsih@gmail.com','23','2026-01-21 14:41:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('514','2404:c0:2c10::f90:b74c','syfaulhusna@gmail.com','52','2026-01-21 14:41:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('515','114.122.103.158','adeirfannugraha@gmail.com','29','2026-01-21 14:43:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('516','114.122.68.95','ikanurhasanah@gmail.com','26','2026-01-21 14:44:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('517','2404:c0:2d10::fa5:c255','detirosmawati@gmail.com','36','2026-01-21 14:44:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('518','2404:c0:2b10::1196:c574','novitaandriani@gmail.com','45','2026-01-21 14:44:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('519','2404:c0:2910::118d:a441','nisa@gmail.com','51','2026-01-21 14:45:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('520','2404:c0:2e10::f95:ef2d','weniwidaningrum@gmail.com','8','2026-01-21 14:45:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('521','2404:c0:2f10::f8d:74b5','sitipatimah@gmail.com','6','2026-01-21 14:45:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('522','2404:c0:2910::1170:a663','henririsnandar@gmail.com','28','2026-01-21 14:45:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('523','114.122.103.246','sitimunawaroh@gmail.com','41','2026-01-21 14:45:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('524','2404:c0:2d10::f87:47ba','neneng@gmail.com','13','2026-01-21 14:45:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('525','36.81.226.139','muhtargojali@gmail.com','21','2026-01-21 14:47:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('526','2404:c0:2f10::f9f:e53a','dinanursolihat@gmail.com','56','2026-01-21 14:47:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('527','2404:c0:2d10::f87:9f9b','muhtarsidik@gmail.com','49','2026-01-21 14:47:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('528','2404:c0:2c10::f75:3c41','ikasartika@gmail.com','7','2026-01-21 14:49:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('529','2404:c0:2c10::f9e:43fb','wulanpurnamasari@gmail.com','37','2026-01-21 14:52:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('530','2404:c0:2910::117a:1d4f','ripkiardian@gmail.com','35','2026-01-21 14:55:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('531','2404:c0:2c10::fa5:370b','elsaandriani@gmail.com','40','2026-01-21 14:56:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('532','2404:c0:2910::1184:5b6e','noviestephen@gmail.com','18','2026-01-21 14:58:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('533','2404:c0:2c10::f8a:1d19','emmysitimariyam@gmail.com','19','2026-01-21 15:04:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('534','114.122.70.109','sriastutisyam@gmail.com','22','2026-01-21 15:09:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('535','2404:c0:2c10::f88:5b95','jonihprasetia@gmail.com','47','2026-01-21 15:11:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('536','2404:c0:2e10::f82:6c1f','ekasantikalestari@gmail.com','44','2026-01-21 15:11:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('537','2404:c0:2910::1196:a516','rentydwiyanti@gmail.com','50','2026-01-21 15:15:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('538','2404:c0:2910::1196:a516','rentydwiyanti@gmail.com','50','2026-01-21 15:15:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('539','2404:c0:2a10::119f:544e','linlinpermatapraja@gmail.com','61','2026-01-21 15:16:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('540','114.122.77.196','asepcandra@gmail.com','31','2026-01-21 15:24:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('541','103.188.169.69','susilawati@gmail.com','54','2026-01-21 15:24:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('542','2404:c0:2b10::11ab:3d71','agismujiprayitno@gmail.com','24','2026-01-21 15:38:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('543','2404:c0:2e10::f9f:79ee','rdsusimurti@gmail.com','48','2026-01-21 15:39:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('544','114.122.102.24','anggagunawan@gmail.com','39','2026-01-21 15:47:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('545','36.81.226.139','evitinisukartini@gmail.com','12','2026-01-21 16:29:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('546','103.188.169.69','rentydwiyanti@gmail.com','50','2026-01-21 18:17:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('547','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-21 18:44:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('548','2404:c0:2e10::fba:54a9','ritanurfatimah@gmail.com','25','2026-01-21 19:15:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('549','114.122.106.54','haniheelina',NULL,'2026-01-21 19:52:47','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('550','114.122.106.54','haniherlina@gmail.com','34','2026-01-21 19:53:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('551','2404:c0:2810::786:4053','elsaandriani@gmail.com','40','2026-01-21 20:03:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('552','202.46.68.71','adeirfannugraha',NULL,'2026-01-21 23:35:14','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('553','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-21 23:35:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('554','2404:c0:2e10::fd0:d269','acepantonfajar@gmail.com','57','2026-01-22 05:35:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('555','2404:c0:2d10::fcd:d611','irmannurhendra@gmail.com','20','2026-01-22 05:56:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('556','2404:c0:2810::79f:789f','yuyunyunaningsih@gmail.com','23','2026-01-22 06:03:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('557','36.81.226.139','sitipatimah@gmail.com','6','2026-01-22 06:10:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('558','2404:c0:2e10::fcd:ba88','jonihprasetia@gmail.com','47','2026-01-22 06:15:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('559','2404:c0:2e10::fc8:bb20','wulanpurnamasari@gmail.com','37','2026-01-22 06:19:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('560','114.122.82.125','anihgindalistiani@gmail.com','15','2026-01-22 06:21:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('561','2404:c0:2e10::fd4:7c97','emmysitimariyam@gmail.com','19','2026-01-22 06:22:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('562','103.188.169.69','susilawati@gmail.com','54','2026-01-22 06:22:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('563','36.81.226.139','siskatutiana@gmail.com','62','2026-01-22 06:26:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('564','114.122.82.53','asepsuryadi',NULL,'2026-01-22 06:27:59','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('565','114.122.82.53','asepsuryadi@gmail.com','5','2026-01-22 06:29:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('566','114.122.79.84','asepcandra@gmail.com','31','2026-01-22 06:31:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('567','202.46.68.41','adeirfannugraha@gmail.com','29','2026-01-22 06:31:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('568','2404:c0:2810::7a7:bd43','ekasantikalestari@gmail.com','44','2026-01-22 06:33:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('569','2404:c0:2910::11dc:78a','syfaulhusna@gmail.com','52','2026-01-22 06:34:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('570','2404:c0:2d10::fce:900e','noviestephen@gmail.com','18','2026-01-22 06:39:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('571','2404:c0:2e10::fcd:2162','firmanmuharam',NULL,'2026-01-22 06:39:55','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('572','2404:c0:2e10::fcd:2162','firmanmuharam',NULL,'2026-01-22 06:40:17','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('573','2404:c0:2c10::fc6:cc45','yuliagustiani@gmail.com','17','2026-01-22 06:43:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('574','2404:c0:2e10::fcd:2162','firmanmuharam',NULL,'2026-01-22 06:47:14','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('575','2404:c0:2d10::fd0:bd9f','pupuypuadah@gmail.com','53','2026-01-22 06:48:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('576','114.122.69.105','sriastutisyam@gmail.com','22','2026-01-22 06:49:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('577','114.122.108.48','enokmira@gmail.com','60','2026-01-22 06:51:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('578','114.122.108.48','enokmira@gmail.com','60','2026-01-22 06:51:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('579','2404:c0:6a1e:8f98:9c4d:ffff:fe92:bc6','nanangnajamudin@gmail.com','30','2026-01-22 06:52:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('580','114.122.105.60','yosisitirosita@gmail.com','32','2026-01-22 06:52:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('581','2404:c0:2d10::fd7:14cf','elsaandriani@gmail.com','40','2026-01-22 06:52:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('582','36.81.226.139','henririsnandar@gmail.com','28','2026-01-22 06:56:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('583','36.81.226.139','henririsnandar@gmail.com','28','2026-01-22 06:56:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('584','2404:c0:2d10::fce:27bf','henririsnandar@gmail.com','28','2026-01-22 06:57:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('585','2404:c0:2b10::11df:f3d6','nisa@gmail.com','51','2026-01-22 06:57:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('586','114.122.114.255','firmanmuharam',NULL,'2026-01-22 06:58:32','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('587','2404:c0:2e10::fcd:2162','firmanmuharam@gmail.com','58','2026-01-22 06:59:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('588','114.122.79.201','anggagunawan@gmail.com','39','2026-01-22 07:05:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('589','114.122.84.32','gilangsepteranurhendra@gmail.com','38','2026-01-22 07:06:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('590','114.122.84.32','gilangsepteranurhendra@gmail.com','38','2026-01-22 07:06:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('591','2404:c0:2810::7a4:61b8','ikasartika@gmail.com','7','2026-01-22 07:10:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('592','114.122.108.52','galihwangi@gmail.com','43','2026-01-22 07:11:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('593','2404:c0:2810::7ac:8091','ranianggraeni@gmail.com','59','2026-01-22 07:12:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('594','36.81.226.139','evitinisukartini@gmail.com','12','2026-01-22 07:14:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('595','114.122.74.138','neneng@gmail.com','13','2026-01-22 07:15:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('596','2404:c0:2b10::11de:e685','muhtarsidik@gmail.com','49','2026-01-22 07:20:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('597','2404:c0:2b10::11df:b99','weniwidaningrum@gmail.com','8','2026-01-22 07:22:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('598','114.122.111.139','mohammadsuhardiwan@gmail.com','4','2026-01-22 07:27:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('599','114.122.111.139','mohammmadsuhardiwan',NULL,'2026-01-22 07:28:03','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('600','114.122.111.139','mohammadsuhardiwan@gmail.com','4','2026-01-22 07:28:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('601','180.241.241.75','muhtarsidik@gmail.com','49','2026-01-22 08:06:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('602','103.188.169.69','rentydwiyanti@gmail.com','50','2026-01-22 08:30:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('603','2404:c0:2910::11dc:78a','syfaulhusna@gmail.com','52','2026-01-22 08:40:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('604','2404:c0:2f10::fd8:350c','ritanurfatimah@gmail.com','25','2026-01-22 08:45:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('605','36.81.226.139','haniherlina@gmail.com','34','2026-01-22 08:47:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('606','2404:c0:2b10::11db:77ac','tiaiqbalhembara@gmail.com','55','2026-01-22 09:03:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('607','2404:c0:2b10::11db:77ac','tiaiqbalhembara@gmail.com','55','2026-01-22 09:03:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('608','2404:c0:2e10::fde:342c','nisa@gmail.com','51','2026-01-22 09:05:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('609','114.122.78.210','agustomi@gmail.com','27','2026-01-22 09:06:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('610','2404:c0:2e10::fd7:aa26','ripkiardian@gmail.com','35','2026-01-22 09:53:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('611','202.46.68.41','anihgindalistiani@gmail.com','15','2026-01-22 10:03:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('612','2404:c0:2e10::fd9:8f05','evitinisukartini@gmail.com','12','2026-01-22 10:11:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('613','114.122.111.139','mohammadsuhardiwan@gmail.com','4','2026-01-22 10:35:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('614','114.122.71.36','asepcandra@gmail.com','31','2026-01-22 11:32:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('615','114.122.78.210','agustomi@gmail.com','27','2026-01-22 12:04:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('616','2404:c0:2b10::11db:77ac','tiaiqbalhembara@gmail.com','55','2026-01-22 12:38:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('617','114.122.111.173','adeirfannugraha@gmail.com','29','2026-01-22 12:56:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('618','2404:c0:2810::79f:789f','yuyunyunaningsih@gmail.com','23','2026-01-22 13:14:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('619','2404:c0:2f10::ff4:f550','sitipatimah@gmail.com','6','2026-01-22 13:17:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('620','114.122.100.6','emmysitimariyam@gmail.com','19','2026-01-22 13:19:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('621','202.46.68.41','noviestephen@gmail.com','18','2026-01-22 13:23:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('622','182.5.137.207','wulanpurnamasari@gmail.com','37','2026-01-22 13:33:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('623','2404:c0:2c10::fe6:38d0','jonihprasetia@gmail.com','47','2026-01-22 13:39:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('624','2404:c0:2a10::11e1:4c13','weniwidaningrum@gmail.com','8','2026-01-22 13:52:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('625','2404:c0:2910::11f6:75ba','syfaulhusna@gmail.com','52','2026-01-22 14:00:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('626','2404:c0:2f10::ffe:a14','nisa@gmail.com','51','2026-01-22 14:06:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('627','2404:c0:2c10::fed:cc0f','muhtarsidik@gmail.com','49','2026-01-22 14:10:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('628','36.77.29.243','nanangnajamudin@gmail.com','30','2026-01-22 14:11:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('629','36.77.29.243','nanangnajamudin@gmail.com','30','2026-01-22 14:11:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('630','114.122.116.9','neneng@gmail.com','13','2026-01-22 14:11:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('631','2404:c0:2810::7a7:bd43','ekasantikalestari@gmail.com','44','2026-01-22 14:20:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('632','36.77.29.243','ajatsudrajat@gmail.com','42','2026-01-22 14:24:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('633','2404:c0:2f10::ffd:3f82','rentydwiyanti@gmail.com','50','2026-01-22 14:24:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('634','2404:c0:2f10::ffd:3f82','rentydwiyanti@gmail.com','50','2026-01-22 14:24:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('635','2404:c0:2f10::fd8:ad54','susilawati@gmail.com','54','2026-01-22 14:25:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('636','2404:c0:2f10::fd8:ad54','susilawati@gmail.com','54','2026-01-22 14:25:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('637','2404:c0:2f10::fd8:ad54','susilawati@gmail.com','54','2026-01-22 14:25:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('638','114.122.85.226','haniherlina@gmail.com','34','2026-01-22 14:26:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('639','2404:c0:2e10::fd0:d269','acepantonfajar@gmail.com','57','2026-01-22 14:26:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('640','2404:c0:2e10::fd0:d269','acepantonfajar@gmail.com','57','2026-01-22 14:26:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('641','2404:c0:2f10::ffd:3f82','rentydwiyanti@gmail.com','50','2026-01-22 14:27:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('642','2404:c0:2f10::ffd:3f82','rentydwiyanti@gmail.com','50','2026-01-22 14:27:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('643','2404:c0:2a10::11de:d694','novitaandriani@gmail.com','45','2026-01-22 14:28:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('644','36.77.29.243','siskatutiana@gmail.com','62','2026-01-22 14:28:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('645','114.122.108.197','galihwangi@gmail.com','43','2026-01-22 14:29:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('646','2404:c0:2d10::fce:27bf','henririsnandar',NULL,'2026-01-22 14:31:12','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('647','2404:c0:2d10::ff0:9b30','evitinisukartini@gmail.com','12','2026-01-22 14:31:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('648','2404:c0:2d10::ff0:9b30','evitinisukartini@gmail.com','12','2026-01-22 14:31:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('649','2404:c0:2d10::ff0:9b30','evitinisukartini@gmail.com','12','2026-01-22 14:31:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('650','2404:c0:2f10::ffa:71aa','dinanursolihat@gmail.com','56','2026-01-22 14:31:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('651','2404:c0:2b10::11fc:3fe1','ikasartika@gmail.com','7','2026-01-22 14:31:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('652','2404:c0:2d10::fce:27bf','henririsnandar@gmail.com','28','2026-01-22 14:31:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('653','114.122.114.208','sitimunawaroh@gmail.com','41','2026-01-22 14:31:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('654','2404:c0:2f10::ff5:7723','rdsusimurti@gmail.com','48','2026-01-22 14:31:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('655','2404:c0:2e10::fee:4e90','pupuypuadah@gmail.com','53','2026-01-22 14:32:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('656','2404:c0:2e10::fe9:735c','yuliagustiani@gmail.com','17','2026-01-22 14:32:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('657','2404:c0:2e10::fe9:735c','yuliagustiani@gmail.com','17','2026-01-22 14:32:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('658','2404:c0:2e10::fe9:735c','yuliagustiani@gmail.com','17','2026-01-22 14:32:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('659','2404:c0:2e10::fe9:735c','yuliagustiani@gmail.com','17','2026-01-22 14:32:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('660','2404:c0:2910::11fb:f9e2','detirosmawati@gmail.com','36','2026-01-22 14:37:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('661','36.77.29.243','linlinpermatapraja@gmail.com','61','2026-01-22 14:38:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('662','36.77.29.243','ikanurhasanah@gmail.com','26','2026-01-22 14:38:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('663','114.122.70.13','enokmira@gmail.com','60','2026-01-22 14:39:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('664','2404:c0:2e10::ff3:d8f7','ritanurtafimah',NULL,'2026-01-22 14:43:07','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('665','2404:c0:2d10::ff9:6ee9','ritanurfatimah@gmail.com','25','2026-01-22 14:43:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('666','36.77.29.243','muchtarsidiq@gmail.com','16','2026-01-22 14:45:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('667','114.122.71.36','asepcandra@gmail.com','31','2026-01-22 14:50:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('668','2404:c0:2e10::fed:8de0','muchtarsidiq@gmail.com','16','2026-01-22 14:52:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('669','114.122.79.197','anggagunawan@gmail.com','39','2026-01-22 14:54:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('670','114.122.79.109','sriastutisyam@gmail.com','22','2026-01-22 15:35:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('671','103.188.169.69','rentydwiyanti@gmail.com','50','2026-01-22 17:29:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('672','2404:c0:2f10::1008:4b37','elsaandriani@gmail.com','40','2026-01-22 18:04:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('673','103.138.53.62','noviestephen@gmail.com','18','2026-01-22 18:27:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('674','103.138.53.62','noviestephen@gmail.com','18','2026-01-22 18:27:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('675','103.166.159.217','pupuypuadah@gmail.com','53','2026-01-22 18:52:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('676','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-22 19:24:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('677','2404:c0:2a10::120b:7801','rentydwiyanti@gmail.com','50','2026-01-22 19:54:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('678','2404:c0:2e10::ff6:1db2','rdsusimurti@gmail.com','48','2026-01-22 20:31:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('679','36.83.124.19','asepcandra@gmail.com','31','2026-01-22 20:33:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('680','2404:c0:2e10::1027:fa5b','acepantonfajar@gmail.com','57','2026-01-23 05:31:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('681','2404:c0:2e10::1027:fa5b','acepantonfajar@gmail.com','57','2026-01-23 05:31:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('682','2404:c0:2b10::1234:1b14','yuyunyunaningsih@gmail.com','23','2026-01-23 06:06:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('683','114.122.73.66','ikanurhasanah@gmail.com','26','2026-01-23 06:06:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('684','2404:c0:2e10::1013:2917','yuliagustiani@gmail.com','17','2026-01-23 06:10:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('685','2404:c0:2910::1237:f7a3','ekasantikalestari@gmail.com','44','2026-01-23 06:10:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('686','114.122.109.213','neneng@gmail.com','13','2026-01-23 06:10:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('687','2404:c0:2f10::1024:938d','neneng ',NULL,'2026-01-23 06:12:49','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('688','2404:c0:2f10::1024:938d','neneng@gmail.com','13','2026-01-23 06:13:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('689','114.122.103.169','adeirfannugraha@gmail.com','29','2026-01-23 06:16:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('690','114.122.102.235','enokmira@gmail.com','60','2026-01-23 06:20:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('691','103.188.169.69','susilawati@gmail.com','54','2026-01-23 06:24:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('692','2404:c0:2b10::123d:8611','rdsusimurti@gmail.com','48','2026-01-23 06:27:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('693','114.122.84.126','asepsuryadi@gmail.com','5','2026-01-23 06:27:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('694','2404:c0:2d10::1028:d57f','jonihprasetia@gmail.com','47','2026-01-23 06:29:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('695','114.122.70.40','anggagunawan@gmail.com','39','2026-01-23 06:30:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('696','2404:c0:2910::1236:69ae','ritanurfatimah@gmail.com','25','2026-01-23 06:30:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('697','2404:c0:2d10::1026:7ece','henririsnandar@gmail.com','28','2026-01-23 06:33:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('698','2404:c0:2810::803:a682','emmysitimariyam@gmail.com','19','2026-01-23 06:33:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('699','2404:c0:2c10::101a:50b','agismujiprayitno@gmail.com','24','2026-01-23 06:36:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('700','2404:c0:2810::805:1903','noviestephen@gmail.com','18','2026-01-23 06:47:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('701','2404:c0:2810::805:1903','noviestephen@gmail.com','18','2026-01-23 06:47:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('702','114.122.73.72','yosisitirosita@gmail.com','32','2026-01-23 06:48:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('703','114.122.73.72','yosisitirosita@gmail.com','32','2026-01-23 06:48:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('704','114.122.73.72','yosisitirosita@gmail.com','32','2026-01-23 06:48:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('705','114.122.110.180','pupuypuadah@gmail.com','53','2026-01-23 06:49:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('706','2404:c0:2a10::122d:ced8','elsaandriani@gmail.com','40','2026-01-23 06:52:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('707','2404:c0:2f10::102f:8218','dinanursolihat@gmail.com','56','2026-01-23 06:53:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('708','2404:c0:2a10::11f0:1e5a','ripkiardian@gmail.com','35','2026-01-23 06:57:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('709','114.122.77.152','sitipatimah@gmail.com','6','2026-01-23 06:58:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('710','114.122.102.7','mohammadsuhardiwan@gmail.com','4','2026-01-23 07:01:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('711','2404:c0:2d10::102a:644a','irmannurhendra@gmail.com','20','2026-01-23 07:03:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('712','2404:c0:2e10::102c:a1e2','rentydwiyanti@gmail.com','50','2026-01-23 07:06:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('713','2404:c0:2e10::102c:a1e2','rentydwiyanti@gmail.com','50','2026-01-23 07:06:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('714','2404:c0:2e10::102c:a1e2','rentydwiyanti@gmail.com','50','2026-01-23 07:07:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('715','114.122.71.97','sriastutisyam@gmail.com','22','2026-01-23 07:09:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('716','2404:c0:2910::123a:43c6','weniwidaningrum@gmail.com','8','2026-01-23 07:09:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('717','2404:c0:2810::806:1c22','nisa@gmail.com','51','2026-01-23 07:12:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('718','114.122.72.69','agustomi@gmail.com','27','2026-01-23 07:34:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('719','2404:c0:2910::1248:f3bf','muhtarsidik@gmail.com','49','2026-01-23 07:37:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('720','114.122.79.141','haniherlina@gmail.com','34','2026-01-23 07:38:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('721','182.5.136.197','wulanpurnamasari@gmail.com','37','2026-01-23 07:45:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('722','36.83.124.19','asepcandra@gmail.com','31','2026-01-23 07:49:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('723','36.77.29.243','anihgindalistiani@gmail.com','15','2026-01-23 08:11:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('724','114.122.103.117','gilangsepteranurhendra@gmail.com','38','2026-01-23 08:48:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('725','2404:c0:2a10::123b:4518','evitinisukartini@gmail.com','12','2026-01-23 09:06:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('726','114.122.117.23','adeirfannugraha@gmail.com','29','2026-01-23 09:08:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('727','2404:c0:2e10::1013:2917','yuliagustiani@gmail.com','17','2026-01-23 09:30:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('728','2404:c0:2e10::1013:2917','yuliagustiani@gmail.com','17','2026-01-23 09:30:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('729','36.77.29.243','ikanurhasanah@gmail.com','26','2026-01-23 09:48:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('730','114.122.73.72','yosisitirosita@gmail.com','32','2026-01-23 09:50:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('731','2404:c0:2810::80e:872','muchtarsidiq@gmail.com','16','2026-01-23 10:15:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('732','2404:c0:2810::80e:872','muchtarsidiq@gmail.com','16','2026-01-23 10:25:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('733','36.77.29.243','adminsuper@gmail.com','1','2026-01-23 10:25:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('734','2404:c0:2810::80e:872','muchtarsidiq@gmail.com','16','2026-01-23 10:26:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('735','114.122.68.128','enokmira@gmail.com','60','2026-01-23 10:50:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('736','2404:c0:2810::80e:a075','ekasantikalestari@gmail.com','44','2026-01-23 10:51:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('737','2404:c0:2f10::1046:e41e','ritanurfatimah@gmail.com','25','2026-01-23 11:01:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('738','2404:c0:2910::124c:7463','linlinpermatapraja@gmail.com','61','2026-01-23 11:07:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('739','114.122.115.29','haniherlina@gmail.com','34','2026-01-23 11:07:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('740','36.77.29.243','evitinisukartini@gmail.com','12','2026-01-23 11:08:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('741','114.122.70.134','muhtargojali@gmail.com','21','2026-01-23 11:08:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('742','2404:c0:2a10::1254:9f0','yuyunyunaningsih@gmail.com','23','2026-01-23 11:09:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('743','2404:c0:2c10::101a:50b','agismujiprayitno@gmail.com','24','2026-01-23 11:11:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('744','2404:c0:2910::123c:cb21','susilawati@gmail.com','54','2026-01-23 11:14:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('745','114.122.115.232','galihwangi@gmail.com','43','2026-01-23 11:14:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('746','36.77.29.243','siskatutiana@gmail.com','62','2026-01-23 11:17:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('747','2404:c0:2d10::1039:3efa','irmannurhendra@gmail.com','20','2026-01-23 11:17:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('748','2404:c0:2d10::1036:a451','elsaandriani@gmail.com','40','2026-01-23 11:17:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('749','2404:c0:2910::1258:bc6d','emmysitimariyam@gmail.com','19','2026-01-23 11:19:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('750','2404:c0:2910::1258:bc6d','emmysitimariyam@gmail.com','19','2026-01-23 11:19:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('751','2404:c0:2910::1258:bc6d','emmysitimariyam@gmail.com','19','2026-01-23 11:19:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('752','2404:c0:2910::1258:bc6d','emmysitimariyam@gmail.com','19','2026-01-23 11:20:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('753','2404:c0:2910::1258:bc6d','emmysitimariyam@gmail.com','19','2026-01-23 11:20:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('754','2404:c0:2910::1258:bc6d','emmysitimariyam@gmail.com','19','2026-01-23 11:20:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('755','2404:c0:2910::1258:bc6d','emmysitimariyam@gmail.com','19','2026-01-23 11:20:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('756','2404:c0:2e10::1042:4225','weniwidaningrum@gmail.com','8','2026-01-23 11:20:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('757','2404:c0:2b10::124a:d715','muhtarsidik@gmail.com','49','2026-01-23 11:22:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('758','2404:c0:2a10::1238:b0a1','sitipatimah@gmail.com','6','2026-01-23 11:22:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('759','2404:c0:2910::1252:6b78','syfaulhusna@gmail.com','52','2026-01-23 11:27:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('760','2404:c0:2e10::103a:b8df','pupuypuadah@gmail.com','53','2026-01-23 11:30:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('761','114.122.68.91','sriastutisyam@gmail.com','22','2026-01-23 11:34:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('762','2404:c0:2e10::1027:fa5b','acepantonfajar@gmail.com','57','2026-01-23 11:37:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('763','114.122.110.36','anihgindalistiani@gmail.com','15','2026-01-23 11:38:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('764','103.208.101.2','nisa@gmail.com','51','2026-01-23 12:14:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('765','103.188.169.69','rentydwiyanti@gmail.com','50','2026-01-23 12:57:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('766','114.122.114.20','yuliagustiani@gmail.com','17','2026-01-23 13:17:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('767','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-23 14:00:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('768','36.83.124.19','asepcandra@gmail.com','31','2026-01-23 14:56:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('769','103.184.16.247','henririsnandar@gmail.com','28','2026-01-23 15:41:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('770','114.122.83.18','adeirfannugraha@gmail.com','29','2026-01-23 15:47:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('771','2404:c0:2a10::1269:fb5f','emmysitimariyam@gmail.com','19','2026-01-23 16:43:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('772','36.77.29.243','galihwangi@gmail.com','43','2026-01-23 17:12:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('773','103.138.53.62','noviestephen@gmail.com','18','2026-01-23 17:59:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('774','103.138.53.62','noviestephen@gmail.com','18','2026-01-23 17:59:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('775','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-23 19:48:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('776','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-23 21:46:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('777','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-24 04:57:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('778','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-24 11:41:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('779','114.122.83.59','mohammadsuhardiwan@gmail.com','4','2026-01-25 01:10:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('780','180.245.252.188','novitaandriani@gmail.com','45','2026-01-25 07:12:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('781','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 00:06:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('782','2404:c0:2810::924:ec1e','linlinpermatapraja@gmail.com','61','2026-01-26 06:06:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('783','2404:c0:2910::1352:86bc','pupuypuadah@gmail.com','53','2026-01-26 06:06:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('784','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-26 06:07:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('785','2404:c0:2d10::1124:a6bd','evitinisukartini@gmail.com','12','2026-01-26 06:11:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('786','202.46.68.41','adeirfannugraha@gmail.com','29','2026-01-26 06:14:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('787','2404:c0:2810::920:3e51','yuyunyunaningsih@gmail.com','23','2026-01-26 06:15:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('788','2404:c0:2e10::1123:91d4','emmysitimariyam@gmail.com','19','2026-01-26 06:17:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('789','2404:c0:2d10::1121:913','tiaiqbalhembara@gmail.com','55','2026-01-26 06:19:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('790','2404:c0:2a10::134c:f188','henririsnandar',NULL,'2026-01-26 06:22:58','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('791','2404:c0:2a10::134c:f188','henririsnandar@gmail.com','28','2026-01-26 06:23:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('792','36.77.30.196','ikasartika@gmail.com','7','2026-01-26 06:24:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('793','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 06:24:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('794','2404:c0:2e10::112c:c5c','weniwidaningrum@gmail.com','8','2026-01-26 06:27:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('795','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 06:29:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('796','2404:c0:2a10::1355:51d4','ripkiardian@gmail.com','35','2026-01-26 06:30:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('797','2404:c0:2e10::1127:7a75','ritanurtafimah',NULL,'2026-01-26 06:32:07','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('798','2404:c0:2e10::1127:7a75','ritanurfatimah@gmail.com','25','2026-01-26 06:32:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('799','2404:c0:2b10::134e:1ca0','nisa@gmail.com','51','2026-01-26 06:36:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('800','114.122.69.124','anggagunawan@gmail.com','39','2026-01-26 06:41:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('801','114.122.111.248','agustomi@gmail.com','27','2026-01-26 06:42:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('802','2404:c0:2d10::1125:3c60','sitipatimah@gmail.com','6','2026-01-26 06:45:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('803','2404:c0:2c10::1121:75','elsaandriani@gmail.com','40','2026-01-26 06:45:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('804','2404:c0:2f10::112c:edc4','muhtarsidik@gmail.com','49','2026-01-26 06:47:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('805','114.122.78.141','mohammadsuhardiwan@gmail.com','4','2026-01-26 06:49:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('806','36.77.30.196','ikanurhasanah@gmail.com','26','2026-01-26 06:51:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('807','114.122.84.226','asepcandra@gmail.com','31','2026-01-26 07:02:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('808','2404:c0:2810::91e:8fff','noviestephen@gmail.com','18','2026-01-26 07:15:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('809','2404:c0:2810::920:f710','irmannurhendra@gmail.com','20','2026-01-26 07:21:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('810','114.122.83.198','haniherlina@gmail.com','34','2026-01-26 07:33:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('811','114.122.68.91','sriastutisyam@gmail.com','22','2026-01-26 07:45:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('812','36.77.30.196','anihgindalistiani@gmail.com','15','2026-01-26 07:45:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('813','2404:c0:2b10::134f:5c83','susilawati@gmail.com','54','2026-01-26 07:49:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('814','2404:c0:2b10::134f:5c83','susilawati@gmail.com','54','2026-01-26 07:49:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('815','114.122.83.136','yosisitirosita@gmail.com','32','2026-01-26 08:09:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('816','114.122.100.245','muhtargojali@gmail.com','21','2026-01-26 08:12:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('817','114.122.116.75','galihwangi@gmail.com','43','2026-01-26 08:36:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('818','114.122.116.75','galihwangi@gmail.com','43','2026-01-26 08:36:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('819','2404:c0:2810::91b:1846','agismujiprayitno@gmail.com','24','2026-01-26 08:45:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('820','2404:c0:2d10::1117:90a6','acepantonfajar@gmail.com','57','2026-01-26 08:48:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('821','2404:c0:2d10::111f:5b42','ekasantikalestari@gmail.com','44','2026-01-26 08:52:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('822','2404:c0:2d10::1137:2941','emmysitimariyam@gmail.com','19','2026-01-26 09:43:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('823','2404:c0:2d10::1137:2941','emmysitimariyam@gmail.com','19','2026-01-26 09:43:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('824','36.77.30.196','nanangnajamudin@gmail.com','30','2026-01-26 10:07:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('825','36.77.30.196','niss',NULL,'2026-01-26 10:10:29','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('826','36.77.30.196','nisa@gmail.com','51','2026-01-26 10:10:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('827','114.122.83.101','mohammadsuhardiwan@gmail.com','4','2026-01-26 10:25:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('828','114.122.111.248','agustomi@gmail.com','27','2026-01-26 10:36:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('829','114.122.104.216','neneng@gmail.com','13','2026-01-26 10:37:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('830','114.122.104.216','neneng@gmail.com','13','2026-01-26 10:37:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('831','36.77.30.196','evitinisukartini@gmail.com','12','2026-01-26 10:38:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('832','36.77.30.196','evitinisukartini@gmail.com','12','2026-01-26 10:38:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('833','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 10:55:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('834','36.77.30.196','anihgindalistiani@gmail.com','15','2026-01-26 10:58:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('835','2404:c0:2d10::1120:653b','tiaiqbalhembara@gmail.com','55','2026-01-26 10:58:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('836','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 11:02:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('837','114.122.108.52','adeirfannugraha@gmail.com','29','2026-01-26 13:12:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('838','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 13:34:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('839','36.83.123.53','ujenahmad@gmail.com','11','2026-01-26 13:40:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('840','2404:c0:2e10::1135:4c4f','susilawati@gmail.com','54','2026-01-26 13:44:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('841','202.46.68.41','yusmansetiawan@gmail.com','14','2026-01-26 13:44:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('842','114.122.101.206','acepantonfajar@gmail.com','57','2026-01-26 13:44:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('843','114.122.107.87','galihwangi@gmail.com','43','2026-01-26 13:46:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('844','114.122.82.196','enokmira@gmail.com','60','2026-01-26 13:47:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('845','2404:c0:2910::1377:2451','ripkiardian@gmail.com','35','2026-01-26 13:53:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('846','2404:c0:2c10::113a:3b40','muhtarsidik@gmail.com','49','2026-01-26 14:24:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('847','36.77.30.196','muchtarsidiq@gmail.com','16','2026-01-26 14:31:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('848','114.122.111.248','agustomi@gmail.com','27','2026-01-26 14:38:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('849','2404:c0:2910::136d:873a','ritanurfatimah@gmail.com','25','2026-01-26 14:41:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('850','114.122.102.171','elsaandriani@gmail.com','40','2026-01-26 14:41:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('851','114.122.104.157','muhtargojali@gmail.com','21','2026-01-26 14:44:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('852','2404:c0:2c10::114b:44f1','noviestephen@gmail.com','18','2026-01-26 14:45:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('853','2404:c0:2a10::1382:edd','linlinpermatapraja@gmail.com','61','2026-01-26 14:46:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('854','202.46.68.41','yusmansetiawan@gmail.com','14','2026-01-26 14:46:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('855','2404:c0:2f10::1141:48c','emmysitimariyam@gmail.com','19','2026-01-26 14:46:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('856','2404:c0:2b10::1378:1194','siskatutiana@gmail.com','62','2026-01-26 14:46:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('857','2404:c0:2910::1348:b284','henririsnandar@gmail.com','28','2026-01-26 14:47:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('858','114.122.101.248','yuliagustiani@gmail.com','17','2026-01-26 14:47:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('859','2404:c0:2810::920:3e51','yuyunyunaningsih@gmail.com','23','2026-01-26 14:48:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('860','2404:c0:2d10::1128:c1d','jonihprasetia@gmail.com','47','2026-01-26 14:49:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('861','202.46.68.41','sitipatimah@gmail.com','6','2026-01-26 14:49:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('862','2404:c0:2a10::137c:dd34','pupuypuadah@gmail.com','53','2026-01-26 14:49:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('863','202.46.68.41','andiciptanugraha',NULL,'2026-01-26 14:50:00','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('864','36.77.30.196','weniwidaningrum@gmail.com','8','2026-01-26 14:50:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('865','2404:c0:2f10::113b:e179','novitaandriani@gmail.com','45','2026-01-26 14:50:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('866','114.122.68.91','sriastutisyam@gmail.com','22','2026-01-26 14:50:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('867','2404:c0:2e10::1142:4ec3','evitinisukartini@gmail.com','12','2026-01-26 14:50:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('868','2404:c0:2f10::114a:ae9d','rdsusimurti@gmail.com','48','2026-01-26 14:50:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('869','202.46.68.41','andicipta',NULL,'2026-01-26 14:50:49','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('870','114.122.78.87','anihgindalistiani@gmail.com','15','2026-01-26 14:50:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('871','2404:c0:2810::91b:1846','agismujiprayitno@gmail.com','24','2026-01-26 14:50:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('872','114.122.70.0','asepcandra@gmail.com','31','2026-01-26 14:51:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('873','2404:c0:2810::940:4a2f','syfaulhusna',NULL,'2026-01-26 14:51:32','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('874','2404:c0:2f10::112f:7e03','ekasantikalestari@gmail.com','44','2026-01-26 14:51:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('875','2404:c0:2810::94a:d3aa','detirosmawati@gmail.com','36','2026-01-26 14:51:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('876','114.122.115.126','yosisitirosita@gmail.com','32','2026-01-26 14:51:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('877','114.122.115.126','yosisitirosita@gmail.com','32','2026-01-26 14:51:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('878','114.122.105.156','haniherlina@gmail.com','34','2026-01-26 14:52:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('879','2404:c0:2b10::1389:1c5c','dinanursolihat@gmail.com','56','2026-01-26 14:52:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('880','138.113.112.165','sypaulhusna',NULL,'2026-01-26 14:52:18','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('881','2404:c0:2c10::1127:d1f','ikasartika@gmail.com','7','2026-01-26 14:52:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('882','114.122.68.87','ikanurhasanah@gmail.com','26','2026-01-26 14:52:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('883','103.138.53.62','irmannurhendra@gmail.com','20','2026-01-26 14:52:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('884','2404:c0:2810::940:4a2f','syfaulhusna@gmail.com','52','2026-01-26 14:53:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('885','2404:c0:2e10::114a:77da','ranianggraeni@gmail.com','59','2026-01-26 14:53:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('886','2404:c0:2f10::114a:ae9d','rdsusimurti@gmail.com','48','2026-01-26 14:54:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('887','2404:c0:2810::920:3e51','yuyunyunaningsih@gmail.com','23','2026-01-26 14:57:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('888','202.46.68.41','nanangnajamudin@gmail.com','30','2026-01-26 14:58:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('889','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 15:04:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('890','2404:c0:7040::9a1f:f8b2','rentydwiyanti@gmail.com','50','2026-01-26 15:04:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('891','114.122.110.173','gilangsepteranurhendra@gmail.com','38','2026-01-26 15:06:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('892','36.83.118.114','97053',NULL,'2026-01-26 15:10:30','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('893','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-26 16:35:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('894','114.122.70.149','anggagunawan@gmail.com','39','2026-01-26 17:38:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('895','114.122.68.91','sriastutisyam@gmail.com','22','2026-01-26 17:59:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('896','103.184.16.247','henririsnandar@gmail.com','28','2026-01-26 18:07:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('897','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-26 18:56:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('898','114.122.101.254','adeirfannugraha@gmail.com','29','2026-01-26 19:13:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('899','114.122.77.68','ujenahmad@gmail.com','11','2026-01-26 19:38:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('900','36.77.30.189','asepcandra@gmail.com','31','2026-01-26 19:53:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('901','36.77.30.189','asepcandra@gmail.com','31','2026-01-26 19:53:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('902','2404:c0:2e10::1142:66a2','weniwidaningrum@gmail.com','8','2026-01-26 20:39:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('903','2404:c0:2d10::1146:b2fa','weniwidaningrum@gmail.com','8','2026-01-26 20:39:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('904','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-26 21:01:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('905','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 23:27:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('906','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 23:32:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('907','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 23:37:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('908','103.188.169.69','asepcandra@gmail.com','31','2026-01-26 23:41:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('909','103.188.169.69','adminsuper@gmail.com','1','2026-01-26 23:53:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('910','103.188.169.69','adminsuper@gmail.com','1','2026-01-27 00:33:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('911','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-27 01:32:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('912','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-27 05:29:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('913','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-27 05:45:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('914','114.122.114.220','galihwangi@gmail.com','43','2026-01-27 05:47:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('915','103.188.169.69','adminsuper@gmail.com','1','2026-01-27 05:56:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('916','114.122.79.95','anihgindalistiani@gmail.com','15','2026-01-27 06:10:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('917','114.122.114.220','galihwangi@gmail.com','43','2026-01-27 06:10:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('918','114.122.101.41','agustomi@gmail.com','27','2026-01-27 06:14:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('919','2404:c0:2a10::13b0:ec2b','elsaandriani@gmail.com','40','2026-01-27 06:15:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('920','36.77.30.196','yuyunyunaningsih@gmail.com','23','2026-01-27 06:15:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('921','114.122.69.57','haniherlina@gmail.com','34','2026-01-27 06:17:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('922','2404:c0:2810::971:ee5f','yuliagustiani@gmail.com','17','2026-01-27 06:21:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('923','2404:c0:2910::13b0:955','emmysitimariyam@gmail.com','19','2026-01-27 06:24:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('924','2404:c0:2910::13ba:213a','irmannurhendra@gmail.com','20','2026-01-27 06:24:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('925','2404:c0:2c10::1174:a57b','jonihprasetia@gmail.com','47','2026-01-27 06:28:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('926','2404:c0:2f10::1156:62','detirosmawati@gmail.com','36','2026-01-27 06:30:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('927','114.122.70.133','asepcandra@gmail.com','31','2026-01-27 06:30:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('928','2404:c0:2a10::13b5:34f7','andiciptanugraha@gmail.com','9','2026-01-27 06:36:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('929','2404:c0:2810::974:28e6','agismujiprayitno@gmail.com','24','2026-01-27 06:38:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('930','36.77.30.196','siskatutiana@gmail.com','62','2026-01-27 06:38:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('931','114.122.68.67','sriastutisyam@gmail.com','22','2026-01-27 06:42:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('932','114.122.109.137','enokmira@gmail.com','60','2026-01-27 06:46:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('933','180.245.117.56','acepantonfajar@gmail.com','57','2026-01-27 06:46:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('934','2404:c0:2e10::1175:6d59','henririsnandar@gmail.com','28','2026-01-27 06:48:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('935','2404:c0:2d10::117a:ba97','susilawati@gmail.com','54','2026-01-27 06:48:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('936','114.122.77.233','ujenahmad@gmail.com','11','2026-01-27 06:49:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('937','2404:c0:2910::13bc:5353','noviestephen@gmail.com','18','2026-01-27 06:56:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('938','2404:c0:2f10::1185:c920','ripkiardian@gmail.com','35','2026-01-27 06:56:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('939','2404:c0:2c10::1170:f224','nisa@gmail.com','51','2026-01-27 06:59:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('940','2404:c0:2f10::117d:8aa2','dinanursolihat@gmail.com','56','2026-01-27 07:01:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('941','2404:c0:2e10::1170:1a09','ikasartika@gmail.com','7','2026-01-27 07:01:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('942','2404:c0:2810::983:3097','weniwidaningrum@gmail.com','8','2026-01-27 07:02:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('943','2404:c0:2b10::13b5:3c0a','pupuypuadah@gmail.com','53','2026-01-27 07:06:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('944','114.122.111.132','yusmansetiawan@gmail.com','14','2026-01-27 07:09:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('945','2404:c0:2e10::117e:f373','ritanurfatimah',NULL,'2026-01-27 07:11:38','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('946','2404:c0:2e10::117e:f373','ritanurfatimah@gmail.com','25','2026-01-27 07:11:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('947','2404:c0:2b10::13b2:7f2d','nanangnajamudin@gmail.com','30','2026-01-27 07:12:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('948','2404:c0:2e10::117b:735a','sitipatimah@gmail.com','6','2026-01-27 07:15:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('949','114.122.101.12','mohammadsuhardiwan@gmail.com','4','2026-01-27 07:16:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('950','114.122.104.118','yosisitirosita@gmail.com','32','2026-01-27 07:16:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('951','114.122.104.118','yosisitirosita@gmail.com','32','2026-01-27 07:16:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('952','114.122.103.133','neneng@gmail.com','13','2026-01-27 07:18:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('953','114.122.103.133','neneng@gmail.com','13','2026-01-27 07:18:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('954','114.122.104.42','adeirfannugraha@gmail.com','29','2026-01-27 07:21:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('955','2404:c0:2f10::117a:1034','Ade Sutrisna',NULL,'2026-01-27 07:22:32','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('956','2404:c0:2f10::117a:1034','adsut. 212@gmail.com',NULL,'2026-01-27 07:23:09','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('957','2404:c0:2f10::117a:1034','Adsut',NULL,'2026-01-27 07:23:25','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('958','2404:c0:2910::1398:fab0','muchtarsidiq@gmail.com','16','2026-01-27 07:29:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('959','2001:67c:198c:906:1f::3a0','andrinugraha@gmail.com','46','2026-01-27 07:38:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('960','202.46.68.1','muhtarsidik@gmail.com','49','2026-01-27 07:41:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('961','36.77.30.196','evitinisukartini@gmail.com','12','2026-01-27 07:58:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('962','114.122.71.0','gilangsepteranurhendra@gmail.com','38','2026-01-27 08:13:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('963','114.122.76.239','anggagunawan@gmail.com','39','2026-01-27 08:39:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('964','114.122.76.239','anggagunawan@gmail.com','39','2026-01-27 08:40:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('965','2404:c0:2e10::117b:735a','sitipatimah@gmail.com','6','2026-01-27 08:54:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('966','2404:c0:9a90::23f6:6ac7','rentydwiyanti@gmail.com','50','2026-01-27 09:34:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('967','202.46.68.41','adeirfannugraha@gmail.com','29','2026-01-27 09:40:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('968','2404:c0:2910::13bc:5353','noviestephen@gmail.com','18','2026-01-27 09:45:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('969','114.122.107.88','yusmansetiawan@gmail.com','14','2026-01-27 09:57:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('970','2404:c0:2f10::1180:a67c','yuyunyunaningsih@gmail.com','23','2026-01-27 09:59:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('971','2404:c0:2f10::1180:a67c','yuyunyunaningsih@gmail.com','23','2026-01-27 09:59:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('972','2404:c0:2f10::1180:a67c','yuyunyunaningsih@gmail.com','23','2026-01-27 09:59:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('973','2404:c0:2810::98c:5929','ranianggraeni@gmail.com','59','2026-01-27 10:12:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('974','114.122.104.98','yosisitirosita@gmail.com','32','2026-01-27 10:36:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('975','36.77.30.196','asepcandra@gmail.com','31','2026-01-27 10:58:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('976','114.122.79.95','anihgindalistiani@gmail.com','15','2026-01-27 11:39:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('977','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-27 12:16:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('978','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-27 12:17:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('979','2404:c0:2b10::13d5:2e4c','nanangnajamudin@gmail.com','30','2026-01-27 12:25:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('980','114.122.69.27','anggagunawan@gmail.com','39','2026-01-27 12:28:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('981','36.83.123.53','ujenahmad@gmail.com','11','2026-01-27 12:41:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('982','2404:c0:2f10::1196:8909','yuyunyunaningsih@gmail.com','23','2026-01-27 12:42:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('983','114.122.114.196','galihwangi@gmail.com','43','2026-01-27 13:09:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('984','2404:c0:2d10::1193:b71e','yuyunyunaningsih@gmail.com','23','2026-01-27 13:13:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('985','36.77.30.196','tiaiqbalhembara@gmail.com','55','2026-01-27 13:21:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('986','114.122.84.179','asepsuryadi@gmail.com','5','2026-01-27 13:31:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('987','114.122.116.181','muhtargojali@gmail.com','21','2026-01-27 13:32:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('988','2404:c0:2e10::118a:9004','syfaulhusna@gmail.com','52','2026-01-27 13:32:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('989','2404:c0:2d10::117e:f975','ekasantikalestari@gmail.com','44','2026-01-27 13:33:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('990','36.77.30.196','ranianggraeni@gmail.com','59','2026-01-27 13:40:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('991','2404:c0:2a10::13d8:469d','detirosmawati@gmail.com','36','2026-01-27 13:44:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('992','2404:c0:2910::13db:ccc0','elsaandriani@gmail.com','40','2026-01-27 13:45:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('993','114.122.68.67','sriastutisyam@gmail.com','22','2026-01-27 13:48:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('994','2404:c0:2f10::1193:7fc7','ritanurfatimah@gmail.com','25','2026-01-27 13:48:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('995','2404:c0:2d10::117a:ba97','susilawati@gmail.com','54','2026-01-27 13:50:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('996','2404:c0:2f10::119b:1ce1','novitaandriani@gmail.com','45','2026-01-27 13:50:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('997','2404:c0:2c10::1175:e03c','ripkiardian@gmail.com','35','2026-01-27 13:51:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('998','2404:c0:2f10::11a1:ef0','dinanursolihat@gmail.com','56','2026-01-27 13:51:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('999','2404:c0:2e10::1175:6d59','henririsnandar@gmail.com','28','2026-01-27 13:51:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1000','2404:c0:2f10::1197:769e','evitinisukartini@gmail.com','12','2026-01-27 13:51:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1001','114.122.101.24','agustomi@gmail.com','27','2026-01-27 13:52:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1002','2404:c0:2c10::1196:9db1','jonihprasetia@gmail.com','47','2026-01-27 13:53:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1003','36.77.30.196','weniwidaningrum@gmail.com','8','2026-01-27 13:53:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1004','114.122.117.159','yosisitirosita@gmail.com','32','2026-01-27 13:53:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1005','114.122.75.137','enokmira@gmail.com','60','2026-01-27 13:53:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1006','2404:c0:2810::971:ee5f','yuliagustiani@gmail.com','17','2026-01-27 13:53:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1007','2404:c0:2810::971:ee5f','yuliagustiani@gmail.com','17','2026-01-27 13:53:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1008','114.122.78.236','gilangsepteranurhendra@gmail.com','38','2026-01-27 13:54:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1009','36.77.30.196','adesutrisna',NULL,'2026-01-27 13:54:34','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1010','36.77.30.196','adesutrisna@gmail.com','33','2026-01-27 13:55:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1011','114.122.78.236','gilangsepteranurhendra@gmail.com','38','2026-01-27 13:55:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1012','2001:67c:2628:647:32:504:0:3a0','andrinugraha@gmail.com','46','2026-01-27 13:55:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1013','114.122.78.236','gilangsepteranurhendra@gmail.com','38','2026-01-27 13:55:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1014','114.122.76.85','asepcandra@gmail.com','31','2026-01-27 13:55:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1015','114.122.78.236','gilangsepteranurhendra@gmail.com','38','2026-01-27 13:55:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1016','114.122.117.54','sitimunawaroh@gmail.com','41','2026-01-27 13:55:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1017','2404:c0:2e10::10ac:4e19','firmanmuharam@gmail.com','58','2026-01-27 13:55:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1018','114.122.117.64','yusmansetiawan@gmail.com','14','2026-01-27 13:56:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1019','2404:c0:2c10::118e:8bdf','nisa@gmail.com','51','2026-01-27 13:57:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1020','114.122.79.75','anihgindalistiani@gmail.com','15','2026-01-27 13:57:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1021','114.122.71.17','dewi@gmail.com','10','2026-01-27 13:58:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1022','2404:c0:2e10::119a:2b44','rdsusimurti@gmail.com','48','2026-01-27 13:59:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1023','2404:c0:2a10::13d3:5e52','emmysitimariyam@gmail.com','19','2026-01-27 13:59:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1024','36.77.30.196','ikanurhasanah@gmail.com','26','2026-01-27 14:01:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1025','2404:c0:2d10::117c:6245','sitipatimah@gmail.com','6','2026-01-27 14:01:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1026','2404:c0:2d10::1193:4436','andiciptanugraha@gmail.com','9','2026-01-27 14:08:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1027','36.77.30.196','haniherlina@gmail.com','34','2026-01-27 15:48:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1028','36.77.30.196','suepradmin',NULL,'2026-01-27 15:59:40','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1029','36.77.30.196','anaymaryana31',NULL,'2026-01-27 15:59:48','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1030','36.77.30.196','adminsuper@gmail.com','1','2026-01-27 16:00:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1031','36.77.30.196','adminsuper@gmail.com','1','2026-01-27 16:08:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1032','114.122.69.235','anggagunawan@gmail.com','39','2026-01-27 17:18:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1033','103.184.16.247','henririsnandar@gmail.com','28','2026-01-27 17:31:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1034','202.46.68.71','adeirfannugraha',NULL,'2026-01-27 18:03:47','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1035','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-27 18:03:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1036','2404:c0:2910::13db:ccc0','elsaandriani@gmail.com','40','2026-01-27 18:12:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1037','36.77.30.189','asepcandra@gmail.com','31','2026-01-27 18:49:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1038','180.245.117.56','acepantonfajar@gmail.com','57','2026-01-27 19:03:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1039','103.188.169.69','adminsuper@gmail.com','1','2026-01-27 19:42:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1040','202.46.68.1','muhtarsidik@gmail.com','49','2026-01-27 20:29:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1041','103.188.169.69','adminsuper@gmail.com','1','2026-01-27 22:12:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1042','103.188.169.69','adminsuper@gmail.com','1','2026-01-28 04:39:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1043','103.188.169.153','evitinisukartini@gmail.com','12','2026-01-28 05:47:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1044','2404:c0:2910::1409:f567','yuyunyunaningsih@gmail.com','23','2026-01-28 06:06:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1045','103.188.169.153','dinanursolihat@gmail.com','56','2026-01-28 06:07:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1046','2404:c0:2e10::11c6:d016','syfaulhusna@gmail.com','52','2026-01-28 06:08:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1047','36.77.30.196','linlinpermatapraja@gmail.com','61','2026-01-28 06:18:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1048','114.122.116.147','yosisitirosita@gmail.com','32','2026-01-28 06:18:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1049','2404:c0:2c10::11c2:13cd','sitipatimah@gmail.com','6','2026-01-28 06:21:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1050','114.122.101.114','ujenahmad@gmail.com','11','2026-01-28 06:23:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1051','2404:c0:2b10::1407:ac73','emmysitimariyam@gmail.com','19','2026-01-28 06:26:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1052','2404:c0:2f10::11c2:38ca','muhtarsidik@gmail.com','49','2026-01-28 06:28:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1053','114.122.78.213','sitimunawaroh@gmail.com','41','2026-01-28 06:29:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1054','114.122.78.213','sitimunawaroh@gmail.com','41','2026-01-28 06:30:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1055','202.46.68.41','adeirfannugraha@gmail.com','29','2026-01-28 06:31:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1056','36.77.30.196','henririsnandar@gmail.com','28','2026-01-28 06:32:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1057','114.122.105.195','sriastutisyam@gmail.com','22','2026-01-28 06:33:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1058','114.122.108.249','ikanurhasanah@gmail.com','26','2026-01-28 06:35:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1059','2404:c0:2b10::1413:cc2f','susilawati@gmail.com','54','2026-01-28 06:39:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1060','2404:c0:2b10::1414:a5d4','ripkiardian@gmail.com','35','2026-01-28 06:43:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1061','2404:c0:2b10::1414:a5d4','ripkiardian@gmail.com','35','2026-01-28 06:43:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1062','114.122.69.255','anggagunawan@gmail.com','39','2026-01-28 06:51:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1063','2404:c0:2a10::141a:8ff7','noviestephen@gmail.com','18','2026-01-28 06:52:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1064','2404:c0:2a10::141a:8ff7','noviestephen@gmail.com','18','2026-01-28 06:52:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1065','36.77.30.196','anihgindalistiani@gmail.com','15','2026-01-28 06:52:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1066','114.122.108.7','galihwangi@gmail.com','43','2026-01-28 06:54:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1067','36.77.30.196','siskatutiana@gmail.com','62','2026-01-28 06:55:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1068','2404:c0:2f10::11d1:db92','irmannurhendra@gmail.com','20','2026-01-28 06:59:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1069','114.122.107.218','Edisi cerita perjalanan jelajah Gunung Bromo, Semeru, Arjuno Welirang dan Slamet. Ketika Hari Kenaikan Isa Al-Masih 2025.  Link Support Kopi☕ https://sociabuzz.com/mamanggaes/support  Eps 53 https://youtu.be/gzRi0tLX8m8?si=dtwXLv1M7puiCSKD  Eps 52 https:/',NULL,'2026-01-28 07:10:43','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1070','2404:c0:2f10::11c7:439d','ikasarti',NULL,'2026-01-28 07:11:28','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1071','2404:c0:2c10::11bd:d9bf','ikasartika@gmail.com','7','2026-01-28 07:11:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1072','114.122.107.218','yusmansetiawan',NULL,'2026-01-28 07:12:58','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1073','2404:c0:2e10::11c5:fe4d','elsaandriani@gmail.com','40','2026-01-28 07:17:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1074','2404:c0:2c10::11d0:6144','adesutrisna@gmail.com','33','2026-01-28 07:36:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1075','114.122.69.43','gilangsepteranurhendra@gmail.com','38','2026-01-28 08:14:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1076','103.188.169.69','adminsuper@gmail.com','1','2026-01-28 08:20:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1077','114.122.74.244','neneng@gmail.com','13','2026-01-28 08:31:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1078','36.77.30.196','weniwidaningrum@gmail.com','8','2026-01-28 08:42:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1079','2404:c0:2d10::11c0:56be','yuliagustiani@gmail.com','17','2026-01-28 08:43:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1080','2404:c0:2c10::11c8:149c','nanangnajamudin@gmail.com','30','2026-01-28 08:49:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1081','2404:c0:2c10::11c8:149c','nanangnajamudin@gmail.com','30','2026-01-28 08:49:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1082','2404:c0:2b10::1427:35b0','adesutrisna@gmail.com','33','2026-01-28 09:47:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1083','114.122.110.110','adeirfannugraha@gmail.com','29','2026-01-28 10:31:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1084','2404:c0:2c10::11dd:e7dc','nisa@gmail.com','51','2026-01-28 11:04:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1085','2404:c0:2c10::11d4:7067','syfaulhusna@gmail.com','52','2026-01-28 11:04:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1086','2404:c0:2f10::11c9:73a4','elsaandriani@gmail.com','40','2026-01-28 11:13:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1087','36.77.30.196','haniherlina@gmail.com','34','2026-01-28 11:37:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1088','2404:c0:2a10::140c:a471','tiaiqbalhembara@gmail.com','55','2026-01-28 11:57:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1089','114.122.109.254','adeirfannugraha',NULL,'2026-01-28 12:48:21','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1090','114.122.109.254','adeirfannugraha@gmail.com','29','2026-01-28 12:48:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1091','114.122.69.250','neneng@gmail.com','13','2026-01-28 13:09:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1092','2404:c0:2a10::1432:1afa','nisa@gmail.com','51','2026-01-28 13:23:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1093','2404:c0:2810::a00:4e01','ranianggraeni@gmail.com','59','2026-01-28 13:28:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1094','114.122.69.75','galihwangi@gmail.com','43','2026-01-28 13:37:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1095','2404:c0:2810::9d1:ff7c','acepantonfajar@gmail.com','57','2026-01-28 13:38:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1096','2404:c0:2810::9e0:e855','agismujiprayitno@gmail.com','24','2026-01-28 13:39:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1097','36.77.30.196','dinanursolihat@gmail.com','56','2026-01-28 13:51:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1098','2404:c0:2a10::140c:a471','tiaiqbalhembara@gmail.com','55','2026-01-28 14:08:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1099','2404:c0:2e10::11cd:21ad','evitinisukartini@gmail.com','12','2026-01-28 14:12:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1100','114.122.110.36','dewi@gmail.com','10','2026-01-28 14:25:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1101','2404:c0:2f10::11ec:335','pupuypuadah@gmail.com','53','2026-01-28 14:25:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1102','114.122.111.149','anihgindalistiani@gmail.com','15','2026-01-28 14:27:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1103','2404:c0:2810::9f5:9bb5','irmannurhendra@gmail.com','20','2026-01-28 14:28:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1104','2404:c0:2b10::142c:c2ac','detirosmawati@gmail.com','36','2026-01-28 14:31:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1105','2404:c0:2e10::11d2:9972','firmanmuharam@gmail.com','58','2026-01-28 14:37:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1106','2404:c0:2b10::1427:35b0','adesutrisna@gmail.com','33','2026-01-28 14:38:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1107','2404:c0:2f10::11d7:bace','ripkiardian@gmail.com','35','2026-01-28 14:39:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1108','2404:c0:2f10::11c7:439d','ikasartika@gmail.com','7','2026-01-28 14:40:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1109','202.46.68.41','noviestephen@gmail.com','18','2026-01-28 14:40:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1110','202.46.68.41','noviestephen@gmail.com','18','2026-01-28 14:40:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1111','2404:c0:2810::9df:3eeb','susilawati@gmail.com','54','2026-01-28 14:40:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1112','114.122.106.114','asepsuryadi@gmail.com','5','2026-01-28 14:41:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1113','36.77.30.196','muchtarsidiq@gmail.com','16','2026-01-28 14:41:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1114','2404:c0:2d10::11e0:4401','ekasantikalestari@gmail.com','44','2026-01-28 14:41:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1115','2404:c0:2c10::11e9:4737','weniwidaningrum@gmail.com','8','2026-01-28 14:41:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1116','2404:c0:2b10::1429:cf8e','emmysitimariyam@gmail.com','19','2026-01-28 14:41:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1117','2404:c0:2c10::11e9:4737','weniwidaningrum@gmail.com','8','2026-01-28 14:41:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1118','36.77.30.196','siskatutiana@gmail.com','62','2026-01-28 14:41:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1119','2404:c0:2f10::11ca:8f61','jonihprasetia@gmail.com','47','2026-01-28 14:42:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1120','2404:c0:2b10::1442:4507','elsaandriani@gmail.com','40','2026-01-28 14:42:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1121','2404:c0:2910::142b:b954','rdsusimurti@gmail.com','48','2026-01-28 14:42:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1122','114.122.77.189','yusmansetiawan@gmail.com','14','2026-01-28 14:42:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1123','36.77.30.196','linlinpermatapraja@gmail.com','61','2026-01-28 14:42:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1124','36.77.30.196','ikanurhasanah@gmail.com','26','2026-01-28 14:42:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1125','2404:c0:2910::142c:db33','ritanurfatimah@gmail.com','25','2026-01-28 14:42:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1126','114.122.101.225','syfaulhusna@gmail.com','52','2026-01-28 14:43:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1127','114.122.76.23','gilangsepteranurhendra@gmail.com','38','2026-01-28 14:43:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1128','114.122.76.23','gilangsepteranurhendra@gmail.com','38','2026-01-28 14:43:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1129','2404:c0:2910::1429:987f','yuyunyunaningsih@gmail.com','23','2026-01-28 14:43:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1130','114.122.105.195','sriastutisyam@gmail.com','22','2026-01-28 14:45:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1131','2404:c0:2d10::11dd:257','muhtarsidik@gmail.com','49','2026-01-28 14:45:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1132','114.122.109.145','sitimunawaroh@gmail.com','41','2026-01-28 14:45:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1133','2404:c0:2e10::11eb:5bf0','rdsusimurti@gmail.com','48','2026-01-28 14:46:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1134','114.122.102.63','anggagunawan@gmail.com','39','2026-01-28 14:47:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1135','114.122.116.66','sitipatimah@gmail.com','6','2026-01-28 14:48:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1136','114.122.116.66','sitipatimah@gmail.com','6','2026-01-28 14:49:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1137','114.122.77.13','mohammadsuhardiwan@gmail.com','4','2026-01-28 14:50:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1138','114.122.85.48','enokmira@gmail.com','60','2026-01-28 14:53:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1139','114.122.85.48','enokmira@gmail.com','60','2026-01-28 14:53:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1140','2404:c0:2b10::1425:9abd','muchtarsidiq@gmail.com','16','2026-01-28 14:56:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1141','114.122.116.141','yuliagustiani@gmail.com','17','2026-01-28 15:08:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1142','36.77.30.196','adminsuper@gmail.com','1','2026-01-28 15:51:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1143','2404:c0:2810::a07:dd1a','elsaandriani@gmail.com','40','2026-01-28 17:04:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1144','2404:c0:2c10::11c2:13cd','sitipatimah@gmail.com','6','2026-01-28 17:26:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1145','36.77.30.196','galihwangi@gmail.com','43','2026-01-28 17:39:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1146','180.249.237.44','agustomi@gmail.com','27','2026-01-28 18:52:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1147','114.122.101.114','ujenahmad@gmail.com','11','2026-01-28 19:01:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1148','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-28 22:12:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1149','2404:c0:2a10::1463:a703','dinanursolihat@gmail.com','56','2026-01-28 23:04:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1150','2404:c0:2d10::1211:7548','rentydwiyanti@gmail.com','50','2026-01-29 05:11:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1151','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-29 05:25:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1152','2404:c0:2910::146d:f620','acepantonfajar@gmail.com','57','2026-01-29 06:07:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1153','2404:c0:2a10::147f:dcc1','noviestephen@gmail.com','18','2026-01-29 06:08:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1154','2404:c0:2d10::1219:499d','jonihprasetia@gmail.com','47','2026-01-29 06:08:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1155','2404:c0:2910::1469:977e','yuyunyunaningsih@gmail.com','23','2026-01-29 06:11:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1156','114.122.78.198','siskatutiana@gmail.com','62','2026-01-29 06:19:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1157','180.241.242.69','muhtarsidik@gmail.com','49','2026-01-29 06:20:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1158','114.122.71.14','anggagunawan@gmail.com','39','2026-01-29 06:20:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1159','202.46.68.41','adeirfannugraha@gmail.com','29','2026-01-29 06:24:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1160','2404:c0:2a10::147d:fb9f','susilawati@gmail.com','54','2026-01-29 06:26:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1161','114.122.101.106','asepsuryadi@gmail.com','5','2026-01-29 06:26:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1162','114.122.110.137','anihgindalistiani@gmail.com','15','2026-01-29 06:27:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1163','2404:c0:2a10::1483:2e61','firmanmuharam@gmail.com','58','2026-01-29 06:30:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1164','114.122.85.79','dewi@gmail.com','10','2026-01-29 06:31:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1165','114.122.105.195','sriastutisyam@gmail.com','22','2026-01-29 06:42:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1166','103.188.169.69','adminsuper@gmail.com','1','2026-01-29 06:42:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1167','114.122.114.248','enokmira@gmail.com','60','2026-01-29 06:42:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1168','2404:c0:2d10::121b:f456','detirosmawati@gmail.com','36','2026-01-29 06:43:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1169','114.122.114.248','enokmira@gmail.com','60','2026-01-29 06:43:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1170','114.122.78.14','yosisitirosita@gmail.com','32','2026-01-29 06:43:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1171','2404:c0:2910::1466:8a67','emmysitimariyam@gmail.com','19','2026-01-29 06:44:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1172','2404:c0:2910::1471:eb08','ripkiardian@gmail.com','35','2026-01-29 06:47:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1173','2404:c0:2d10::1216:1974','nisa@gmail.com','51','2026-01-29 06:47:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1174','2404:c0:2d10::120f:585a','henririsnandar@gmail.com','28','2026-01-29 06:49:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1175','2404:c0:2a10::1472:293','irmannurhendra@gmail.com','20','2026-01-29 06:49:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1176','2404:c0:2a10::1474:1bbf','dinanursolihat@gmail.com','56','2026-01-29 06:52:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1177','2404:c0:2810::a3b:3fd1','enungnuryamin@gmail.com','3','2026-01-29 06:57:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1178','114.122.85.17','yusmansetiawan@gmail.com','14','2026-01-29 07:07:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1179','2404:c0:2810::a30:f953','pupuypuadah@gmail.com','53','2026-01-29 07:07:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1180','114.122.68.105','neneng@gmail.com','13','2026-01-29 07:07:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1181','36.77.30.196','yuliagustiani@gmail.com','17','2026-01-29 07:08:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1182','114.122.76.232','ujenahmad@gmail.com','11','2026-01-29 07:12:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1183','2404:c0:2d10::121a:b645','ritanurfatimah@gmail.com','25','2026-01-29 07:19:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1184','2404:c0:2b10::147c:e895','ikasartika@gmail.com','7','2026-01-29 07:19:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1185','2404:c0:2910::145f:fde0','elsaandriani@gmail.com','40','2026-01-29 07:19:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1186','2404:c0:2f10::121d:91f4','sitipatimah@gmail.com','6','2026-01-29 07:19:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1187','2404:c0:2810::a41:a730','ekasantikalestari@gmail.com','44','2026-01-29 07:23:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1188','114.122.108.51','galihwangi@gmail.com','43','2026-01-29 07:31:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1189','2404:c0:2f10::121e:e658','weniwidaningrum@gmail.com','8','2026-01-29 07:49:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1190','2404:c0:2810::a3b:7560','ranianggraeni@gmail.com','59','2026-01-29 07:50:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1191','2404:c0:2e10::1220:e76f','evitinisukartini@gmail.com','12','2026-01-29 07:51:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1192','114.122.117.42','gilangsepteranurhendra@gmail.com','38','2026-01-29 07:51:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1193','114.122.71.25','agustomi@gmail.com','27','2026-01-29 07:51:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1194','114.122.82.109','asepcandra@gmail.com','31','2026-01-29 08:02:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1195','114.122.103.148','haniherlina@gmail.com','34','2026-01-29 08:04:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1196','103.188.169.69','adminsuper@gmail.com','1','2026-01-29 08:53:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1197','2404:c0:2b10::1475:d649','tiaiqbalhembara@gmail.com','55','2026-01-29 08:54:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1198','180.241.240.93','muhtarsidik@gmail.com','49','2026-01-29 09:04:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1199','2404:c0:6a1f:887e:f41f:43ff:fe72:7e04','nanangnajamudin@gmail.com','30','2026-01-29 09:22:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1200','2404:c0:2f10::121e:e658','weniwidaningrum@gmail.com','8','2026-01-29 09:57:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1201','114.122.78.254','anggagunawan@gmail.com','39','2026-01-29 09:59:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1202','2404:c0:2f10::1232:20a5','irmannurhendra@gmail.com','20','2026-01-29 10:41:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1203','2404:c0:2b10::149d:58d','yuyunyunaningsih@gmail.com','23','2026-01-29 11:47:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1204','2404:c0:2a10::1482:4dbb','elsaandriani@gmail.com','40','2026-01-29 11:57:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1205','114.122.101.204','adeirfannugraha@gmail.com','29','2026-01-29 11:57:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1206','2404:c0:2810::a41:a730','ekasantikalestari@gmail.com','44','2026-01-29 12:20:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1207','2404:c0:2810::a3d:28c5','tiaiqbalhembara@gmail.com','55','2026-01-29 14:03:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1208','114.122.107.162','anihgindalistiani@gmail.com','15','2026-01-29 14:33:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1209','114.122.82.219','yuliagustiani@gmail.com','17','2026-01-29 14:34:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1210','2404:c0:2c10::1232:50a6','detirosmawati@gmail.com','36','2026-01-29 14:34:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1211','2404:c0:2e10::123e:16d2','ritanurfatimah@gmail.com','25','2026-01-29 14:35:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1212','2404:c0:2910::146d:4607','susilawati@gmail.com','54','2026-01-29 14:35:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1213','114.122.78.56','dewi@gmail.com','10','2026-01-29 14:36:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1214','114.122.111.14','syfaulhusna@gmail.com','52','2026-01-29 14:36:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1215','182.5.137.30','anggagunawan@gmail.com','39','2026-01-29 14:37:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1216','114.122.77.94','haniherlina@gmail.com','34','2026-01-29 14:38:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1217','2404:c0:2810::a65:2752','firmanmuharam@gmail.com','58','2026-01-29 14:39:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1218','2404:c0:2f10::123a:4312','yuyunyunaningsih@gmail.com','23','2026-01-29 14:39:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1219','2404:c0:2f10::1246:3c10','pupuypuadah@gmail.com','53','2026-01-29 14:39:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1220','2404:c0:2f10::123a:4312','yuyunyunaningsih@gmail.com','23','2026-01-29 14:39:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1221','114.122.71.52','yosisitirosita@gmail.com','32','2026-01-29 14:39:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1222','182.5.134.121','rdsusimurti@gmail.com','48','2026-01-29 14:41:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1223','2404:c0:2810::a38:2ca5','ikasartika@gmail.com','7','2026-01-29 14:41:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1224','114.122.72.211','evitinisukartini@gmail.com','12','2026-01-29 14:41:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1225','2404:c0:2d10::120f:585a','henririsnandar@gmail.com','28','2026-01-29 14:42:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1226','114.122.72.211','evitinisukartini@gmail.com','12','2026-01-29 14:42:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1227','114.122.105.237','muhtarsidik@gmail.com','49','2026-01-29 14:42:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1228','2404:c0:2b10::1493:2bc6','acepantonfajar@gmail.com','57','2026-01-29 14:42:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1229','114.122.108.191','galihwangi@gmail.com','43','2026-01-29 14:42:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1230','2404:c0:2810::a69:db37','rdsusimurti@gmail.com','48','2026-01-29 14:42:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1231','114.122.104.216','ujenahmad@gmail.com','11','2026-01-29 14:42:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1232','202.46.68.41','noviestephen@gmail.com','18','2026-01-29 14:43:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1233','2404:c0:2910::1471:eb08','ripkiardian@gmail.com','35','2026-01-29 14:43:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1234','114.122.70.10','asepcandra@gmail.com','31','2026-01-29 14:43:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1235','114.122.104.63','neneng@gmail.com','13','2026-01-29 14:43:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1236','114.122.68.54','enokmira@gmail.com','60','2026-01-29 14:45:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1237','2404:c0:2a10::1493:d53e','nisa@gmail.com','51','2026-01-29 14:45:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1238','36.77.30.196','muchtarsidiq@gmail.com','16','2026-01-29 14:46:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1239','36.77.30.196','siskatutiana@gmail.com','62','2026-01-29 14:46:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1240','36.77.30.196','linlinpermatapraja@gmail.com','61','2026-01-29 14:46:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1241','2404:c0:2f10::1237:5672','sitipatimah@gmail.com','6','2026-01-29 14:48:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1242','114.122.114.74','sitimunawaroh@gmail.com','41','2026-01-29 14:49:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1243','2404:c0:2c10::1245:f17e','elsaandriani@gmail.com','40','2026-01-29 16:53:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1244','2404:c0:2e10::1251:baba','muchtarsidiq@gmail.com','16','2026-01-29 17:51:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1245','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-29 19:39:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1246','180.245.116.21','agustomi@gmail.com','27','2026-01-29 20:42:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1247','2404:c0:2d10::1254:62f6','muchtarsidiq@gmail.com','16','2026-01-29 20:45:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1248','2404:c0:2a10::14b6:e5fb','acepantonfajar@gmail.com','57','2026-01-30 05:04:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1249','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-30 05:30:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1250','2404:c0:2d10::1262:3ade','emmysitimariyam@gmail.com','19','2026-01-30 06:06:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1251','2404:c0:2c10::1238:dc96','agismujiprayitno@gmail.com','24','2026-01-30 06:09:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1252','114.122.69.247','enokmira@gmail.com','60','2026-01-30 06:10:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1253','114.122.82.152','ikanurhasanah@gmail.com','26','2026-01-30 06:11:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1254','114.122.110.68','gilangsepteranurhendra@gmail.com','38','2026-01-30 06:15:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1255','2404:c0:2810::a91:e0d0','neneng@gmail.com','13','2026-01-30 06:18:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1256','36.77.30.196','henririsnandar@gmail.com','28','2026-01-30 06:19:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1257','2404:c0:2e10::126a:cc6e','ekasantikalestari@gmail.com','44','2026-01-30 06:19:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1258','2404:c0:2c10::1261:4f6','rdsusimurti@gmail.com','48','2026-01-30 06:21:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1259','2404:c0:2810::a98:ca88','evitinisukartini@gmail.com','12','2026-01-30 06:21:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1260','114.122.84.135','yusmansetiawan@gmail.com','14','2026-01-30 06:24:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1261','2404:c0:2d10::1264:e3c','yuliagustiani@gmail.com','17','2026-01-30 06:26:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1262','2404:c0:2e10::126f:d825','sitipatimah@gmail.com','6','2026-01-30 06:29:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1263','2404:c0:2b10::14da:41dd','ritanurfatimah',NULL,'2026-01-30 06:31:48','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1264','2404:c0:2910::14bc:d37','elsaandriani@gmail.com','40','2026-01-30 06:31:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1265','2404:c0:2b10::14da:41dd','ritanurfatimah@gmail.com','25','2026-01-30 06:32:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1266','114.122.68.39','adeirfannugraha@gmail.com','29','2026-01-30 06:33:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1267','2404:c0:2f10::1265:5d97','ripkiardian@gmail.com','35','2026-01-30 06:38:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1268','2404:c0:2b10::14de:d3f7','pupuypuadah@gmail.com','53','2026-01-30 06:52:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1269','114.122.103.0','galihwangi@gmail.com','43','2026-01-30 06:54:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1270','114.122.83.54','dewi@gmail.com','10','2026-01-30 06:54:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1271','2404:c0:2b10::14d0:de01','dinanursolihat@gmail.com','56','2026-01-30 06:55:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1272','2404:c0:2a10::14cb:3df2','susilawati@gmail.com','54','2026-01-30 06:57:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1273','114.122.84.115','anggagunawan@gmail.com','39','2026-01-30 07:00:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1274','114.122.105.161','sriastutisyam@gmail.com','22','2026-01-30 07:00:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1275','114.122.107.186','anihgindalistiani@gmail.com','15','2026-01-30 07:09:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1276','2404:c0:2e10::1266:724e','weniwidaningrum@gmail.com','8','2026-01-30 07:10:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1277','114.122.82.2','agustomi@gmail.com','27','2026-01-30 07:12:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1278','2404:c0:2d10::1269:8487','irmannurhendra@gmail.com','20','2026-01-30 07:13:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1279','2404:c0:2910::14cc:6251','enungnuryamin@gmail.com','3','2026-01-30 07:23:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1280','114.122.68.203','asepcandra@gmail.com','31','2026-01-30 07:28:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1281','2404:c0:2910::14d1:7f35','muhtarsidik@gmail.com','49','2026-01-30 07:30:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1282','114.122.108.113','ujenahmad@gmail.com','11','2026-01-30 07:39:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1283','36.77.30.196','yosisitirosita@gmail.com','32','2026-01-30 08:08:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1284','2404:c0:2c10::1267:c38d','ripkiardian@gmail.com','35','2026-01-30 09:11:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1285','36.77.30.196','noviestephen@gmail.com','18','2026-01-30 09:13:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1286','36.77.30.196','noviestephen@gmail.com','18','2026-01-30 09:13:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1287','2404:c0:2e10::1272:db3c','yuliagustiani@gmail.com','17','2026-01-30 09:15:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1288','2404:c0:2e10::1266:724e','weniwidaningrum@gmail.com','8','2026-01-30 09:17:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1289','2404:c0:2910::14b3:5ef6','acepantonfajar@gmail.com','57','2026-01-30 09:27:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1290','36.77.30.196','ranianggraeni@gmail.com','59','2026-01-30 09:45:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1291','36.77.30.196','siskatutiana@gmail.com','62','2026-01-30 09:49:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1292','114.122.104.43','neneng@gmail.com','13','2026-01-30 09:53:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1293','114.122.104.43','neneng@gmail.com','13','2026-01-30 09:53:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1294','114.122.85.175','rentydwiyanti@gmail.com','50','2026-01-30 10:11:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1295','114.122.85.175','rentydwiyanti@gmail.com','50','2026-01-30 10:11:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1296','2404:c0:2b10::14da:41dd','ritanurfatimah',NULL,'2026-01-30 10:13:05','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1297','2404:c0:2b10::14da:41dd','ritanurfatimah@gmail.com','25','2026-01-30 10:13:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1298','36.77.30.196','haniherlina@gmail.com','34','2026-01-30 10:17:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1299','114.122.100.81','asepcandra@gmail.com','31','2026-01-30 10:27:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1300','114.122.100.94','anihgindalistini',NULL,'2026-01-30 10:36:13','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1301','114.122.100.94','anihgindalistiani@gmail.com','15','2026-01-30 10:36:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1302','36.77.30.196','anggagunawan@gmail.com','39','2026-01-30 10:37:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1303','2404:c0:2d10::1269:193f','ikasartika@gmail.com','7','2026-01-30 10:41:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1304','114.122.108.113','ujenahmad@gmail.com','11','2026-01-30 10:47:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1305','2404:c0:2a10::14f0:2106','pupuypuadah@gmail.com','53','2026-01-30 10:47:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1306','2404:c0:2910::14e0:fc40','dinanursolihat@gmail.com','56','2026-01-30 10:47:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1307','2404:c0:2f10::1279:d2c8','novitaandriani@gmail.com','45','2026-01-30 10:47:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1308','36.77.30.196','irmannurhendra@gmail.com','20','2026-01-30 10:48:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1309','2404:c0:2e10::127b:7412','rdsusimurti@gmail.com','48','2026-01-30 10:48:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1310','2404:c0:2c10::1279:fbe7','detirosmawati@gmail.com','36','2026-01-30 10:49:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1311','114.122.83.54','dewi@gmail.com','10','2026-01-30 10:49:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1312','114.122.117.39','enokmira@gmail.com','60','2026-01-30 10:49:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1313','114.122.103.92','gilangsepteranurhendra@gmail.com','38','2026-01-30 10:50:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1314','114.122.111.167','mohammadsuhardiwan@gmail.com','4','2026-01-30 10:52:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1315','36.77.30.196','linlinpermatapraja@gmail.com','61','2026-01-30 10:53:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1316','114.122.115.212','sriastutisyam@gmail.com','22','2026-01-30 10:54:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1317','114.122.103.137','yusmansetiawan@gmail.com','14','2026-01-30 10:55:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1318','2404:c0:2810::a98:ca88','evitinisukartini@gmail.com','12','2026-01-30 10:56:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1319','36.77.30.196','sitipatimah@gmail.com','6','2026-01-30 11:31:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1320','114.122.73.30','agustomi@gmail.com','27','2026-01-30 13:07:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1321','103.208.101.2','nisa@gmail.com','51','2026-01-30 13:12:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1322','114.122.115.212','sriastutisyam@gmail.com','22','2026-01-30 14:33:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1323','2404:c0:2b10::14f4:c842','pupuypuadah@gmail.com','53','2026-01-30 15:20:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1324','103.188.169.69','ekasantikalestari@gmail.com','44','2026-01-30 15:34:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1325','2404:c0:2c10::12a2:b428','tiaiqbalhembara@gmail.com','55','2026-01-30 19:31:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1326','114.122.109.122','galihwangi@gmail.com','43','2026-01-30 19:35:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1327','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-30 20:04:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1328','202.46.68.71','adeirfannugraha@gmail.com','29','2026-01-30 20:40:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1329','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-30 20:49:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1330','36.77.28.201','asepcandra@gmail.com','31','2026-01-30 20:54:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1331','36.77.28.201','asepcandra@gmail.com','31','2026-01-30 20:54:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1332','103.188.169.69','rentydwiyanti@gmail.com','50','2026-01-30 23:16:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1333','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-31 05:40:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1334','103.186.204.55','yuyunyunaningsih@gmail.com','23','2026-01-31 08:55:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1335','103.188.169.69','adminsuper@gmail.com','1','2026-01-31 14:19:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1336','103.188.169.69','adminsuper@gmail.com','1','2026-01-31 14:34:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1337','114.122.110.225','adeirfannugraha@gmail.com','29','2026-01-31 18:04:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1338','110.136.90.47','nanangnajamudin@gmail.com','30','2026-01-31 21:12:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1339','::1','adminsuper@gmail.com','1','2026-02-01 08:51:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1340','::1','anaymaryana','70','2026-02-01 09:59:07','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1341','::1','anaymaryana1',NULL,'2026-02-01 09:59:13','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1342','::1','anaymaryana',NULL,'2026-02-01 09:59:30','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1343','::1','adminsuper@gmail.com','1','2026-02-01 09:59:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1344','::1','dadansudrajat@gmail.com','2','2026-02-01 10:00:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1345','::1','asepcandra@gmail.com','31','2026-02-01 10:01:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1346','::1','adminsuper@gmail.com','1','2026-02-01 10:02:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1347','::1','anaymaryana31','71','2026-02-01 10:03:19','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1348','::1','adminsuper@gmail.com','1','2026-02-01 10:03:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1349','::1','anaymaryana31','71','2026-02-01 10:04:20','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1350','::1','anaymaryana31','71','2026-02-01 10:05:19','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1351','::1','anaymaryana31','71','2026-02-01 10:08:33','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1352','::1','adminsuper@gmail.com','1','2026-02-01 10:08:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1353','::1','anaymaryana31@gmail.com','72','2026-02-01 10:09:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1354','::1','adminsuper@gmail.com','1','2026-02-01 10:10:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1355','::1','a111naymaryana31@gmail.com','73','2026-02-01 10:10:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1356','::1','anaymaryana31@gmail.com','72','2026-02-01 10:11:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1357','::1','adminsuper@gmail.com','1','2026-02-01 10:11:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1358','::1','anaymaryasdsdna31@gmail.com','74','2026-02-01 10:12:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1359','::1','a111naymaryana31@gmail.com','73','2026-02-01 10:13:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1360','::1','anaymaryana31@gmail.com','72','2026-02-01 10:13:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1361','::1','a111naymaryana31@gmail.com','73','2026-02-01 10:14:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1362','::1','petugas@gmail.com','2','2026-02-01 10:29:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1363','::1','siswa@gmail.com','5','2026-02-01 10:29:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1364','::1','adminsuper@gmail.com','1','2026-02-01 10:29:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1365','::1','petugas@gmail.com','2','2026-02-01 10:32:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1366','::1','adminsuper@gmail.com','1','2026-02-01 10:33:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1367','::1','admin@gmail.com','3','2026-02-01 10:49:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1368','::1','adminsuper@gmail.com','1','2026-02-01 10:53:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1369','::1','adminsuper@gmail.com','1','2026-02-01 14:06:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1370','::1','adminsuper@gmail.com','1','2026-02-01 14:15:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1371','::1','orangtua@gmail.com','6','2026-02-01 14:16:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1372','::1','adminsuper@gmail.com','1','2026-02-01 14:23:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1373','::1','orangtua@gmail.com','6','2026-02-01 14:44:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1374','::1','siswa@gmail.com','5','2026-02-01 14:44:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1375','::1','admin@gmail.com','3','2026-02-01 14:44:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1376','::1','adminsuper@gmail.com','1','2026-02-01 14:51:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1377','::1','admin',NULL,'2026-02-01 14:54:27','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1378','::1','admin@gmail.com','3','2026-02-01 14:54:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1379','::1','adminsuper@gmail.com','1','2026-02-01 14:55:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1380','::1','petugas@gmail.com','2','2026-02-01 14:57:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1381','::1','admin@gmail.com','3','2026-02-01 14:57:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1382','::1','admin@gmail.com','3','2026-02-01 15:33:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1383','::1','adminsuper@gmail.com','1','2026-02-01 15:35:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1384','::1','adminsuper@gmail.com','1','2026-02-01 17:27:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1385','::1','adminsuper@gmail.com','1','2026-02-01 17:42:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1386','::1','anaymaryana31@gmail.com','75','2026-02-01 17:43:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1387','::1','adminsuper@gmail.com','1','2026-02-01 17:48:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1388','::1','adminsuper@gmail.com','1','2026-02-01 19:02:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1389','::1','adminsuper@gmail.com','1','2026-02-01 19:33:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1390','::1','superadmin',NULL,'2026-02-01 19:36:17','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1391','::1','adminsuper@gmail.com','1','2026-02-01 19:36:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1392','::1','adminsuper@gmail.com','1','2026-02-01 19:39:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1393','::1','adminsuper@gmail.com','1','2026-02-14 20:50:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1394','::1','adminsuper@gmail.com','1','2026-02-14 20:50:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1395','::1','asepcandra@gmail.com','37','2026-02-14 21:50:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1396','103.188.169.69','adminsuper@gmail.com','1','2026-02-01 22:55:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1397','103.188.169.69','asepcandra@gmail.com','37','2026-02-01 22:56:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1398','103.188.169.69','adminsuper@gmail.com','1','2026-02-01 23:01:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1399','103.188.169.69','asepcandra@gmail.com','37','2026-02-01 23:02:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1400','103.188.169.69','adminsuper@gmail.com','1','2026-02-01 23:09:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1401','103.188.169.69','asepcandra@gmail.com','37','2026-02-01 23:50:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1402','103.188.169.69','admin@gmail.com','3','2026-02-02 00:46:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1403','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 00:46:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1404','103.188.169.69','asepcandra',NULL,'2026-02-02 00:48:13','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1405','103.188.169.69','asepcandra@gmail.com','37','2026-02-02 00:48:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1406','103.208.101.2','nisa@gmail.com','57','2026-02-02 04:36:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1407','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 05:05:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1408','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 05:35:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1409','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 05:43:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1410','103.188.169.69','admin@gmail.com','3','2026-02-02 05:47:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1411','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 05:49:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1412','103.188.169.69','susilawati@gmail.com','60','2026-02-02 05:52:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1413','2404:c0:2c10::135e:79ab','pupuypuadah@gmail.com','59','2026-02-02 06:06:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1414','36.83.121.43','yuyunyunaningsih@gmail.com','29','2026-02-02 06:09:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1415','36.83.121.43','yuyunyunaningsih@gmail.com','29','2026-02-02 06:09:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1416','2404:c0:2c10::1362:2e5b','evitinisukartini@gmail.com','18','2026-02-02 06:11:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1417','114.122.74.245','adeirfannugraha@gmail.com','35','2026-02-02 06:15:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1418','2404:c0:2a10::15eb:e74e','tiaiqbalhembara@gmail.com','61','2026-02-02 06:23:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1419','2404:c0:2e10::1369:c314','linlinpermatapraja@gmail.com','67','2026-02-02 06:23:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1420','2404:c0:2e10::1357:fc2d','henririsnandar@gmail.com','34','2026-02-02 06:25:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1421','2404:c0:2a10::15d0:2011','ripkiardian@gmail.com','41','2026-02-02 06:27:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1422','2404:c0:2910::15ec:c90','ika',NULL,'2026-02-02 06:28:16','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1423','2404:c0:2f10::1360:6fa0','weniwidaningrum@gmail.com','14','2026-02-02 06:28:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1424','2404:c0:2910::15ec:c90','ikasartika@gmail.com','13','2026-02-02 06:28:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1425','202.46.68.41','noviestephen@gmail.com','24','2026-02-02 06:31:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1426','202.46.68.41','noviestephen@gmail.com','24','2026-02-02 06:31:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1427','114.122.116.31','sriastutisyam@gmail.com','28','2026-02-02 06:32:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1428','36.83.121.43','sitipatimah@gmail.com','12','2026-02-02 06:40:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1429','2404:c0:2810::baf:3f7a','agismujiprayitno@gmail.com','30','2026-02-02 06:46:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1430','36.83.121.43','anihgindalistiani@gmail.com','21','2026-02-02 06:49:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1431','2404:c0:2b10::15f2:3bdb','muhtarsidik@gmail.com','55','2026-02-02 06:50:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1432','2404:c0:2e10::136b:4555','dinanursolihat@gmail.com','62','2026-02-02 06:54:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1433','36.83.121.43','rentydwiyanti@gmail.com','56','2026-02-02 06:54:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1434','36.83.121.43','rentydwiyanti@gmail.com','56','2026-02-02 06:54:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1435','114.122.100.115','anggagunawan@gmail.com','45','2026-02-02 06:56:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1436','2404:c0:2910::15fb:6041','emmysitimariyam@gmail.com','25','2026-02-02 06:57:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1437','2404:c0:2e10::1370:4fce','irmannurhendra@gmail.com','26','2026-02-02 07:08:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1438','2404:c0:2810::bb8:8d77','elsaandriani@gmail.com','46','2026-02-02 07:10:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1439','2404:c0:2e10::135f:ec7b','yuliagustiani@gmail.com','23','2026-02-02 07:21:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1440','114.122.103.201','galihwangi@gmail.com','49','2026-02-02 07:27:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1441','103.208.101.2','nisa',NULL,'2026-02-02 07:27:34','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1442','103.208.101.2','nisa',NULL,'2026-02-02 07:27:48','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1443','2404:c0:2b10::15f0:fd6b','nanangnajamudin@gmail.com','36','2026-02-02 07:28:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1444','2404:c0:2b10::15f0:fd6b','nanangnajamudin@gmail.com','36','2026-02-02 07:28:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1445','103.208.101.2','nisa@gmail.com','57','2026-02-02 07:28:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1446','114.122.101.136','asepcandra@gmail.com','37','2026-02-02 07:33:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1447','36.83.121.43','asepcandra@gmail.com','37','2026-02-02 07:48:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1448','36.83.121.43','asepcandra@gmail.com','37','2026-02-02 07:56:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1449','36.83.121.43','asepcandra@gmail.com','37','2026-02-02 07:58:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1450','114.122.116.240','agustomi@gmail.com','33','2026-02-02 07:59:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1451','114.122.116.47','ujenahmad@gmail.com','17','2026-02-02 07:59:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1452','114.122.107.60','gilangsepteranurhendra@gmail.com','44','2026-02-02 08:04:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1453','114.122.107.60','gilangsepteranurhendra@gmail.com','44','2026-02-02 08:04:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1454','114.122.101.1','syfaulhusna@gmail.com','58','2026-02-02 08:15:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1455','114.122.108.229','yosisitirosita@gmail.com','38','2026-02-02 08:23:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1456','2404:c0:2f10::1365:e3a1','ekasantikalestari@gmail.com','50','2026-02-02 08:24:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1457','36.83.121.43','haniherlina@gmail.com','40','2026-02-02 08:53:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1458','36.83.121.43','rentydwiyanti@gmail.com','56','2026-02-02 09:17:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1459','36.83.121.43','asepcandra@gmail.com','37','2026-02-02 10:05:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1460','202.46.68.41','guru@gmail.com','4','2026-02-02 10:05:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1461','36.83.121.43','nanangnajamudin@gmail.com','36','2026-02-02 10:09:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1462','202.46.68.41','adeirfannugraha@gmail.com','35','2026-02-02 10:28:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1463','2404:c0:2f10::136b:b73d','ritanurfatimah@gmail.com','31','2026-02-02 10:40:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1464','2404:c0:2810::bbc:3482','wulanpurnamasari@gmail.com','43','2026-02-02 10:51:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1465','2404:c0:2c10::137a:529a','ikasartika@gmail.com','13','2026-02-02 12:02:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1466','2404:c0:2e10::1382:b37b','pupuypuadah@gmail.com','59','2026-02-02 12:11:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1467','2404:c0:2b10::1610:c467','ripkiardian@gmail.com','41','2026-02-02 12:18:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1468','2404:c0:2a10::1606:6135','linlinpermatapraja@gmail.com','67','2026-02-02 12:19:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1469','2404:c0:2e10::1385:3477','evitinisukartini@gmail.com','18','2026-02-02 12:20:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1470','2404:c0:2a10::15eb:e74e','tiaiqbalhembara@gmail.com','61','2026-02-02 12:21:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1471','2404:c0:2a10::15e4:c3d9','yuyunyunaningsih@gmail.com','29','2026-02-02 12:21:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1472','36.83.121.43','anggagunawan@gmail.com','45','2026-02-02 12:30:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1473','114.122.116.31','sriastutisyam@gmail.com','28','2026-02-02 12:30:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1474','114.122.71.162','anihgindalistiani@gmail.com','21','2026-02-02 12:31:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1475','2404:c0:2b10::15f2:717b','susilawati@gmail.com','60','2026-02-02 12:31:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1476','114.122.109.74','muhtargojali@gmail.com','27','2026-02-02 12:31:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1477','2404:c0:2b10::160e:2024','emmysitimariyam@gmail.com','25','2026-02-02 12:38:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1478','36.83.114.146','irmannurhendra@gmail.com','26','2026-02-02 12:57:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1479','114.122.73.94','dewi@gmail.com','16','2026-02-02 13:13:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1480','114.122.79.120','sitipatimah@gmail.com','12','2026-02-02 13:21:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1481','2404:c0:2a10::1606:f66f','noviestephen@gmail.com','24','2026-02-02 13:25:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1482','2404:c0:2a10::1606:f66f','noviestephen@gmail.com','24','2026-02-02 13:25:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1483','2404:c0:2a10::1606:f66f','noviestephen@gmail.com','24','2026-02-02 13:26:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1484','202.46.68.41','guru@gmail.com','4','2026-02-02 13:30:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1485','114.122.75.30','yosisitirosita@gmail.com','38','2026-02-02 13:34:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1486','114.122.101.1','syfaulhusna@gmail.com','58','2026-02-02 13:42:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1487','114.122.73.187','galihwangi@gmail.com','49','2026-02-02 13:43:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1488','114.122.73.187','galihwangi@gmail.com','49','2026-02-02 13:43:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1489','2404:c0:2e10::135f:ec7b','yuliagustiani@gmail.com','23','2026-02-02 13:45:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1490','103.208.101.2','nisa@gmail.com','57','2026-02-02 14:11:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1491','2404:c0:2d10::1380:f965','henririsnandar@gmail.com','34','2026-02-02 14:23:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1492','114.122.114.96','agustomi@gmail.com','33','2026-02-02 14:26:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1493','36.83.121.43','henririsnandar@gmail.com','34','2026-02-02 14:29:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1494','114.122.106.250','haniherlina@gmail.com','40','2026-02-02 14:34:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1495','2404:c0:2a10::1616:bc40','dinanursolihat@gmail.com','62','2026-02-02 14:39:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1496','2404:c0:2910::1605:c621','ikasartika@gmail.com','13','2026-02-02 14:39:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1497','114.122.73.94','dewi@gmail.com','16','2026-02-02 14:42:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1498','114.122.73.94','dewi@gmail.com','16','2026-02-02 14:42:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1499','2404:c0:2d10::1382:e4c7','rdsusimurti@gmail.com','54','2026-02-02 14:42:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1500','114.122.83.233','muhtargojali@gmail.com','27','2026-02-02 14:42:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1501','2404:c0:2d10::135f:a483','jonihprasetia@gmail.com','53','2026-02-02 14:43:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1502','2404:c0:2c10::135d:a7b9','acepantonfajar@gmail.com','63','2026-02-02 14:43:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1503','2404:c0:2b10::1610:c467','ripkiardian@gmail.com','41','2026-02-02 14:44:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1504','2404:c0:2a10::1619:3bc0','firmanmuharam@gmail.com','64','2026-02-02 14:44:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1505','2404:c0:2b10::1617:722d','ranianggraeni@gmail.com','65','2026-02-02 14:45:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1506','114.122.72.164','enokmira@gmail.com','66','2026-02-02 14:48:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1507','2404:c0:2810::bbe:7a58','novitaandriani@gmail.com','51','2026-02-02 14:49:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1508','2404:c0:2810::bbe:7a58','novitaandriani@gmail.com','51','2026-02-02 14:49:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1509','114.122.83.69','neneng@gmail.com','19','2026-02-02 14:50:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1510','36.83.121.43','asepcandra@gmail.com','37','2026-02-02 14:50:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1511','36.83.121.43','asepcandra@gmail.com','37','2026-02-02 14:51:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1512','36.83.121.43','asepcandra@gmail.com','37','2026-02-02 14:52:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1513','2404:c0:2a10::1613:effc','weniwidaningrum@gmail.com','14','2026-02-02 14:52:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1514','36.83.121.43','adminsuper@gmail.com','1','2026-02-02 14:54:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1515','2404:c0:2e10::137f:2c4b','nanangnajamudin@gmail.com','36','2026-02-02 14:57:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1516','202.46.68.41','adeirfannugraha@gmail.com','35','2026-02-02 15:15:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1517','114.122.117.60','gilangsepteranurhendra@gmail.com','44','2026-02-02 15:28:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1518','2404:c0:2d10::1387:f67c','andiciptanugraha@gmail.com','15','2026-02-02 15:53:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1519','180.241.241.72','muhtarsidik@gmail.com','55','2026-02-02 16:20:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1520','103.138.53.62','noviestephen@gmail.com','24','2026-02-02 17:05:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1521','103.138.53.62','noviestephen@gmail.com','24','2026-02-02 17:05:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1522','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 17:25:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1523','36.83.113.87','asepcandra@gmail.com','37','2026-02-02 17:33:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1524','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 17:59:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1525','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 17:59:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1526','103.183.57.3','elsaandriani@gmail.com','46','2026-02-02 18:28:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1527','103.188.169.153','evitinisukartini@gmail.com','18','2026-02-02 18:35:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1528','103.208.101.2','nisa@gmail.com','57','2026-02-02 19:06:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1529','103.184.16.247','henririsnandar@gmail.com','34','2026-02-02 19:08:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1530','202.46.68.71','guru@gmail.com','4','2026-02-02 20:22:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1531','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-02 20:28:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1532','103.166.159.217','pupuypuadah@gmail.com','59','2026-02-02 20:36:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1533','103.188.169.69','adminsuper@gmail.com','1','2026-02-02 20:50:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1534','2404:c0:2910::1636:3d91','ritanurfatimah@gmail.com','31','2026-02-02 21:08:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1535','202.46.68.71','guru@gmail.com','4','2026-02-02 21:13:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1536','36.78.244.90','acepantonfajar@gmail.com','63','2026-02-02 21:29:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1537','36.83.121.43','nanangnajamudin@gmail.com','36','2026-02-02 21:30:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1538','114.122.116.31','sriastutisyam@gmail.com','28','2026-02-02 22:12:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1539','103.188.169.69','susilawati@gmail.com','60','2026-02-03 03:43:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1540','202.46.68.71','guru@gmail.com','4','2026-02-03 03:57:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1541','114.122.68.55','haniherlina@gmail.com','40','2026-02-03 04:15:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1542','103.188.169.69','ranianggraeni@gmail.com','65','2026-02-03 04:38:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1543','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-03 04:38:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1544','114.122.105.132','yuliagustiani@gmail.com','23','2026-02-03 04:39:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1545','2404:c0:2d10::13b4:9f50','acepantonfajar@gmail.com','63','2026-02-03 05:04:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1546','114.122.102.251','galihwangi@gmail.com','49','2026-02-03 06:08:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1547','202.46.68.41','yusmansetiawan@gmail.com','20','2026-02-03 06:10:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1548','202.46.68.41','guru@gmail.com','4','2026-02-03 06:12:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1549','103.188.169.153','dinanursolihat@gmail.com','62','2026-02-03 06:14:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1550','114.122.71.184','haniherlina@gmail.com','40','2026-02-03 06:16:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1551','114.122.116.31','sriastutisyam@gmail.com','28','2026-02-03 06:19:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1552','114.122.71.69','asepcandra@gmail.com','37','2026-02-03 06:24:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1553','2404:c0:2e10::13b7:4fe1','emmysitimariyam@gmail.com','25','2026-02-03 06:28:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1554','2404:c0:2a10::1647:7097','irmannurhendra@gmail.com','26','2026-02-03 06:29:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1555','114.122.85.141','adeirfannugraha@gmail.com','35','2026-02-03 06:29:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1556','2404:c0:2d10::13bf:21d8','yuyunyunaningsih@gmail.com','29','2026-02-03 06:29:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1557','103.188.169.69','susilawati@gmail.com','60','2026-02-03 06:30:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1558','2404:c0:2b10::163e:b6a0','detirosmawati@gmail.com','42','2026-02-03 06:31:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1559','103.183.57.3','elsaandriani@gmail.com','46','2026-02-03 06:31:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1560','114.122.71.206','mohammadsuhardiwan@gmail.com','10','2026-02-03 06:32:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1561','2404:c0:2d10::13b4:b874','andiciptanugraha@gmail.com','15','2026-02-03 06:32:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1562','36.83.121.43','henririsnandar@gmail.com','34','2026-02-03 06:33:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1563','2404:c0:2c10::13b0:221','noviestephen@gmail.com','24','2026-02-03 06:35:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1564','114.122.109.194','anggagunawan@gmail.com','45','2026-02-03 06:43:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1565','2404:c0:2e10::13ba:9dc9','weniwidaningrum@gmail.com','14','2026-02-03 06:46:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1566','202.46.68.1','muhtarsidik@gmail.com','55','2026-02-03 06:58:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1567','36.83.121.43','evitinisukartini@gmail.com','18','2026-02-03 07:06:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1568','2404:c0:2e10::13ae:feab','nisa@gmail.com','57','2026-02-03 07:07:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1569','2404:c0:2e10::13ae:feab','nisa@gmail.com','57','2026-02-03 07:07:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1570','2404:c0:2e10::13bc:196e','ripkiardian@gmail.com','41','2026-02-03 07:07:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1571','114.122.101.144','gilangsepteranurhendra@gmail.com','44','2026-02-03 07:15:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1572','114.122.85.141','guru@gmail.com','4','2026-02-03 07:27:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1573','114.122.85.141','guru@gmail.com','4','2026-02-03 07:29:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1574','114.122.85.141','adeirfannugraha@gmail.com','35','2026-02-03 07:34:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1575','114.122.104.207','enokmira@gmail.com','66','2026-02-03 07:37:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1576','2404:c0:2c10::13ab:16aa','ikasartika@gmail.com','13','2026-02-03 07:39:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1577','2404:c0:2b10::1655:ab16','pupuypuadah@gmail.com','59','2026-02-03 07:39:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1578','103.188.169.69','adminsuper@gmail.com','1','2026-02-03 07:41:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1579','2404:c0:2c10::13b7:d593','yuliagustiani@gmail.com','23','2026-02-03 07:45:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1580','36.83.117.204','ujenahmad@gmail.com','17','2026-02-03 08:06:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1581','2404:c0:2f10::13c5:5c7e','ekasantikalestari@gmail.com','50','2026-02-03 08:16:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1582','103.3.221.222','wulanpurnamasari@gmail.com','43','2026-02-03 08:22:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1583','114.122.71.162','anihgindalistiani@gmail.com','21','2026-02-03 08:33:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1584','36.83.121.43','osis',NULL,'2026-02-03 08:38:12','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1585','36.83.121.43','guru@gmail.com','4','2026-02-03 08:38:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1586','114.122.100.86','muhtargojali@gmail.com','27','2026-02-03 08:41:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1587','114.122.82.236','agustomi@gmail.com','33','2026-02-03 09:16:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1588','36.83.121.43','asepcandra@gmail.com','37','2026-02-03 09:18:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1589','202.46.68.41','nanangnajamudin@gmail.com','36','2026-02-03 09:21:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1590','202.46.68.41','nanangnajamudin@gmail.com','36','2026-02-03 09:21:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1591','36.83.121.43','sitipatimah@gmail.com','12','2026-02-03 09:21:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1592','114.122.100.148','gilangsepteranurhendra@gmail.com','44','2026-02-03 09:32:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1593','114.122.109.33','yosisitirosita@gmail.com','38','2026-02-03 10:03:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1594','2404:c0:2f10::13b8:65a1','ikasartika@gmail.com','13','2026-02-03 10:52:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1595','2404:c0:2910::1643:6e7','irmannurhendra@gmail.com','26','2026-02-03 11:34:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1596','36.83.121.43','nisa@gmail.com','57','2026-02-03 11:48:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1597','2404:c0:2e10::13cd:d5e2','nanangnajamudin@gmail.com','36','2026-02-03 11:55:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1598','2404:c0:2e10::13cd:d5e2','nanangnajamudin@gmail.com','36','2026-02-03 11:55:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1599','114.122.110.27','galihwangi@gmail.com','49','2026-02-03 12:01:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1600','114.122.110.27','galihwangi@gmail.com','49','2026-02-03 12:01:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1601','114.122.84.164','asepcandra@gmail.com','37','2026-02-03 12:02:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1602','36.83.116.99','rentydwiyanti@gmail.com','56','2026-02-03 12:03:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1603','2404:c0:2810::c2e:85ec','sitipatimah@gmail.com','12','2026-02-03 12:14:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1604','2404:c0:2e10::13d5:7413','emmysitimariyam@gmail.com','25','2026-02-03 12:17:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1605','2404:c0:2910::1657:8080','susilawati@gmail.com','60','2026-02-03 12:18:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1606','114.122.115.204','enokmira@gmail.com','66','2026-02-03 12:27:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1607','114.122.106.164','anggagunawan@gmail.com','45','2026-02-03 12:34:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1608','2404:c0:2810::c38:c38a','linlinpermatapraja@gmail.com','67','2026-02-03 12:44:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1609','114.122.103.192','gilangsepteranurhendra@gmail.com','44','2026-02-03 12:57:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1610','114.122.103.192','gilangsepteranurhendra@gmail.com','44','2026-02-03 12:57:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1611','114.122.103.192','gilangsepteranurhendra@gmail.com','44','2026-02-03 12:58:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1612','36.83.116.99','evitinisukartini@gmail.com','18','2026-02-03 12:59:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1613','36.83.116.99','evitinisukartini@gmail.com','18','2026-02-03 13:00:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1614','36.83.116.99','evitinisukartini@gmail.com','18','2026-02-03 13:00:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1615','36.83.116.99','weniwidaningrum@gmail.com','14','2026-02-03 13:02:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1616','202.46.68.41','osis',NULL,'2026-02-03 13:08:06','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1617','2404:c0:2e10::13ce:b86a','alliyazahira11@gmail.com',NULL,'2026-02-03 13:27:21','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1618','2404:c0:2e10::13ce:b86a','alliyazahira11@gmail.com',NULL,'2026-02-03 13:27:27','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1619','2404:c0:2e10::13ce:b86a','ALLIYA ZAHIRA GARNANTARA ',NULL,'2026-02-03 13:27:53','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1620','2404:c0:2e10::13ce:b86a','alliyazahira11@gmail.com',NULL,'2026-02-03 13:50:51','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1621','2404:c0:2910::1679:674a','detirosmawati@gmail.com','42','2026-02-03 14:21:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1622','114.122.79.135','yusmansetiawan@gmail.com','20','2026-02-03 14:23:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1623','2404:c0:2810::c33:ce4d','jonihprasetia@gmail.com','53','2026-02-03 14:28:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1624','2404:c0:2810::c33:ce4d','jonihprasetia@gmail.com','53','2026-02-03 14:28:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1625','36.83.116.99','adminsuper@gmail.com','1','2026-02-03 14:30:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1626','2404:c0:2810::c2e:85ec','sitipatimah@gmail.com','12','2026-02-03 14:31:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1627','2404:c0:2d10::13d1:39b2','ritanurfatimah@gmail.com','31','2026-02-03 14:32:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1628','114.122.85.3','mohammadsuhardiwan@gmail.com','10','2026-02-03 14:33:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1629','2404:c0:2d10::13dc:8a6a','andiciptanugraha@gmail.com','15','2026-02-03 14:34:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1630','2404:c0:2e10::13e6:1075','rdsusimurti@gmail.com','54','2026-02-03 14:34:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1631','36.83.116.99','irmannurhendra@gmail.com','26','2026-02-03 14:34:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1632','36.83.116.99','irmannurhendra@gmail.com','26','2026-02-03 14:34:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1633','2404:c0:2810::c3f:1ba','noviestephen@gmail.com','24','2026-02-03 14:34:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1634','114.122.110.228','muhtargojali@gmail.com','27','2026-02-03 14:35:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1635','114.122.105.104','dewi@gmail.com','16','2026-02-03 14:35:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1636','2404:c0:2d10::13d1:c9f7','tiaiqbalhembara@gmail.com','61','2026-02-03 14:37:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1637','36.83.116.99','siskatutiana@gmail.com','68','2026-02-03 14:38:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1638','114.122.116.31','sriastutisyam@gmail.com','28','2026-02-03 14:38:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1639','114.122.83.30','oceankenzie284@gmail.com',NULL,'2026-02-03 14:39:15','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1640','2404:c0:2f10::13e4:f0ae','nisa@gmail.com','57','2026-02-03 14:39:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1641','2404:c0:2f10::13e4:f0ae','nisa@gmail.com','57','2026-02-03 14:39:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1642','114.122.83.126','haniherlina@gmail.com','40','2026-02-03 14:39:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1643','36.83.116.99','ikanurhasanah@gmail.com','32','2026-02-03 14:42:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1644','2404:c0:2c10::13db:d02e','dinanursolihat@gmail.com','62','2026-02-03 14:42:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1645','2404:c0:2d10::13da:b0d8','ranianggraeni@gmail.com','65','2026-02-03 14:43:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1646','114.122.101.165','yosisitirosita@gmail.com','38','2026-02-03 14:47:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1647','2404:c0:2e10::13b9:545','acepantonfajar@gmail.com','63','2026-02-03 14:56:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1648','36.83.116.99','anihgindalistiani@gmail.com','21','2026-02-03 15:10:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1649','36.83.116.99','adesutrisna@gmail.com','39','2026-02-03 15:11:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1650','2404:c0:2d10::13da:8705','alliyazahira11@gmail.com',NULL,'2026-02-03 15:47:06','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1651','2404:c0:2d10::13da:8705','alliyazahira11@gmail.com',NULL,'2026-02-03 15:47:31','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1652','2404:c0:2d10::13d9:9504','emmysitimariyam@gmail.com','25','2026-02-03 15:57:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1653','103.166.159.217','pupuypuadah@gmail.com','59','2026-02-03 16:45:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1654','180.241.242.11','muhtarsidik@gmail.com','55','2026-02-03 16:46:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1655','36.83.114.146','guru@gmail.com','4','2026-02-03 17:11:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1656','36.83.116.99','galihwangi@gmail.com','49','2026-02-03 17:30:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1657','103.188.169.69','susilawati@gmail.com','60','2026-02-03 18:28:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1658','2404:c0:2c10::13df:6d8','tiaiqbalhembara@gmail.com','61','2026-02-03 18:47:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1659','114.122.72.107','haniherlina@gmail.com','40','2026-02-03 19:00:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1660','202.46.68.71','osis',NULL,'2026-02-03 19:07:50','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1661','202.46.68.71','guru@gmail.com','4','2026-02-03 19:08:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1662','202.46.68.71','Osis',NULL,'2026-02-03 19:09:37','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1663','202.46.68.71','guru@gmail.com','4','2026-02-03 19:09:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1664','202.46.68.71','guru@gmail.com','4','2026-02-03 19:14:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1665','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-03 19:21:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1666','103.188.169.69','anggagunawan@gmail.com','45','2026-02-03 21:24:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1667','103.188.169.153','dinanursolihat@gmail.com','62','2026-02-04 05:25:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1668','2404:c0:2a10::16a3:a73b','acepantonfajar@gmail.com','63','2026-02-04 05:53:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1669','202.46.68.41','sitipatimah@gmail.com','12','2026-02-04 06:01:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1670','202.46.68.41','yusmansetiawan@gmail.com','20','2026-02-04 06:06:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1671','2404:c0:2b10::16a0:930','syfaulhusna@gmail.com','58','2026-02-04 06:10:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1672','2404:c0:2d10::140c:13c2','yuyunyunaningsih@gmail.com','29','2026-02-04 06:10:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1673','114.122.108.9','yosisitirosita@gmail.com','38','2026-02-04 06:21:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1674','2404:c0:2b10::16af:cdd3','emmysitimariyam@gmail.com','25','2026-02-04 06:29:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1675','114.122.68.63','adeirfannugraha@gmail.com','35','2026-02-04 06:31:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1676','114.122.106.158','sriastutisyam@gmail.com','28','2026-02-04 06:32:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1677','2404:c0:2b10::16a7:7b3b','siskatutiana@gmail.com','68','2026-02-04 06:33:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1678','114.122.68.85','muhtargojali@gmail.com','27','2026-02-04 06:35:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1679','103.138.53.62','gilangsepteranurhendra@gmail.com','44','2026-02-04 06:36:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1680','2404:c0:2810::c75:428f','muhtarsidik@gmail.com','55','2026-02-04 06:37:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1681','2404:c0:2f10::13ff:5afa','novitaandriani@gmail.com','51','2026-02-04 06:38:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1682','114.122.101.145','asepcandra@gmail.com','37','2026-02-04 06:41:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1683','2404:c0:2910::16af:b0a4','pupuypuadah@gmail.com','59','2026-02-04 06:42:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1684','114.122.100.169','galihwangi@gmail.com','49','2026-02-04 06:42:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1685','114.122.104.219','sitimunawaroh@gmail.com','47','2026-02-04 06:44:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1686','2404:c0:2f10::140f:14cf','ripkiardian@gmail.com','41','2026-02-04 06:47:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1687','2404:c0:2810::c73:7bed','susilawati@gmail.com','60','2026-02-04 06:54:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1688','2404:c0:2810::c76:bff','nisa@gmail.com','57','2026-02-04 06:54:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1689','114.122.84.96','ujenahmad@gmail.com','17','2026-02-04 07:08:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1690','2404:c0:2d10::1409:9fd5','evitinisukartini@gmail.com','18','2026-02-04 07:10:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1691','2404:c0:2d10::1409:9fd5','evitinisukartini@gmail.com','18','2026-02-04 07:10:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1692','114.122.69.133','anihgindalistiani@gmail.com','21','2026-02-04 07:13:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1693','114.122.68.71','neneng@gmail.com','19','2026-02-04 07:14:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1694','2404:c0:2f10::1417:e23a','agismujiprayitno@gmail.com','30','2026-02-04 07:16:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1695','2404:c0:2f10::140f:124f','henririsnandar@gmail.com','34','2026-02-04 07:18:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1696','2404:c0:2b10::16ae:98d9','tiaiqbalhembara@gmail.com','61','2026-02-04 07:20:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1697','103.188.169.69','adminsuper@gmail.com','1','2026-02-04 07:23:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1698','2404:c0:2f10::1417:a23a','noviestephen@gmail.com','24','2026-02-04 07:24:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1699','103.188.169.69','adminsuper@gmail.com','1','2026-02-04 07:28:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1700','2404:c0:2f10::1417:a23a','noviestephen@gmail.com','24','2026-02-04 07:34:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1701','2404:c0:2f10::1417:a23a','noviestephen@gmail.com','24','2026-02-04 07:34:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1702','103.188.169.69','adminsuper@gmail.com','1','2026-02-04 07:34:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1703','2404:c0:2b10::16a6:2a05','weniwidaningrum@gmail.com','14','2026-02-04 07:35:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1704','2404:c0:2e10::1419:9d18','irmannurhendra@gmail.com','26','2026-02-04 07:37:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1705','2404:c0:2e10::1407:7b01','yuliagustiani@gmail.com','23','2026-02-04 07:38:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1706','36.83.116.99','linlinpermatapraja@gmail.com','67','2026-02-04 07:42:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1707','2404:c0:2b10::16b2:c56b','rentydwiyanti@gmail.com','56','2026-02-04 07:42:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1708','2404:c0:2910::16af:7811','elsaandriani@gmail.com','46','2026-02-04 07:43:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1709','202.46.68.41','guru@gmail.com','4','2026-02-04 07:50:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1710','2404:c0:2f10::1417:e23a','agismujiprayitno@gmail.com','30','2026-02-04 08:02:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1711','2404:c0:2d10::1409:9fd5','evitinisukartini@gmail.com','18','2026-02-04 08:06:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1712','2404:c0:2d10::1409:9fd5','evitinisukartini@gmail.com','18','2026-02-04 08:06:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1713','114.122.77.236','adeirfannugraha@gmail.com','35','2026-02-04 08:08:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1714','2404:c0:2e10::140d:8556','ikasartika@gmail.com','13','2026-02-04 08:12:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1715','114.122.106.158','sriastutisyam@gmail.com','28','2026-02-04 08:17:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1716','114.122.68.85','muhtargojali@gmail.com','27','2026-02-04 08:18:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1717','114.122.68.85','muhtargojali@gmail.com','27','2026-02-04 08:18:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1718','2404:c0:2d10::140c:13c2','yuyunyunaningsih@gmail.com','29','2026-02-04 08:23:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1719','114.122.84.96','ujenahmad@gmail.com','17','2026-02-04 08:44:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1720','114.122.100.169','galihwangi@gmail.com','49','2026-02-04 09:16:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1721','2404:c0:2810::c6f:70b8','tiaiqbalhembara@gmail.com','61','2026-02-04 09:17:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1722','114.122.84.68','gilangsepteranurhendra@gmail.com','44','2026-02-04 09:20:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1723','114.122.84.157','anihgindalistiani@gmail.com','21','2026-02-04 10:04:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1724','2404:c0:2810::c80:ba2d','emmysitimariyam@gmail.com','25','2026-02-04 10:11:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1725','2404:c0:2810::c73:7bed','susilawati@gmail.com','60','2026-02-04 10:44:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1726','36.83.124.37','adminsuper@gmail.com','1','2026-02-04 10:49:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1727','2404:c0:2d10::140c:13c2','yuyunyunaningsih@gmail.com','29','2026-02-04 10:59:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1728','2404:c0:2b10::16a0:930','syfaulhusna@gmail.com','58','2026-02-04 11:40:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1729','36.83.124.37','linlinpermatapraja@gmail.com','67','2026-02-04 11:53:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1730','114.122.108.162','yosisitirosita@gmail.com','38','2026-02-04 11:55:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1731','114.122.108.162','yosisitirosita@gmail.com','38','2026-02-04 11:55:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1732','2404:c0:2e10::1409:60d9','evitinisukartini@gmail.com','18','2026-02-04 12:01:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1733','114.122.84.68','gilangsepteranurhendra@gmail.com','44','2026-02-04 12:02:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1734','2404:c0:2c10::1423:5f44','dinanursolihat@gmail.com','62','2026-02-04 12:06:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1735','2404:c0:2c10::1410:8e9d','sitipatimah@gmail.com','12','2026-02-04 12:22:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1736','114.122.116.127','sitimunawaroh@gmail.com','47','2026-02-04 12:34:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1737','2404:c0:2a10::16c6:f1b4','emmysitimariyam@gmail.com','25','2026-02-04 12:35:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1738','2404:c0:2c10::1410:8e9d','sitipatimah@gmail.com','12','2026-02-04 12:57:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1739','202.46.68.41','agustomi@gmail.com','33','2026-02-04 13:00:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1740','2404:c0:2a10::16c6:c48','muhtarsidik@gmail.com','55','2026-02-04 13:00:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1741','2404:c0:2810::c73:7bed','susilawati@gmail.com','60','2026-02-04 13:04:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1742','114.122.108.150','haniherlina@gmail.com','40','2026-02-04 13:20:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1743','2404:c0:2f10::142e:6ec','nisa@gmail.com','57','2026-02-04 13:22:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1744','114.122.68.45','enokmira@gmail.com','66','2026-02-04 13:22:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1745','114.122.68.45','enokmira@gmail.com','66','2026-02-04 13:22:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1746','2404:c0:2a10::16c3:8db4','pupuypuadah@gmail.com','59','2026-02-04 13:25:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1747','114.122.102.207','dewi@gmail.com','16','2026-02-04 14:05:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1748','2404:c0:2c10::1425:f83c','rentydwiyanti@gmail.com','56','2026-02-04 14:12:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1749','2404:c0:2c10::1425:f83c','rentydwiyanti@gmail.com','56','2026-02-04 14:12:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1750','2404:c0:2d10::1429:6b34','yuliagustiani@gmail.com','23','2026-02-04 14:12:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1751','114.122.114.231','yusmansetiawan@gmail.com','20','2026-02-04 14:14:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1752','2404:c0:2e10::142b:4aaa','jonihprasetia@gmail.com','53','2026-02-04 14:15:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1753','2404:c0:2810::c6f:70b8','tiaiqbalhembara@gmail.com','61','2026-02-04 14:28:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1754','2404:c0:2d10::142b:e28b','detirosmawati@gmail.com','42','2026-02-04 14:28:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1755','2404:c0:2e10::142d:9200','irmannurhendra@gmail.com','26','2026-02-04 14:31:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1756','2404:c0:2d10::13af:c95c','firmanmuharam@gmail.com','64','2026-02-04 14:32:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1757','2404:c0:2910::1690:4c4','acepantonfajar@gmail.com','63','2026-02-04 14:32:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1758','2404:c0:2910::1690:4c4','acepantonfajar@gmail.com','63','2026-02-04 14:32:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1759','36.83.124.37','linlinpermatapraja@gmail.com','67','2026-02-04 14:32:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1760','2404:c0:2e10::1422:8cbc','noviestephen@gmail.com','24','2026-02-04 14:33:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1761','2404:c0:2e10::1422:8cbc','noviestephen@gmail.com','24','2026-02-04 14:33:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1762','2404:c0:2d10::142a:e5e9','siskatutiana@gmail.com','68','2026-02-04 14:34:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1763','2404:c0:2d10::1409:9fd5','evitinisukartini@gmail.com','18','2026-02-04 14:34:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1764','114.122.101.141','asepcandra@gmail.com','37','2026-02-04 14:35:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1765','114.122.101.141','asepcandra@gmail.com','37','2026-02-04 14:35:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1766','2404:c0:2b10::16cd:b7b0','andiciptanugraha@gmail.com','15','2026-02-04 14:35:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1767','114.122.84.68','gilangsepteranurhendra@gmail.com','44','2026-02-04 14:35:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1768','2404:c0:2d10::13af:c95c','firmanmuharam@gmail.com','64','2026-02-04 14:35:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1769','114.122.84.150','anggagunawan@gmail.com','45','2026-02-04 14:36:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1770','114.122.105.249','ritanurfatimah@gmail.com','31','2026-02-04 14:36:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1771','2404:c0:2c10::1409:9c1','ripkiardian@gmail.com','41','2026-02-04 14:36:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1772','2404:c0:2810::ca5:addf','rdsusimurti@gmail.com','54','2026-02-04 14:37:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1773','2404:c0:2d10::1424:3f5a','elsaandriani@gmail.com','46','2026-02-04 14:38:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1774','2404:c0:2c10::1416:c546','henririsnandar@gmail.com','34','2026-02-04 14:43:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1775','2404:c0:2810::c9c:b48','weniwidaningrum@gmail.com','14','2026-02-04 14:45:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1776','114.122.84.137','anihgindalistiani@gmail.com','21','2026-02-04 14:46:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1777','2404:c0:2d10::1419:372f','muchtarsidiq@gmail.com','22','2026-02-04 14:48:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1778','2404:c0:2e10::142b:6a38','ikasartika@gmail.com','13','2026-02-04 14:55:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1779','2404:c0:2910::16e5:6012','nanangnajamudin@gmail.com','36','2026-02-04 16:13:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1780','202.46.68.71','guru@gmail.com','4','2026-02-04 18:49:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1781','202.46.68.41','adeirfannugraha@gmail.com','35','2026-02-04 19:24:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1782','36.83.124.37','adminsuper@gmail.com','1','2026-02-04 19:31:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1783','103.188.169.69','adminsuper@gmail.com','1','2026-02-04 20:17:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1784','36.50.92.136','novitaandriani@gmail.com','51','2026-02-04 20:29:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1785','2404:c0:2a10::16ea:4804','evitinisukartini@gmail.com','18','2026-02-04 20:44:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1786','114.122.84.146','sriastutisyam@gmail.com','28','2026-02-04 22:25:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1787','103.188.169.69','adminsuper@gmail.com','1','2026-02-04 23:08:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1788','2404:c0:2910::170f:a5f4','nanangnajamudin@gmail.com','36','2026-02-05 06:07:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1789','2404:c0:2910::170d:601d','jonihprasetia@gmail.com','53','2026-02-05 06:09:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1790','2404:c0:2e10::1463:e93a','neneng@gmail.com','19','2026-02-05 06:23:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1791','2404:c0:2f10::145d:3b7a','emmysitimariyam@gmail.com','25','2026-02-05 06:23:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1792','114.122.71.253','adeirfannugraha',NULL,'2026-02-05 06:24:15','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1793','114.122.71.253','adeirfannugraha@gmail.com','35','2026-02-05 06:24:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1794','2404:c0:2b10::171c:9072','noviestephen@gmail.com','24','2026-02-05 06:25:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1795','114.122.100.232','dewi@gmail.com','16','2026-02-05 06:29:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1796','2404:c0:2d10::144b:a69d','detirosmawati@gmail.com','42','2026-02-05 06:31:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1797','2404:c0:2810::cd3:9056','ikasartika@gmail.com','13','2026-02-05 06:35:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1798','2404:c0:2d10::1454:fd5f','rdsusimurti@gmail.com','54','2026-02-05 06:41:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1799','2404:c0:2d10::1454:fd5f','rdsusimurti@gmail.com','54','2026-02-05 06:41:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1800','36.83.124.37','evitinisukartini@gmail.com','18','2026-02-05 06:49:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1801','114.122.79.193','ikanurhasanah@gmail.com','32','2026-02-05 06:52:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1802','202.46.68.41','yusmansetiawan@gmail.com','20','2026-02-05 06:53:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1803','2001:67c:198c:906:e2db:55ff:fefd:dfc4','andrinugraha@gmail.com','52','2026-02-05 06:59:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1804','114.122.100.57','ujenahmad@gmail.com','17','2026-02-05 07:00:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1805','2404:c0:2b10::1703:eae8','wulanpurnamasari@gmail.com','43','2026-02-05 07:04:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1806','202.46.68.1','muhtarsidik@gmail.com','55','2026-02-05 07:05:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1807','114.122.73.124','asepcandra@gmail.com','37','2026-02-05 07:09:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1808','114.122.73.124','asepcandra@gmail.com','37','2026-02-05 07:09:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1809','2404:c0:2f10::1457:d14e','ripkiardian@gmail.com','41','2026-02-05 07:09:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1810','114.122.84.142','sriastutisyam@gmail.com','28','2026-02-05 07:10:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1811','114.122.69.195','muhtargojali@gmail.com','27','2026-02-05 07:10:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1812','114.122.69.195','muhtargojali@gmail.com','27','2026-02-05 07:10:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1813','114.122.69.195','muhtargojali@gmail.com','27','2026-02-05 07:10:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1814','114.122.84.40','galihwangi@gmail.com','49','2026-02-05 07:16:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1815','114.122.83.0','gilangsepteranurhendra@gmail.com','44','2026-02-05 07:16:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1816','2404:c0:2b10::170f:8957','sitipatimah@gmail.com','12','2026-02-05 07:17:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1817','2404:c0:2b10::1717:847c','elsaandriani@gmail.com','46','2026-02-05 07:18:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1818','2404:c0:2d10::145a:d471','syfaulhusna@gmail.com','58','2026-02-05 07:21:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1819','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-05 07:28:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1820','2404:c0:2f10::145c:7698','susilawati@gmail.com','60','2026-02-05 07:28:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1821','2404:c0:2a10::1706:6546','agismujiprayitno@gmail.com','30','2026-02-05 07:32:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1822','2404:c0:2f10::1451:7a54','yuliagustiani@gmail.com','23','2026-02-05 07:36:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1823','103.184.16.247','henririsnandar@gmail.com','34','2026-02-05 07:42:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1824','103.188.169.69','adminsuper@gmail.com','1','2026-02-05 07:53:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1825','2404:c0:2b10::1703:eae8','wulanpurnamasari@gmail.com','43','2026-02-05 07:53:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1826','2404:c0:2f10::1468:1c3','dinanursolihat@gmail.com','62','2026-02-05 07:54:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1827','202.46.68.41','noviestephen@gmail.com','24','2026-02-05 07:57:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1828','202.46.68.41','noviestephen@gmail.com','24','2026-02-05 07:57:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1829','2404:c0:2910::1714:ce9c','muhtarsidik@gmail.com','55','2026-02-05 07:57:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1830','2404:c0:2e10::1466:bd65','pupuypuadah@gmail.com','59','2026-02-05 08:00:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1831','114.122.69.219','muhtargojali@gmail.com','27','2026-02-05 08:02:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1832','2404:c0:2b10::1713:7a13','irmannurhendra@gmail.com','26','2026-02-05 08:06:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1833','36.83.124.37','galihwangi@gmail.com','49','2026-02-05 08:08:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1834','114.122.115.51','enokmira@gmail.com','66','2026-02-05 08:11:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1835','2404:c0:2f10::1471:78d8','ranianggraeni@gmail.com','65','2026-02-05 08:11:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1836','202.46.68.41','adeirfannugraha@gmail.com','35','2026-02-05 08:12:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1837','114.122.110.141','haniherlina@gmail.com','40','2026-02-05 08:12:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1838','2404:c0:2b10::1716:c724','acepantonfajar@gmail.com','63','2026-02-05 08:21:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1839','2404:c0:2f10::1458:78d3','tiaiqbalhembara@gmail.com','61','2026-02-05 08:23:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1840','114.122.77.73','yosisitirosita@gmail.com','38','2026-02-05 08:23:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1841','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-05 08:27:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1842','2404:c0:2f10::145c:7698','susilawati@gmail.com','60','2026-02-05 08:46:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1843','2404:c0:2c10::1462:db13','ripkiardian@gmail.com','41','2026-02-05 08:47:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1844','36.83.124.37','adminsuper@gmail.com','1','2026-02-05 08:54:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1845','2404:c0:2f10::1462:4e8c','nisa@gmail.com','57','2026-02-05 09:22:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1846','202.46.68.41','anihgindalistiani@gmail.com','21','2026-02-05 09:45:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1847','2404:c0:2a10::171c:3143','sitipatimah@gmail.com','12','2026-02-05 10:02:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1848','2404:c0:2a10::1719:1cd8','wulanpurnamasari@gmail.com','43','2026-02-05 10:05:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1849','2404:c0:2d10::146d:d4af','weniwidaningrum@gmail.com','14','2026-02-05 10:09:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1850','114.122.108.218','anggagunawan@gmail.com','45','2026-02-05 10:56:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1851','36.83.124.37','yuyunyunaningsih@gmail.com','29','2026-02-05 10:57:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1852','202.46.68.41','adeirfannugraha@gmail.com','35','2026-02-05 11:17:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1853','2404:c0:2b10::1726:9338','muhtarsidik@gmail.com','55','2026-02-05 11:34:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1854','114.122.109.212','elsaandriani@gmail.com','46','2026-02-05 11:41:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1855','114.122.103.61','yosisitirosita@gmail.com','38','2026-02-05 11:46:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1856','2404:c0:2a10::1731:e1fa','nanangnajamudin@gmail.com','36','2026-02-05 11:53:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1857','114.122.109.86','dewi@gmail.com','16','2026-02-05 11:55:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1858','2404:c0:2d10::145a:d471','syfaulhusna@gmail.com','58','2026-02-05 11:55:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1859','36.83.124.37','galihwangi@gmail.com','49','2026-02-05 12:19:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1860','114.122.75.150','sriastutisyam@gmail.com','28','2026-02-05 12:21:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1861','2404:c0:2910::171c:80b7','noviestephen@gmail.com','24','2026-02-05 12:32:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1862','2404:c0:2910::171c:80b7','noviestephen@gmail.com','24','2026-02-05 12:32:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1863','2404:c0:2a10::1719:1cd8','wulanpurnamasari@gmail.com','43','2026-02-05 12:33:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1864','114.122.101.182','yusmansetiawan@gmail.com','20','2026-02-05 12:47:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1865','2404:c0:2c10::147c:904f','yuliagustiani@gmail.com','23','2026-02-05 13:29:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1866','36.83.124.37','adminsuper@gmail.com','1','2026-02-05 13:37:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1867','114.122.79.172','neneng@gmail.com','19','2026-02-05 13:39:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1868','114.122.108.248','rentydwiyanti@gmail.com','56','2026-02-05 13:40:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1869','114.122.108.248','rentydwiyanti@gmail.com','56','2026-02-05 13:40:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1870','2404:c0:2d10::1470:6393','novitaandriani@gmail.com','51','2026-02-05 13:42:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1871','2404:c0:2810::cf6:d31f','ritanurfatimah@gmail.com','31','2026-02-05 13:42:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1872','2404:c0:2810::cf6:d31f','ritanurfatimah@gmail.com','31','2026-02-05 13:42:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1873','114.122.115.46','haniherlina@gmail.com','40','2026-02-05 13:42:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1874','114.122.117.213','sitimunawaroh@gmail.com','47','2026-02-05 13:42:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1875','114.122.108.245','henririsnandar@gmail.com','34','2026-02-05 13:43:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1876','2404:c0:2c10::1485:6c53','rdsusimurti@gmail.com','54','2026-02-05 13:44:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1877','2404:c0:2f10::145c:7698','susilawati@gmail.com','60','2026-02-05 13:45:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1878','2404:c0:2c10::1477:71e3','evitinisukartini@gmail.com','18','2026-02-05 13:46:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1879','2404:c0:2d10::1453:a07a','muchtarsidiq@gmail.com','22','2026-02-05 13:47:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1880','2404:c0:2c10::146c:efc1','yuyunyunaningsih@gmail.com','29','2026-02-05 14:02:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1881','2404:c0:2910::170d:16c5','irmannurhendra@gmail.com','26','2026-02-05 14:07:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1882','2404:c0:2f10::1458:78d3','tiaiqbalhembara@gmail.com','61','2026-02-05 14:31:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1883','114.122.70.16','anihgindalistiani@gmail.com','21','2026-02-05 14:48:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1884','2404:c0:2f10::1468:1c3','dinanursolihat@gmail.com','62','2026-02-05 15:20:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1885','202.46.68.71','guru',NULL,'2026-02-05 16:05:57','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1886','202.46.68.71','guru@gmail.com','4','2026-02-05 16:06:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1887','103.188.169.69','susilawati@gmail.com','60','2026-02-05 16:10:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1888','36.81.233.19','sitipatimah@gmail.com','12','2026-02-05 16:11:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1889','103.188.169.69','dihankuclak@gmail.com',NULL,'2026-02-05 16:50:57','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1890','103.188.169.69','1111',NULL,'2026-02-05 16:51:13','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1891','103.188.169.69','1',NULL,'2026-02-05 16:51:22','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1892','103.188.169.69','sman1cikatomas',NULL,'2026-02-05 16:53:14','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1893','103.188.169.69','dina',NULL,'2026-02-05 16:53:26','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1894','103.188.169.69','Dina',NULL,'2026-02-05 16:53:36','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1895','36.83.124.37','ojatdarojat@gmail.com','76','2026-02-05 17:12:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1896','2404:c0:2d10::148d:3fad','ojatdarojat@gmail.com','76','2026-02-05 17:14:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1897','2404:c0:2f10::1483:5260','henririsnandar@gmail.com','34','2026-02-05 17:23:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1898','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-05 17:44:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1899','114.122.85.44','galihwangi@gmail.com','49','2026-02-05 17:50:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1900','114.122.85.44','galihwangi@gmail.com','49','2026-02-05 17:50:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1901','180.245.116.227','acepantonfajar@gmail.com','63','2026-02-05 17:55:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1902','2404:c0:2c10::1493:fe','noviestephen@gmail.com','24','2026-02-05 17:57:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1903','2404:c0:2810::cf9:73e','elsaandriani@gmail.com','46','2026-02-05 18:29:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1904','2404:c0:2e10::1470:56a6','weniwidaningrum@gmail.com','14','2026-02-05 18:30:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1905','202.46.68.71','guru@gmail.com','4','2026-02-05 18:36:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1906','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-05 18:39:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1907','103.166.159.217','pupuypuadah@gmail.com','59','2026-02-05 18:54:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1908','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-05 19:33:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1909','103.188.169.69','ranianggraeni@gmail.com','65','2026-02-05 19:47:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1910','114.122.68.34','muhtargojali@gmail.com','27','2026-02-05 20:17:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1911','180.249.236.164','agustomi@gmail.com','33','2026-02-05 22:48:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1912','103.188.169.69','adminsuper@gmail.com','1','2026-02-06 01:26:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1913','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-06 05:09:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1914','36.81.233.19','sitipatimah@gmail.com','12','2026-02-06 05:32:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1915','2404:c0:2d10::14b2:72c4','acepantonfajar@gmail.com','63','2026-02-06 05:32:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1916','2404:c0:2810::d28:7214','ojatdarojat@gmail.com','76','2026-02-06 05:49:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1917','2404:c0:2b10::1768:2d9c','ekasantikalestari@gmail.com','50','2026-02-06 06:07:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1918','2404:c0:2d10::14b7:ab96','yuliagustiani@gmail.com','23','2026-02-06 06:09:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1919','114.122.117.174','ikanurhasanah@gmail.com','32','2026-02-06 06:10:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1920','2404:c0:2d10::14b0:e50c','yuyunyunaningsih@gmail.com','29','2026-02-06 06:10:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1921','114.122.105.53','neneng@gmail.com','19','2026-02-06 06:11:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1922','2404:c0:2d10::14b3:e460','syfaulhusna@gmail.com','58','2026-02-06 06:12:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1923','114.122.117.174','ikanurhasanah@gmail.com','32','2026-02-06 06:13:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1924','2404:c0:2d10::14ad:e8c5','neneng@gmail.com','19','2026-02-06 06:14:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1925','114.122.117.124','enokmira@gmail.com','66','2026-02-06 06:14:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1926','103.188.169.69','adminsuper@gmail.com','1','2026-02-06 06:17:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1927','103.188.169.69','asepcandra@gmail.com','37','2026-02-06 06:17:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1928','114.122.117.174','ikanurhasanah@gmail.com','32','2026-02-06 06:19:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1929','114.122.101.200','gilangsepteranurhendra@gmail.com','44','2026-02-06 06:19:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1930','2404:c0:2e10::14b5:4894','yuliagustiani@gmail.com','23','2026-02-06 06:20:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1931','2404:c0:2f10::1499:3308','rdsusimurti@gmail.com','54','2026-02-06 06:20:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1932','2404:c0:2810::d41:87ad','ekasantikalestari@gmail.com','50','2026-02-06 06:20:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1933','2404:c0:2e10::14a7:b434','emmysitimariyam@gmail.com','25','2026-02-06 06:22:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1934','103.188.169.69','asepcandra@gmail.com','37','2026-02-06 06:24:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1935','114.122.69.173','yusmansetiawan@gmail.com','20','2026-02-06 06:25:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1936','36.83.124.37','henririsnandar@gmail.com','34','2026-02-06 06:26:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1937','2404:c0:2f10::14b9:2b58','susilawati@gmail.com','60','2026-02-06 06:39:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1938','2404:c0:2e10::14b8:f97b','elsaandriani@gmail.com','46','2026-02-06 06:49:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1939','36.83.124.37','yosisitirosita@gmail.com','38','2026-02-06 06:50:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1940','2404:c0:2a10::1772:b9ee','dinanursolihat@gmail.com','62','2026-02-06 06:51:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1941','2404:c0:2810::d45:c32d','irmannurhendra@gmail.com','26','2026-02-06 06:51:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1942','2404:c0:2910::176f:64fb','muhtarsidik@gmail.com','55','2026-02-06 06:52:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1943','2404:c0:2810::d3c:9055','nisa@gmail.com','57','2026-02-06 06:56:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1944','2404:c0:2810::d3c:9055','nisa@gmail.com','57','2026-02-06 06:56:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1945','2404:c0:2a10::1768:434e','pupuypuadah@gmail.com','59','2026-02-06 06:59:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1946','114.122.84.36','galihwangi@gmail.com','49','2026-02-06 06:59:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1947','114.122.84.36','galihwangi@gmail.com','49','2026-02-06 06:59:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1948','2404:c0:2e10::14b1:bce8','evitinisukartini@gmail.com','18','2026-02-06 07:06:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1949','114.122.75.25','asepcandra@gmail.com','37','2026-02-06 07:07:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1950','114.122.75.150','sriastutisyam@gmail.com','28','2026-02-06 07:12:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1951','2404:c0:2f10::14ba:9739','noviestephen@gmail.com','24','2026-02-06 07:15:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1952','2404:c0:2e10::14bb:f399','rentydwiyanti@gmail.com','56','2026-02-06 07:16:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1953','2404:c0:2e10::14bb:f399','rentydwiyanti@gmail.com','56','2026-02-06 07:16:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1954','2404:c0:2e10::14bb:f399','rentydwiyanti@gmail.com','56','2026-02-06 07:16:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1955','36.83.124.37','anggagunawan@gmail.com','45','2026-02-06 07:20:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1956','2404:c0:2d10::149a:a8b','novitaandriani@gmail.com','51','2026-02-06 07:27:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1957','2404:c0:2d10::149a:a8b','novitaandriani@gmail.com','51','2026-02-06 07:27:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1958','2404:c0:2d10::149a:a8b','novitaandriani@gmail.com','51','2026-02-06 07:27:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1959','2404:c0:2d10::149a:a8b','novitaandriani@gmail.com','51','2026-02-06 07:27:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1960','2404:c0:2910::1767:bda8','weniwidaningrum@gmail.com','14','2026-02-06 07:30:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1961','114.122.70.65','haniherlina@gmail.com','40','2026-02-06 07:30:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1962','114.122.76.241','wulanpurnamasari@gmail.com','43','2026-02-06 07:37:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1963','2404:c0:2a10::176d:b895','ripkiardian@gmail.com','41','2026-02-06 07:39:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1964','103.188.169.69','asepcandra@gmail.com','37','2026-02-06 08:00:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1965','114.122.73.214','yusmansetiawan@gmail.com','20','2026-02-06 08:00:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1966','114.122.116.22','adeirfannugraha@gmail.com','35','2026-02-06 08:02:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1967','114.122.68.74','anihgindalistiani@gmail.com','21','2026-02-06 08:02:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1968','2404:c0:2d10::14b0:e50c','yuyunyunaningsih@gmail.com','29','2026-02-06 08:02:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1969','103.188.169.69','adminsuper@gmail.com','1','2026-02-06 08:04:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1970','103.188.169.69','asepcandra@gmail.com','37','2026-02-06 08:06:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1971','103.188.169.69','asepcandra@gmail.com','37','2026-02-06 08:08:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1972','2404:c0:2c10::14c5:ba73','dinanursolihat@gmail.com','62','2026-02-06 08:22:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1973','2404:c0:2910::176f:64fb','muhtarsidik@gmail.com','55','2026-02-06 08:24:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1974','114.122.115.80','dewi@gmail.com','16','2026-02-06 08:32:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1975','114.122.84.36','galihwangi@gmail.com','49','2026-02-06 08:37:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1976','114.122.75.150','sriastutisyam@gmail.com','28','2026-02-06 08:44:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1977','36.83.124.37','adminsuper@gmail.com','1','2026-02-06 08:46:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1978','36.83.124.37','asepcandra@gmail.com','37','2026-02-06 08:49:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1979','2404:c0:2910::1767:bda8','weniwidaningrum@gmail.com','14','2026-02-06 08:50:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1980','36.83.124.37','adminsuper@gmail.com','1','2026-02-06 08:51:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1981','2404:c0:2910::1781:56ef','nisa@gmail.com','57','2026-02-06 08:55:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1982','2404:c0:2910::1781:56ef','nisa@gmail.com','57','2026-02-06 08:55:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1983','114.122.73.58','ujenahmad@gmail.com','17','2026-02-06 09:09:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1984','2404:c0:2e10::14b6:f9d9','tiaiqbalhembara@gmail.com','61','2026-02-06 09:10:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1985','114.122.115.62','muhtargojali@gmail.com','27','2026-02-06 09:14:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1986','2404:c0:2c10::14bc:d2ed','rentydwiyanti@gmail.com','56','2026-02-06 09:54:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1987','2404:c0:2c10::14bc:d2ed','rentydwiyanti@gmail.com','56','2026-02-06 09:54:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1988','114.122.74.138','agustomi@gmail.com','33','2026-02-06 10:07:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1989','114.122.74.251','nanangnajamudin@gmail.com','36','2026-02-06 10:18:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1990','2404:c0:2b10::177c:f7a2','nanangnajamudin@gmail.com','36','2026-02-06 10:18:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1991','2404:c0:2b10::1768:2d9c','ekasantikalestari@gmail.com','50','2026-02-06 10:32:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1992','2404:c0:2e10::14b6:f9d9','tiaiqbalhembara@gmail.com','61','2026-02-06 11:16:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1993','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-06 13:46:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1994','2404:c0:2810::d67:a3ad','nanangnajamudin@gmail.com','36','2026-02-06 15:25:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1995','2404:c0:2810::d67:a3ad','nanangnajamudin@gmail.com','36','2026-02-06 15:25:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1996','114.122.105.15','anggagunawan@gmail.com','45','2026-02-06 15:41:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1997','103.183.57.3','elsaandriani@gmail.com','46','2026-02-06 16:24:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1998','103.183.57.3','elsaandriani@gmail.com','46','2026-02-06 16:24:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('1999','36.83.124.37','adminsuper@gmail.com','1','2026-02-06 17:02:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2000','103.186.204.55','yuyunyunaningsih@gmail.com','29','2026-02-06 19:00:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2001','103.188.169.69','adminsuper@gmail.com','1','2026-02-06 19:37:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2002','2404:c0:2810::d60:95a','henririsnandar@gmail.com','34','2026-02-06 21:09:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2003','114.122.78.147','adeirfannugraha@gmail.com','35','2026-02-06 22:26:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2004','114.122.78.147','guru@gmail.com','4','2026-02-06 22:26:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2005','103.186.204.55','yuyunyunaningsih@gmail.com','29','2026-02-07 05:37:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2006','103.188.169.69','adminsuper@gmail.com','1','2026-02-07 17:36:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2007','103.186.204.55','yuyunyunaningsih@gmail.com','29','2026-02-07 20:52:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2008','2404:c0:2c10::1557:73fa','yuyunyunaningsih@gmail.com','29','2026-02-08 05:05:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2009','103.186.204.55','yuyunyunaningsih@gmail.com','29','2026-02-08 08:19:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2010','103.188.169.69','adminsuper@gmail.com','1','2026-02-08 10:10:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2011','2404:c0:2d10::1575:55ac','novitaandriani@gmail.com','51','2026-02-08 13:02:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2012','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-08 16:05:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2013','103.186.204.55','yuyunyunaningsih@gmail.com','29','2026-02-08 18:10:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2014','103.188.169.69','adminsuper@gmail.com','1','2026-02-08 18:19:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2015','103.188.169.69','admin',NULL,'2026-02-08 18:19:51','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2016','103.188.169.69','admin@gmail.com','3','2026-02-08 18:20:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2017','103.188.169.69','adminsuper@gmail.com','1','2026-02-08 23:54:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2018','103.188.169.69','adminsuper@gmail.com','1','2026-02-09 01:35:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2019','103.186.204.55','yuyunyunaningsih@gmail.com','29','2026-02-09 04:34:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2020','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-09 04:51:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2021','202.46.68.71','siswa@gmail.com','5','2026-02-09 05:33:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2022','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-09 05:42:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2023','202.46.68.71','superadmin',NULL,'2026-02-09 05:54:21','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2024','202.46.68.71','admin@gmail.com','3','2026-02-09 05:54:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2025','2404:c0:2f10::15ad:f8e7','ekasantikalestari@gmail.com','50','2026-02-09 06:16:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2026','114.122.110.44','adeirfannugraha@gmail.com','35','2026-02-09 06:17:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2027','114.122.110.44','guru',NULL,'2026-02-09 06:17:51','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2028','114.122.110.44','guru@gmail.com','4','2026-02-09 06:18:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2029','2404:c0:2f10::15b4:cc1d','ojatdarojat@gmail.com','76','2026-02-09 06:20:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2030','2404:c0:2d10::15bb:2a8a','evitinisukartini@gmail.com','18','2026-02-09 06:21:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2031','2404:c0:2f10::15b7:538f','linlinpermatapraja@gmail.com','67','2026-02-09 06:22:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2032','2404:c0:2f10::15b2:d157','ikasartika@gmail.com','13','2026-02-09 06:24:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2033','2404:c0:2b10::1887:c286','pupuypuadah@gmail.com','59','2026-02-09 06:26:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2034','2404:c0:2e10::15b5:b66e','henririsnandar@gmail.com','34','2026-02-09 06:27:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2035','2404:c0:2810::e58:686d','tiaiqbalhembara@gmail.com','61','2026-02-09 06:29:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2036','114.122.82.240','ujenahmad@gmail.com','17','2026-02-09 06:32:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2037','2404:c0:2910::1899:ad5a','sitipatimah@gmail.com','12','2026-02-09 06:34:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2038','2404:c0:2e10::15ba:5dc0','nisa@gmail.com','57','2026-02-09 06:35:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2039','114.122.73.222','galihwangi@gmail.com','49','2026-02-09 06:35:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2040','114.122.73.222','galihwangi@gmail.com','49','2026-02-09 06:35:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2041','2404:c0:2a10::1897:d9ba','muhtarsidik@gmail.com','55','2026-02-09 06:36:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2042','2404:c0:2a10::1898:3ecf','susilawati@gmail.com','60','2026-02-09 06:37:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2043','114.122.74.244','anggagunawan@gmail.com','45','2026-02-09 06:38:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2044','2404:c0:2a10::188b:4260','emmysitimariyam@gmail.com','25','2026-02-09 06:39:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2045','2404:c0:2a10::188b:4260','emmysitimariyam@gmail.com','25','2026-02-09 06:39:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2046','2404:c0:2b10::189d:4928','elsaandriani@gmail.com','46','2026-02-09 06:40:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2047','2404:c0:2f10::15bb:e64','dinanursolihat@gmail.com','62','2026-02-09 06:47:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2048','2404:c0:6a1f:a94d:4b3:16ff:fe75:bf8e','nanangnajamudin@gmail.com','36','2026-02-09 06:48:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2049','114.122.100.106','sriastutisyam@gmail.com','28','2026-02-09 06:51:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2050','103.188.169.69','asepcandra@gmail.com','37','2026-02-09 06:52:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2051','103.188.169.69','adminsuper@gmail.com','1','2026-02-09 06:53:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2052','2404:c0:2a10::1886:f7d3','yuliagustiani@gmail.com','23','2026-02-09 07:20:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2053','103.188.169.69','adminsuper@gmail.com','1','2026-02-09 07:25:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2054','114.122.72.93','yusmansetiawan',NULL,'2026-02-09 07:28:01','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2055','114.122.72.93','yusmansetiawan@gmail.com','20','2026-02-09 07:28:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2056','114.122.73.250','anihgindalistiani@gmail.com','21','2026-02-09 07:34:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2057','2404:c0:2c10::15b1:9930','noviestephen@gmail.com','24','2026-02-09 07:44:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2058','2404:c0:2c10::15b1:9930','noviestephen@gmail.com','24','2026-02-09 07:44:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2059','114.122.100.76','asepcandra@gmail.com','37','2026-02-09 07:52:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2060','2404:c0:2b10::186e:a9b6','irmannurhendra@gmail.com','26','2026-02-09 08:07:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2061','36.83.124.37','adeirfannugraha@gmail.com','35','2026-02-09 08:12:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2062','114.122.84.161','muhtargojali@gmail.com','27','2026-02-09 08:13:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2063','114.122.84.161','muhtargojali@gmail.com','27','2026-02-09 08:14:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2064','114.122.117.165','dewi@gmail.com','16','2026-02-09 08:20:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2065','114.122.85.176','mohammadsuhardiwan@gmail.com','10','2026-02-09 08:35:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2066','36.83.124.37','asepcandra@gmail.com','37','2026-02-09 09:11:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2067','36.83.124.37','yuyunyunaningsih@gmail.com','29','2026-02-09 09:20:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2068','114.122.107.161','guru@gmail.com','4','2026-02-09 09:27:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2069','114.122.108.224','agustomi@gmail.com','33','2026-02-09 10:03:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2070','2404:c0:2810::e52:a1a2','yosisitirosita@gmail.com','38','2026-02-09 10:32:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2071','36.83.124.37','rentydwiyanti@gmail.com','56','2026-02-09 10:41:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2072','2404:c0:2b10::1886:c2d3','tiaiqbalhembara@gmail.com','61','2026-02-09 11:00:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2073','2404:c0:2e10::15d3:70b8','elsaandriani@gmail.com','46','2026-02-09 11:02:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2074','2404:c0:2810::e6a:22b7','evitinisukartini@gmail.com','18','2026-02-09 11:07:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2075','2404:c0:2810::e6a:22b7','evitinisukartini@gmail.com','18','2026-02-09 11:07:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2076','36.83.124.37','henririsnandar@gmail.com','34','2026-02-09 11:47:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2077','2404:c0:2e10::15c1:bbbe','ojatdarojat@gmail.com','76','2026-02-09 12:00:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2078','2404:c0:2c10::15ca:be2f','pupuypuadah@gmail.com','59','2026-02-09 12:05:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2079','2404:c0:2c10::15c0:45bb','nisa@gmail.com','57','2026-02-09 12:08:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2080','2404:c0:2c10::15c0:45bb','nisa@gmail.com','57','2026-02-09 12:08:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2081','36.83.124.37','susilawati@gmail.com','60','2026-02-09 12:20:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2082','2404:c0:2f10::15b2:d157','ikasartika@gmail.com','13','2026-02-09 12:30:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2083','36.83.124.37','yuyunyunaningsih@gmail.com','29','2026-02-09 12:32:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2084','2404:c0:2f10::15cc:17b1','linlinpermatapraja@gmail.com','67','2026-02-09 12:37:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2085','114.122.117.163','anggagunawan@gmail.com','45','2026-02-09 12:38:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2086','2404:c0:2810::e6e:184','emmysitimariyam@gmail.com','25','2026-02-09 12:42:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2087','2404:c0:2810::e6e:184','emmysitimariyam@gmail.com','25','2026-02-09 12:42:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2088','2404:c0:2f10::15b0:7b98','syfaulhusna@gmail.com','58','2026-02-09 12:51:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2089','114.122.108.224','agustomi@gmail.com','33','2026-02-09 13:01:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2090','114.122.83.210','galihwangi@gmail.com','49','2026-02-09 13:12:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2091','2404:c0:2f10::15ca:d438','ritanurfatimah@gmail.com','31','2026-02-09 13:13:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2092','2404:c0:2810::e73:4d87','yosisitirosita@gmail.com','38','2026-02-09 13:17:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2093','36.83.124.37','muchtarsidiq@gmail.com','22','2026-02-09 13:26:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2094','36.83.124.37','asepcandra@gmail.com','37','2026-02-09 13:27:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2095','2404:c0:2c10::15b3:5b89','ranianggraeni@gmail.com','65','2026-02-09 13:31:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2096','2404:c0:2c10::15b3:5b89','ranianggraeni@gmail.com',NULL,'2026-02-09 13:32:26','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2097','2404:c0:2c10::15b3:5b89','ranianggraeni@gmail.com','65','2026-02-09 13:32:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2098','36.83.124.37','asepcandra@gmail.com','37','2026-02-09 13:33:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2099','36.83.124.37','admin@gmail.com','3','2026-02-09 13:34:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2100','114.122.84.198','dewi@gmail.com','16','2026-02-09 13:34:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2101','36.83.124.37','adminsuper@gmail.com','1','2026-02-09 13:36:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2102','2404:c0:2a10::18ab:ec50','dinanursolihat@gmail.com','62','2026-02-09 13:42:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2103','114.122.73.102','anihgindalistiani@gmail.com','21','2026-02-09 13:51:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2104','114.122.104.16','adeirfannugraha@gmail.com','35','2026-02-09 13:52:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2105','114.122.74.228','enokmira@gmail.com','66','2026-02-09 13:57:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2106','2404:c0:2a10::18b1:5d06','sitipatimah@gmail.com','12','2026-02-09 14:04:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2107','2404:c0:2a10::18b1:5d06','sitipatimah@gmail.com','12','2026-02-09 14:04:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2108','114.122.104.240','ujenahmad@gmail.com','17','2026-02-09 14:07:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2109','114.122.76.95','gilangsepteranurhendra@gmail.com','44','2026-02-09 14:08:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2110','2404:c0:2e10::15cb:1d75','rdsusimurti@gmail.com','54','2026-02-09 14:19:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2111','2404:c0:2e10::15cb:1d75','rdsusimurti@gmail.com','54','2026-02-09 14:19:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2112','2404:c0:2810::e59:4700','wulanpurnamasari@gmail.com','43','2026-02-09 14:23:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2113','2404:c0:2f10::15d0:e1ed','noviestephen@gmail.com','24','2026-02-09 14:23:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2114','114.122.102.207','muhtargojali@gmail.com','27','2026-02-09 14:29:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2115','114.122.68.82','mohammadsuhardiwan@gmail.com','10','2026-02-09 14:30:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2116','2404:c0:2e10::15d3:70b8','elsaandriani@gmail.com','46','2026-02-09 14:30:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2117','2404:c0:2d10::15ae:10ac','acepantonfajar@gmail.com','63','2026-02-09 14:31:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2118','2404:c0:2f10::15d6:4ce5','jonihprasetia@gmail.com','53','2026-02-09 14:31:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2119','2404:c0:2f10::15b9:d8f9','muchtarsidiq@gmail.com','22','2026-02-09 14:35:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2120','2404:c0:2910::18b3:f8c2','firmanmuharam@gmail.com','64','2026-02-09 14:36:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2121','2404:c0:2910::18b3:f8c2','firmanmuharam@gmail.com','64','2026-02-09 14:37:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2122','2404:c0:2910::18b3:f8c2','firmanmuharam@gmail.com','64','2026-02-09 14:37:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2123','2404:c0:2e10::15ce:22ab','novitaandriani@gmail.com','51','2026-02-09 14:41:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2124','2404:c0:2e10::15ce:22ab','novitaandriani@gmail.com','51','2026-02-09 14:41:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2125','36.83.124.37','muhtarsidik@gmail.com','55','2026-02-09 14:44:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2126','2404:c0:2a10::18b2:7499','nanangnajamudin@gmail.com','36','2026-02-09 14:47:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2127','114.122.78.52','haniherlina@gmail.com','40','2026-02-09 15:01:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2128','114.122.108.224','agustomi@gmail.com','33','2026-02-09 17:09:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2129','103.188.169.69','susilawati@gmail.com','60','2026-02-09 18:46:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2130','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-09 19:54:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2131','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-09 20:33:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2132','202.46.68.71','siswa@gmail.com','5','2026-02-09 20:42:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2133','202.46.68.71','guru@gmail.com','4','2026-02-09 20:42:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2134','103.188.169.69','adminsuper@gmail.com','1','2026-02-10 04:32:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2135','103.188.169.69','asepcandra@gmail.com','37','2026-02-10 04:44:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2136','2404:c0:2c10::15ff:2b67','acepantonfajar@gmail.com','63','2026-02-10 05:34:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2137','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-10 05:40:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2138','103.188.169.69','asepcandra@gmail.com','37','2026-02-10 05:50:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2139','103.188.169.69','susilawati@gmail.com','60','2026-02-10 05:56:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2140','103.188.169.153','dinanursolihat@gmail.com','62','2026-02-10 06:02:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2141','2404:c0:2d10::160d:ea95','ojatdarojat@gmail.com','76','2026-02-10 06:08:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2142','2404:c0:2d10::1604:473b','ojatdarojat@gmail.com','76','2026-02-10 06:11:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2143','2404:c0:2d10::1604:473b','ojatdarojat@gmail.com','76','2026-02-10 06:11:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2144','103.188.169.69','admin@gmail.com','3','2026-02-10 06:12:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2145','2404:c0:2a10::18df:5eca','syfaulhusna@gmail.com','58','2026-02-10 06:15:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2146','114.122.76.131','haniherlina@gmail.com','40','2026-02-10 06:16:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2147','2404:c0:2b10::18ed:31d0','elsaandriani@gmail.com','46','2026-02-10 06:16:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2148','2404:c0:2f10::160a:1311','noviestephen@gmail.com','24','2026-02-10 06:24:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2149','2404:c0:2f10::160a:1311','noviestephen@gmail.com','24','2026-02-10 06:24:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2150','202.46.68.1','muhtarsidik@gmail.com','55','2026-02-10 06:30:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2151','2404:c0:2f10::1610:5e1f','wulanpurnamasari',NULL,'2026-02-10 06:31:43','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2152','2404:c0:2f10::1610:5e1f','wulanpurnamasari@gmail.com','43','2026-02-10 06:32:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2153','2404:c0:2d10::160a:cd0','irmannurhendra@gmail.com','26','2026-02-10 06:32:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2154','114.122.104.6','adeirfannugraha@gmail.com','35','2026-02-10 06:33:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2155','114.122.68.90','asepcandra@gmail.com','37','2026-02-10 06:34:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2156','114.122.104.6','guru@gmail.com','4','2026-02-10 06:35:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2157','2404:c0:2d10::15ec:e79c','detirosmawati@gmail.com','42','2026-02-10 06:39:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2158','36.83.124.37','evitinisukartini@gmail.com','18','2026-02-10 06:42:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2159','114.122.107.181','agustomi@gmail.com','33','2026-02-10 06:46:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2160','36.83.124.37','nanangnajamudin@gmail.com','36','2026-02-10 06:46:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2161','36.83.124.37','nanangnajamudin@gmail.com','36','2026-02-10 06:46:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2162','36.83.124.37','nanangnajamudin@gmail.com','36','2026-02-10 06:46:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2163','114.122.115.226','sriastutisyam@gmail.com','28','2026-02-10 06:48:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2164','114.122.106.50','dewi@gmail.com','16','2026-02-10 06:50:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2165','2404:c0:2b10::1900:ed74','andiciptanugraha@gmail.com','15','2026-02-10 06:50:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2166','114.122.68.42','galihwangi@gmail.com','49','2026-02-10 06:51:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2167','2404:c0:2b10::18ef:6dda','agismujiprayitno@gmail.com','30','2026-02-10 06:52:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2168','2404:c0:2b10::18ec:6d82','henririsnandar@gmail.com','34','2026-02-10 06:56:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2169','36.83.124.37','ripkiardian@gmail.com','41','2026-02-10 06:59:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2170','2404:c0:2d10::15fd:cd00','tiaiqbalhembara@gmail.com','61','2026-02-10 06:59:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2171','114.122.69.17','ujenahmad@gmail.com','17','2026-02-10 07:03:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2172','2404:c0:2e10::1607:5bf0','l',NULL,'2026-02-10 07:05:19','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2173','2404:c0:2e10::1607:5bf0','emmysitimariyam@gmail.com','25','2026-02-10 07:05:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2174','2404:c0:2b10::18ea:9a42','yuyunyunaningsih@gmail.com','29','2026-02-10 07:05:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2175','2404:c0:2c10::15f6:dfbf','yuliagustiani@gmail.com','23','2026-02-10 07:06:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2176','114.122.107.243','enokmira@gmail.com','66','2026-02-10 07:06:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2177','114.122.115.234','adeirfannugraha@gmail.com','35','2026-02-10 07:07:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2178','114.122.74.65','yosisitirosita@gmail.com','38','2026-02-10 07:07:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2179','114.122.103.181','yusmansetiawan@gmail.com','20','2026-02-10 07:32:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2180','2404:c0:2f10::1609:4b96','pupuypuadah@gmail.com','59','2026-02-10 07:45:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2181','114.122.77.247','muhtargojali@gmail.com','27','2026-02-10 07:54:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2182','114.122.109.152','anggagunawan@gmail.com','45','2026-02-10 08:15:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2183','2404:c0:2a10::18f3:e135','sitipatimah@gmail.com','12','2026-02-10 08:27:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2184','2404:c0:2c10::15f6:51fe','ikasartika@gmail.com','13','2026-02-10 08:36:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2185','2404:c0:2910::1902:a2cc','linlinpermatapraja@gmail.com','67','2026-02-10 08:38:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2186','36.83.124.37','admin@gmail.com','3','2026-02-10 08:48:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2187','2404:c0:2d10::15fd:cd00','tiaiqbalhembara@gmail.com','61','2026-02-10 09:09:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2188','114.122.107.134','gilangsepteranurhendra@gmail.com','44','2026-02-10 09:35:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2189','114.122.107.185','agustomi@gmail.com','33','2026-02-10 10:23:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2190','114.122.106.250','anihgindalistiani@gmail.com','21','2026-02-10 10:52:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2191','114.122.68.90','asepcandra@gmail.com','37','2026-02-10 11:57:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2192','202.46.68.71','guru@gmail.com','4','2026-02-10 12:03:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2193','36.83.124.37','rentydwiyanti@gmail.com','56','2026-02-10 12:04:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2194','2404:c0:2810::edb:85ad','detirosmawati@gmail.com','42','2026-02-10 12:04:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2195','2404:c0:2c10::161a:d7dd','yuliagustiani@gmail.com','23','2026-02-10 12:17:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2196','2404:c0:2c10::161a:d7dd','yuliagustiani@gmail.com','23','2026-02-10 12:17:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2197','114.122.82.89','galihwangi@gmail.com','49','2026-02-10 12:17:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2198','2404:c0:2810::ec6:3459','elsaandriani@gmail.com','46','2026-02-10 12:19:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2199','36.83.124.37','yuyunyunaningsih@gmail.com','29','2026-02-10 12:29:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2200','114.122.107.2','dewi@gmail.com','16','2026-02-10 12:34:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2201','2404:c0:2c10::15ff:2b67','acepantonfajar@gmail.com','63','2026-02-10 12:42:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2202','2404:c0:2c10::1619:afb6','sitipatimah@gmail.com','12','2026-02-10 12:44:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2203','2404:c0:2d10::1604:de4','evitinisukartini@gmail.com','18','2026-02-10 12:46:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2204','2404:c0:2e10::1628:ca77','ritanurfatimah@gmail.com','31','2026-02-10 12:56:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2205','36.83.124.37','susilawati@gmail.com','60','2026-02-10 13:04:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2206','114.122.107.2','evitinisukartini@gmail.com','18','2026-02-10 13:05:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2207','36.83.124.37','anggagunawan@gmail.com','45','2026-02-10 13:09:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2208','114.122.116.142','gilangsepteranurhendra@gmail.com','44','2026-02-10 13:10:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2209','114.122.115.226','sriastutisyam@gmail.com','28','2026-02-10 13:13:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2210','2404:c0:2f10::1621:299c','noviestephen@gmail.com','24','2026-02-10 13:13:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2211','2404:c0:2f10::1621:299c','noviestephen@gmail.com','24','2026-02-10 13:13:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2212','2404:c0:2f10::1619:bb9b','emmysitimariyam@gmail.com','25','2026-02-10 13:19:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2213','36.83.124.37','henririsnandar@gmail.com','34','2026-02-10 14:10:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2214','2404:c0:2e10::1605:15f8','tiaiqbalhembara@gmail.com','61','2026-02-10 14:11:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2215','2404:c0:2e10::1605:15f8','tiaiqbalhembara@gmail.com','61','2026-02-10 14:11:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2216','2404:c0:2a10::1921:ff99','dinanursolihat@gmail.com','62','2026-02-10 14:27:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2217','2404:c0:2b10::1916:d890','nisa@gmail.com','57','2026-02-10 14:30:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2218','2404:c0:2e10::1626:ef84','ripkiardian@gmail.com','41','2026-02-10 14:31:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2219','2404:c0:2f10::161a:bdf2','irmannurhendra@gmail.com','26','2026-02-10 14:31:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2220','114.122.76.186','haniherlina@gmail.com','40','2026-02-10 14:31:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2221','77.111.244.76','andrinugraha@gmail.com','52','2026-02-10 14:33:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2222','2404:c0:2f10::1628:9894','yosisitirosita@gmail.com','38','2026-02-10 14:35:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2223','114.122.116.254','anihgindalistiani@gmail.com','21','2026-02-10 14:39:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2224','2404:c0:2f10::1630:10bf','rdsusimurti@gmail.com','54','2026-02-10 14:41:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2225','114.122.100.199','yusmansetiawan@gmail.com','20','2026-02-10 14:42:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2226','2404:c0:2d10::1629:813d','andiciptanugraha@gmail.com','15','2026-02-10 14:44:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2227','36.83.124.37','ikanurhasanah@gmail.com','32','2026-02-10 15:02:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2228','36.83.124.37','yuyunyunaningsih@gmail.com','29','2026-02-10 16:50:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2229','103.186.204.55','yuyunyunaningsih@gmail.com','29','2026-02-10 17:22:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2230','103.166.159.217','pupuypuadah@gmail.com','59','2026-02-10 18:22:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2231','2404:c0:2910::1917:99c3','yuyunyunaningsih@gmail.com','29','2026-02-10 18:52:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2232','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-10 19:06:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2233','103.188.169.69','admin@gmail.com','3','2026-02-10 23:16:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2234','2404:c0:2910::1946:d92e','ojatdarojat@gmail.com','76','2026-02-11 06:07:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2235','2404:c0:2b10::1961:24f8','syfaulhusna@gmail.com','58','2026-02-11 06:11:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2236','114.122.68.93','galihwangi@gmail.com','49','2026-02-11 06:16:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2237','2404:c0:2c10::165b:c138','sitipatimah@gmail.com','12','2026-02-11 06:25:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2238','36.83.124.37','henririsnandar@gmail.com','34','2026-02-11 06:26:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2239','36.83.124.37','yuyunyunaningsih@gmail.com','29','2026-02-11 06:29:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2240','36.83.124.37','yuyunyunaningsih@gmail.com','29','2026-02-11 06:29:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2241','2404:c0:2910::1948:390b','muhtarsidik@gmail.com','55','2026-02-11 06:30:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2242','2404:c0:2810::f17:7e2f','emmysitimariyam@gmail.com','25','2026-02-11 06:30:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2243','36.83.124.37','evitinisukartini@gmail.com','18','2026-02-11 06:31:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2244','2404:c0:2e10::1657:ad92','agismujiprayitno@gmail.com','30','2026-02-11 06:33:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2245','114.122.84.195','haniherlina@gmail.com','40','2026-02-11 06:36:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2246','114.122.82.118','asepcandra@gmail.com','37','2026-02-11 06:37:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2247','114.122.103.233','sitimunawaroh@gmail.com','47','2026-02-11 06:38:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2248','2404:c0:2c10::1652:c56d','dinanursolihat@gmail.com','62','2026-02-11 06:40:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2249','114.122.104.2','sriastutisyam@gmail.com','28','2026-02-11 06:40:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2250','114.122.72.209','mohammadsuhardiwan@gmail.com','10','2026-02-11 06:40:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2251','2404:c0:2910::1944:93a0','elsaandriani@gmail.com','46','2026-02-11 06:41:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2252','2404:c0:2910::1944:93a0','elsaandriani@gmail.com','46','2026-02-11 06:41:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2253','114.122.102.24','ujenahmad@gmail.com','17','2026-02-11 06:42:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2254','2404:c0:2d10::164f:7db5','novitaandriani@gmail.com','51','2026-02-11 06:43:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2255','114.122.76.44','muhtargojali@gmail.com','27','2026-02-11 06:43:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2256','2404:c0:2c10::1656:73d2','noviestephen@gmail.com','24','2026-02-11 06:43:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2257','2404:c0:2c10::1656:73d2','noviestephen@gmail.com','24','2026-02-11 06:43:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2258','36.83.124.37','anggagunawan@gmail.com','45','2026-02-11 06:50:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2259','103.138.53.62','gilangsepteranurhendra@gmail.com','44','2026-02-11 06:58:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2260','36.83.124.37','nanangnajamudin@gmail.com','36','2026-02-11 06:59:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2261','2404:c0:2910::194d:bbc9','acepantonfajar@gmail.com','63','2026-02-11 07:00:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2262','36.83.124.37','dewi@gmail.com','16','2026-02-11 07:01:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2263','114.122.115.97','neneng@gmail.com','19','2026-02-11 07:02:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2264','2404:c0:2910::1952:c95e','yosisitirosita@gmail.com','38','2026-02-11 07:07:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2265','36.83.124.37','rentydwiyanti@gmail.com','56','2026-02-11 07:07:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2266','2404:c0:2d10::1659:4f75','pupuypuadah@gmail.com','59','2026-02-11 07:09:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2267','114.122.82.159','enokmira@gmail.com','66','2026-02-11 07:14:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2268','2404:c0:2a10::1946:1b81','ripkiardian@gmail.com','41','2026-02-11 07:15:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2269','36.77.26.79','irmannurhendra@gmail.com','26','2026-02-11 07:18:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2270','2404:c0:2910::1957:a3a3','nisa@gmail.com','57','2026-02-11 07:18:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2271','2404:c0:2810::f20:70e8','yuliagustiani@gmail.com','23','2026-02-11 07:21:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2272','2404:c0:2810::f25:83df','detirosmawati@gmail.com','42','2026-02-11 07:23:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2273','114.122.111.65','adeirfannugraha@gmail.com','35','2026-02-11 07:30:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2274','114.122.74.248','anihgindalistiani@gmail.com','21','2026-02-11 07:32:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2275','114.122.82.119','yusmansetiawan@gmail.com','20','2026-02-11 07:38:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2276','36.83.124.37','susilawati@gmail.com','60','2026-02-11 07:39:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2277','103.188.169.69','yuyunyunaningsih@gmail.com','29','2026-02-11 08:04:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2278','2404:c0:2810::f2e:56c2','ikasartika@gmail.com','13','2026-02-11 08:18:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2279','114.122.70.149','anggagunawan@gmail.com','45','2026-02-11 09:07:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2280','2404:c0:2910::1948:390b','muhtarsidik@gmail.com','55','2026-02-11 10:02:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2281','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-11 10:16:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2282','2404:c0:2910::1952:c95e','yosisitirosita@gmail.com','38','2026-02-11 10:33:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2283','2404:c0:2810::f1a:373a','tiaiqbalhembara@gmail.com','61','2026-02-11 10:38:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2284','2404:c0:2b10::1951:4791','wulanpurnamasari@gmail.com','43','2026-02-11 10:42:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2285','2404:c0:2b10::1961:24f8','syfaulhusna@gmail.com','58','2026-02-11 11:12:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2286','114.122.103.68','sriastutisyam@gmail.com','28','2026-02-11 12:10:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2287','2404:c0:2b10::196b:7f40','dinanursolihat@gmail.com','62','2026-02-11 12:10:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2288','2404:c0:2910::1972:11bb','evitinisukartini@gmail.com','18','2026-02-11 12:17:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2289','2404:c0:2b10::196b:3c03','novitaandriani@gmail.com','51','2026-02-11 12:17:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2290','2404:c0:2810::f31:4a68','yuyunyunaningsih@gmail.com','29','2026-02-11 12:19:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2291','114.122.70.153','anggagunawan@gmail.com','45','2026-02-11 12:19:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2292','2404:c0:2910::1963:3d3b','emmysitimariyam@gmail.com','25','2026-02-11 12:21:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2293','2404:c0:2910::1963:3d3b','emmysitimariyam@gmail.com','25','2026-02-11 12:21:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2294','36.83.117.224','susilawati@gmail.com','60','2026-02-11 12:29:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2295','2404:c0:2a10::1960:d5f8','acepantonfajar@gmail.com','63','2026-02-11 12:40:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2296','2404:c0:2b10::1951:2a59','tiaiqbalhembara@gmail.com','61','2026-02-11 12:43:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2297','36.83.117.224','sitipatimah@gmail.com','12','2026-02-11 12:47:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2298','114.122.74.236','sitimunawaroh@gmail.com','47','2026-02-11 12:47:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2299','2404:c0:2e10::1665:4445','nanangnajamudin@gmail.com','36','2026-02-11 13:14:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2300','114.122.106.127','dewi@gmail.com','16','2026-02-11 13:16:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2301','114.122.82.25','anihgindalistiani@gmail.com','21','2026-02-11 13:56:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2302','2404:c0:2f10::167a:735c','rentydwiyanti@gmail.com','56','2026-02-11 14:00:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2303','36.83.117.224','adminsuper@gmail.com','1','2026-02-11 14:04:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2304','2404:c0:2c10::1664:5416','noviestephen@gmail.com','24','2026-02-11 14:04:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2305','2404:c0:2c10::1664:5416','noviestephen@gmail.com','24','2026-02-11 14:04:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2306','2404:c0:2a10::1971:b1bb','yuliagustiani@gmail.com','23','2026-02-11 14:05:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2307','2404:c0:2810::f46:2021','detirosmawati@gmail.com','42','2026-02-11 14:13:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2308','114.122.78.36','gilangsepteranurhendra@gmail.com','44','2026-02-11 14:16:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2309','2404:c0:2810::f39:bacd','ripkiardian@gmail.com','41','2026-02-11 14:17:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2310','2404:c0:2e10::165e:8fdc','jonihprasetia@gmail.com','53','2026-02-11 14:18:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2311','114.122.76.9','pupuypuadah@gmail.com','59','2026-02-11 14:25:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2312','2404:c0:2d10::166d:bdb9','neneng@gmail.com','19','2026-02-11 14:27:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2313','2404:c0:2b10::195f:9325','ekasantikalestari',NULL,'2026-02-11 14:32:25','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2314','2404:c0:2b10::195f:9325','ekasantikalestari@gmail.com','50','2026-02-11 14:32:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2315','2404:c0:2f10::1666:4eee','firmanmuharam@gmail.com','64','2026-02-11 14:35:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2316','114.122.78.157','anggagunawan@gmail.com','45','2026-02-11 14:36:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2317','114.122.82.50','elsaandriani@gmail.com','46','2026-02-11 14:38:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2318','2404:c0:2810::f38:2866','ritanurfatimah@gmail.com','31','2026-02-11 14:40:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2319','2404:c0:2f10::1678:9a89','ikasartika@gmail.com','13','2026-02-11 14:43:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2320','2404:c0:2b10::197d:dac6','nisa@gmail.com','57','2026-02-11 14:44:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2321','114.122.115.46','yusmansetiawan@gmail.com','20','2026-02-11 14:45:03','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2322','2404:c0:2910::1948:390b','muhtarsidik@gmail.com','55','2026-02-11 14:57:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2323','2404:c0:2910::1952:c95e','yosisitirosita@gmail.com','38','2026-02-11 15:20:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2324','180.245.117.116','acepantonfajar@gmail.com','63','2026-02-11 15:39:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2325','180.245.117.249','agustomi@gmail.com','33','2026-02-11 15:42:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2326','114.122.85.118','asepcandra@gmail.com','37','2026-02-11 16:37:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2327','103.138.53.62','noviestephen@gmail.com','24','2026-02-11 17:07:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2328','36.83.117.224','adminsuper@gmail.com','1','2026-02-11 17:09:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2329','2404:c0:2c10::167e:4cc0','neneng@gmail.com','19','2026-02-11 17:23:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2330','36.83.117.224','admin@gmail.com','3','2026-02-11 17:47:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2331','114.122.72.146','adeirfannugraha@gmail.com','35','2026-02-11 18:29:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2332','114.122.72.146','guru@gmail.com','4','2026-02-11 18:33:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2333','114.122.103.68','sriastutisyam@gmail.com','28','2026-02-11 18:50:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2334','103.184.16.247','henririsnandar@gmail.com','34','2026-02-11 19:37:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2335','114.122.106.233','galihwangi@gmail.com','49','2026-02-11 19:44:49','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2336','103.188.169.69','adminsuper@gmail.com','1','2026-02-12 01:45:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2337','103.188.169.69','guru@gmail.com','4','2026-02-12 01:46:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2338','103.188.169.69','asepcandra@gmail.com','37','2026-02-12 01:53:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2339','103.188.169.69','asepcandra@gmail.com','37','2026-02-12 02:04:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2340','103.188.169.69','adminsuper@gmail.com','1','2026-02-12 02:26:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2341','103.188.169.153','dinanursolihat@gmail.com','62','2026-02-12 05:55:09','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2342','125.163.112.209','ripkiardian@gmail.com','41','2026-02-12 05:57:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2343','2404:c0:2d10::16a2:aa8e','acepantonfajar@gmail.com','63','2026-02-12 06:01:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2344','114.122.107.52','haniherlina@gmail.com','40','2026-02-12 06:09:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2345','2404:c0:2b10::19af:e673','ojatdarojat@gmail.com','76','2026-02-12 06:19:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2346','36.83.117.224','nanangnajamudin@gmail.com','36','2026-02-12 06:20:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2347','2404:c0:2b10::19b6:6eff','jonihprasetia@gmail.com','53','2026-02-12 06:22:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2348','2404:c0:2c10::169a:ff35','ikasartika',NULL,'2026-02-12 06:23:47','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2349','2404:c0:2c10::169a:ff35','ikasartika@gmail.com','13','2026-02-12 06:24:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2350','114.122.103.75','asepsuryadi@gmail.com','11','2026-02-12 06:25:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2351','2404:c0:2d10::16a5:69ac','siskatutiana@gmail.com','68','2026-02-12 06:25:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2352','2404:c0:2910::19a9:aeb','noviestephen@gmail.com','24','2026-02-12 06:27:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2353','114.122.83.165','anihgindalistiani@gmail.com','21','2026-02-12 06:29:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2354','114.122.111.112','adeirfannugraha@gmail.com','35','2026-02-12 06:32:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2355','36.83.117.224','anggagunawan@gmail.com','45','2026-02-12 06:33:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2356','2404:c0:2a10::196e:1976','emmysitimariyam@gmail.com','25','2026-02-12 06:33:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2357','36.83.117.224','sitipatimah@gmail.com','12','2026-02-12 06:38:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2358','103.188.169.69','adminsuper@gmail.com','1','2026-02-12 06:38:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2359','103.188.169.69','adminsuper@gmail.com','1','2026-02-12 06:39:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2360','2404:c0:2810::f6d:a388','susilawati@gmail.com','60','2026-02-12 06:40:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2361','36.83.117.224','dewi@gmail.com','16','2026-02-12 06:40:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2362','2404:c0:2810::f7f:d949','evitinisukartini@gmail.com','18','2026-02-12 06:41:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2363','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-12 06:44:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2364','2404:c0:2f10::1666:4eee','firmanmuharam@gmail.com','64','2026-02-12 06:45:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2365','103.188.169.69','adminsuper@gmail.com','1','2026-02-12 06:55:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2366','103.188.169.69','guru@gmail.com','4','2026-02-12 06:58:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2367','2404:c0:2a10::1984:8c5e','yuliagustiani@gmail.com','23','2026-02-12 06:59:35','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2368','114.122.104.23','muhtargojali@gmail.com','27','2026-02-12 07:06:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2369','2404:c0:2d10::16a2:a49e','wulanpurnamasari@gmail.com','43','2026-02-12 07:12:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2370','36.83.117.224','irfannugraha719@gmail.com',NULL,'2026-02-12 07:12:06','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2371','36.83.117.224','adeirfannugraha@gmail.com','35','2026-02-12 07:12:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2372','2404:c0:2a10::19b5:8c77','dinanursolihat@gmail.com','62','2026-02-12 07:13:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2373','2404:c0:2910::19ab:75c3','risnandarhendri@gmail.com',NULL,'2026-02-12 07:18:43','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2374','2404:c0:2910::19ab:75c3','henririsnandar@gmail.com','34','2026-02-12 07:18:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2375','2404:c0:2f10::16a3:acfc','ikasartika',NULL,'2026-02-12 07:19:43','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2376','103.188.169.69','guru@gmail.com','4','2026-02-12 07:20:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2377','103.188.169.69','asepcandra@gmail.com','37','2026-02-12 07:20:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2378','2404:c0:2f10::16a3:acfc','ikasartika@gmail.com','13','2026-02-12 07:21:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2379','114.122.104.52','neneng@gmail.com','19','2026-02-12 07:21:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2380','114.122.104.23','muhtargojali@gmail.com','27','2026-02-12 07:25:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2381','114.122.83.165','anihgindalistiani@gmail.com','21','2026-02-12 07:28:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2382','114.122.104.122','adeirfannugraha@gmail.com','35','2026-02-12 07:28:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2383','114.122.111.49','ujenahmad@gmail.com','17','2026-02-12 07:28:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2384','2404:c0:2d10::16aa:ec65','nisa@gmail.com','57','2026-02-12 07:29:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2385','2404:c0:2d10::16aa:ec65','nisa@gmail.com','57','2026-02-12 07:29:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2386','36.83.117.224','evitinisukartini@gmail.com','18','2026-02-12 07:31:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2387','103.188.169.69','adminsuper@gmail.com','1','2026-02-12 07:32:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2388','103.188.169.69','asepcandra@gmail.com','37','2026-02-12 07:32:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2389','2404:c0:2b10::19b2:8cd3','susilawati@gmail.com','60','2026-02-12 07:34:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2390','114.122.70.52','dewi@gmail.com','16','2026-02-12 07:38:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2391','2404:c0:2e10::16a3:939f','acepantonfajar@gmail.com','63','2026-02-12 07:39:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2392','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-12 07:45:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2393','114.122.110.92','sriastutisyam@gmail.com','28','2026-02-12 07:47:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2394','114.122.85.244','irmannurhendra@gmail.com','26','2026-02-12 07:52:14','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2395','114.122.85.244','irmannurhendra@gmail.com','26','2026-02-12 07:52:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2396','2404:c0:2b10::19c5:4562','agismujiprayitno@gmail.com','30','2026-02-12 07:54:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2397','114.122.115.166','agustomi@gmail.com','33','2026-02-12 07:58:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2398','2404:c0:2c10::169f:5e0f','sitipatimah@gmail.com','12','2026-02-12 07:58:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2399','114.122.108.45','galihwangi@gmail.com','49','2026-02-12 07:59:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2400','114.122.108.45','galihwangi@gmail.com','49','2026-02-12 07:59:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2401','2a0d:5600:4d:101a:c331:5e54:f974:a29','gilangsepteranurhendra@gmail.com','44','2026-02-12 08:02:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2402','2404:c0:2f10::16af:7c5e','elsaandriani@gmail.com','46','2026-02-12 08:03:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2403','2404:c0:2f10::16af:7c5e','elsaandriani@gmail.com','46','2026-02-12 08:03:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2404','114.122.102.110','enokmira@gmail.com','66','2026-02-12 08:03:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2405','36.83.117.224','adminsuper@gmail.com','1','2026-02-12 08:17:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2406','2404:c0:2f10::16b6:fb42','siskatutiana@gmail.com','68','2026-02-12 08:18:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2407','2404:c0:2910::19a7:8ce3','yosisitirosita@gmail.com','38','2026-02-12 08:18:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2408','2404:c0:2910::19a7:8ce3','yosisitirosita@gmail.com','38','2026-02-12 08:18:45','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2409','202.46.68.1','muhtarsidik@gmail.com','55','2026-02-12 08:25:20','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2410','36.83.117.224','asepcandra@gmail.com','37','2026-02-12 08:47:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2411','2404:c0:2d10::16aa:ec65','nisa@gmail.com','57','2026-02-12 08:59:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2412','2404:c0:2d10::16aa:ec65','nisa@gmail.com','57','2026-02-12 09:00:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2413','114.122.110.158','adeirfannugraha@gmail.com','35','2026-02-12 09:06:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2414','36.83.117.224','asepcandra@gmail.com','37','2026-02-12 09:09:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2415','114.122.108.45','galihwangi@gmail.com','49','2026-02-12 09:10:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2416','114.122.108.45','galihwangi@gmail.com','49','2026-02-12 09:10:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2417','114.122.114.223','asepcandra@gmail.com','37','2026-02-12 09:17:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2418','2404:c0:2810::f72:adc7','tiaiqbalhembara@gmail.com','61','2026-02-12 09:18:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2419','36.83.117.224','admin@gmail.com','3','2026-02-12 09:30:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2420','2404:c0:2a10::19c3:61d7','noviestephen@gmail.com','24','2026-02-12 10:00:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2421','2404:c0:2a10::19c3:61d7','noviestephen@gmail.com','24','2026-02-12 10:00:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2422','2404:c0:2e10::16a0:7d1c','ekasantikalestari@gmail.com','50','2026-02-12 10:04:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2423','2404:c0:2b10::19c5:4ebb','nisa@gmail.com','57','2026-02-12 10:16:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2424','2404:c0:2b10::19c5:4ebb','nisa@gmail.com','57','2026-02-12 10:16:02','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2425','2404:c0:2f10::16b2:7512','sitipatimah@gmail.com','12','2026-02-12 10:55:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2426','2404:c0:2c10::16bf:48bc','pupuypuadah@gmail.com','59','2026-02-12 11:09:52','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2427','114.122.110.158','adeirfannugraha@gmail.com','35','2026-02-12 11:25:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2428','114.122.73.57','anihgindalistiani@gmail.com','21','2026-02-12 11:29:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2429','114.122.106.248','dewi@gmail.com','16','2026-02-12 12:01:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2430','2404:c0:2f10::1666:4eee','firmanmuharam@gmail.com','64','2026-02-12 12:06:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2431','2404:c0:2e10::16c5:2a63','noviestephen@gmail.com','24','2026-02-12 13:06:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2432','36.81.232.147','admin@gmail.com','3','2026-02-12 15:35:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2433','114.122.102.87','adeirfannugraha@gmail.com','35','2026-02-12 16:23:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2434','114.122.102.87','guru@gmail.com','4','2026-02-12 16:25:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2435','2404:c0:2e10::16c5:2a63','noviestephen@gmail.com','24','2026-02-12 16:29:55','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2436','114.122.109.197','galihwangi@gmail.com','49','2026-02-12 16:29:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2437','114.122.109.197','galihwangi@gmail.com','49','2026-02-12 16:29:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2438','114.122.82.239','dewi@gmail.com','16','2026-02-12 16:30:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2439','114.122.117.216','asepcandra@gmail.com','37','2026-02-12 16:33:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2440','114.122.117.216','asepcandra@gmail.com','37','2026-02-12 16:33:17','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2441','103.138.53.62','gilangsepteranurhendra@gmail.com','44','2026-02-12 16:34:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2442','103.188.169.153','evitinisukartini@gmail.com','18','2026-02-12 16:43:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2443','36.81.234.6','sitipatimah@gmail.com','12','2026-02-12 16:45:33','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2444','103.208.101.2','nisa@gmail.com','57','2026-02-12 16:47:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2445','2404:c0:2b10::19d6:2792','henririsnandar',NULL,'2026-02-12 16:48:39','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2446','2404:c0:2b10::19d6:2792','henririsnandar',NULL,'2026-02-12 16:48:52','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2447','2404:c0:2810::f9e:9ade','henririsnandar@gmail.com','34','2026-02-12 16:49:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2448','2404:c0:2f10::16cc:b998','ritanurfatimah@gmail.com','31','2026-02-12 16:50:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2449','103.166.159.217','anggagunawan@gmail.com','45','2026-02-12 16:50:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2450','103.188.169.69','susilawati@gmail.com','60','2026-02-12 16:55:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2451','2404:c0:2b10::19e2:f15b','emmysitimariyam@gmail.com','25','2026-02-12 16:59:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2452','114.122.100.16','adminsuper@gmail.com','1','2026-02-12 17:00:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2453','36.81.232.147','admin@gmail.com','3','2026-02-12 17:09:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2454','2001:448a:3070:e9da:cd3f:378a:5b74:d93e','nanangnajamudin@gmail.com','36','2026-02-12 17:31:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2455','2001:448a:3070:e9da:cd3f:378a:5b74:d93e','nanangnajamudin@gmail.com','36','2026-02-12 17:31:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2456','180.245.252.111','ripkiardian@gmail.com','41','2026-02-12 17:31:22','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2457','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-12 17:33:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2458','202.46.68.71','guru@gmail.com','4','2026-02-12 17:34:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2459','103.188.169.69','yuliagustiani@gmail.com','23','2026-02-12 17:36:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2460','2404:c0:2e10::16c5:2a63','noviestephen@gmail.com','24','2026-02-12 17:36:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2461','2404:c0:2e10::16c5:2a63','noviestephen@gmail.com','24','2026-02-12 17:36:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2462','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-12 17:40:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2463','103.166.159.217','pupuypuadah@gmail.com','59','2026-02-12 17:46:38','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2464','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-12 17:52:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2465','180.245.117.116','acepantonfajar@gmail.com','63','2026-02-12 18:01:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2466','103.186.204.55','yuyunyunaningsih@gmail.com','29','2026-02-12 18:01:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2467','114.122.107.104','muhtargojali@gmail.com','27','2026-02-12 18:07:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2468','114.122.110.144','haniherlina@gmail.com','40','2026-02-12 18:17:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2469','103.3.221.193','wulanpurnamasari',NULL,'2026-02-12 18:27:26','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2470','103.3.221.193','wulanpurnamasari@gmail.com','43','2026-02-12 18:28:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2471','2404:c0:2a10::19ef:a4bf','elsaandriani@gmail.com','46','2026-02-12 18:30:01','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2472','103.188.169.69','susilawati@gmail.com','60','2026-02-12 19:10:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2473','114.122.75.113','agustomi@gmail.com','33','2026-02-12 19:30:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2474','114.122.108.196','adminsuper@gmail.com','1','2026-02-13 02:31:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2475','114.122.108.196','adminsuper@gmail.com','1','2026-02-13 02:31:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2476','114.122.108.196','asepcandra@gmail.com','37','2026-02-13 02:34:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2477','114.122.101.236','asepcandra@gmail.com','37','2026-02-13 03:15:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2478','103.188.169.153','dinanursolihat@gmail.com','62','2026-02-13 05:53:53','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2479','2404:c0:2a10::1a0c:74ff','ekasantikalestari@gmail.com','50','2026-02-13 06:09:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2480','103.188.169.69','anggagunawan@gmail.com','45','2026-02-13 06:11:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2481','114.122.111.240','ikanurhasanah@gmail.com','32','2026-02-13 06:12:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2482','36.81.232.147','yuliagustiani@gmail.com','23','2026-02-13 06:18:37','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2483','114.122.104.52','neneng@gmail.com','19','2026-02-13 06:19:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2484','2404:c0:2b10::1a0e:6899','yuyunyunaningsih@gmail.com','29','2026-02-13 06:19:59','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2485','114.122.82.252','enokmira@gmail.com','66','2026-02-13 06:21:41','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2486','103.188.169.69','admin@gmail.com','3','2026-02-13 06:22:07','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2487','114.122.103.151','adeirfannugraha@gmail.com','35','2026-02-13 06:22:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2488','114.122.103.55','gilangsepteranurhendra@gmail.com','44','2026-02-13 06:35:32','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2489','202.46.68.1','muhtarsidik@gmail.com','55','2026-02-13 06:40:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2490','103.188.169.69','susilawati@gmail.com','60','2026-02-13 06:42:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2491','2404:c0:2c10::16fd:150d','noviestephen@gmail.com','24','2026-02-13 06:43:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2492','2404:c0:2810::fe5:df32','pupuypuadah@gmail.com','59','2026-02-13 06:45:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2493','2404:c0:2f10::16fc:6650','rdsusimurti@gmail.com','54','2026-02-13 06:46:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2494','103.188.169.69','admin@gmail.com','3','2026-02-13 06:49:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2495','2404:c0:2c10::16fa:7c1','sitipatimah@gmail.com','12','2026-02-13 06:51:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2496','2404:c0:2b10::1a1a:6f9f','neneng@gmail.com','19','2026-02-13 06:51:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2497','114.122.111.75','ujenahmad@gmail.com','17','2026-02-13 06:52:05','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2498','114.10.146.234','Ade Irfan Nugraha',NULL,'2026-02-13 06:53:31','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2499','114.10.146.234','ikanurhasanah',NULL,'2026-02-13 06:53:51','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2500','36.81.232.147','henririsnandar@gmail.com','34','2026-02-13 06:55:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2501','2404:c0:2e10::16fb:e66d','emmysitimariyam@gmail.com','25','2026-02-13 06:56:21','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2502','2404:c0:2c10::16fe:5ced','tiaiqbalhembara@gmail.com','61','2026-02-13 06:58:04','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2503','36.83.135.63','ripkiardian@gmail.com','41','2026-02-13 06:59:43','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2504','36.81.232.147','evitinisukartini@gmail.com','18','2026-02-13 07:03:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2505','114.122.100.246','sriastutisyam@gmail.com','28','2026-02-13 07:11:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2506','2404:c0:2a10::1a0c:4892','elsaandriani@gmail.com','46','2026-02-13 07:14:24','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2507','2404:c0:2810::fd0:378','nisa@gmail.com','57','2026-02-13 07:14:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2508','2404:c0:2e10::16bd:76f2','yosisitirosita@gmail.com','38','2026-02-13 07:17:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2509','114.122.83.100','anihgindalistiani@gmail.com','21','2026-02-13 07:30:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2510','2404:c0:2910::1a15:d0e2','rentydwiyanti@gmail.com','56','2026-02-13 07:38:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2511','36.81.232.147','adminsuper@gmail.com','1','2026-02-13 08:08:18','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2512','114.122.76.102','dewi@gmail.com','16','2026-02-13 08:21:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2513','2404:c0:2e10::16fd:c209','ikasartika@gmail.com','13','2026-02-13 08:22:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2514','2404:c0:2b10::1a17:c365','acepantonfajar@gmail.com','63','2026-02-13 08:23:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2515','2404:c0:2f10::16f4:2484','wulanpurnamasari@gmail.com','43','2026-02-13 08:27:42','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2516','114.122.75.113','agustomi@gmail.com','33','2026-02-13 08:36:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2517','2404:c0:2f10::1706:54f2','ritanurfatimah@gmail.com','31','2026-02-13 08:44:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2518','114.122.115.126','haniherlina@gmail.com','40','2026-02-13 09:07:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2519','114.122.77.115','anggagunawan@gmail.com','45','2026-02-13 09:09:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2520','114.122.102.118','muhtargojali@gmail.com','27','2026-02-13 09:23:34','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2521','114.122.106.121','sitipatimah@gmail.com','12','2026-02-13 09:41:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2522','114.122.106.121','sitipatimah@gmail.com','12','2026-02-13 09:41:47','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2523','114.122.101.35','asepcandra@gmail.com','37','2026-02-13 10:11:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2524','2404:c0:2f10::16ff:d137','irmannurhendra@gmail.com','26','2026-02-13 10:17:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2525','2404:c0:2f10::16ff:d137','irmannurhendra@gmail.com','26','2026-02-13 10:17:31','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2526','36.81.232.147','adminsuper@gmail.com','1','2026-02-13 11:04:29','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2527','36.81.232.147','adminsuper@gmail.com','1','2026-02-13 11:43:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2528','2404:c0:2d10::1706:36fc','noviestephen@gmail.com','24','2026-02-13 12:32:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2529','2404:c0:2a10::1a26:d826','nisa@gmail.com','57','2026-02-13 13:16:46','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2530','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-13 13:33:27','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2531','2404:c0:6a1c:45a1:e05f:75ff:fe54:41cd','nanangnajamudin@gmail.com','36','2026-02-13 13:48:13','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2532','103.184.16.247','henririsnandar@gmail.com','34','2026-02-13 15:38:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2533','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-13 15:47:15','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2534','36.81.232.147','galihwangi@gmail.com','49','2026-02-13 15:54:11','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2535','103.188.169.69','yuyunyunaningsih@gmail.com','29','2026-02-13 16:00:25','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2536','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-13 16:23:19','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2537','2404:c0:2f10::1717:5174','yuyunyunaningsih@gmail.com','29','2026-02-13 18:03:40','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2538','2404:c0:2d10::171f:613f','pupuypuadah@gmail.com','59','2026-02-13 18:05:58','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2539','202.46.68.71','adeirfannugraha@gmail.com','35','2026-02-13 20:15:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2540','103.188.169.69','yuyunyunaningsih@gmail.com','29','2026-02-13 21:00:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2541','103.188.169.69','adminsuper@gmail.com','1','2026-02-13 21:01:54','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2542','2404:c0:2a10::1a8a:47f7','pupuypuadah@gmail.com','59','2026-02-14 12:16:51','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2543','114.122.104.18','adminsuper@gmail.com','1','2026-02-15 10:46:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2544','114.122.68.50','adeirfannugraha',NULL,'2026-02-16 16:49:45','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2545','114.122.68.50','adeirfannugraha@gmail.com','35','2026-02-16 16:49:56','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2546','103.188.169.69','rentydwiyanti@gmail.com','56','2026-02-16 17:56:10','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2547','103.188.169.69','adminsuper@gmail.com','1','2026-02-18 01:31:23','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2548','103.188.169.69','adminsuper@gmail.com','1','2026-02-18 02:38:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2549','::1','adminsuper@gmail.com','1','2026-02-19 19:52:08','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2550','::1','adminsuper@gmail.com','1','2026-02-19 19:55:00','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2551','::1','adminsuper@gmail.com','1','2026-02-19 20:10:36','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2552','::1','siswa@gmail.com','5','2026-02-19 20:10:50','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2553','::1','adminsuper@gmail.com','1','2026-02-19 21:30:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2554','::1','adminsuper@gmail.com','1','2026-02-19 21:40:26','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2555','::1','siswa@gmail.com','5','2026-02-19 22:16:57','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2556','::1','admin@gmail.com','3','2026-02-19 22:18:06','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2557','::1','adminsuper@gmail.com','1','2026-02-19 22:18:48','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2558','::1','adminsuper@gmail.com','1','2026-02-19 22:19:30','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2559','::1','adminsuper@gmail.com','1','2026-02-19 22:20:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2560','::1','guru@gmail.com','4','2026-02-19 22:29:16','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2561','::1','admin@gmail.com','3','2026-02-19 22:33:28','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2562','::1','superadmin',NULL,'2026-02-20 03:49:26','0');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2563','::1','adminsuper@gmail.com','1','2026-02-20 03:49:44','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2564','::1','adminsuper@gmail.com','1','2026-02-20 03:54:39','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2565','::1','adminsuper@gmail.com','1','2026-02-20 03:58:12','1');
INSERT INTO `auth_logins` (`id`,`ip_address`,`email`,`user_id`,`date`,`success`) VALUES ('2566','::1','adminsuper@gmail.com','1','2026-02-20 04:01:04','1');


CREATE TABLE `auth_permissions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;



CREATE TABLE `auth_reset_attempts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `ip_address` varchar(255) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;



CREATE TABLE `auth_tokens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `selector` varchar(255) NOT NULL,
  `hashedValidator` varchar(255) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `expires` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_tokens_user_id_foreign` (`user_id`),
  KEY `selector` (`selector`),
  CONSTRAINT `auth_tokens_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;



CREATE TABLE `auth_users_permissions` (
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `permission_id` int(11) unsigned NOT NULL DEFAULT 0,
  KEY `auth_users_permissions_permission_id_foreign` (`permission_id`),
  KEY `user_id_permission_id` (`user_id`,`permission_id`),
  CONSTRAINT `auth_users_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `auth_permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `auth_users_permissions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;



CREATE TABLE `general_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `logo` varchar(225) DEFAULT NULL,
  `school_name` varchar(225) DEFAULT 'SMAN 1 CIKATOMAS',
  `school_year` varchar(225) DEFAULT '2024/2025',
  `copyright` varchar(225) DEFAULT '© 2025 All rights reserved.',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `general_settings` (`id`,`logo`,`school_name`,`school_year`,`copyright`) VALUES ('1',NULL,'SMAN 1 CIKATOMAS','2025/2026','© 2026 All rights reserved.');


CREATE TABLE `jam_presensi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jenis` enum('masuk','duhur','pulang') NOT NULL,
  `jam_mulai` time NOT NULL,
  `jam_selesai` time NOT NULL,
  `aktif` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `jam_presensi` (`id`,`jenis`,`jam_mulai`,`jam_selesai`,`aktif`) VALUES ('1','masuk','05:00:00','08:00:00','1');
INSERT INTO `jam_presensi` (`id`,`jenis`,`jam_mulai`,`jam_selesai`,`aktif`) VALUES ('2','duhur','11:45:00','13:15:00','1');
INSERT INTO `jam_presensi` (`id`,`jenis`,`jam_mulai`,`jam_selesai`,`aktif`) VALUES ('3','pulang','14:30:00','17:00:00','0');
INSERT INTO `jam_presensi` (`id`,`jenis`,`jam_mulai`,`jam_selesai`,`aktif`) VALUES ('4','pulang','03:15:00','23:00:00','1');


CREATE TABLE `menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(100) NOT NULL,
  `icon` varchar(50) NOT NULL,
  `url` varchar(150) NOT NULL,
  `ctx` varchar(50) NOT NULL,
  `roles` varchar(50) NOT NULL COMMENT 'dipisah koma: 1,2,3',
  `urutan` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `sidebar_color` varchar(20) DEFAULT 'rose',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('1','Dashboard','home','admin/dashboard','dashboard','0,1,2,3,4,5,6','1','1','purple');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('2','Scan QRCode','qr_code_scanner','admin/menuqrcode','menuqrcode','0,1,2,3,4,5,6','2','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('3','Piket Harian','article','admin/menupiket','menupiket','0,1,2,3,4,5,6','3','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('4','Data Siswa','person','admin/menudata','menudata','0,1,2,3,4,5,6','4','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('5','Generate Laporan','print','admin/menurekap','menurekap','0,1,2,3,4,5,6','5','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('6','Grafhic Kehadiran','pie_chart','admin/menu-persentasi','menupersentasi','0,1,2,3,4,5','6','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('7','Pengaturan','settings','admin/menuseting','menupengaturan','1,2','7','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('8','Sidebar Seting','settings_applications','admin/menus','menus','1','8','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('9','Auto Absen','event_available','admin/absenotomatis','absenotomatis','1','9','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('10','Role Seting','manage_accounts','admin/petugas','petugas','1','10','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('11','Change Password','lock_reset','admin/userloginaktif','userloginaktif','0,1,2,3,4,5,6','11','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('12','Input Jurusan','category','admin/upload/input-jurusan','inputjurusan','0,1,2,3,4,5,6','12','0','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('13','Input Kelas','meeting_room','admin/upload/kelas','inputkelas','0,1,2,3,4,5,6','13','0','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('14','Input Siswa','assignment_ind','admin/upload/input_siswa','inputsiswa','2,3','14','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('15','Upload Siswa','cloud_upload','admin/upload/siswa','uploadsiswa','0,1,2,3,4,5,6','15','0','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('18','Seting Page','home','admin/roolseting/role-route','roolseting','1','20','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('19','Logout','logout','logout','logout','0,1,2,3,4,5,6','25','1','green');
INSERT INTO `menus` (`id`,`label`,`icon`,`url`,`ctx`,`roles`,`urutan`,`is_active`,`sidebar_color`) VALUES ('20','Backup DB','backup','/admin/backup','backup','1','22','1','green');


CREATE TABLE `migrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(255) NOT NULL,
  `class` varchar(255) NOT NULL,
  `group` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `time` int(11) NOT NULL,
  `batch` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `migrations` (`id`,`version`,`class`,`group`,`namespace`,`time`,`batch`) VALUES ('1','2017-11-20-223112','Myth\\Auth\\Database\\Migrations\\CreateAuthTables','default','Myth\\Auth','1766452147','1');
INSERT INTO `migrations` (`id`,`version`,`class`,`group`,`namespace`,`time`,`batch`) VALUES ('2','2023-08-18-000001','App\\Database\\Migrations\\CreateJurusanTable','default','App','1766452147','1');
INSERT INTO `migrations` (`id`,`version`,`class`,`group`,`namespace`,`time`,`batch`) VALUES ('3','2023-08-18-000002','App\\Database\\Migrations\\CreateKelasTable','default','App','1766452147','1');
INSERT INTO `migrations` (`id`,`version`,`class`,`group`,`namespace`,`time`,`batch`) VALUES ('4','2023-08-18-000003','App\\Database\\Migrations\\CreateDB','default','App','1766452147','1');
INSERT INTO `migrations` (`id`,`version`,`class`,`group`,`namespace`,`time`,`batch`) VALUES ('5','2023-08-18-000004','App\\Database\\Migrations\\AddSuperadmin','default','App','1766452148','1');
INSERT INTO `migrations` (`id`,`version`,`class`,`group`,`namespace`,`time`,`batch`) VALUES ('6','2024-07-24-083011','App\\Database\\Migrations\\GeneralSettings','default','App','1766452148','1');


CREATE TABLE `role_routes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `route` varchar(255) NOT NULL,
  `allowed_roles` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('3','route','allowed_roles');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('14','admin/menuqrcode','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('15','admin/menupiket','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('16','admin/menudata','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('17','admin/menurekap','0,1,2,3,4,5,6,7');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('20','admin/menu-persentasi','0,1,2,3,4,5,6,7');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('22','admin/menuseting','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('23','admin/absen-siswa','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('24','scan/masuk','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('25','scan/duhur','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('26','scan/pulang','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('27','scan/izin','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('28','admin/piket/suratizin','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('29','admin/pelanggaran','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('30','admin/upload/datasiswa','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('31','admin/upload/input-jurusan','1,2');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('32','admin/upload/kelas','1,2');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('33','admin/siswa','1,2');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('34','admin/generate','1,2');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('35','admin/lap/lapharian','0,1,2,3,4,5,6,7');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('36','admin/lap/lapmingguan','0,1,2,3,4,5,6,7');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('37','admin/kehadiran/rekapbulanan','0,1,2,3,4,5,6,7');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('38','admin/lap/lapbulananhadir','0,1,2,3,4,5,6,7');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('39','admin/absenotomatis','1');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('40','admin/jam-presensi','1,2');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('41','admin/siswa/kelas','1,2');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('42','admin/harilibur','1,2');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('43','admin/pelanggaran/inputjenispelanggaran','1,2');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('44','admin/userloginaktif','0,1,2,3,4,5,6,7');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('45','admin/menus','1');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('46','admin/petugas','1');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('47','admin/upload/input_siswa','1,2,3');
INSERT INTO `role_routes` (`id`,`route`,`allowed_roles`) VALUES ('48','admin/roolseting/role-route','1');


CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `slug` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `roles` (`id`,`name`,`slug`) VALUES ('1','Super Admin','superadmin');
INSERT INTO `roles` (`id`,`name`,`slug`) VALUES ('2','Admin','admin');
INSERT INTO `roles` (`id`,`name`,`slug`) VALUES ('3','Guru','guru');
INSERT INTO `roles` (`id`,`name`,`slug`) VALUES ('4','Siswa','siswa');
INSERT INTO `roles` (`id`,`name`,`slug`) VALUES ('5','Orang Tua','orangtua');


CREATE TABLE `tb_guru` (
  `id_guru` int(11) NOT NULL AUTO_INCREMENT,
  `nuptk` varchar(24) NOT NULL,
  `nama_guru` varchar(255) NOT NULL,
  `jenis_kelamin` enum('Laki-laki','Perempuan') NOT NULL,
  `alamat` text NOT NULL,
  `no_hp` varchar(32) NOT NULL,
  `unique_code` varchar(64) NOT NULL,
  PRIMARY KEY (`id_guru`),
  UNIQUE KEY `unique_code` (`unique_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `tb_guru1` (
  `id_guru` int(11) NOT NULL AUTO_INCREMENT,
  `nip` varchar(30) DEFAULT NULL,
  `nama_guru` varchar(100) DEFAULT NULL,
  `role` enum('admin','guru_piket','wali_kelas') DEFAULT 'guru_piket',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_guru`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `tb_hari_libur` (
  `id_libur` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `keterangan` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_libur`),
  UNIQUE KEY `tanggal` (`tanggal`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('1','2026-01-01','Tahun Baru Masehi\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('2','2026-01-02','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('3','2026-01-03','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('4','2026-01-04','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('5','2026-01-05','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('6','2026-01-06','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('7','2026-01-07','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('8','2026-01-08','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('9','2026-01-09','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('10','2026-01-10','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('11','2026-01-11','libur sekolah\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('12','2026-01-16','Isra Mi’raj Nabi Muhammad SAW\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('13','2026-02-17','Tahun Baru Imlek 2577 Kongzili\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('14','2026-03-19','Hari Raya Nyepi Tahun Baru Saka\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('15','2026-03-21','Hari Raya Idul Fitri 1477 H\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('16','2026-03-22','Hari Raya Idul Fitri 1477 H\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('17','2026-04-03','Wafat Yesus Kristus (Jumat Agung)\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('18','2026-04-05','Hari Kebangkitan Yesus Kristus (Paskah)\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('19','2026-05-01','Hari Buruh Internasional\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('20','2026-05-14','Kenaikan Yesus Kristus\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('21','2026-05-27','Hari Raya Idul Adha 1447 H\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('22','2026-05-31','Hari Raya Waisak\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('23','2026-06-01','Hari Lahir Pancasila\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('24','2026-06-16','Tahun Baru Islam 1448 H\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('25','2026-08-17','Hari Kemerdekaan RI\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('26','2026-08-25','Maulid Nabi Muhammad SAW\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('27','2026-12-25','Hari Raya Natal\r');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('32','2026-02-18','Libur Awal Romadon');
INSERT INTO `tb_hari_libur` (`id_libur`,`tanggal`,`keterangan`) VALUES ('33','2026-02-16','Awal Romadon');


CREATE TABLE `tb_izin_siswa` (
  `id_izin` int(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` int(11) NOT NULL,
  `id_kelas` int(11) DEFAULT NULL,
  `tanggal` date NOT NULL,
  `jam` varchar(10) DEFAULT NULL,
  `jenis` enum('izin','sakit') NOT NULL,
  `keterangan` text DEFAULT NULL,
  `bukti` varchar(255) DEFAULT NULL,
  `id_guru` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('menunggu','disetujui') DEFAULT 'menunggu',
  PRIMARY KEY (`id_izin`),
  KEY `id_siswa` (`id_siswa`),
  KEY `id_guru` (`id_guru`),
  CONSTRAINT `tb_izin_siswa_ibfk_1` FOREIGN KEY (`id_siswa`) REFERENCES `tb_siswa` (`id_siswa`) ON DELETE CASCADE,
  CONSTRAINT `tb_izin_siswa_ibfk_2` FOREIGN KEY (`id_guru`) REFERENCES `tb_guru` (`id_guru`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('5','955','28','2026-02-09','08:10','izin','Keluar sekolah beli Gas (Kokulikuler)',NULL,NULL,'2026-02-09 08:11:09','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('6','971','28','2026-02-09','08:11','izin','Beli Gas (Kokulikuler)',NULL,NULL,'2026-02-09 08:11:49','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('7','1018','30','2026-02-09','08:14','izin','Beli Galon (Praktik Kokulikuler)',NULL,NULL,'2026-02-09 08:15:08','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('8','1043','30','2026-02-09','08:15','izin','Beli Galon (Praktik Kokulikuler)',NULL,NULL,'2026-02-09 08:15:50','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('9','388','11','2026-02-09','12:33','izin','Membeli galon',NULL,NULL,'2026-02-09 12:33:40','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('10','364','11','2026-02-09','12:34','izin','Memebeli galon',NULL,NULL,'2026-02-09 12:34:24','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('11','917','27','2026-02-09','12:36','izin','Keperluan keluarga mau ke singaparna',NULL,NULL,'2026-02-09 12:36:21','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('12','436','13','2026-02-09','12:40','izin','Pulang sakit',NULL,NULL,'2026-02-09 12:40:25','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('13','438','13','2026-02-09','12:51','izin','Pulang sakit lambung kambuh',NULL,NULL,'2026-02-09 12:51:34','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('14','438','13','2026-02-09','12:51','izin','Pulang sakit lambung kambuh',NULL,NULL,'2026-02-09 12:51:37','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('15','438','13','2026-02-09','12:51','izin','Pulang sakit lambung kambuh',NULL,NULL,'2026-02-09 12:51:38','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('17','11','1','2026-02-10','07:10:57','izin','Di suruh Beli Bodrek sama Pak Nanang Katanya buat pak gilang',NULL,NULL,'2026-02-10 07:10:57','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('18','622','18','2026-02-10','07:10','izin','Kegiatan DKR kec cikatomas samlau jam terakhir',NULL,NULL,'2026-02-10 07:11:00','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('19','604','18','2026-02-10','07:11','izin','KEGIATAN DKR DI CIKATOMAS SAMPAI JAM TERAKHIR',NULL,NULL,'2026-02-10 07:11:36','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('20','54','2','2026-02-10','09:30','sakit','Sakit panas pusing mual',NULL,NULL,'2026-02-10 15:00:19','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('21','60','2','2026-02-10','12:30','sakit','Pusing kepala',NULL,NULL,'2026-02-10 15:01:02','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('22','1229','36','2026-02-11','09:31','izin','Ganti celana sobek dan ambil KTP',NULL,NULL,'2026-02-11 09:32:21','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('23','1220','36','2026-02-11','09:32','izin','Ambil KTP',NULL,NULL,'2026-02-11 09:32:42','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('24','1089','32','2026-02-11','12:48','izin','Ngeprint raport',NULL,NULL,'2026-02-11 12:49:11','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('25','1106','32','2026-02-11','12:49','izin','Ngeprint raport',NULL,NULL,'2026-02-11 12:50:00','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('26','335','10','2026-02-11','12:51','izin','Ngambil magic com dan katel untuk PKWU',NULL,NULL,'2026-02-11 12:52:08','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('27','343','10','2026-02-11','12:52','izin','Nganter ikhlas bawa barang untuk PKWU',NULL,NULL,'2026-02-11 12:52:54','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('28','338','10','2026-02-11','12:53','izin','Ngambil daging untuk praktek PKWU',NULL,NULL,'2026-02-11 12:54:08','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('29','338','10','2026-02-11','12:54','izin','Ngambil daging untuk praktek PKWU',NULL,NULL,'2026-02-11 12:55:13','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('30','856','25','2026-02-11','13:04','izin','Memperbaiki KIP ',NULL,NULL,'2026-02-11 13:05:23','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('31','1055','31','2026-02-11','13:05','izin','Membuat SKTM',NULL,NULL,'2026-02-11 13:05:56','disetujui');
INSERT INTO `tb_izin_siswa` (`id_izin`,`id_siswa`,`id_kelas`,`tanggal`,`jam`,`jenis`,`keterangan`,`bukti`,`id_guru`,`created_at`,`status`) VALUES ('32','916','27','2026-02-11','13:06','izin','Mengantar Nanda ke BNI TASIK',NULL,NULL,'2026-02-11 13:07:03','disetujui');


CREATE TABLE `tb_jenis_pelanggaran` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `poin` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('1','Terlambat masuk sekolah','5','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('2','Tidak memakai atribut lengkap','5','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('3','Tidak membawa buku pelajaran','5','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('4','Seragam tidak rapi','5','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('5','Berisik di kelas','5','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('6','Tidak mengikuti upacara tanpa keterangan','10','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('7','Keluar kelas tanpa izin','10','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('8','Tidak mengerjakan tugas','10','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('9','Menggunakan HP saat pelajaran','10','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('10','Membolos satu jam pelajaran','15','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('11','Membolos satu hari penuh','25','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('12','Merokok di lingkungan sekolah','30','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('13','Berpacaran di lingkungan sekolah','20','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('14','Melawan guru','30','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('15','Membawa barang terlarang','40','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('16','Berkelahi di sekolah','50','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('17','Perundungan (bullying)','50','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('18','Merusak fasilitas sekolah','50','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('19','Membawa senjata tajam','75','2026-02-10 05:55:15');
INSERT INTO `tb_jenis_pelanggaran` (`id`,`nama`,`poin`,`created_at`) VALUES ('20','Penyalahgunaan narkoba','100','2026-02-10 05:55:15');


CREATE TABLE `tb_jurusan` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `jurusan` varchar(32) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `jurusan` (`jurusan`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `tb_jurusan` (`id`,`jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('1','UMUM','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);


CREATE TABLE `tb_kehadiran` (
  `id_kehadiran` int(11) NOT NULL AUTO_INCREMENT,
  `kehadiran` enum('Hadir','Sakit','Izin','Tanpa keterangan') NOT NULL,
  PRIMARY KEY (`id_kehadiran`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_kehadiran` (`id_kehadiran`,`kehadiran`) VALUES ('1','Hadir');
INSERT INTO `tb_kehadiran` (`id_kehadiran`,`kehadiran`) VALUES ('2','Sakit');
INSERT INTO `tb_kehadiran` (`id_kehadiran`,`kehadiran`) VALUES ('3','Izin');
INSERT INTO `tb_kehadiran` (`id_kehadiran`,`kehadiran`) VALUES ('4','Tanpa keterangan');


CREATE TABLE `tb_kelas` (
  `id_kelas` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `kelas` varchar(32) NOT NULL,
  `id_jurusan` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id_kelas`),
  KEY `tb_kelas_id_jurusan_foreign` (`id_jurusan`),
  CONSTRAINT `tb_kelas_id_jurusan_foreign` FOREIGN KEY (`id_jurusan`) REFERENCES `tb_jurusan` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('1','X-1','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('2','X-2','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('3','X-3','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('4','X-4','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('5','X-5','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('6','X-6','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('7','X-7','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('8','X-8','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('9','X-9','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('10','X-10','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('11','X-11','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('12','X-12','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('13','XI-1','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('14','XI-2','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('15','XI-3','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('16','XI-4','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('17','XI-5','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('18','XI-6','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('19','XI-7','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('20','XI-8','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('21','XI-9','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('22','XI-10','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('23','XI-11','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('24','XI-12','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('25','XII-1','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('26','XII-2','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('27','XII-3','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('28','XII-4','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('29','XII-5','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('30','XII-6','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('31','XII-7','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('32','XII-8','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('33','XII-9','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('34','XII-10','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('35','XII-11','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);
INSERT INTO `tb_kelas` (`id_kelas`,`kelas`,`id_jurusan`,`created_at`,`updated_at`,`deleted_at`) VALUES ('36','XII-12','1','2025-12-23 08:09:07','2025-12-23 08:09:07',NULL);


CREATE TABLE `tb_pelanggaran` (
  `id_pelanggaran` int(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `jenis_pelanggaran` varchar(100) DEFAULT NULL,
  `poin` int(11) DEFAULT 0,
  `keterangan` text DEFAULT NULL,
  `id_guru` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_pelanggaran`),
  KEY `id_siswa` (`id_siswa`),
  KEY `id_guru` (`id_guru`),
  CONSTRAINT `tb_pelanggaran_ibfk_1` FOREIGN KEY (`id_siswa`) REFERENCES `tb_siswa` (`id_siswa`) ON DELETE CASCADE,
  CONSTRAINT `tb_pelanggaran_ibfk_2` FOREIGN KEY (`id_guru`) REFERENCES `tb_guru` (`id_guru`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_pelanggaran` (`id_pelanggaran`,`id_siswa`,`tanggal`,`jenis_pelanggaran`,`poin`,`keterangan`,`id_guru`,`created_at`) VALUES ('1','159','2026-02-11','Menggunakan HP saat pelajaran','10','',NULL,'2026-02-11 11:13:46');


CREATE TABLE `tb_piket_harian` (
  `id_piket` int(11) NOT NULL AUTO_INCREMENT,
  `id_guru` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `keterangan` text DEFAULT NULL,
  PRIMARY KEY (`id_piket`),
  KEY `fk_id_guru_idx` (`id_guru`),
  CONSTRAINT `fk_piket_harian_guru` FOREIGN KEY (`id_guru`) REFERENCES `tb_guru1` (`id_guru`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `tb_presensi_guru` (
  `id_presensi` int(11) NOT NULL AUTO_INCREMENT,
  `id_guru` int(11) DEFAULT NULL,
  `tanggal` date NOT NULL,
  `jam_masuk` time DEFAULT NULL,
  `jam_keluar` time DEFAULT NULL,
  `id_kehadiran` int(11) NOT NULL,
  `keterangan` varchar(255) NOT NULL,
  PRIMARY KEY (`id_presensi`),
  KEY `id_kehadiran` (`id_kehadiran`),
  KEY `id_guru` (`id_guru`),
  CONSTRAINT `tb_presensi_guru_ibfk_2` FOREIGN KEY (`id_kehadiran`) REFERENCES `tb_kehadiran` (`id_kehadiran`),
  CONSTRAINT `tb_presensi_guru_ibfk_3` FOREIGN KEY (`id_guru`) REFERENCES `tb_guru` (`id_guru`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `tb_presensi_siswa` (
  `id_presensi` int(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` int(11) NOT NULL,
  `id_kelas` int(11) unsigned DEFAULT NULL,
  `tanggal` date NOT NULL,
  `jam_masuk` time DEFAULT NULL,
  `jam_keluar` time DEFAULT NULL,
  `jam_sholat` time DEFAULT NULL,
  `id_kehadiran` int(11) NOT NULL,
  `keterangan` varchar(255) NOT NULL,
  PRIMARY KEY (`id_presensi`),
  KEY `id_siswa` (`id_siswa`),
  KEY `id_kehadiran` (`id_kehadiran`),
  KEY `id_kelas` (`id_kelas`),
  CONSTRAINT `tb_presensi_siswa_ibfk_2` FOREIGN KEY (`id_kehadiran`) REFERENCES `tb_kehadiran` (`id_kehadiran`),
  CONSTRAINT `tb_presensi_siswa_ibfk_3` FOREIGN KEY (`id_siswa`) REFERENCES `tb_siswa` (`id_siswa`) ON DELETE CASCADE,
  CONSTRAINT `tb_presensi_siswa_ibfk_4` FOREIGN KEY (`id_kelas`) REFERENCES `tb_kelas` (`id_kelas`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26733 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1','1','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2','2','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('3','3','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('4','4','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('5','5','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('6','6','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('7','7','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('8','8','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('9','9','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('10','10','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('11','11','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('12','12','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('13','13','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('14','14','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('15','15','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('16','16','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('17','17','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('19','19','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('20','20','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('21','21','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('22','22','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('23','23','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('24','24','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('25','25','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('26','26','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('27','27','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('28','28','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('29','29','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('30','30','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('31','31','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('32','32','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('33','33','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('34','34','1','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('35','35','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('36','36','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('37','37','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('38','38','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('39','39','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('40','40','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('42','42','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('43','43','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('44','44','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('45','45','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('46','46','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('47','47','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('48','48','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('49','49','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('50','50','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('51','51','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('52','52','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('53','53','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('54','54','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('55','55','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('56','56','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('57','57','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('58','58','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('59','59','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('60','60','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('61','61','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('62','62','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('63','63','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('64','64','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('65','65','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('66','66','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('67','67','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('68','68','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('69','69','2','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('70','70','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('71','71','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('72','72','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('73','73','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('74','74','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('75','75','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('76','76','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('77','77','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('78','78','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('79','79','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('80','80','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('81','81','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('82','82','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('83','83','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('84','84','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('85','85','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('86','86','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('87','87','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('88','88','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('89','89','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('90','90','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('91','91','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('92','92','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('93','93','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('94','94','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('95','95','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('96','96','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('97','97','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('98','98','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('99','99','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('100','100','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('101','101','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('102','102','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('103','103','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('104','104','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('105','105','3','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('106','106','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('107','107','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('108','108','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('109','109','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('110','110','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('111','112','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('112','113','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('113','114','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('114','115','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('115','116','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('116','117','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('117','118','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('118','119','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('119','120','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('120','121','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('121','122','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('122','123','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('123','124','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('124','125','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('125','126','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('126','127','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('127','128','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('128','129','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('129','130','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('130','131','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('131','132','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('132','133','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('133','134','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('134','135','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('135','136','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('136','137','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('137','138','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('138','139','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('139','140','4','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('140','141','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('141','142','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('142','143','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('143','144','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('144','145','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('145','146','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('146','147','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('147','148','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('148','149','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('149','150','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('150','151','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('151','152','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('152','153','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('153','154','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('154','155','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('155','156','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('156','157','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('157','158','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('158','159','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('159','160','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('160','161','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('161','162','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('162','163','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('163','164','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('164','165','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('165','166','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('166','167','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('167','168','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('168','169','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('169','170','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('170','171','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('171','172','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('172','173','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('173','174','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('174','175','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('175','176','5','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('176','177','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('177','178','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('178','179','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('179','180','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('180','181','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('181','182','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('182','183','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('183','184','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('184','185','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('185','186','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('186','187','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('187','188','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('188','189','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('189','190','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('190','191','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('191','192','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('192','193','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('193','194','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('194','195','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('195','196','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('196','197','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('197','198','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('198','199','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('199','200','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('200','201','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('201','202','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('202','203','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('203','204','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('204','205','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('205','206','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('206','207','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('207','208','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('208','209','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('209','210','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('210','211','6','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('211','212','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('212','213','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('213','214','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('214','215','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('215','216','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('216','217','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('217','218','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('218','219','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('219','220','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('220','221','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('221','222','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('222','223','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('223','224','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('224','225','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('225','226','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('226','227','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('227','228','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('228','229','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('229','230','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('230','231','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('231','232','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('232','233','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('233','234','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('234','235','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('235','236','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('236','237','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('237','238','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('238','239','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('239','240','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('240','242','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('241','243','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('242','244','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('243','245','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('244','246','7','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('245','247','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('246','248','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('247','249','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('248','250','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('249','251','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('250','252','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('251','253','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('252','254','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('253','255','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('254','256','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('255','257','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('256','258','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('257','259','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('258','260','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('259','261','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('260','262','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('261','263','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('262','264','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('263','265','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('264','266','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('265','267','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('266','268','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('267','269','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('268','270','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('269','271','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('270','272','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('271','273','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('272','274','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('273','275','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('274','276','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('275','277','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('276','278','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('277','279','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('278','280','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('279','281','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('280','282','8','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('281','283','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('282','284','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('283','285','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('284','286','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('285','287','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('286','288','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('287','289','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('289','291','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('290','292','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('291','293','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('292','294','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('293','295','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('294','296','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('295','297','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('296','298','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('297','299','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('298','300','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('299','301','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('300','302','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('301','303','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('302','304','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('303','305','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('304','306','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('305','307','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('306','308','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('307','309','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('308','310','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('309','311','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('310','312','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('311','313','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('312','314','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('313','315','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('314','316','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('315','317','9','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('316','318','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('317','319','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('318','320','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('319','321','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('320','322','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('321','323','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('322','324','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('323','325','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('324','326','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('325','327','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('326','328','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('327','329','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('328','330','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('329','331','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('330','332','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('331','333','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('332','334','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('333','335','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('334','336','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('335','337','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('336','338','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('337','339','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('338','340','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('339','341','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('340','342','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('341','343','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('342','344','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('343','345','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('344','346','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('345','347','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('346','348','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('347','349','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('348','350','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('349','351','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('350','352','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('351','353','10','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('352','354','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('353','355','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('354','356','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('355','357','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('356','359','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('357','360','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('358','361','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('359','362','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('360','363','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('361','364','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('362','365','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('363','366','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('364','367','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('365','368','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('366','369','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('367','370','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('368','371','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('369','372','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('370','373','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('371','374','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('372','375','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('373','376','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('374','377','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('375','378','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('376','379','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('377','380','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('378','381','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('379','382','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('380','383','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('381','384','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('382','385','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('383','386','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('384','387','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('385','388','11','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('386','389','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('387','390','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('388','391','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('389','392','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('390','393','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('391','394','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('392','395','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('393','396','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('394','397','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('395','398','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('396','399','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('397','400','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('398','401','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('399','402','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('400','403','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('401','404','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('402','405','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('403','406','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('404','407','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('405','408','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('406','409','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('407','410','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('408','411','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('409','412','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('410','413','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('411','414','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('412','415','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('413','416','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('414','417','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('415','418','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('416','419','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('417','420','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('418','421','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('419','422','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('420','423','12','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('421','424','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('422','425','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('423','426','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('424','427','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('425','428','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('426','429','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('427','430','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('428','431','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('429','432','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('430','433','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('431','434','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('432','435','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('433','436','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('434','437','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('435','438','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('436','439','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('437','440','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('438','441','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('439','442','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('440','443','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('441','444','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('442','445','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('443','446','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('444','447','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('445','448','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('446','449','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('447','450','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('448','451','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('449','452','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('450','453','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('451','454','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('452','455','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('453','456','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('454','457','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('455','458','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('456','459','13','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('457','460','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('458','461','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('459','462','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('460','463','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('461','464','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('462','465','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('463','466','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('464','467','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('465','468','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('466','469','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('467','470','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('468','471','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('469','472','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('470','473','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('471','474','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('472','475','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('473','476','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('474','477','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('475','478','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('476','479','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('477','480','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('478','481','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('479','482','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('480','483','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('481','484','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('482','485','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('483','486','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('484','487','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('485','488','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('486','489','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('487','490','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('488','491','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('489','492','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('490','493','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('491','494','14','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('492','495','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('493','496','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('494','497','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('495','498','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('496','499','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('497','500','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('498','501','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('499','502','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('500','503','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('501','504','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('502','505','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('503','506','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('504','507','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('505','508','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('506','509','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('507','510','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('508','511','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('509','512','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('510','513','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('511','514','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('512','515','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('513','516','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('514','517','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('515','518','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('516','519','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('517','520','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('518','521','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('519','522','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('520','523','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('521','524','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('522','525','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('523','526','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('524','527','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('525','528','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('526','529','15','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('527','530','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('528','531','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('529','532','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('530','533','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('531','534','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('532','535','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('533','536','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('534','537','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('535','538','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('536','539','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('537','540','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('538','541','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('539','542','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('540','543','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('541','544','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('542','545','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('543','546','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('544','547','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('545','548','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('546','549','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('547','550','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('548','551','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('549','552','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('550','553','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('551','554','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('552','555','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('553','556','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('554','557','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('555','558','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('556','559','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('557','560','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('558','561','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('559','562','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('560','563','16','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('561','564','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('562','565','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('563','566','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('564','567','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('565','568','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('566','569','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('567','570','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('568','571','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('569','572','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('570','573','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('571','574','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('572','575','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('573','576','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('574','577','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('575','578','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('576','579','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('577','580','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('578','581','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('579','582','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('580','583','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('581','584','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('582','585','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('583','586','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('584','587','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('585','588','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('586','589','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('587','590','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('588','591','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('589','592','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('590','593','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('591','594','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('592','595','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('593','596','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('594','597','17','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('595','598','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('596','599','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('597','600','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('598','601','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('599','602','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('600','603','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('601','604','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('602','605','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('603','606','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('604','607','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('605','608','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('606','609','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('607','610','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('608','611','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('609','612','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('610','613','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('611','614','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('612','615','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('613','616','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('614','617','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('615','618','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('616','619','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('617','620','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('618','621','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('619','622','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('620','623','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('621','624','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('622','625','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('623','626','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('624','627','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('625','628','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('626','629','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('627','630','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('628','631','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('629','632','18','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('630','633','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('631','634','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('632','635','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('633','636','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('634','637','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('635','638','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('636','639','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('637','640','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('638','641','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('639','642','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('640','643','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('641','644','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('642','645','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('643','646','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('644','647','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('645','648','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('646','649','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('647','650','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('648','651','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('649','652','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('650','653','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('651','654','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('652','655','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('653','656','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('654','657','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('655','658','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('656','659','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('657','660','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('658','661','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('659','662','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('660','663','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('661','664','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('662','665','19','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('663','666','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('664','667','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('665','668','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('666','669','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('667','670','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('668','671','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('669','672','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('670','673','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('671','674','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('672','675','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('673','676','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('674','677','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('675','678','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('676','679','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('677','680','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('678','681','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('679','682','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('680','683','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('681','684','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('682','685','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('683','686','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('684','687','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('685','688','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('686','689','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('687','690','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('689','692','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('690','693','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('691','694','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('692','695','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('693','696','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('694','697','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('695','698','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('696','699','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('697','700','20','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('698','701','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('699','702','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('700','703','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('701','704','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('702','705','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('703','706','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('704','707','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('705','708','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('706','709','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('707','710','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('708','711','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('709','712','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('710','713','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('711','714','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('712','715','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('713','716','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('714','717','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('715','718','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('716','719','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('717','720','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('718','721','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('719','722','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('720','723','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('721','724','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('722','725','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('723','726','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('724','727','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('725','728','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('726','729','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('727','730','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('728','731','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('729','732','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('730','733','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('731','734','21','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('732','735','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('733','736','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('734','737','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('735','738','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('736','739','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('737','740','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('738','741','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('739','742','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('740','743','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('741','744','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('742','745','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('743','746','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('744','747','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('745','748','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('746','749','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('747','750','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('748','751','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('749','752','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('750','753','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('751','754','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('752','755','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('753','756','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('754','757','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('755','758','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('756','759','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('757','760','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('758','761','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('759','762','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('760','763','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('761','764','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('762','765','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('763','766','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('764','767','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('765','768','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('766','769','22','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('767','770','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('768','771','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('769','772','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('770','773','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('771','774','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('772','775','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('773','776','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('774','777','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('775','778','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('776','779','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('777','780','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('778','781','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('779','782','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('780','783','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('781','784','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('782','785','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('783','786','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('784','787','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('785','788','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('786','789','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('787','790','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('788','791','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('789','792','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('790','793','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('791','794','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('792','795','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('793','796','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('794','797','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('795','798','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('796','799','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('797','800','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('798','801','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('799','802','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('800','803','23','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('801','804','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('802','805','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('803','806','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('804','807','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('805','808','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('806','809','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('807','810','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('808','811','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('809','812','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('810','813','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('811','814','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('812','815','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('813','816','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('814','817','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('815','818','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('816','819','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('817','820','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('818','821','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('819','822','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('820','823','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('821','824','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('822','825','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('823','826','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('824','827','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('825','828','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('826','829','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('827','830','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('828','831','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('829','832','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('830','833','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('831','834','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('832','835','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('833','836','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('834','837','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('835','838','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('836','839','24','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('837','840','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('838','841','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('839','842','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('840','843','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('841','844','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('842','845','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('843','846','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('844','847','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('845','848','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('846','849','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('847','850','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('848','851','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('849','852','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('850','853','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('851','854','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('852','855','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('853','856','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('854','857','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('855','858','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('856','859','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('857','860','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('858','861','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('859','862','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('860','863','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('861','864','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('862','865','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('863','866','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('864','867','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('865','868','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('866','869','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('867','870','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('868','871','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('869','872','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('870','873','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('871','874','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('872','875','25','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('873','876','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('874','877','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('875','878','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('876','879','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('877','880','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('878','881','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('879','882','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('880','883','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('881','884','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('882','885','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('883','886','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('884','887','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('885','888','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('886','889','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('887','890','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('888','891','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('889','892','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('890','893','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('891','894','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('892','895','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('893','896','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('894','897','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('895','898','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('896','899','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('897','900','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('898','901','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('899','902','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('900','903','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('901','904','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('902','905','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('903','906','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('904','907','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('905','908','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('906','909','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('907','910','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('908','911','26','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('909','912','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('910','913','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('911','914','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('912','915','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('913','916','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('914','917','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('915','918','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('916','919','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('917','920','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('918','921','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('919','922','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('920','923','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('921','924','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('922','925','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('923','926','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('924','927','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('925','928','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('926','929','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('927','930','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('928','931','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('929','932','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('930','933','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('931','934','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('932','935','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('933','936','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('934','937','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('935','938','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('936','939','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('937','940','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('938','941','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('939','942','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('940','943','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('941','944','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('942','945','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('943','946','27','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('944','947','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('945','948','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('946','949','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('947','950','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('948','951','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('949','952','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('950','953','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('951','954','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('952','955','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('953','956','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('954','957','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('955','958','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('956','959','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('957','960','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('958','961','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('959','962','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('960','963','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('961','964','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('962','965','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('963','966','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('964','967','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('965','968','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('966','969','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('967','970','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('968','971','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('969','972','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('970','973','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('971','974','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('972','975','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('973','976','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('974','977','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('975','978','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('976','979','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('977','980','28','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('978','981','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('979','982','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('980','983','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('981','984','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('982','985','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('983','986','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('984','987','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('985','988','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('986','989','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('987','990','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('988','991','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('989','992','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('990','993','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('991','994','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('992','995','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('993','996','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('994','997','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('995','998','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('996','999','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('997','1000','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('998','1001','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('999','1002','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1000','1003','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1001','1004','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1002','1005','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1003','1006','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1004','1007','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1005','1008','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1006','1009','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1007','1010','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1008','1011','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1009','1012','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1010','1013','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1011','1014','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1012','1015','29','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1013','1016','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1014','1017','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1015','1018','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1016','1019','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1017','1020','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1018','1021','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1019','1022','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1020','1023','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1021','1024','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1022','1025','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1023','1026','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1024','1027','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1025','1028','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1026','1029','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1027','1030','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1028','1031','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1029','1032','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1030','1033','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1031','1034','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1032','1035','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1033','1036','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1034','1037','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1035','1038','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1036','1039','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1037','1040','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1038','1041','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1039','1042','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1040','1043','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1041','1044','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1042','1045','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1043','1046','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1044','1047','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1045','1048','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1046','1049','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1047','1050','30','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1048','1051','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1049','1052','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1050','1053','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1051','1054','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1052','1055','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1053','1056','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1054','1057','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1055','1058','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1056','1059','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1057','1060','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1058','1061','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1059','1062','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1060','1063','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1061','1065','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1062','1066','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1063','1067','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1064','1068','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1065','1069','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1066','1070','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1067','1071','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1068','1072','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1069','1073','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1070','1074','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1071','1075','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1072','1076','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1073','1077','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1074','1078','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1075','1079','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1076','1080','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1077','1081','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1078','1082','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1079','1083','31','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1080','1084','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1081','1085','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1082','1086','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1083','1087','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1084','1088','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1085','1089','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1086','1090','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1087','1091','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1088','1092','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1089','1093','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1090','1094','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1091','1095','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1092','1096','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1093','1097','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1094','1098','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1095','1099','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1096','1100','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1097','1101','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1098','1102','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1099','1103','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1100','1104','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1101','1105','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1102','1106','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1103','1107','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1104','1108','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1105','1109','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1106','1110','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1107','1111','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1108','1112','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1109','1113','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1110','1114','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1111','1115','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1112','1116','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1113','1117','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1114','1118','32','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1115','1119','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1116','1120','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1117','1121','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1118','1122','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1119','1123','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1120','1124','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1121','1125','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1122','1126','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1123','1127','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1124','1128','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1125','1129','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1126','1130','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1127','1131','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1128','1132','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1129','1133','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1130','1134','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1131','1135','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1132','1136','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1133','1137','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1134','1138','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1135','1139','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1136','1140','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1137','1141','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1138','1142','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1139','1143','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1140','1144','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1141','1145','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1142','1146','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1143','1147','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1144','1148','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1145','1149','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1146','1150','33','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1147','1151','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1148','1152','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1149','1153','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1150','1154','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1151','1155','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1152','1156','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1153','1157','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1154','1158','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1155','1159','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1156','1160','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1157','1161','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1158','1162','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1159','1163','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1160','1164','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1161','1165','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1162','1166','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1163','1167','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1164','1168','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1165','1169','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1166','1170','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1167','1172','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1168','1173','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1169','1174','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1170','1175','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1171','1176','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1172','1177','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1173','1178','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1174','1179','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1175','1180','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1176','1181','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1177','1182','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1178','1183','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1179','1184','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1180','1185','34','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1181','1186','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1182','1187','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1183','1188','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1184','1189','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1185','1190','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1186','1191','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1187','1192','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1188','1193','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1189','1194','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1190','1195','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1191','1196','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1192','1197','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1193','1198','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1194','1199','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1195','1200','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1196','1201','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1197','1202','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1198','1203','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1199','1204','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1200','1205','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1201','1206','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1202','1207','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1203','1208','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1204','1209','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1205','1210','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1206','1211','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1207','1212','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1208','1213','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1209','1214','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1210','1215','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1211','1216','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1212','1217','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1213','1218','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1214','1219','35','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1215','1220','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1216','1221','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1217','1222','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1218','1223','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1219','1224','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1220','1225','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1221','1226','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1222','1227','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1223','1228','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1224','1229','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1225','1230','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1226','1231','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1227','1232','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1228','1233','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1229','1234','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1230','1235','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1231','1236','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1232','1237','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1233','1238','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1234','1239','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1235','1240','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1236','1241','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1237','1242','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1238','1243','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1239','1244','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1240','1245','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1241','1246','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1242','1247','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1243','1248','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1244','1249','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1245','1250','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1246','1251','36','2026-01-12','06:30:00','15:00:00','12:05:00','1','Hadir Otomatis\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1247','1118','32','2026-01-13','09:13:49',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1248','893','26','2026-01-13','09:14:04',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1249','942','27','2026-01-13','09:14:09',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1250','847','25','2026-01-13','09:14:17',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1251','1247','36','2026-01-13','09:14:21',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1252','1150','33','2026-01-13','09:14:58',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1253','1219','35','2026-01-13','09:15:14',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1254','1','1','2026-01-13',NULL,NULL,NULL,'2','Sakit Gigi\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1255','1236','36','2026-01-13','10:00:26',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1256','1235','36','2026-01-13','10:00:34',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1257','1183','34','2026-01-13','10:00:43',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1258','1040','30','2026-01-13','10:00:52',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1259','1123','33','2026-01-13','10:01:03',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1260','1011','29','2026-01-13','10:01:08',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1261','1103','32','2026-01-13','10:01:12',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1262','1234','36','2026-01-13','10:01:18',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1263','943','27','2026-01-13','10:01:22',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1264','901','26','2026-01-13','10:02:13',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1265','886','26','2026-01-13','10:02:20',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1266','1168','34','2026-01-13','10:02:29',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1267','1079','31','2026-01-13','10:02:35',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1268','1120','33','2026-01-13','10:02:41',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1269','1239','36','2026-01-13','10:02:47',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1270','890','26','2026-01-13','10:02:58',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1271','1119','33','2026-01-13','10:03:05',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1272','1045','30','2026-01-13','10:03:12',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1273','1105','32','2026-01-13','10:03:27',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1274','866','25','2026-01-13','10:03:45',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1275','1100','32','2026-01-13','10:03:51',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1276','1182','34','2026-01-13','10:03:57',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1277','1151','34','2026-01-13','10:04:06',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1278','958','28','2026-01-13','10:04:13',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1279','897','26','2026-01-13','10:04:17',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1280','1232','36','2026-01-13','10:04:27',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1281','952','28','2026-01-13','10:04:32',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1282','1000','29','2026-01-13','10:04:39',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1283','914','27','2026-01-13','10:04:44',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1284','889','26','2026-01-13','10:04:49',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1285','1056','31','2026-01-13','10:04:54',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1286','1055','31','2026-01-13','10:05:03',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1287','1062','31','2026-01-13','10:05:50',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1288','891','26','2026-01-13','10:05:58',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1289','987','29','2026-01-13','10:06:04',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1290','924','27','2026-01-13','10:06:07',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1291','1165','34','2026-01-13','10:06:18',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1292','1049','30','2026-01-13','10:06:28',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1293','1008','29','2026-01-13','10:06:31',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1294','1186','35','2026-01-13','10:06:36',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1295','1143','33','2026-01-13','10:06:41',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1296','998','29','2026-01-13','10:06:45',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1297','1110','32','2026-01-13','10:06:53',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1298','1181','34','2026-01-13','10:11:55',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1299','1149','33','2026-01-13','10:12:29',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1300','975','28','2026-01-13','10:12:36','10:14:52','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1301','1220','36','2026-01-13',NULL,'15:44:36',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1302','961','28','2026-01-13','15:41:31','15:45:13','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1303','854','25','2026-01-13','15:41:45','15:45:19','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1304','1016','30','2026-01-13','15:41:48','15:44:59','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1305','1053','31','2026-01-13','15:41:57',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1306','1052','31','2026-01-13','15:42:02','15:44:46','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1307','1051','31','2026-01-13','15:42:16','15:45:05','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1308','912','27','2026-01-13','15:42:29',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1309','1136','33','2026-01-13','15:42:33',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1310','947','28','2026-01-13','15:42:46',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1311','960','28','2026-01-13','15:42:50',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1312','1104','32','2026-01-13','15:42:59',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1313','1084','32','2026-01-13','15:43:08',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1314','1121','33','2026-01-13','15:43:33',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1315','1122','33','2026-01-13','15:44:28',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1316','17','1','2026-01-13','16:50:46',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1318','254','8','2026-01-13','16:51:00',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1319','258','8','2026-01-13','16:51:04',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1320','132','4','2026-01-13','16:51:08',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1321','335','10','2026-01-13','16:51:12',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1322','54','2','2026-01-13','16:51:16',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1323','823','24','2026-01-13','16:51:20',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1324','759','22','2026-01-13','16:51:24',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1325','671','20','2026-01-13','16:51:28',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1326','715','21','2026-01-13','16:51:32',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1327','606','18','2026-01-13','16:51:36',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1328','755','22','2026-01-13','16:51:40',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1329','433','13','2026-01-13','16:51:45',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1330','500','15','2026-01-13','16:51:48',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1331','813','24','2026-01-13','16:51:52',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1332','735','22','2026-01-13','16:51:56',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1333','431','13','2026-01-13','16:52:00',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1334','498','15','2026-01-13','16:52:04',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1335','692','20','2026-01-13','16:52:08',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1336','780','23','2026-01-13','16:52:11',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1337','519','15','2026-01-13','16:52:15',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1338','635','19','2026-01-13','16:52:20',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1339','496','15','2026-01-13','16:52:25',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1340','624','18','2026-01-13','16:52:28',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1341','555','16','2026-01-13','16:52:32',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1342','719','21','2026-01-13','16:52:36',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1343','424','13','2026-01-13','16:52:41',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1344','483','14','2026-01-13','16:52:45',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1345','824','24','2026-01-13','16:52:49',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1346','1221','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1347','1222','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1348','1223','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1349','1224','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1350','1225','36','2026-01-14',NULL,'12:43:08',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1351','1232','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1352','1235','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1353','1236','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1354','1237','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1355','1238','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1356','1241','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1357','1242','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1358','1245','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1359','1246','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1360','1251','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1361','1248','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1362','1244','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1363','1230','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1364','1233','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1365','1239','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1366','1250','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1367','1247','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1368','1228','36','2026-01-14',NULL,NULL,NULL,'2','Pemulihan Sakit\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1369','1231','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1370','1243','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1371','1234','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1372','1240','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1373','1226','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1374','1220','36','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1375','1227','36','2026-01-14',NULL,'19:57:47',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1376','646','19','2026-01-14','12:39:39','13:02:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1377','112','4','2026-01-14','12:40:55','12:42:19','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1378','184','6','2026-01-14','12:41:13',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1379','245','7','2026-01-14','12:44:05',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1380','838','24','2026-01-14','12:44:14',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1381','181','6','2026-01-14','12:46:08',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1382','212','7','2026-01-14','21:46:00','21:46:00','12:05:00','3','Sakit\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1383','274','8','2026-01-14','12:46:33',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1384','649','19','2026-01-14',NULL,NULL,NULL,'2','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1385','247','8','2026-01-14',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1386','1','1','2026-01-14','07:35:00',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1387','2','1','2026-01-14',NULL,NULL,NULL,'3','Mengantar ibu\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1388','419','12','2026-01-14','14:16:49',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1389','621','18','2026-01-14','15:14:23',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1390','618','18','2026-01-14','15:14:34','15:14:44','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1391','627','18','2026-01-14','15:15:44','15:16:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1392','629','18','2026-01-14','15:16:22','15:16:30','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1393','613','18','2026-01-14','15:16:44','15:18:44','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1394','610','18','2026-01-14','15:17:13','15:18:35','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1395','605','18','2026-01-14','15:17:18','15:18:39','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1396','619','18','2026-01-14','15:17:22','15:18:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1397','625','18','2026-01-14','15:17:26','15:18:22','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1398','617','18','2026-01-14','15:17:30','15:18:16','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1399','616','18','2026-01-14','15:17:35','15:18:11','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1400','630','18','2026-01-14','15:17:39','15:18:06','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1401','598','18','2026-01-14','15:17:44','15:18:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1402','623','18','2026-01-14','15:19:24','15:19:33','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1403','194','6','2026-01-15','06:18:51',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1404','161','5','2026-01-15','06:19:33','14:07:04','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1405','480','14','2026-01-15','06:19:40','14:07:11','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1406','315','9','2026-01-15','06:19:54','14:09:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1407','326','10','2026-01-15','06:20:07',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1408','337','10','2026-01-15','06:20:13','14:08:36','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1409','218','7','2026-01-15','06:20:17','15:00:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1410','352','10','2026-01-15','06:20:20','14:08:33','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1411','206','6','2026-01-15','06:20:25',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1412','379','11','2026-01-15','06:20:29','14:41:02','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1413','72','3','2026-01-15','06:20:33','14:07:30','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1414','420','12','2026-01-15','06:20:36',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1415','253','8','2026-01-15','06:20:47','14:19:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1416','73','3','2026-01-15','06:20:55','14:07:47','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1417','370','11','2026-01-15','06:21:07','14:14:16','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1418','32','1','2026-01-15','06:21:13','14:26:49','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1419','81','3','2026-01-15','06:22:06',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1420','172','5','2026-01-15','06:22:45','14:04:35','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1421','688','20','2026-01-15','06:23:00','14:31:49','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1422','669','20','2026-01-15','06:23:03','14:11:37','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1423','662','19','2026-01-15','06:23:21','14:12:49','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1424','346','10','2026-01-15','06:23:23','14:39:34','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1425','313','9','2026-01-15','06:23:26','14:12:42','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1426','295','9','2026-01-15','06:23:32','14:13:44','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1427','366','11','2026-01-15','06:23:36','14:19:06','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1428','689','20','2026-01-15','06:23:41','14:31:37','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1429','648','19','2026-01-15','06:23:44','14:05:03','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1430','143','5','2026-01-15','06:23:45','14:13:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1431','661','19','2026-01-15','06:23:51','14:04:45','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1432','645','19','2026-01-15','06:23:56','14:04:49','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1433','293','9','2026-01-15','06:24:10','14:27:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1434','1083','31','2026-01-15',NULL,'14:08:47',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1435','561','16','2026-01-15','06:24:17',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1436','795','23','2026-01-15','06:24:25','14:20:55','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1437','120','4','2026-01-15','06:24:26','14:19:41','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1438','1065','31','2026-01-15',NULL,'14:08:20',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1439','594','17','2026-01-15','06:24:41','14:08:24','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1440','319','10','2026-01-15','06:24:46',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1441','706','21','2026-01-15','06:24:49','14:30:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1442','604','18','2026-01-15','06:24:00',NULL,'12:05:00','1','Hadir \r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1443','28','1','2026-01-15','06:25:07','14:12:35','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1444','280','8','2026-01-15','06:25:08','14:05:35','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1445','3','1','2026-01-15','06:25:16','14:26:54','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1446','137','4','2026-01-15','06:25:18','14:22:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1447','323','10','2026-01-15','06:25:26','14:14:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1448','203','6','2026-01-15','06:25:34',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1449','163','5','2026-01-15','06:25:45',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1450','10','1','2026-01-15','06:25:45','14:20:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1451','631','18','2026-01-15','06:25:58','14:01:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1452','652','19','2026-01-15','06:25:58','14:04:52','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1453','1071','31','2026-01-15','06:25:00','14:09:50','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1454','331','10','2026-01-15','06:26:04',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1455','306','9','2026-01-15','06:26:11','14:27:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1456','557','16','2026-01-15','06:26:24','14:34:48','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1457','80','3','2026-01-15','06:26:47',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1458','776','23','2026-01-15','06:27:10',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1459','671','20','2026-01-15','06:27:00','14:30:47','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1460','577','17','2026-01-15','06:28:02',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1461','610','18','2026-01-15','06:28:11','14:02:33','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1462','1093','32','2026-01-15','06:28:00',NULL,'12:05:00','1','Hadir \r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1463','799','23','2026-01-15','06:28:38',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1464','552','16','2026-01-15','06:28:39',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1465','435','13','2026-01-15','06:28:41',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1466','99','3','2026-01-15','06:28:47','14:13:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1467','627','18','2026-01-15','06:28:58','14:02:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1468','822','24','2026-01-15','06:29:01','14:08:55','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1469','869','25','2026-01-15','06:29:00','14:07:25','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1470','789','23','2026-01-15','06:29:19',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1471','787','23','2026-01-15','06:29:22',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1472','660','19','2026-01-15','06:29:43','14:13:20','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1473','832','24','2026-01-15','06:29:46',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1474','847','25','2026-01-15','06:29:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1475','520','15','2026-01-15','06:30:12','14:05:29','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1476','376','11','2026-01-15','06:30:12','14:21:13','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1477','279','8','2026-01-15','06:30:15','14:14:38','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1478','523','15','2026-01-15','06:30:16','14:05:22','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1479','566','17','2026-01-15','06:30:19','14:31:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1480','721','21','2026-01-15','06:30:00','14:13:00','12:05:00','1','Kartu lupa\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1481','673','20','2026-01-15','06:30:20','14:32:06','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1482','595','17','2026-01-15','06:30:22','14:08:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1483','359','11','2026-01-15','06:30:28','14:20:56','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1484','694','20','2026-01-15','06:30:32','14:11:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1485','2','1','2026-01-15','06:30:33','14:12:53','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1486','592','17','2026-01-15','06:30:35','14:31:23','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1487','593','17','2026-01-15','06:30:38','14:50:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1488','405','12','2026-01-15','06:30:44',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1489','413','12','2026-01-15','06:30:45',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1490','894','26','2026-01-15','06:30:00','14:04:50','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1491','429','13','2026-01-15','06:31:01',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1492','542','16','2026-01-15','06:31:09',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1493','208','6','2026-01-15','06:31:13',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1494','179','6','2026-01-15','06:31:16',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1495','881','26','2026-01-15','06:31:00','14:03:43','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1496','618','18','2026-01-15','06:31:17',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1497','403','12','2026-01-15','06:31:31',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1498','407','12','2026-01-15','06:31:34',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1499','736','22','2026-01-15','06:31:46','14:20:31','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1500','424','13','2026-01-15','06:31:00',NULL,'12:05:00','1','Terlambat \r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1501','504','15','2026-01-15','06:31:53','14:05:55','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1502','71','3','2026-01-15','06:32:06',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1503','180','6','2026-01-15','06:32:13','14:17:52','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1504','381','11','2026-01-15','06:32:19','14:40:58','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1505','133','4','2026-01-15','06:32:20',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1506','543','16','2026-01-15','06:32:22',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1507','89','3','2026-01-15','06:32:23','14:08:50','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1508','55','2','2026-01-15','06:32:25','14:50:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1509','528','15','2026-01-15','06:32:00',NULL,'12:05:00','1','Terlambat 2 menit\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1510','252','8','2026-01-15','06:32:40','14:05:45','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1511','119','4','2026-01-15','06:32:41','14:23:58','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1512','268','8','2026-01-15','06:32:43','14:06:07','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1513','43','2','2026-01-15','06:32:48','14:28:09','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1514','283','9','2026-01-15','06:32:48','14:15:47','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1515','777','23','2026-01-15','06:32:52','14:17:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1516','278','8','2026-01-15','06:32:53','14:23:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1517','800','23','2026-01-15','06:32:56','14:17:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1518','456','13','2026-01-15','06:32:59','14:15:35','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1519','1108','32','2026-01-15','06:32:00','14:11:07','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1520','387','11','2026-01-15','06:33:02','14:19:16','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1521','701','21','2026-01-15','06:33:02',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1522','450','13','2026-01-15','06:33:08','14:13:45','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1523','668','20','2026-01-15','06:33:25','14:32:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1524','77','3','2026-01-15','06:33:30',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1525','703','21','2026-01-15','06:33:35','14:06:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1526','992','29','2026-01-15',NULL,'14:23:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1527','616','18','2026-01-15','06:33:38','14:02:53','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1528','654','19','2026-01-15','06:33:40','14:04:56','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1529','1010','29','2026-01-15',NULL,'14:23:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1530','554','16','2026-01-15','06:33:59','15:29:57','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1531','711','21','2026-01-15','06:34:00','14:07:55','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1532','434','13','2026-01-15','06:34:12',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1533','1104','32','2026-01-15','06:33:00','14:06:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1534','140','4','2026-01-15','06:34:15','14:24:03','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1535','442','13','2026-01-15','06:34:17',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1536','129','4','2026-01-15','06:34:24','14:18:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1537','512','15','2026-01-15','06:34:26','14:07:52','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1538','205','6','2026-01-15','06:34:30',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1539','493','14','2026-01-15','06:34:33','14:02:56','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1540','453','13','2026-01-15','06:34:36','14:11:31','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1541','361','11','2026-01-15','06:34:47','14:18:53','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1542','183','6','2026-01-15','06:34:50',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1543','443','13','2026-01-15','06:34:52','14:13:54','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1544','246','7','2026-01-15','06:34:58','15:00:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1545','207','6','2026-01-15','06:34:00','15:00:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1546','1238','36','2026-01-15',NULL,'14:03:47',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1547','549','16','2026-01-15','06:35:01','14:02:58','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1548','539','16','2026-01-15','06:35:05',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1549','339','10','2026-01-15','06:35:09','14:45:55','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1550','651','19','2026-01-15','06:35:13','14:05:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1551','213','7','2026-01-15','06:35:13','14:10:44','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1552','647','19','2026-01-15','06:35:19','14:13:10','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1553','422','12','2026-01-15','06:35:30','15:09:26','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1554','519','15','2026-01-15','06:35:00','14:20:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1555','727','21','2026-01-15','06:35:33','14:06:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1556','930','27','2026-01-15',NULL,'14:12:10',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1557','526','15','2026-01-15','06:35:50','14:09:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1558','788','23','2026-01-15','06:35:54','14:21:03','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1559','174','5','2026-01-15','06:35:55','15:00:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1560','175','5','2026-01-15','06:35:59','14:04:29','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1561','761','22','2026-01-15','06:36:01','14:20:41','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1562','162','5','2026-01-15','06:36:02','15:00:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1563','866','25','2026-01-15','06:35:00','14:08:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1564','767','22','2026-01-15','06:36:04','14:30:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1565','223','7','2026-01-15','06:36:06','14:08:02','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1566','173','5','2026-01-15','06:36:06','15:00:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1567','754','22','2026-01-15','06:36:07','14:36:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1568','639','19','2026-01-15','06:36:09','14:05:07','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1569','167','5','2026-01-15','06:36:12','14:30:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1570','964','28','2026-01-15',NULL,'14:19:44',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1571','638','19','2026-01-15','06:36:18','14:12:45','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1572','224','7','2026-01-15','06:36:20','14:08:16','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1573','848','25','2026-01-15','06:36:00','14:07:18','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1574','979','28','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1575','85','3','2026-01-15','06:36:27','14:23:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1576','1215','35','2026-01-15',NULL,'14:09:38',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1577','84','3','2026-01-15','06:36:31','14:23:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1578','289','9','2026-01-15','06:36:33','14:27:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1579','973','28','2026-01-15',NULL,'14:08:42',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1580','103','3','2026-01-15','06:36:41',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1581','118','4','2026-01-15','06:36:41','14:13:07','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1582','76','3','2026-01-15','06:36:42',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1583','961','28','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1584','840','25','2026-01-15',NULL,'14:08:04',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1585','78','3','2026-01-15','06:36:47','14:11:06','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1586','394','12','2026-01-15','06:36:49','14:56:14','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1587','956','28','2026-01-15',NULL,'14:09:16',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1588','875','25','2026-01-15','06:36:00','14:07:50','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1589','369','11','2026-01-15','06:36:53','14:55:57','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1590','457','13','2026-01-15','06:37:01','14:07:49','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1591','923','27','2026-01-15',NULL,'14:06:20',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1592','1241','36','2026-01-15',NULL,'14:05:22',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1593','321','10','2026-01-15','06:37:07','14:46:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1594','1225','36','2026-01-15',NULL,'14:00:44',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1595','927','27','2026-01-15',NULL,'14:01:44',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1596','607','18','2026-01-15','06:37:14','15:30:05','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1597','1228','36','2026-01-15',NULL,'14:03:40',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1598','70','3','2026-01-15','06:37:18','14:24:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1599','1136','33','2026-01-15','06:30:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1600','356','11','2026-01-15','06:37:22','14:12:36','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1601','288','9','2026-01-15','06:37:22','14:24:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1602','502','15','2026-01-15','06:37:33','14:05:52','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1603','929','27','2026-01-15','06:37:00','14:02:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1604','730','21','2026-01-15','06:37:44','14:05:51','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1605','1146','33','2026-01-15','06:37:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1606','902','26','2026-01-15',NULL,'14:03:59',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1607','920','27','2026-01-15','06:37:00','14:04:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1608','783','23','2026-01-15','06:37:57','14:03:26','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1609','1232','36','2026-01-15',NULL,'14:06:42',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1610','906','26','2026-01-15',NULL,'14:03:47',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1611','940','27','2026-01-15','06:38:00','14:03:15','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1612','38','2','2026-01-15','06:38:18','14:19:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1613','1014','29','2026-01-15','06:38:00','14:03:02','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1614','818','24','2026-01-15','06:38:21',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1615','1202','35','2026-01-15',NULL,'14:06:21',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1616','517','15','2026-01-15','06:38:26','14:05:15','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1617','547','16','2026-01-15','06:38:29',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1618','887','26','2026-01-15',NULL,'14:04:16',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1619','302','9','2026-01-15','06:38:34','14:13:20','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1620','465','14','2026-01-15','06:38:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1621','1237','36','2026-01-15',NULL,'14:06:36',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1622','989','29','2026-01-15','06:38:00','14:35:41','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1623','551','16','2026-01-15','06:38:49',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1624','87','3','2026-01-15','06:38:54','14:08:54','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1625','980','28','2026-01-15',NULL,'14:09:10',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1626','569','17','2026-01-15','06:39:02','14:08:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1627','1128','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1628','340','10','2026-01-15','06:39:00','14:45:00','12:05:00','1','Terlambat\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1629','215','7','2026-01-15','06:39:12','14:10:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1630','1140','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1631','74','3','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1632','863','25','2026-01-15',NULL,'14:44:41',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1633','191','6','2026-01-15','06:39:19',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1634','4','1','2026-01-15','06:39:20',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1635','178','6','2026-01-15','06:39:23',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1636','222','7','2026-01-15','06:39:26',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1637','13','1','2026-01-15','06:39:30',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1638','873','25','2026-01-15',NULL,'14:08:11',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1639','134','4','2026-01-15','06:39:35','04:00:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1640','1035','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1641','347','10','2026-01-15','06:39:38','14:10:18','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1642','605','18','2026-01-15','06:39:40','14:02:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1643','301','9','2026-01-15','06:39:00','14:20:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1644','438','13','2026-01-15','06:39:43','14:11:46','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1645','717','21','2026-01-15','06:39:43','14:05:23','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1646','1045','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1647','803','23','2026-01-15','06:39:47','14:20:59','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1648','193','6','2026-01-15','06:39:48',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1649','342','10','2026-01-15','06:39:52','14:08:43','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1650','1046','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1651','603','18','2026-01-15','06:39:54','14:02:36','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1652','1159','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1653','328','10','2026-01-15','06:39:00',NULL,'12:05:00','1','Terlambat 9 menit\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1654','704','21','2026-01-15','06:39:56','14:01:05','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1655','1047','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1656','771','23','2026-01-15','06:40:01','14:16:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1657','1166','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1658','1185','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1659','9','1','2026-01-15','06:40:16',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1660','705','21','2026-01-15','06:40:17','14:35:50','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1661','684','20','2026-01-15','06:40:17','14:31:05','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1662','545','16','2026-01-15','06:40:18',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1663','546','16','2026-01-15','06:40:22',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1664','663','19','2026-01-15','06:40:24','14:03:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1665','56','2','2026-01-15','06:40:25',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1666','1000','29','2026-01-15','06:40:00','14:23:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1667','650','19','2026-01-15','06:40:28','14:03:42','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1668','587','17','2026-01-15','06:40:00',NULL,'12:05:00','1','Terlambat \r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1669','824','24','2026-01-15','06:36:00','14:10:13','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1670','656','19','2026-01-15','06:40:32','14:04:23','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1671','469','14','2026-01-15','06:40:36','14:08:16','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1672','170','5','2026-01-15','06:40:37','14:12:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1673','344','10','2026-01-15','06:40:38','14:07:46','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1674','1008','29','2026-01-15',NULL,'14:35:21',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1675','664','19','2026-01-15','06:40:40','14:13:04','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1676','171','5','2026-01-15','06:40:45','14:13:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1677','995','29','2026-01-15',NULL,'14:06:31',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1678','994','29','2026-01-15','06:40:00','14:24:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1679','625','18','2026-01-15','06:40:57','14:02:14','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1680','385','11','2026-01-15','06:40:58','14:21:05','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1681','737','22','2026-01-15','06:40:00','14:21:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1682','710','21','2026-01-15','06:40:58','14:05:14','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1683','221','7','2026-01-15','06:40:58','15:24:03','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1684','834','24','2026-01-15','06:41:05','14:05:54','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1685','380','11','2026-01-15','06:41:05','14:20:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1686','991','29','2026-01-15','06:41:00','14:23:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1687','437','13','2026-01-15','06:41:17','14:07:42','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1688','579','17','2026-01-15','06:41:18','14:06:55','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1689','617','18','2026-01-15','06:41:20','14:01:50','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1690','114','4','2026-01-15','06:41:25','14:16:45','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1691','719','21','2026-01-15','06:41:00','14:10:47','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1692','501','15','2026-01-15','06:41:26','14:05:39','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1693','983','29','2026-01-15','06:41:00','14:11:03','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1694','117','4','2026-01-15','06:41:29','14:18:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1695','151','5','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1696','831','24','2026-01-15','06:41:30',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1697','128','4','2026-01-15','06:41:32','14:12:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1698','195','6','2026-01-15','06:41:34',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1699','144','5','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1700','781','23','2026-01-15','06:41:41',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1701','90','3','2026-01-15','06:41:41',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1702','1107','32','2026-01-15','06:41:00',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1703','1005','29','2026-01-15','06:41:00','14:02:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1704','708','21','2026-01-15','06:41:49','14:02:24','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1705','12','1','2026-01-15','06:41:51','14:12:47','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1706','653','19','2026-01-15','06:41:52','14:04:04','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1707','960','28','2026-01-15',NULL,'14:09:20',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1708','879','26','2026-01-15',NULL,'14:02:09',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1709','462','14','2026-01-15','06:41:56','14:07:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1710','632','18','2026-01-15','06:42:01','14:02:29','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1711','999','29','2026-01-15','06:41:00','13:58:48','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1712','1207','35','2026-01-15','06:41:00','14:06:58','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1713','1242','36','2026-01-15',NULL,'14:05:56',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1714','584','17','2026-01-15','06:42:05','14:07:19','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1715','425','13','2026-01-15','06:42:12','14:09:42','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1716','1239','36','2026-01-15',NULL,'14:05:41',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1717','294','9','2026-01-15','06:42:18','14:28:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1718','833','24','2026-01-15','06:42:20',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1719','987','29','2026-01-15','06:42:00','14:02:46','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1720','1244','36','2026-01-15',NULL,'14:06:16',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1721','1114','32','2026-01-15','06:42:00','14:07:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1722','571','17','2026-01-15','06:42:25','14:06:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1723','1124','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1724','1200','35','2026-01-15',NULL,'14:10:01',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1725','230','7','2026-01-15','06:42:36','14:08:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1726','1187','35','2026-01-15',NULL,'14:06:46',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1727','982','29','2026-01-15','06:42:00','14:35:37','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1728','415','12','2026-01-15','06:42:42',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1729','805','24','2026-01-15','06:42:43',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1730','1132','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1731','553','16','2026-01-15','06:42:49',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1732','954','28','2026-01-15',NULL,'14:09:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1733','5','1','2026-01-15','06:42:50','14:13:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1734','1235','36','2026-01-15',NULL,'14:07:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1735','931','27','2026-01-15','06:42:00','14:09:07','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1736','20','1','2026-01-15','06:42:54','14:44:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1737','1230','36','2026-01-15',NULL,'14:06:06',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1738','1143','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1739','748','22','2026-01-15','06:43:02','14:11:41','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1740','1226','36','2026-01-15',NULL,'14:04:16',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1741','492','14','2026-01-15','06:43:03','14:04:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1742','916','27','2026-01-15',NULL,'14:08:45',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1743','878','26','2026-01-15','06:43:00','14:02:42','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1744','382','11','2026-01-15','06:43:09','14:19:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1745','1251','36','2026-01-15',NULL,'14:03:59',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1746','317','9','2026-01-15','06:43:00','14:29:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1747','802','23','2026-01-15','06:43:14','14:21:11','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1748','1222','36','2026-01-15',NULL,'14:03:55',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1749','700','20','2026-01-15','06:43:20','14:31:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1750','123','4','2026-01-15','06:43:21','14:18:46','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1751','131','4','2026-01-15','06:43:26','14:18:37','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1752','11','1','2026-01-15','06:43:27','14:13:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1753','265','8','2026-01-15','06:43:30','14:14:54','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1754','597','17','2026-01-15','06:43:32','14:38:05','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1755','249','8','2026-01-15','06:43:34','14:05:30','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1756','127','4','2026-01-15','06:43:35','14:18:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1757','998','29','2026-01-15',NULL,'14:22:29',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1758','250','8','2026-01-15','06:43:41','14:28:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1759','155','5','2026-01-15','06:43:45','14:07:25','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1760','96','3','2026-01-15','06:43:50',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1761','214','7','2026-01-15','06:43:52','14:09:05','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1762','165','5','2026-01-15','06:43:55','15:00:41','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1763','264','8','2026-01-15','06:43:58','14:24:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1764','562','16','2026-01-15','06:43:59','14:20:36','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1765','1055','31','2026-01-15',NULL,'14:10:19',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1766','198','6','2026-01-15','06:44:05','14:18:09','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1767','515','15','2026-01-15','06:44:05','14:06:03','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1768','524','15','2026-01-15','06:44:06','14:05:41','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1769','1078','31','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1770','1103','32','2026-01-15','06:30:00','14:06:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1771','210','6','2026-01-15','06:44:13',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1772','1088','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1773','1080','31','2026-01-15',NULL,'14:08:51',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1774','1069','31','2026-01-15',NULL,'14:09:13',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1775','609','18','2026-01-15','06:44:25','14:08:14','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1776','433','13','2026-01-15','06:30:00','14:14:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1777','538','16','2026-01-15','06:44:32',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1778','1070','31','2026-01-15',NULL,'14:09:28',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1779','33','1','2026-01-15','06:44:36','14:13:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1780','1072','31','2026-01-15',NULL,'14:11:34',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1781','917','27','2026-01-15','06:44:00','14:03:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1782','1029','30','2026-01-15',NULL,'14:39:08',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1783','590','17','2026-01-15','06:44:43','14:07:49','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1784','933','27','2026-01-15',NULL,'14:06:04',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1785','1079','31','2026-01-15',NULL,'14:09:43',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1786','537','16','2026-01-15','06:44:50',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1787','814','24','2026-01-15','06:44:51','14:06:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1788','1099','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1789','1188','35','2026-01-15',NULL,'14:10:53',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1790','720','21','2026-01-15','06:45:01','14:01:52','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1791','88','3','2026-01-15','06:44:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1792','1250','36','2026-01-15','06:45:00','14:06:24','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1793','417','12','2026-01-15','06:45:06','14:04:56','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1794','1217','35','2026-01-15',NULL,'14:07:25',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1795','1182','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1796','412','12','2026-01-15','06:45:14',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1797','1199','35','2026-01-15',NULL,'14:10:30',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1798','411','12','2026-01-15','06:45:17',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1799','1181','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1800','1147','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1801','303','9','2026-01-15','06:45:25','14:13:26','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1802','432','13','2026-01-15','06:45:25','14:09:35','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1803','1216','35','2026-01-15',NULL,'14:09:33',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1804','702','21','2026-01-15','06:45:30','14:01:46','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1805','953','28','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1806','620','18','2026-01-15','06:45:33','14:01:58','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1807','325','10','2026-01-15','06:45:35','14:12:58','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1808','284','9','2026-01-15','06:45:36','14:13:22','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1809','124','4','2026-01-15','06:45:40','14:13:03','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1810','51','2','2026-01-15','06:45:41','14:15:34','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1811','1236','36','2026-01-15',NULL,'14:05:52',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1812','66','2','2026-01-15','06:45:47','14:15:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1813','1102','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1814','65','2','2026-01-15','06:45:51','14:18:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1815','591','17','2026-01-15','06:45:52','14:08:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1816','40','2','2026-01-15','06:45:56','14:17:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1817','1051','31','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1818','589','17','2026-01-15','06:45:59','14:06:23','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1819','1056','31','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1820','485','14','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1821','287','9','2026-01-15','06:46:06','14:24:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1822','1117','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1823','459','13','2026-01-15','06:46:10','14:12:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1824','749','22','2026-01-15','06:46:11','14:41:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1825','1084','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1826','46','2','2026-01-15','06:46:16','15:27:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1827','1152','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1828','458','13','2026-01-15','06:46:20','14:07:38','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1829','333','10','2026-01-15','06:46:24','14:08:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1830','67','2','2026-01-15','06:46:24','15:26:25','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1831','722','21','2026-01-15','06:46:27','14:07:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1832','1158','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1833','583','17','2026-01-15','06:46:00',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1834','160','5','2026-01-15','06:46:29','15:00:18','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1835','1183','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1836','942','27','2026-01-15','06:46:00','14:09:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1837','48','2','2026-01-15','06:46:46',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1838','336','10','2026-01-15','06:46:48','14:18:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1839','574','17','2026-01-15','06:46:51','14:06:50','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1840','1002','29','2026-01-15','06:46:00','14:08:35','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1841','758','22','2026-01-15','06:46:58','14:30:56','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1842','147','5','2026-01-15','06:46:59','14:42:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1843','693','20','2026-01-15','06:47:05','14:31:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1844','227','7','2026-01-15','06:47:06',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1845','62','2','2026-01-15','06:47:06','14:22:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1846','61','2','2026-01-15','06:47:10','14:22:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1847','1148','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1848','186','6','2026-01-15','06:47:14',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1849','611','18','2026-01-15','06:47:18','14:02:25','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1850','934','27','2026-01-15',NULL,'14:04:01',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1851','677','20','2026-01-15','06:47:34','14:31:26','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1852','699','20','2026-01-15','06:47:36','14:31:30','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1853','548','16','2026-01-15','06:47:39',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1854','1019','30','2026-01-15',NULL,'14:13:48',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1855','509','15','2026-01-15','06:47:45','14:08:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1856','393','12','2026-01-15','06:47:46','14:23:52','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1857','1027','30','2026-01-15',NULL,'14:13:38',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1858','1059','31','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1859','1067','31','2026-01-15',NULL,'14:11:26',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1860','1049','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1861','1125','33','2026-01-15','06:47:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1862','1066','31','2026-01-15',NULL,'14:16:56',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1863','744','22','2026-01-15','06:48:09','14:28:54','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1864','837','24','2026-01-15','06:48:11','14:11:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1865','1098','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1866','1075','31','2026-01-15',NULL,'14:09:24',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1867','211','6','2026-01-15','06:48:17',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1868','725','21','2026-01-15','06:48:17','14:02:14','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1869','855','25','2026-01-15',NULL,'14:07:07',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1870','1127','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1871','1095','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1872','716','21','2026-01-15','06:48:27','14:02:09','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1873','718','21','2026-01-15','06:48:34','14:01:30','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1874','256','8','2026-01-15',NULL,NULL,NULL,'2','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1875','836','24','2026-01-15','06:48:36','14:11:19','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1876','389','12','2026-01-15','06:48:37','14:12:30','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1877','541','16','2026-01-15',NULL,'14:30:08',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1878','399','12','2026-01-15','06:48:41','14:12:37','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1879','276','8','2026-01-15','06:48:42','14:30:09','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1880','220','7','2026-01-15','06:48:42','14:05:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1881','225','7','2026-01-15','06:48:46','14:25:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1882','236','7','2026-01-15','06:48:51','14:08:26','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1883','467','14','2026-01-15','06:49:01','15:08:59','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1884','1145','33','2026-01-15','06:48:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1885','726','21','2026-01-15','06:49:04','14:01:25','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1886','266','8','2026-01-15',NULL,NULL,NULL,'2','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1887','464','14','2026-01-15','06:49:08','14:06:47','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1888','986','29','2026-01-15','06:49:00','14:10:54','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1889','398','12','2026-01-15','06:49:11',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1890','479','14','2026-01-15','06:49:12',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1891','489','14','2026-01-15','06:49:13','14:11:24','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1892','391','12','2026-01-15','06:49:14',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1893','984','29','2026-01-15','06:49:00','14:10:59','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1894','482','14','2026-01-15','06:49:24',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1895','993','29','2026-01-15',NULL,'14:02:59',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1896','985','29','2026-01-15','06:49:00','14:06:27','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1897','392','12','2026-01-15','06:49:35',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1898','996','29','2026-01-15','06:49:00','14:02:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1899','820','24','2026-01-15','06:49:40',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1900','801','23','2026-01-15','06:49:47',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1901','269','8','2026-01-15','06:49:48','14:05:19','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1902','909','26','2026-01-15',NULL,'14:03:03',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1903','217','7','2026-01-15','06:50:00','14:11:39','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1904','723','21','2026-01-15','06:50:00','14:01:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1905','296','9','2026-01-15','06:49:00','14:20:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1906','707','21','2026-01-15','06:50:08','14:05:19','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1907','1037','30','2026-01-15','06:50:00',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1908','24','1','2026-01-15','06:50:12','14:11:18','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1909','674','20','2026-01-15','06:50:12','14:34:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1910','634','19','2026-01-15','06:50:14','14:04:02','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1911','372','11','2026-01-15','06:50:31','14:18:43','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1912','903','26','2026-01-15',NULL,'14:04:19',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1913','360','11','2026-01-15','06:50:37','14:18:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1914','742','22','2026-01-15','06:50:00','14:11:35','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1915','1043','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1916','63','2','2026-01-15','06:50:41','14:12:26','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1917','496','15','2026-01-15',NULL,'14:13:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1918','871','25','2026-01-15',NULL,'14:07:46',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1919','1101','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1920','1109','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1921','197','6','2026-01-15','06:51:10',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1922','184','6','2026-01-15','06:51:12',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1923','1163','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1924','635','19','2026-01-15','06:51:00','14:13:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1925','1041','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1926','885','26','2026-01-15',NULL,'14:03:35',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1927','614','18','2026-01-15','06:51:32',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1928','1042','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1929','216','7','2026-01-15','06:51:33','14:12:14','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1930','882','26','2026-01-15',NULL,'14:04:07',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1931','1149','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1932','798','23','2026-01-15','06:51:38','14:21:06','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1933','892','26','2026-01-15',NULL,'14:04:04',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1934','305','9','2026-01-15','06:51:00','14:20:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1935','911','26','2026-01-15',NULL,'14:04:42',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1936','1179','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1937','185','6','2026-01-15','06:51:50','14:18:04','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1938','1036','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1939','1061','31','2026-01-15',NULL,'14:16:47',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1940','93','3','2026-01-15','06:51:59',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1941','907','26','2026-01-15',NULL,'14:04:10',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1942','1154','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1943','104','3','2026-01-15','06:52:02',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1944','1020','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1945','1073','31','2026-01-15',NULL,'14:17:01',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1946','817','24','2026-01-15','06:52:09',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1947','1033','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1948','770','23','2026-01-15','06:52:16',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1949','1082','31','2026-01-15',NULL,'14:09:35',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1950','1017','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1951','757','22','2026-01-15','06:52:21','14:44:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1952','15','1','2026-01-15','06:52:21','14:30:27','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1953','1021','30','2026-01-15',NULL,'14:12:43',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1954','83','3','2026-01-15','06:52:23',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1955','828','24','2026-01-15','06:52:24','14:04:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1956','21','1','2026-01-15','06:52:28','14:07:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1957','912','27','2026-01-15','06:52:00','14:04:36','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1958','307','9','2026-01-15','06:52:31','14:28:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1959','1031','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1960','1203','35','2026-01-15',NULL,'14:10:45',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1961','750','22','2026-01-15','06:52:38','14:20:45','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1962','507','15','2026-01-15',NULL,'14:05:37',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1963','924','27','2026-01-15','06:52:00','14:04:26','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1964','877','26','2026-01-15',NULL,'14:02:48',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1965','714','21','2026-01-15','06:52:47','14:01:13','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1966','1134','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1967','778','23','2026-01-15','06:52:57',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1968','918','27','2026-01-15','06:52:00','14:03:46','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1969','229','7','2026-01-15','06:53:01',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1970','896','26','2026-01-15',NULL,'14:03:51',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1971','1081','31','2026-01-15',NULL,'14:09:09',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1972','935','27','2026-01-15','06:53:00','14:03:33','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1973','1028','30','2026-01-15',NULL,'14:12:35',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1974','1054','31','2026-01-15',NULL,'14:06:42',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1975','895','26','2026-01-15',NULL,'14:03:32',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1976','619','18','2026-01-15','06:53:31','14:02:02','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1977','613','18','2026-01-15','06:53:36','14:01:36','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1978','886','26','2026-01-15',NULL,'14:03:55',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1979','915','27','2026-01-15','06:53:00','14:05:53','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1980','588','17','2026-01-15','06:53:47','14:07:01','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1981','646','19','2026-01-15','06:53:47','14:35:02','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1982','271','8','2026-01-15','06:53:54','14:06:52','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1983','135','4','2026-01-15','06:53:58',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1984','843','25','2026-01-15',NULL,'02:28:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1985','353','10','2026-01-15','06:54:09','14:07:14','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1986','1178','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1987','679','20','2026-01-15','06:54:20','14:31:33','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1988','844','25','2026-01-15',NULL,'14:40:37',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1989','1184','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1990','794','23','2026-01-15','06:54:26','14:21:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1991','672','20','2026-01-15','06:54:26','14:30:19','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1992','891','26','2026-01-15',NULL,'14:03:40',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1993','1170','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1994','845','25','2026-01-15',NULL,'14:07:53',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1995','136','4','2026-01-15','06:54:36','14:19:11','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1996','1155','34','2026-01-15',NULL,'14:15:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1997','1167','34','2026-01-15',NULL,NULL,NULL,'2','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1998','839','24','2026-01-15','06:54:46','14:10:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('1999','856','25','2026-01-15',NULL,'14:12:44',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2000','1180','34','2026-01-15','06:54:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2001','819','24','2026-01-15','06:54:55',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2002','1164','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2003','775','23','2026-01-15','06:54:58','14:04:31','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2004','544','16','2026-01-15','06:55:01','14:34:45','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2005','853','25','2026-01-15',NULL,'14:07:15',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2006','1001','29','2026-01-15',NULL,NULL,NULL,'3','Acara keluaga\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2007','563','16','2026-01-15','06:55:09',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2008','426','13','2026-01-15','06:55:19','14:04:44','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2009','1123','33','2026-01-15','07:02:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2010','50','2','2026-01-15','06:55:23',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2011','602','18','2026-01-15','06:55:24','14:03:44','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2012','870','25','2026-01-15',NULL,'14:07:37',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2013','825','24','2026-01-15','06:55:28',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2014','928','27','2026-01-15',NULL,'14:04:51',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2015','696','20','2026-01-15','06:55:31','15:25:43','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2016','1058','31','2026-01-15',NULL,'14:10:08',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2017','261','8','2026-01-15','06:55:37','14:05:16','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2018','310','9','2026-01-15','06:55:37','14:29:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2019','874','25','2026-01-15',NULL,'14:07:41',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2020','7','1','2026-01-15','06:55:45',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2021','513','15','2026-01-15','06:55:48','14:06:49','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2022','444','13','2026-01-15','06:55:49','14:12:07','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2023','655','19','2026-01-15','06:55:50','14:05:57','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2024','522','15','2026-01-15','06:55:53','14:04:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2025','908','26','2026-01-15',NULL,'14:04:31',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2026','251','8','2026-01-15','06:56:00','14:30:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2027','291','9','2026-01-15','06:42:00','14:12:58','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2028','893','26','2026-01-15','06:55:00','14:04:25','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2029','29','1','2026-01-15','06:56:03','14:30:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2030','743','22','2026-01-15','06:56:08','14:04:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2031','637','19','2026-01-15','06:56:11','14:04:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2032','682','20','2026-01-15','06:52:00','14:30:38','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2033','1024','30','2026-01-15',NULL,'14:44:37',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2034','943','27','2026-01-15','06:56:00','14:01:56','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2035','1032','30','2026-01-15',NULL,'14:39:12',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2036','404','12','2026-01-15','06:56:37','14:11:17','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2037','1129','33','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2038','390','12','2026-01-15','06:56:44',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2039','1022','30','2026-01-15',NULL,'14:39:26',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2040','419','12','2026-01-15','06:56:45',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2041','741','22','2026-01-15','06:56:46','14:43:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2042','494','14','2026-01-15','06:56:46',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2043','768','22','2026-01-15','06:56:49','14:42:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2044','1197','35','2026-01-15',NULL,'14:07:13',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2045','332','10','2026-01-15','06:56:59','14:07:37','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2046','1030','30','2026-01-15',NULL,'14:37:30',NULL,'4','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2047','1190','35','2026-01-15',NULL,'14:09:52',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2048','1192','35','2026-01-15',NULL,'14:06:37',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2049','345','10','2026-01-15','06:57:07',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2050','842','25','2026-01-15',NULL,'15:52:55',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2051','60','2','2026-01-15','06:57:10',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2052','1218','35','2026-01-15',NULL,'14:11:09',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2053','1015','29','2026-01-15','06:56:00','14:10:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2054','16','1','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2055','1219','35','2026-01-15',NULL,'14:10:33',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2056','1013','29','2026-01-15','06:57:00','14:02:26','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2057','1208','35','2026-01-15',NULL,'14:10:58',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2058','59','2','2026-01-15','06:57:34',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2059','234','7','2026-01-15','06:57:00','14:11:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2060','1016','30','2026-01-15',NULL,'14:37:25',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2061','1091','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2062','17','1','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2063','535','16','2026-01-15','06:58:08','14:08:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2064','1011','29','2026-01-15',NULL,NULL,NULL,'2','Pemulihan operasi\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2065','1038','30','2026-01-15',NULL,'14:12:45',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2066','297','9','2026-01-15','06:58:11','14:11:56','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2067','26','1','2026-01-15','06:58:13','14:11:59','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2068','219','7','2026-01-15','06:58:17','14:10:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2069','1018','30','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2070','926','27','2026-01-15','06:58:00','14:06:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2071','615','18','2026-01-15','06:58:25','14:03:41','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2072','629','18','2026-01-15','06:58:27','14:01:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2073','1194','35','2026-01-15',NULL,'14:10:15',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2074','612','18','2026-01-15','06:58:38','14:01:55','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2075','1196','35','2026-01-15',NULL,'14:09:29',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2076','735','22','2026-01-15','06:40:00','14:46:00','12:05:00','1','Belum punya kartu\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2077','1209','35','2026-01-15',NULL,'14:10:24',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2078','282','8','2026-01-15',NULL,NULL,NULL,'3','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2079','623','18','2026-01-15','06:58:57','14:02:44','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2080','1068','31','2026-01-15',NULL,'14:16:35',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2081','1077','31','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2082','439','13','2026-01-15','06:59:24','14:07:57','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2083','1157','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2084','1023','30','2026-01-15',NULL,'14:13:04',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2085','525','15','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2086','865','25','2026-01-15','07:00:00',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2087','98','3','2026-01-15','07:00:13',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2088','937','27','2026-01-15','07:00:00','14:03:20','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2089','872','25','2026-01-15',NULL,'14:07:11',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2090','153','5','2026-01-15','07:00:30','14:41:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2091','1201','35','2026-01-15',NULL,'14:08:02',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2092','248','8','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2093','235','7','2026-01-15','07:04:00','14:11:00','12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2094','867','25','2026-01-15','07:00:00',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2095','649','19','2026-01-15','07:00:51','14:03:32','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2096','275','8','2026-01-15',NULL,'14:30:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2097','181','6','2026-01-15','07:01:05',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2098','769','22','2026-01-15','07:01:08','14:43:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2099','868','25','2026-01-15',NULL,'14:07:31',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2100','1156','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2101','196','6','2026-01-15','07:01:18',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2102','1162','34','2026-01-15',NULL,'14:09:00',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2103','558','16','2026-01-15','07:01:35',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2104','1168','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2105','53','2','2026-01-15','07:01:38',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2106','550','16','2026-01-15','07:01:42',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2107','815','24','2026-01-15','07:01:44',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2108','1223','36','2026-01-15','07:01:00','14:00:53','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2109','1169','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2110','49','2','2026-01-15','07:01:51',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2111','39','2','2026-01-15','07:02:02',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2112','670','20','2026-01-15','07:02:07','14:31:42','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2113','1231','36','2026-01-15',NULL,'14:06:12',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2114','1089','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2115','644','19','2026-01-15','06:45:00','14:00:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2116','808','24','2026-01-15','07:02:35','14:08:58','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2117','1126','33','2026-01-15','07:02:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2118','925','27','2026-01-15',NULL,'14:05:24',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2119','101','3','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2120','1050','30','2026-01-15',NULL,'14:39:21',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2121','945','27','2026-01-15',NULL,'14:05:04',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2122','830','24','2026-01-15','07:03:00','14:06:12','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2123','922','27','2026-01-15','07:03:00','14:05:09','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2124','932','27','2026-01-15',NULL,'14:05:40',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2125','827','24','2026-01-15','07:03:36',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2126','402','12','2026-01-15','07:03:38',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2127','861','25','2026-01-15','07:03:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2128','733','21','2026-01-15','07:04:04','14:05:37','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2129','416','12','2026-01-15',NULL,NULL,NULL,'2','Sakit\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2130','709','21','2026-01-15','07:04:33',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2131','772','23','2026-01-15','07:04:36','14:04:27','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2132','790','23','2026-01-15','07:04:41',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2133','500','15','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2134','858','25','2026-01-15',NULL,'14:40:33',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2135','1003','29','2026-01-15',NULL,'14:03:15',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2136','1086','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2137','1177','34','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2138','969','28','2026-01-15',NULL,'14:19:28',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2139','1092','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2140','272','8','2026-01-15','07:05:58','14:05:25','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2141','1052','31','2026-01-15',NULL,'14:07:59',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2142','938','27','2026-01-15',NULL,'14:24:29',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2143','423','12','2026-01-15',NULL,NULL,NULL,'3','Kontrol ke dokter\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2144','242','7','2026-01-15','07:06:13','14:10:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2145','408','12','2026-01-15',NULL,NULL,NULL,'2','Sakit\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2146','260','8','2026-01-15','07:06:26','14:09:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2147','257','8','2026-01-15','07:06:30','14:30:05','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2148','247','8','2026-01-15','07:06:34','14:04:18','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2149','273','8','2026-01-15','07:06:37','14:05:42','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2150','921','27','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2151','238','7','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2152','919','27','2026-01-15',NULL,'14:04:47',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2153','491','14','2026-01-15','06:30:00',NULL,'12:05:00','1','Ketinggalan kartu\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2154','157','5','2026-01-15','07:08:01','15:00:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2155','740','22','2026-01-15','07:08:19','14:04:20','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2156','764','22','2026-01-15','07:08:22','14:44:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2157','739','22','2026-01-15',NULL,NULL,NULL,'2','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2158','396','12','2026-01-15','07:08:29','14:14:21','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2159','1100','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2160','1090','32','2026-01-15','07:08:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2161','751','22','2026-01-15','07:08:51','14:44:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2162','1','1','2026-01-15','07:08:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2163','745','22','2026-01-15',NULL,NULL,NULL,'2','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2164','756','22','2026-01-15','07:09:03','14:44:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2165','8','1','2026-01-15','07:09:08','14:30:43','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2166','1062','31','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2167','483','14','2026-01-15','06:28:00',NULL,'12:05:00','1','Belum punya kartu\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2168','773','23','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2169','941','27','2026-01-15',NULL,NULL,NULL,'3','Ada keperluan keluarga\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2170','109','4','2026-01-15','07:09:38','14:13:15','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2171','141','5','2026-01-15','07:09:40','14:10:43','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2172','176','5','2026-01-15','07:09:46','14:41:00','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2173','149','5','2026-01-15','07:09:49','14:12:33','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2174','152','5','2026-01-15','07:09:55','14:40:08','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2175','91','3','2026-01-15','07:10:03','14:07:37','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2176','299','9','2026-01-15',NULL,'07:29:33',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2177','1245','36','2026-01-15',NULL,'14:07:12',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2178','1085','32','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2179','862','25','2026-01-15',NULL,NULL,NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2180','292','9','2026-01-15',NULL,'14:12:16',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2181','1210','35','2026-01-15','07:10:00','14:09:56','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2182','1246','36','2026-01-15',NULL,'14:06:56',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2183','642','19','2026-01-15','07:10:48','14:03:47','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2184','690','20','2026-01-15','07:10:52','14:29:40','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2185','255','8','2026-01-15','07:10:56','14:09:55','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2186','678','20','2026-01-15','07:10:57','14:55:53','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2187','793','23','2026-01-15','07:10:59','14:04:18','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2188','473','14','2026-01-15','07:11:06','14:11:20','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2189','285','9','2026-01-15',NULL,'14:09:53',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2190','267','8','2026-01-15','07:11:13','14:06:14','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2191','997','29','2026-01-15','07:11:00','14:02:06','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2192','946','27','2026-01-15',NULL,'14:13:17',NULL,'1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2193','338','10','2026-01-15','07:11:42','14:07:28','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2194','1087','32','2026-01-15','07:11:00',NULL,'12:05:00','1','Hadir\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2195','421','12','2026-01-15','07:11:46',NULL,'12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2196','747','22','2026-01-15',NULL,NULL,NULL,'2','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,`jam_masuk`,`jam_keluar`,`jam_sholat`,`id_kehadiran`,`keterangan`) VALUES ('2197','350','10','2026-01-15','07:11:53','14:07:25','12:05:00','1','\r');
INSERT INTO `tb_presensi_siswa` (`id_presensi`,`id_siswa`,`id_kelas`,`tanggal`,